/*
 * File:   touch.c
 * Author: Tim Blythman
 * Demo code for ATtiny816 on breakout board
 * touch
 * Basic capacitative touch interface, because PTC uses too much flash space
 * Created on 15 October 2018, 10:29 AM
 */

// touch

#include "touch.h"
#include "io.h"

// inspired by:
// http://playground.arduino.cc/Code/CapacitiveSensor

unsigned char getTouch(PORT_t* port, unsigned char bt){       //bit on port
    unsigned char bm=1<<bt;         //optimise for future use
    unsigned char v=0;
    port->DIRSET=bm;                 //set output
    port->OUTCLR=bm;                 //set low
    switch(bt){                      //pullups on, port invert off, input buffer enabled
        case 0: port->PIN0CTRL=PORT_PULLUPEN_bm; break;
        case 1: port->PIN1CTRL=PORT_PULLUPEN_bm; break;
        case 2: port->PIN2CTRL=PORT_PULLUPEN_bm; break;
        case 3: port->PIN3CTRL=PORT_PULLUPEN_bm; break;
        case 4: port->PIN4CTRL=PORT_PULLUPEN_bm; break;
        case 5: port->PIN5CTRL=PORT_PULLUPEN_bm; break;
        case 6: port->PIN6CTRL=PORT_PULLUPEN_bm; break;
        case 7: port->PIN7CTRL=PORT_PULLUPEN_bm; break;
    }        
    asm("nop");                      //let it settle
    asm("nop");
    asm("nop");
    di();                            //timing critical, disable interrupts
    port->DIRCLR=bm;                 //set as input, see how long pullup takes to go high
    if(!(port->IN & bm)){v++;}       //see how long it takes to rise
    if(!(port->IN & bm)){v++;}
    if(!(port->IN & bm)){v++;}
    if(!(port->IN & bm)){v++;}
    if(!(port->IN & bm)){v++;}
    if(!(port->IN & bm)){v++;}
    if(!(port->IN & bm)){v++;}
    if(!(port->IN & bm)){v++;}
    if(!(port->IN & bm)){v++;}
    if(!(port->IN & bm)){v++;}
    if(!(port->IN & bm)){v++;}
    if(!(port->IN & bm)){v++;}
    if(!(port->IN & bm)){v++;}
    if(!(port->IN & bm)){v++;}
    if(!(port->IN & bm)){v++;}
    if(!(port->IN & bm)){v++;}
    if(!(port->IN & bm)){v++;}
    if(!(port->IN & bm)){v++;}
    if(!(port->IN & bm)){v++;}
    if(!(port->IN & bm)){v++;}
    ei();                            //end of critical section
    port->DIRSET=bm;                 //set output for next time
    return v;
}

// analog touch inspired by shared capacitance method
// set ADC sample cap low by measuring GND
// put charge on pin by setting high
// let pin float, then measure with ADC
// charge is shared between pin capacitance and sample capacitance
// leading to a value related to pin capacitance (monotonic but non linear)

int getAnalogTouch(unsigned char chan){
    int r=0;
    PORT_t* port=getPortFromAnalog(chan);   //get digital port corresponding to analog mux
    unsigned char bt=getBitFromAnalog(chan);//get digital bit corresponding to analog mux
    if(bt==0xFF){return 0;}                 //invalid port
    setDir(port,bt,0);                      //set as input
    setPullup(port,bt,1);                   //pullup on to charge pin capacitance
    getADC(ANALOG_GND);                     //ground sample cap
    setPullup(port,bt,0);                   //pullup off
    r=getADC(chan);                         //read pin
    setPullup(port,bt,1);                   //pullup on to charge pin capacitance
    return r;
}