/*
 * File:   io.c
 * Author: Tim Blythman
 * Demo code for ATtiny816 on breakout board
 * Some simple digital IO APIs
 * Created on 15 October 2018, 10:29 AM
 */

#include "io.h"

void setDir(PORT_t* port, unsigned char bt, unsigned char v){
    unsigned char bm=1<<bt;         //optimise for future use
    if(v){                          
        port->DIRSET=bm;            //set high=output
    }else{
        port->DIRCLR=bm;            //set low=input   
    }
}


void setPin(PORT_t* port, unsigned char bt, unsigned char v){
    unsigned char bm=1<<bt;         //optimise for future use
    if(v){                          
        port->OUTSET=bm;            //set high
    }else{
        port->OUTCLR=bm;            //set low        
    }
}

unsigned char getPin(PORT_t* port, unsigned char bt){               //read back port.bt
    unsigned char bm=1<<bt;         //optimise for future use
    if(port->IN & bm){              //check pin
        return 1;
    }else{
        return 0;
    }
}

void setPullup(PORT_t* port, unsigned char bt, unsigned char v){    //set pullup on port.bt to v
    unsigned char d;
    if(v){
        d=PORT_PULLUPEN_bm;         //pullups on, port invert off, input buffer enabled
    }else{
        d=0;                        //pullups off, port invert off, input buffer enabled
    }
    switch(bt){                      //
        case 0: port->PIN0CTRL=d; break;
        case 1: port->PIN1CTRL=d; break;
        case 2: port->PIN2CTRL=d; break;
        case 3: port->PIN3CTRL=d; break;
        case 4: port->PIN4CTRL=d; break;
        case 5: port->PIN5CTRL=d; break;
        case 6: port->PIN6CTRL=d; break;
        case 7: port->PIN7CTRL=d; break;
    }            
}

int getADC(unsigned char chan){
    ADC0.CTRLA = 0;                         //reset ADC, off, 10 bit, free run off
    ADC0.CTRLB = ADC_SAMPNUM_ACC1_gc;       //samples accumulated=1
    ADC0.CTRLC = 0;                         //reset
    //ADC0.CTRLC |= ADC_SAMPCAP_bm;           //use reduced sample capacitance
    ADC0.CTRLC |= ADC_REFSEL_VDDREF_gc;     //use VDD as ADC reference
    ADC0.CTRLC |= ADC_PRESC_DIV4_gc;        //use CLK_PER/4 as ADC clock
    ADC0.CTRLD = 0;                         //turn init delay and ADSV off
    ADC0.CTRLE = ADC_WINCM_NONE_gc;         //window comparator off
    ADC0.SAMPCTRL = 0;                      //sample extend = 0
    ADC0.EVCTRL = 0;                        //no event control
    ADC0.INTCTRL = 0;                       //no interrupt control
    ADC0.CTRLA |= ADC_ENABLE_bm;            //turn on ADC
    ADC0.MUXPOS=(chan&ADC_MUXPOS_gm);       //set MUX
    ADC0.COMMAND = ADC_STCONV_bm;           //start conversion
    while(!(ADC0.INTFLAGS&ADC_RESRDY_bm)){} //wait til result
    return ADC0.RESL | (ADC0.RESH<<8);      //get result, LSB first        
}

PORT_t* getPortFromAnalog(unsigned char chan){        //get port from analog channel
    if(chan<8){return &PORTA;}
    if(chan<12){return &PORTB;}
    return 0;        
}

unsigned char getBitFromAnalog(unsigned char chan){   //get bit from analog channel
    if(chan<8){return chan;}        //port A
    if(chan==8){return 5;}          //B5
    if(chan==9){return 4;}          //B4
    if(chan==10){return 1;}         //B1
    if(chan==11){return 0;}         //B0
    return 0xFF;                    //fail
}
