/*
 * File:   uart.h
 * Author: Tim Blythman
 * Demo code for ATtiny816 on breakout board
 * UART
 * Created on 15 October 2018, 10:29 AM
 */

#ifndef ATTINY_UART_H
#define	ATTINY_UART_H

#include <xc.h> // include processor files - each processor file is guarded.  

void uartInit(unsigned long baud);       //start
void uartDeinit();                       //shut down UART
char uartSend(char c);                   //send
char uartPrint(char* c);                 //send char array
char uartSendInt(int n);                 //print a decimal int
char uartReceive();                      //take a char from rx buffer                  
unsigned char uartAvailable();           //bytes available to read


// keep buffer < 256 as only 8 bits used
#define UART_BUFFER_SIZE 32
volatile char uart_rx_buffer[UART_BUFFER_SIZE];
volatile unsigned char uart_rx_buffer_head,uart_rx_buffer_tail;

#endif	/* ATTINY_UART_H */

