/*
 * File:   time.c
 * Author: Tim Blythman
 * Demo code for ATtiny816 on breakout board
 * RTC interface
 * Created on 15 October 2018, 10:29 AM
 */

#include "time.h"

void timeInit(char ps){                     //initialise RTC module 1kHz/(2^ps) (1ms resolution), reset to 0
    while(RTC.STATUS&RTC_CTRLABUSY_bm){}    //wait till prescaler register not busy
    RTC.CTRLA = (ps&0xF)<<3;                //prescale 1:2^ps, disable RTC
    //RTC.CTRLA = RTC_PRESCALER_DIV1_gc;      //prescale 1:1, disable RTC
    RTC.CLKSEL=RTC_CLKSEL_INT1K_gc ;        //internal 1kHz
    while(RTC.STATUS&RTC_CNTBUSY_bm){}      //wait till count register not busy
    RTC.CNT=0;                              //reset
    while(RTC.STATUS&RTC_PERBUSY_bm){}      //wait till period register not busy    
    RTC.PER=65535;                          //full period
    RTC.INTCTRL=0;                          //no interrupts
    while(RTC.STATUS&RTC_CTRLABUSY_bm){}    //wait till ctrla register not busy
    RTC.CTRLA |= RTC_RTCEN_bm;              //enable RTC
}

unsigned int getTime(){     //get value of RTC CNT
    return RTC.CNT;         //get value
}

void timeDelay(unsigned int n){ //wait for n RTC cycles
    unsigned int t0;
    t0=RTC.CNT;                 //start time
    while((RTC.CNT-t0)<n){}     //wait
}