/*
 * File:   DAC.c
 * Author: Tim Blythman
 * Demo code for ATtiny816 on breakout board
 * DAC
 * Created on 15 October 2018, 10:29 AM
 */

// Use these Enums for DAC reference:
//    VREF_DAC0REFSEL_0V55_gc
//    VREF_DAC0REFSEL_1V1_gc
//    VREF_DAC0REFSEL_2V5_gc
//    VREF_DAC0REFSEL_4V34_gc
//    VREF_DAC0REFSEL_1V5_gc

//Single 8 bit DAC on PA6 (SOIC pin 4) designated DAC0

#include "DAC.h"

void DACinit(unsigned char vref){               //set up, connect to output pin, use vref
    PORTA.DIRCLR=PIN6_bm;                       //set as digital input
    PORTA.PIN6CTRL=PORT_ISC_INPUT_DISABLE_gc;   //disable input buffer (also clears IO inversion and pullup)
    VREF.CTRLA &= ~VREF_DAC0REFSEL_gm;          //clear reference
    VREF.CTRLA |= (vref&VREF_DAC0REFSEL_gm);    //reference set
    VREF.CTRLB |= VREF_DAC0REFEN_bm;            //force reference on     
    DAC0.CTRLA |= DAC_OUTEN_bm;                 //output DAC to pin
    DAC0.CTRLA |= DAC_ENABLE_bm;                //enable DAC    
    DAC0.DATA=0;                                //set output to 0    
}

void DACdeinit(){       //release
    DAC0.CTRLA &= ~DAC_ENABLE_bm;               //disable DAC        
    PORTA.PIN6CTRL=PORT_ISC_INTDISABLE_gc;      //enable input buffer (also clears IO inversion and pullup)
    VREF.CTRLB &= ~VREF_DAC0REFEN_bm;           //allow reference to turn off
    DAC0.CTRLA &= ~DAC_OUTEN_bm;                //stop output DAC to pin
}

void DACset(unsigned char d){                   //set output up to 350ksps
    DAC0.DATA=d;
}