
#include "therm.h"
#include "1wire.h"
#include "config.h"
#include "system.h"
#include <xc.h>

unsigned char temp_delta[18] = { 6, 11, 20, 32, 49, 68, 87, 100, 104, 101, 90, 76, 61, 47, 37, 29, 21, 17 };

signed short est_therm_temp_dC(unsigned short adcval) {
  unsigned char i;
  unsigned short val = 1017, nextval, ret = -5000;
  if( adcval <= val ) {
      for( i = 0; i < 18; ++i ) {
          nextval = val - temp_delta[i];
          if( adcval <= val && adcval >= nextval ) {
              ret += (val- adcval) * 500 / temp_delta[i] * 2;
              return ret;
          }
          val = nextval;
          ret += 1000;
      }
  }
  return ret;
}

extern unsigned short ReadADC(unsigned char channel);

signed short read_therm_temp_dC(unsigned char chan) {
    if( chan < 2 ) {
        if( chan == 0 )
            ANSELCbits.ANSC1 = 1;
        else
            ANSELCbits.ANSC2 = 1;
    } else {
        if( chan == 2 )
            ANSELBbits.ANSB4 = 1;
        else
            ANSELBbits.ANSB5 = 1;
    }
    if( chan > 1 )
        chan += 3;
    chan += 5;
    return est_therm_temp_dC(ReadADC(chan));//ADCval);
}

#define Skip_ROM 0xCC
#define Convert_temperature 0x44
#define Read_scratchpad 0xBE

#if 0
signed short DS18B20_read_temp_dC(unsigned char channel) {
    unsigned char temp_msb, temp_lsb;

    if( OW_reset_pulse(channel) ) { // 980us
        OW_write_byte(channel, Skip_ROM); // 504us
        OW_write_byte(channel, Convert_temperature); // 504us
        drive_OW_high(channel); // 0us

        __delay_ms(750+10); // 760ms

        OW_reset_pulse(channel); // 980us
        OW_write_byte(channel, Skip_ROM); // 504us
        OW_write_byte(channel, Read_scratchpad); // 504us

        temp_lsb = OW_read_byte(channel); // 504us
        temp_msb = OW_read_byte(channel); // 504us
        OW_reset_pulse(channel); // 980us

        return (signed short)(((signed short)temp_msb << 8) + (unsigned short)temp_lsb) * 25 / 4;
    } else {
        return -0x8000;
    }
}
#endif

typedef enum { idle, reset1, wait, reset2, read } ds18b20_state;

unsigned char cur_sensor;
ds18b20_state ds18b20_states[4];
unsigned short ds18b20_timers[4];
extern unsigned short raw_ms_timer;

void InitSensors() {
    INTCONbits.T0IF = 0;
    INTCONbits.T0IE = 1;
    OPTION_REG = 0xD4;
}

void DeinitSensors() {
    INTCONbits.T0IE = 0;
    OPTION_REG = 0xFF;
}

void UpdateSensorTemps() {
    if( overrides.temp_dC[cur_sensor] != 0x8000 ) {
        status.input_temp_dC[cur_sensor] = overrides.temp_dC[cur_sensor];
    } else {
        if( active_config.cfg.input_config1&(1<<cur_sensor) ) { // enabled
            if( active_config.cfg.input_config1&(16<<cur_sensor) ) { // is DS18B20
                unsigned char state_inc = 1;
                switch( ds18b20_states[cur_sensor] ) {
                    case idle:
                        if( OW_reset_pulse(cur_sensor) ) // 980us
                            state_inc = 0;
                        break;
                    case reset1:
                        OW_write_byte(cur_sensor, Skip_ROM); // 504us
                        OW_write_byte(cur_sensor, Convert_temperature); // 504us
                        drive_OW_high(cur_sensor); // 0us
                        ds18b20_timers[cur_sensor] = get_raw_ms_timer();
                        break;
                    case wait:
                        if( get_raw_ms_timer() - ds18b20_timers[cur_sensor] > 750+50 ) {
                            if( OW_reset_pulse(cur_sensor) ) // 980us
                                state_inc = 0;
                        } else {
                            state_inc = 0;
                        }
                        break;
                    case reset2: {
                        OW_write_byte(cur_sensor, Skip_ROM); // 504us
                        OW_write_byte(cur_sensor, Read_scratchpad); // 504us
                        break;
                    }
                    case read: {
                        unsigned char temp_lsb, temp_msb;
                        signed short temp;
                        temp_lsb = OW_read_byte(cur_sensor); // 504us
                        temp_msb = OW_read_byte(cur_sensor); // 504us
                        temp = ((signed short)temp_msb << 8) + (signed short)temp_lsb;
                        if( temp >= -880 && temp <= 0x7D0 )
                            status.input_temp_dC[cur_sensor] = temp / 4 * 25;
                        state_inc = idle - read;
                        break;
                    }
                }
                ds18b20_states[cur_sensor] += state_inc;
            } else {
                signed short temp = read_therm_temp_dC(cur_sensor);
                if( status.input_temp_dC[cur_sensor] == 0x8000 )
                    status.input_temp_dC[cur_sensor] = temp;
                else
                    status.input_temp_dC[cur_sensor] += (temp - status.input_temp_dC[cur_sensor]) / 8;
//                SensorTemps_dC[cur_sensor] = read_therm_temp_dC(cur_sensor);
            }
        } else {
           status.input_temp_dC[cur_sensor] = 0x8000;
        }
    }
    cur_sensor = (cur_sensor + 1) & 3;
}
