
#include "pwmlogic.h"
#include "config.h"

static signed short getTemp_dC(signed char val) {
  if( /*val >= INPUT_1 &&*/val <= INPUT_4 )
    return status.input_temp_dC[val - INPUT_1];
  else
    return ((signed short)val) * 100;
}

static signed short getMinMaxTemp_dC(minormax_t* pMinMax) {
  signed short a, b;
  a = getTemp_dC(pMinMax->temp1);
  b = getTemp_dC(pMinMax->temp2);
  if( a > b ) {
    if( pMinMax->min_or_max != min )
      return a;
    else
      return b;
  } else {
    if( pMinMax->min_or_max != max )
      return a;
    else
      return b;
  }
}

static signed short getOutputTemp(output_t* pOut) {
    signed short diff1 = getMinMaxTemp_dC(&pOut->input_temp[0].inputs.plus) - getMinMaxTemp_dC(&pOut->input_temp[0].inputs.minus);
    signed short diff2 = getMinMaxTemp_dC(&pOut->input_temp[1].inputs.plus) - getMinMaxTemp_dC(&pOut->input_temp[1].inputs.minus);
    if( (pOut->input_comb == min && diff2 < diff1) || (pOut->input_comb == max && diff2 > diff1) ) {
        diff1 = diff2;
    } else if( pOut->input_comb == avg ) {
        diff1 = (diff1 + diff2) / 2;
    }
    return diff1;
}

static unsigned char square_uc(unsigned char val) {
    return ((unsigned short)val) * ((unsigned short)val) / 255;
}

static unsigned char cube_uc(unsigned char val) {
    unsigned char ret = ((unsigned short)val) * ((unsigned short)val) / 255;
    return ((unsigned short)ret) * ((unsigned short)val) / 255;
}

static unsigned char newtons_method(unsigned char val, unsigned char (*func) (unsigned char)) {
  unsigned char minval = 0, maxval = 255, avgval, temp;
  while( minval < maxval ) {
    avgval = (minval + maxval) / 2;
    temp = (*func)(avgval);
    if( temp >= val ) {
      maxval = avgval;
    } else {
      minval = avgval + 1;
    }
  }
  return minval;
}
/*
static unsigned char sqrt_uc(unsigned char val) {
  return newtons_method(val, &square_uc);
}

static unsigned char cubert_uc(unsigned char val) {
  return newtons_method(val, &cube_uc);
}
*/

static unsigned char get_target_duty_for(output_t* pOut, unsigned short batt_mV) {
    signed short temp = getOutputTemp(pOut);
    signed short min = pOut->input_temp[0].temp_range.min * 100;
    signed short max = pOut->input_temp[0].temp_range.max * 100;
    if( temp >= min && max > min ) {
        unsigned char duty;
        if( temp >= max ) {
            duty = 255;
        } else {
            duty = (temp - min) * 255UL / (max - min);
        }

        switch(pOut->exp) {
        case exp_2:
            duty = square_uc(duty);
            break;
        case exp_3:
            duty = cube_uc(duty);
            break;
        case exp_sqrt:
            duty = newtons_method(duty, &square_uc);//sqrt_uc(duty[0]);
            break;
        case exp_cubert:
            duty = newtons_method(duty, &cube_uc);//cubert_uc(duty[0]);
            break;
        }

        if( status.cur_mode == mode_cooldown && active_config.cfg.supply.cooldown_comp_high_pct > active_config.cfg.supply.cooldown_comp_low_pct ) {
            unsigned char mV_per_pct = (active_config.cfg.supply.cooldown_min_mV - active_config.cfg.supply.off_mV) / (active_config.cfg.supply.cooldown_comp_high_pct - active_config.cfg.supply.cooldown_comp_low_pct);
            if( mV_per_pct ) {
                unsigned char fact = active_config.cfg.supply.cooldown_comp_low_pct + (batt_mV - active_config.cfg.supply.off_mV) / mV_per_pct;
                duty = (unsigned short)duty * (unsigned short)fact / 100;
            }
        }
        duty = pOut->duty_range.min + (unsigned short)(pOut->duty_range.max - pOut->duty_range.min) * duty / 255;
        if( pOut->SVC_mV && pOut->SVC_mV < batt_mV )
            duty = pOut->duty_range.min + ((duty - pOut->duty_range.min) * (unsigned long)pOut->SVC_mV/* + batt_mV / 2*/) / batt_mV;
        return duty;
    } else {
        return 0;
    }
}

unsigned char duties[4];
unsigned char ms_since_duty_change[4];

void update_duty_cycles(unsigned short ms_passed) {
    unsigned char i;
    for( i = 0; i < 4; ++i ) {
        if( active_config.cfg.outputs[i].disabled || status.cur_mode == mode_sleep ) {
          duties[i] = 0;
        } else if( active_config.cfg.outputs[i].slave_to ) {
          duties[i] = duties[active_config.cfg.outputs[i].slave_to-1];
        } else {
            unsigned char target_duty = get_target_duty_for(&active_config.cfg.outputs[i], status.supply_mV);
            unsigned char ramp_rate = active_config.cfg.outputs[i].ramp_ms_per_pct;

//            if( target_duty > active_config.cfg.outputs[i].duty_range.max )
//                target_duty = active_config.cfg.outputs[i].duty_range.max;

            if( ramp_rate == 0 ) {
                duties[i] = target_duty;
            } else {
                unsigned char diff;
                if( target_duty >= duties[i] ) {
                    diff = target_duty - duties[i];
                } else {
                    diff = duties[i] - target_duty;
                }

                if( diff * (unsigned short)ramp_rate > ms_passed + ms_since_duty_change[i] ) {
                    diff = (ms_passed + ms_since_duty_change[i]) / ramp_rate;
                    ms_since_duty_change[i] = (ms_passed + ms_since_duty_change[i]) - diff * (unsigned short)ramp_rate;
                } else {
                    ms_since_duty_change[i] = 0;
                }
                if( target_duty >= duties[i] )
                    duties[i] += diff;
                else
                    duties[i] -= diff;
            }
        }
    }
}
