<?php

$strings = file("strings.txt");
$seen = array();
$hdr = array("extern unsigned short strings[];");
$asm = array("#include <xc.inc>", "PSECT strings,class=CODE,local,delta=2", "GLOBAL _strings", "_strings");
$offset = 0;
$symnum = 0;
foreach( $strings as $str ) {
  $str = preg_replace("/[\r\n]/", "", $str);
  $sym = preg_replace("/[ ,.\\\\:;()\-\\#\[\]]/", "_", $str);
  $sym = preg_replace("/%/", "pct", $sym);
  $sym = preg_replace("/=/", "equ", $sym);
  if( strlen($sym) > 40 ) {
    $sym = ++$symnum . "";
  }
  if( !isset($seen[$str]) ) {
    array_push($hdr, "#define STR_${sym} (((unsigned)strings) + ${offset})");
    $seen[$str] = $offset;
    $str = preg_replace("/\\\\r/", "\r", $str);
    $str = preg_replace("/\\\\n/", "\n", $str);
    $init_offset = $offset;
    for( $i = 0; $i <= strlen($str); $i += 2 ) {
      if( $i < strlen($str) )
        $val1 = ord(substr($str, $i, 1));
      else
        $val1 = 0;
      if( $i+1 < strlen($str) )
        $val2 = ord(substr($str, $i+1, 1));
      else
        $val2 = 0;
      if( $val1 > 127 || $val2 > 127 )
        throw new Exception("ASCII character with value 128+ found in string: ".$str);
      array_push($asm, sprintf("DW 0x%04x", $val1 + $val2 * 128));
      $offset += 1;
    }
    print "String size = ".($offset - $init_offset)." words.\n";
  }
}
file_put_contents("strings.h", implode("\r\n", $hdr)."\r\n");
file_put_contents("strings.asm", implode("\r\n", $asm)."\r\n");
print "Total words: ".$offset.".\n";

?>