
#include "dumprestore.h"

static char get_base64_char(unsigned char val) {
    val &= 63;
    if( val < 52 ) {
        if( val < 26 )
            return 'A' + val;
        else
            return 'a' + val - 26;
    } else {
        if( val < 62 )
            return '0' + val - 52;
        else if( val == 62 )
            return '+';
        else
            return '/';
    }
}

unsigned char encode_base64(unsigned char* from, unsigned char* to, unsigned char len) {
    unsigned char ret = 0;
    while( len >= 3 ) {
        to[0] = get_base64_char( from[0]>>2 );
        to[1] = get_base64_char( (from[0]<<4) | (from[1]>>4) );
        to[2] = get_base64_char( (from[1]<<2) | (from[2]>>6) );
        to[3] = get_base64_char( from[2] );
        to += 4;
        from += 3;
        len -= 3;
        ret += 4;
    }
    return ret;
}

static unsigned char get_base64_val(char c) {
  if( c >= 'A' && c <= 'Z' )
    return c - 'A';
  else if( c >= 'a' && c <= 'z' )
    return c - 'a' + 26;
  else if( c >= '0' && c <= '9' )
    return c - '0' + 52;
  else if( c == '+' )
    return 62;
  else if( c == '/' )
    return 63;
  else
    return 255;
}

unsigned char decode_base64(const char* from, unsigned char* to) {
  unsigned char dat[4];
  unsigned char ret = 0;
  while( *from ) {
    if( !from[1] || !from[2] || !from[3] )
      return 0;
    dat[0] = get_base64_val(from[0]);
    dat[1] = get_base64_val(from[1]);
    dat[2] = get_base64_val(from[2]);
    dat[3] = get_base64_val(from[3]);
    if( dat[0] == 255 || dat[1] == 255 || dat[2] == 255 || dat[3] == 255 )
      return 0;
    to[0] = (dat[0]<<2)|(dat[1]>>4);
    to[1] = (dat[1]<<4)|(dat[2]>>2);
    to[2] = (dat[2]<<6)| dat[3];
    to += 3;
    from += 4;
    ret += 3;
  }
  return ret;
}
