
#include <xc.h>
#include "1wire.h"
#include "system.h"

static void drive_OW_low(unsigned char channel) {
    if( channel < 2 ) {
        if( channel == 0 ) {
            LATCbits.LATC1 = 0;
            TRISCbits.TRISC1 = 0;
        } else {
            LATCbits.LATC2 = 0;
            TRISCbits.TRISC2 = 0;
        }
    } else {
        if( channel == 2 ) {
            LATBbits.LATB4 = 0;
            TRISBbits.TRISB4 = 0;
        } else {
            LATBbits.LATB5 = 0;
            TRISBbits.TRISB5 = 0;
        }
    }
}

void drive_OW_high(unsigned char channel) {
    if( channel < 2 ) {
        if( channel == 0 ) {
            LATCbits.LATC1 = 1;
            TRISCbits.TRISC1 = 0;
        } else {
            LATCbits.LATC2 = 1;
            TRISCbits.TRISC2 = 0;
        }
    } else {
        if( channel == 2 ) {
            LATBbits.LATB4 = 1;
            TRISBbits.TRISB4 = 0;
        } else {
            LATBbits.LATB5 = 1;
            TRISBbits.TRISB5 = 0;
        }
    }
}

static unsigned char read_OW(unsigned char channel) {
    if( channel < 2 ) {
        if( channel == 0 ) {
            ANSELCbits.ANSC1 = 0;
            TRISCbits.TRISC1 = 1;
            return PORTCbits.RC1;
        } else {
            ANSELCbits.ANSC2 = 0;
            TRISCbits.TRISC2 = 1;
            return PORTCbits.RC2;
        }
    } else {
        if( channel == 2 ) {
            ANSELBbits.ANSB4 = 0;
            TRISBbits.TRISB4 = 1;
            return PORTBbits.RB4;
        } else {
            ANSELBbits.ANSB5 = 0;
            TRISBbits.TRISB5 = 1;
            return PORTBbits.RB5;
        }
    }
}

static void delay_us1(unsigned char us1) {
    while( us1-- )
        __delay_us(1);
}

void delay_us10(unsigned char us10) {
    while( us10-- )
        delay_us1(5);
}

unsigned char OW_reset_pulse(unsigned char channel) {
        unsigned char presence_detect;
        drive_OW_low(channel);
        delay_us10(49);
        read_OW(channel);
        INTCONbits.GIE = 0;
        delay_us10(7);
        presence_detect = read_OW(channel);
        INTCONbits.GIE = 1;
        delay_us10(42);
        return presence_detect;
}

static void OW_write_bit(unsigned char channel, unsigned char write_bit) {
        INTCONbits.GIE = 0;
        if (write_bit) {
                drive_OW_low(channel);
                delay_us10(1);
                drive_OW_high(channel);
                delay_us10(5);
        } else {
                drive_OW_low(channel);
                delay_us10(6);
                drive_OW_high(channel);
                __delay_us(2);
        }
        INTCONbits.GIE = 1;
}

static unsigned char OW_read_bit(unsigned char channel) {
        unsigned char read_data;
        INTCONbits.GIE = 0;
        drive_OW_low(channel);
        __delay_us(2);
        read_OW(channel);
        __delay_us(5+2);
        read_data = read_OW(channel);
        INTCONbits.GIE = 1;
        delay_us10(read_data ? 1 : 5);
        return read_data;
}

void OW_write_byte(unsigned char channel, unsigned char write_data) {
        unsigned char i;
        for (i = 0; i < 8; i++) {
                OW_write_bit(channel, write_data&1);
                write_data >>= 1;
        }        
}

unsigned char OW_read_byte(unsigned char channel) {
        unsigned char i, result=0;

        for (i = 0; i < 8; i++) {
          result >>= 1;
          if( OW_read_bit(channel) )
             result |= 0x80;
        }
        return result;
}
