'Ball Maze by GB Pallotti 
'----------
'Calibrating the 2 Servos may be required.
'The Maximum and Minimum values accepted by the MM Servo command are 2.6 and 0.5
'Adjsut the stationary value of Xoffset and Yoffset to achive correct X and Y axes horizontal levels. 
'----------
OPTION AUTORUN ON
OPTION EXPLICIT
LCD init 9,10,12,13,20,21                      
LCD 1,1, "   MicroMite    "
LCD 2,1, "   Version V1.0   "
Pause 1000
LCD 1,1, "    BALL-MAZE   "
LCD 2,1, " GBP-2023  V1.0 "
Dim VKonst = 0.5                             'Joy Vout to Pulse Width constant multiplier
Dim PWMin = 0.5                              'Servo minimum pulse width   
DIM PWMax = 2.6                              'Servo maximum pulse width 
dim Yservo as float                          'Signal to Servo 2, A
dim Xservo as float                          'Signal to Servo 2, B
dim Yoffset = 0.0                            'Horizontal offset (if required)
dim Xoffset = -0.2                           'Horizontal offset (if required)
dim TimeTaken as STRING                      'Record time taken 
dim ReachStage as integer                    'Stage number completed
Dim CompleteStage(5) as string = ("Stage 1 - ", "Stage 2 - ", "Stage 3 - ", "Stage 4 - ", "Stage 5 - ", "FINISH  - ")
Dim TopStageScore(5) as string 
Dim EXST As string                           'check existing score
SetPin 26, ain                               'Xservo (Pot1) <->
SetPin 27, ain                               'Yservo (Pot2)^-v
SetPin 37, DIN                               'Sjoy (switch NC = 1) 
setpin 4, intH, Stage1                       'Stage 1 completion 
setpin 3, intH, Stage2                       'Stage 2 completion 
setpin 2, intH, Stage3                       'Stage 3 completion 
setpin 1, intH, Stage4                       'Stage 4 completion 
setpin 5, intH, Stage5                       'Stage 5 completion 
setpin 44, intH, Finish                      'Finish 
setpin 43, INTH, Lost                        'Ball lost
'------------------
'Set Times to Beat 
TopStageScore(0) = CompleteStage(0) + " 00:20"
TopStageScore(1) = CompleteStage(1) + " 00:40"
TopStageScore(2) = CompleteStage(2) + " 01:00"
TopStageScore(3) = CompleteStage(3) + " 01:20"
TopStageScore(4) = CompleteStage(4) + " 01:40"
TopStageScore(5) = CompleteStage(5) + " 02:00"
pause 100
VAR restore
'-------------------
ReachStage = 0
servo 2, 1.15, 2.6
LCD 1,1," Move Stick  Up "
LCD 2,1,"To see TOP Score"
pause 2000
LCD 1,1,"Move Stick Down "
LCD 2,1," To START Game  "

Do
if Pin(27) < 1 then  ShowScores                     'Shows scores of all stages
if Pin(27) > 3 then                                 'Hold ball at START 
LCD 1,1, "    BALL-MAZE   "
LCD 2,1, " ..Get Ready..  "
pause 2000
 time$ = "00:00:00"
  do
   LCD 2,1, "    " + time$ + "    "
   Xservo = (Pin(26)* VKonst + PWMin + Xoffset)    'get XJoy pot value to Pulse Width
   if Xservo < PWMin then Xservo = PWMin
   if Xservo > PWMax then Xservo = PWMax
   Yservo = (Pin(27)* VKonst + PWMin + Yoffset)    'get YJoy pot value to Pulse Width     
   if Yservo < PWMin then Yservo = PWMin
   if Yservo > PWMax then Yservo = PWMax
   servo 2, Xservo, Yservo 
  loop
else
Loop
end if
'---------------------
sub Stage1    
Timetaken$ = right$(time$,5) 
LCD 1,1," Reached Stage1 "
ReachStage = 1
end sub
'---------------------
sub Stage2     
Timetaken$ = right$(time$,5) 
LCD 1,1," Reached Stage2 "
ReachStage = 2
end sub
'---------------------
sub Stage3     
Timetaken$ = right$(time$,5) 
LCD 1,1," Reached Stage3 "
ReachStage = 3
end sub
'---------------------
sub Stage4     
Timetaken$ = right$(time$,5) 
LCD 1,1," Reached Stage4 "
ReachStage = 4
end sub
'---------------------
sub Stage5    
Timetaken$ = right$(time$,5) 
LCD 1,1," Reached Stage5 "
ReachStage = 5
end sub
'---------------------
sub Finish     
Timetaken$ = right$(time$,5) 
LCD 1,1," Reached FINISH "
ReachStage = 6
end sub
'---------------------
sub Lost
if ReachStage = 0 then  
 LCD 1,1,"   You loose!    " 
 LCD 2,1,"  Start Again?   "  
 servo 2, 1.15, 2.6
else 
 LCD 1,1,CompleteStage(ReachStage - 1) + " " + TimeTaken$
 CurrentTime = Val(left$(TimeTaken$,2)) * 60 + Val(Right$(TimeTaken$,2))
 BestTime = Val(Mid$(TopStageScore(ReachStage - 1),12,2)) * 60 + Val(Right$(TopStageScore(ReachStage - 1),2))
 if BestTime = 0 then BestTime = 3600
 if CurrentTime < BestTime then
  for x = 1 to 5
   LCD 2,1,"** NEW RECORD **"
   pause 350
   LCD 2,1,"**            **"
   pause 350
   LCD 2,1,"** NEW RECORD **"
  next x
  TopStageScore(ReachStage - 1) = CompleteStage(ReachStage - 1) + " " + Timetaken$
  Var Save TopStageScore()
  pause 1000
 end if
 LCD 2,1,"  Start Again?   "
end if
do
 if Pin(37) = 0 then cpu restart
loop
end sub
'---------------------
sub ShowScores 
LCD 1,1,TopStageScore(0)
LCD 2,1,TopStageScore(1)
pause 2000
LCD 1,1,TopStageScore(2)
LCD 2,1,TopStageScore(3)
pause 2000
LCD 1,1,TopStageScore(4)
LCD 2,1,TopStageScore(5)
Pause 2000
LCD 1,1,"Move Stick Down "
LCD 2,1," To START Game  "
end sub