//  PASTE PROCESSING CLIPBOARD FROM HERE //
#define LED_BOARD_COUNT 9
int led_board_rotation[LED_BOARD_COUNT]={0,-1,-1,0,-1,0,1,1,1};
int led_board_depth[LED_BOARD_COUNT]={0,1,2,1,2,2,2,1,2};
int led_board_x_coord[LED_BOARD_COUNT]={320,262,157,320,262,320,378,378,483};
int led_board_y_coord[LED_BOARD_COUNT]={639,516,411,490,367,341,367,516,411};

#define LED_PIXEL_COUNT 72
int led_pixel_x_coord[LED_PIXEL_COUNT]={
  331,333,341,348,320,285,300,309,256,234,222,203,173,154,196,234,
  151,129,117,98,68,49,91,129,331,333,341,348,320,285,300,309,
  256,234,222,203,173,154,196,234,331,333,341,348,320,285,300,309,
  399,424,448,476,465,436,416,390,399,424,448,476,465,436,416,390,
  504,529,553,581,570,541,521,495
  };
int led_pixel_y_coord[LED_PIXEL_COUNT]={
  619,586,561,527,514,521,565,610,495,470,446,418,429,458,478,504,
  390,365,341,313,324,353,373,399,470,437,412,378,365,372,416,461,
  346,321,297,269,280,309,329,355,321,288,263,229,216,223,267,312,
  361,339,327,308,278,259,301,339,510,488,476,457,427,408,450,488,
  405,383,371,352,322,303,345,383
  };

// TO HERE //

//change pins to suit connections
#define DI_PIN 2
#define CK_PIN 5
#define LT_PIN 4

char leds[LED_PIXEL_COUNT];
int n=0;
int k=0;
int d=10;
int kmin=led_pixel_x_coord[0];
int kmax=led_pixel_x_coord[0];

void setup() {
  int i;
  pinMode(DI_PIN,OUTPUT);
  digitalWrite(DI_PIN,LOW);
  pinMode(CK_PIN,OUTPUT);
  digitalWrite(CK_PIN,LOW);
  pinMode(LT_PIN,OUTPUT);
  digitalWrite(LT_PIN,LOW);
  for(i=0;i<LED_PIXEL_COUNT;i++){
    leds[i]=0;         //start with all off
    if(kmin>led_pixel_x_coord[i]){kmin=led_pixel_x_coord[i];}   //set limits based on data
    if(kmax<led_pixel_x_coord[i]){kmax=led_pixel_x_coord[i];}
  }
}

void loop(){
  int i;
  for(i=0;i<LED_PIXEL_COUNT;i++){
    if(led_pixel_x_coord[i]>k-10&&led_pixel_x_coord[i]<k+10){     //turn boards on if parameter matches k
      leds[i]=1;
    }else{
      leds[i]=0;
    }
  }
  doLeds();
  k=k+d;
  if(k>=kmax){d=-10;}
  if(k<=kmin){d=10;}
  delay(100);
}


void doLeds(){
  int i=LED_PIXEL_COUNT;
  while(i){
    --i;
    digitalWrite(DI_PIN,leds[i]);
    digitalWrite(CK_PIN,HIGH);
    digitalWrite(CK_PIN,LOW);    
  }
  digitalWrite(LT_PIN,LOW);
  digitalWrite(LT_PIN,HIGH);
}

