/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.util.pngj.chunks;

import jogamp.opengl.util.pngj.ImageInfo;
import jogamp.opengl.util.pngj.PngHelperInternal;
import jogamp.opengl.util.pngj.PngjException;
import jogamp.opengl.util.pngj.chunks.ChunkRaw;
import jogamp.opengl.util.pngj.chunks.PngChunk;
import jogamp.opengl.util.pngj.chunks.PngChunkTextVar;

public class PngChunkTEXT
extends PngChunkTextVar {
    public static final String ID = "tEXt";

    public PngChunkTEXT(ImageInfo imageInfo) {
        super(ID, imageInfo);
    }

    @Override
    public ChunkRaw createRawChunk() {
        if (this.key.isEmpty()) {
            throw new PngjException("Text chunk key must be non empty");
        }
        byte[] byArray = (this.key + "\u0000" + this.val).getBytes(PngHelperInternal.charsetLatin1);
        ChunkRaw chunkRaw = this.createEmptyChunk(byArray.length, false);
        chunkRaw.data = byArray;
        return chunkRaw;
    }

    @Override
    public void parseFromRaw(ChunkRaw chunkRaw) {
        int n;
        for (n = 0; n < chunkRaw.data.length && chunkRaw.data[n] != 0; ++n) {
        }
        this.key = new String(chunkRaw.data, 0, n, PngHelperInternal.charsetLatin1);
        this.val = ++n < chunkRaw.data.length ? new String(chunkRaw.data, n, chunkRaw.data.length - n, PngHelperInternal.charsetLatin1) : "";
    }

    @Override
    public void cloneDataFromRead(PngChunk pngChunk) {
        PngChunkTEXT pngChunkTEXT = (PngChunkTEXT)pngChunk;
        this.key = pngChunkTEXT.key;
        this.val = pngChunkTEXT.val;
    }
}

