/*
 * Decompiled with CFR 0.152.
 */
import processing.core.PApplet;
import processing.core.PImage;
import processing.serial.Serial;

public class LEDTreeDataMap
extends PApplet {
    Serial TreeControl;
    int serialIndex = 0;
    String portName = "-port-";
    boolean portConnect = false;
    int x_window = 640;
    int y_window = 640;
    int tx1 = -59;
    int ty1 = -124;
    int tr1 = -1;
    int tx2 = 0;
    int ty2 = -149;
    int tr2 = 0;
    int tx3 = 59;
    int ty3 = -124;
    int tr3 = 1;
    float d1 = 137.0f;
    float a1 = -0.4441f;
    float d2 = 149.0f;
    float a2 = 0.0f;
    float d3 = 137.0f;
    float a3 = 0.4441f;
    float d4 = 100.0f;
    float a4 = 0.0f;
    float[] ledd = new float[8];
    float[] leda = new float[8];
    PImage tree;
    int[] parent = new int[100];
    int[] child1 = new int[100];
    int[] child2 = new int[100];
    int[] child3 = new int[100];
    int[] treex = new int[100];
    int[] treey = new int[100];
    int[] treer = new int[100];
    int[] treeseq = new int[100];
    int[] seqid = new int[100];
    int[] treedepth = new int[100];
    boolean[] ledOn = new boolean[800];
    char[] hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    int nexttree = 1;
    boolean lastmouse;
    boolean lastkey;
    int printcode = -1;
    int printkey = -1;
    boolean showhelp = true;
    float zoom = 1.0f;
    String serialOutput = "";
    int lastt;

    public void setup() {
        this.surface.setResizable(true);
        this.ledd[0] = 22.825424f;
        this.ledd[1] = 54.571056f;
        this.ledd[2] = 80.77747f;
        this.ledd[3] = 115.44696f;
        this.ledd[4] = 125.004f;
        this.ledd[5] = 123.081276f;
        this.ledd[6] = 76.655075f;
        this.ledd[7] = 31.016125f;
        this.leda[0] = 0.5028432f;
        this.leda[1] = 0.24053425f;
        this.leda[2] = 0.26299474f;
        this.leda[3] = 0.24497867f;
        this.leda[4] = -0.007999829f;
        this.leda[5] = -0.28834397f;
        this.leda[6] = -0.26396373f;
        this.leda[7] = -0.36254424f;
        this.treeseq[0] = 1;
        this.seqid[1] = 0;
        this.treedepth[0] = 0;
        this.tree = this.loadImage("tree.png");
        this.background(this.color(192, 192, 192));
        this.imageMode(0);
        this.treex[0] = this.x_window / 2;
        this.treey[0] = this.y_window - 1;
        this.treer[0] = 0;
        this.noStroke();
        this.textSize(32.0f);
        if (Serial.list().length > 0) {
            this.portName = Serial.list()[0];
        }
        this.lastmouse = this.mousePressed;
        this.lastkey = this.keyPressed;
        this.lastt = this.millis();
    }

    public void draw() {
        int n;
        int r;
        this.background(this.color(192, 192, 192));
        this.fill(this.color(0, 0, 0));
        this.text("Trees:" + LEDTreeDataMap.str((int)this.nexttree), this.width - 150, 30.0f);
        this.text("LEDs:" + LEDTreeDataMap.str((int)(this.nexttree * 8)), this.width - 150, 60.0f);
        if (this.portConnect) {
            this.fill(this.color(0, 192, 0));
        } else {
            this.fill(this.color(0, 0, 0));
        }
        this.text(this.portName, this.width - 150, 90.0f);
        this.translate((float)(this.width / 2) - 320.0f * this.zoom, (float)this.height - 640.0f * this.zoom);
        this.scale(this.zoom);
        int j = 0;
        while (j < this.nexttree) {
            this.drawTree(j);
            this.fill(this.color(255, 255, 255));
            r = 0;
            while (r < 8) {
                if (this.ledOn[j * 8 + r]) {
                    this.ellipse(this.treex[j] + PApplet.parseInt((float)(this.ledd[r] * LEDTreeDataMap.sin((float)(LEDTreeDataMap.radians((float)(this.treer[j] * 45)) + this.leda[r])))), this.treey[j] - PApplet.parseInt((float)(this.ledd[r] * LEDTreeDataMap.cos((float)(LEDTreeDataMap.radians((float)(this.treer[j] * 45)) + this.leda[r])))), 10.0f, 10.0f);
                }
                ++r;
            }
            ++j;
        }
        boolean thismouse = this.mousePressed;
        boolean thiskey = this.keyPressed;
        if (thiskey && !this.lastkey) {
            this.printcode = this.keyCode;
            this.printkey = this.key;
            if (this.printkey == 104) {
                boolean bl = this.showhelp = !this.showhelp;
            }
            if (this.printkey == 99) {
                this.generateOutput(99);
            }
            if (this.printkey == 116) {
                GClip.copy(this.serialOutput);
            }
            if (this.printkey == 113) {
                this.exit();
            }
            if (this.printcode == 39) {
                this.surface.setSize(this.width + 20, this.height);
                if (this.width < 100) {
                    this.surface.setSize(100, this.height);
                }
            }
            if (this.printcode == 37) {
                this.surface.setSize(this.width - 20, this.height);
            }
            if (this.printcode == 38) {
                this.surface.setSize(this.width, this.height - 20);
                if (this.height < 100) {
                    this.surface.setSize(this.width, 100);
                }
            }
            if (this.printcode == 40) {
                this.surface.setSize(this.width, this.height + 20);
            }
            if (this.printkey == 61) {
                this.zoom *= 1.1f;
                if (this.zoom > 3.0f) {
                    this.zoom = 3.0f;
                }
            }
            if (this.printkey == 45) {
                this.zoom /= 1.1f;
                if (this.zoom < 0.1f) {
                    this.zoom = 0.1f;
                }
            }
            if (this.printkey == 46 && !this.portConnect) {
                ++this.serialIndex;
            }
            if (this.printkey == 44 && !this.portConnect) {
                --this.serialIndex;
                if (this.serialIndex < 0) {
                    this.serialIndex = 0;
                }
            }
            if (this.serialIndex > Serial.list().length - 1) {
                this.serialIndex = Serial.list().length - 1;
            }
            if (Serial.list().length > 0) {
                this.portName = Serial.list()[this.serialIndex];
            }
            if (this.printkey == 115) {
                if (!this.portConnect) {
                    try {
                        this.TreeControl = new Serial((PApplet)this, this.portName, 9600);
                        this.portConnect = true;
                    }
                    catch (Exception exception) {
                        this.portConnect = false;
                    }
                } else {
                    this.TreeControl.stop();
                    this.portConnect = false;
                }
            }
        }
        this.lastkey = thiskey;
        if (thismouse) {
            this.color(0, 0, 0);
        } else {
            this.color(0, 255, 0);
        }
        j = 0;
        while (j < this.nexttree) {
            this.fill(this.color(0, 255, 0));
            n = this.checkTree(PApplet.parseInt((float)((float)(this.mouseX - this.width / 2) / this.zoom + 320.0f)), PApplet.parseInt((float)((float)(this.mouseY - this.height) / this.zoom + 640.0f)), j);
            if (this.child1[j] != 0 && n == 1) {
                n = 0;
            }
            if (this.child2[j] != 0 && n == 2) {
                n = 0;
            }
            if (this.child3[j] != 0 && n == 3) {
                n = 0;
            }
            switch (n) {
                case 1: {
                    this.ellipse(this.treex[j] + PApplet.parseInt((float)(this.d1 * LEDTreeDataMap.sin((float)(LEDTreeDataMap.radians((float)(this.treer[j] * 45)) + this.a1)))), this.treey[j] - PApplet.parseInt((float)(this.d1 * LEDTreeDataMap.cos((float)(LEDTreeDataMap.radians((float)(this.treer[j] * 45)) + this.a1)))), 30.0f, 30.0f);
                    break;
                }
                case 2: {
                    this.ellipse(this.treex[j] + PApplet.parseInt((float)(this.d2 * LEDTreeDataMap.sin((float)(LEDTreeDataMap.radians((float)(this.treer[j] * 45)) + this.a2)))), this.treey[j] - PApplet.parseInt((float)(this.d2 * LEDTreeDataMap.cos((float)(LEDTreeDataMap.radians((float)(this.treer[j] * 45)) + this.a2)))), 30.0f, 30.0f);
                    break;
                }
                case 3: {
                    this.ellipse(this.treex[j] + PApplet.parseInt((float)(this.d3 * LEDTreeDataMap.sin((float)(LEDTreeDataMap.radians((float)(this.treer[j] * 45)) + this.a3)))), this.treey[j] - PApplet.parseInt((float)(this.d3 * LEDTreeDataMap.cos((float)(LEDTreeDataMap.radians((float)(this.treer[j] * 45)) + this.a3)))), 30.0f, 30.0f);
                    break;
                }
                case 4: {
                    this.ellipse(this.treex[j] + PApplet.parseInt((float)(this.d4 * LEDTreeDataMap.sin((float)(LEDTreeDataMap.radians((float)(this.treer[j] * 45)) + this.a4)))), this.treey[j] - PApplet.parseInt((float)(this.d4 * LEDTreeDataMap.cos((float)(LEDTreeDataMap.radians((float)(this.treer[j] * 45)) + this.a4)))), 30.0f, 30.0f);
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    if (this.ledOn[j * 8 + n - 5]) {
                        this.fill(this.color(255, 255, 255));
                    }
                    this.ellipse(this.treex[j] + PApplet.parseInt((float)(this.ledd[n - 5] * LEDTreeDataMap.sin((float)(LEDTreeDataMap.radians((float)(this.treer[j] * 45)) + this.leda[n - 5])))), this.treey[j] - PApplet.parseInt((float)(this.ledd[n - 5] * LEDTreeDataMap.cos((float)(LEDTreeDataMap.radians((float)(this.treer[j] * 45)) + this.leda[n - 5])))), 15.0f, 15.0f);
                }
            }
            if (thismouse && !this.lastmouse && this.mouseButton == 37 && this.nexttree < 99) {
                if (n == 1) {
                    this.treex[this.nexttree] = this.treex[j] + PApplet.parseInt((float)(this.d1 * LEDTreeDataMap.sin((float)(LEDTreeDataMap.radians((float)(this.treer[j] * 45)) + this.a1))));
                    this.treey[this.nexttree] = this.treey[j] - PApplet.parseInt((float)(this.d1 * LEDTreeDataMap.cos((float)(LEDTreeDataMap.radians((float)(this.treer[j] * 45)) + this.a1))));
                    this.treer[this.nexttree] = this.treer[j] - 1;
                    this.child1[j] = this.nexttree;
                    this.parent[this.nexttree] = j;
                    this.treedepth[this.nexttree] = this.treedepth[j] + 1;
                    ++this.nexttree;
                    this.rebuildTree();
                }
                if (n == 2) {
                    this.treex[this.nexttree] = this.treex[j] + PApplet.parseInt((float)(this.d2 * LEDTreeDataMap.sin((float)(LEDTreeDataMap.radians((float)(this.treer[j] * 45)) + this.a2))));
                    this.treey[this.nexttree] = this.treey[j] - PApplet.parseInt((float)(this.d2 * LEDTreeDataMap.cos((float)(LEDTreeDataMap.radians((float)(this.treer[j] * 45)) + this.a2))));
                    this.treer[this.nexttree] = this.treer[j];
                    this.child2[j] = this.nexttree;
                    this.parent[this.nexttree] = j;
                    this.treedepth[this.nexttree] = this.treedepth[j] + 1;
                    ++this.nexttree;
                    this.rebuildTree();
                }
                if (n == 3) {
                    this.treex[this.nexttree] = this.treex[j] + PApplet.parseInt((float)(this.d3 * LEDTreeDataMap.sin((float)(LEDTreeDataMap.radians((float)(this.treer[j] * 45)) + this.a3))));
                    this.treey[this.nexttree] = this.treey[j] - PApplet.parseInt((float)(this.d3 * LEDTreeDataMap.cos((float)(LEDTreeDataMap.radians((float)(this.treer[j] * 45)) + this.a3))));
                    this.treer[this.nexttree] = this.treer[j] + 1;
                    this.child3[j] = this.nexttree;
                    this.parent[this.nexttree] = j;
                    this.treedepth[this.nexttree] = this.treedepth[j] + 1;
                    ++this.nexttree;
                    this.rebuildTree();
                }
                if (n > 4 && n < 13) {
                    this.ledOn[j * 8 + n - 5] = !this.ledOn[j * 8 + n - 5];
                }
            }
            ++j;
        }
        if (thismouse && !this.lastmouse && this.mouseButton == 39 && this.nexttree > 1) {
            if (this.child1[this.parent[this.nexttree - 1]] == this.nexttree - 1) {
                this.child1[this.parent[this.nexttree - 1]] = 0;
            }
            if (this.child2[this.parent[this.nexttree - 1]] == this.nexttree - 1) {
                this.child2[this.parent[this.nexttree - 1]] = 0;
            }
            if (this.child3[this.parent[this.nexttree - 1]] == this.nexttree - 1) {
                this.child3[this.parent[this.nexttree - 1]] = 0;
            }
            this.parent[this.nexttree - 1] = 0;
            r = 0;
            while (r < 8) {
                this.ledOn[(this.nexttree - 1) * 8 + r] = false;
                ++r;
            }
            --this.nexttree;
            this.rebuildTree();
        }
        this.lastmouse = thismouse;
        if (this.showhelp) {
            this.fill(this.color(192, 192, 192), 192.0f);
            this.rect(10.0f, 10.0f, 620.0f, 620.0f);
            this.fill(this.color(0, 0, 0));
            this.textSize(48.0f);
            this.text("HELP and TIPS:", 30.0f, 50.0f);
            this.textSize(26.0f);
            this.text("Hover over the top of a branch to see which", 30.0f, 100.0f);
            this.text("nodes are available.", 30.0f, 130.0f);
            this.text("Left click to add a node.", 30.0f, 160.0f);
            this.text("Right click to remove the last node.", 30.0f, 190.0f);
            this.text("The tree numbers are automatically updated.", 30.0f, 220.0f);
            this.text("Press 'h' to toggle help.", 30.0f, 260.0f);
            this.text("Press 'c' to copy Arduino code to the clipboard.", 30.0f, 290.0f);
            this.text("Use arrow keys to resize window.", 30.0f, 320.0f);
            this.text("Use +(=)/- to zoom.", 30.0f, 350.0f);
            this.text("Use <(,) and >(.) to cycle through serial ports.", 30.0f, 390.0f);
            this.text("Press 's' to start/stop a serial port connection.", 30.0f, 420.0f);
            this.text("Click on individual LEDs to toggle the LEDs off", 30.0f, 450.0f);
            this.text("and on (output using 9600 baud HEX mode).", 30.0f, 480.0f);
            this.text("Press 't' to copy serial command data", 30.0f, 510.0f);
            this.text("to the clipboard.", 30.0f, 540.0f);
            this.text("Press 'q' to quit.", 30.0f, 570.0f);
            this.text("If the layouts don't match, the LEDs won't!", 30.0f, 610.0f);
            this.textSize(32.0f);
        }
        this.serialOutput = "v0000000000000000";
        j = this.nexttree;
        while (j > 0) {
            n = 0;
            while (n < this.nexttree) {
                if (this.treeseq[n] == j) {
                    this.serialOutput = String.valueOf(this.serialOutput) + this.hex[PApplet.parseInt((boolean)this.ledOn[n * 8 + 4]) * 1 + PApplet.parseInt((boolean)this.ledOn[n * 8 + 5]) * 2 + PApplet.parseInt((boolean)this.ledOn[n * 8 + 6]) * 4 + PApplet.parseInt((boolean)this.ledOn[n * 8 + 7]) * 8];
                    this.serialOutput = String.valueOf(this.serialOutput) + this.hex[PApplet.parseInt((boolean)this.ledOn[n * 8 + 0]) * 1 + PApplet.parseInt((boolean)this.ledOn[n * 8 + 1]) * 2 + PApplet.parseInt((boolean)this.ledOn[n * 8 + 2]) * 4 + PApplet.parseInt((boolean)this.ledOn[n * 8 + 3]) * 8];
                }
                ++n;
            }
            --j;
        }
        this.serialOutput = String.valueOf(this.serialOutput) + "V\r\n";
        if (this.millis() - this.lastt > 250) {
            if (this.portConnect) {
                this.TreeControl.write(this.serialOutput);
            }
            this.lastt = this.millis();
        }
    }

    public void generateOutput(int k) {
        int j;
        String out = "";
        out = String.valueOf(out) + "#define LED_BOARD_COUNT " + LEDTreeDataMap.str((int)this.nexttree) + "\r\n";
        out = String.valueOf(out) + "int led_board_rotation[LED_BOARD_COUNT]={";
        int i = 1;
        while (i < this.nexttree + 1) {
            out = String.valueOf(out) + LEDTreeDataMap.str((int)this.treer[this.seqid[i]]) + ",";
            ++i;
        }
        out = out.substring(0, out.length() - 1);
        out = String.valueOf(out) + "};" + "\r\n";
        out = String.valueOf(out) + "int led_board_depth[LED_BOARD_COUNT]={";
        i = 1;
        while (i < this.nexttree + 1) {
            out = String.valueOf(out) + LEDTreeDataMap.str((int)this.treedepth[this.seqid[i]]) + ",";
            ++i;
        }
        out = out.substring(0, out.length() - 1);
        out = String.valueOf(out) + "};\r\n";
        out = String.valueOf(out) + "int led_board_x_coord[LED_BOARD_COUNT]={";
        i = 1;
        while (i < this.nexttree + 1) {
            out = String.valueOf(out) + LEDTreeDataMap.str((int)this.treex[this.seqid[i]]) + ",";
            ++i;
        }
        out = out.substring(0, out.length() - 1);
        out = String.valueOf(out) + "};\r\n";
        out = String.valueOf(out) + "int led_board_y_coord[LED_BOARD_COUNT]={";
        i = 1;
        while (i < this.nexttree + 1) {
            out = String.valueOf(out) + LEDTreeDataMap.str((int)this.treey[this.seqid[i]]) + ",";
            ++i;
        }
        out = out.substring(0, out.length() - 1);
        out = String.valueOf(out) + "};\r\n\r\n";
        out = String.valueOf(out) + "#define LED_PIXEL_COUNT " + LEDTreeDataMap.str((int)(this.nexttree * 8)) + "\r\n";
        out = String.valueOf(out) + "int led_pixel_x_coord[LED_PIXEL_COUNT]={";
        i = 1;
        while (i < this.nexttree + 1) {
            if ((i & 1) == 1) {
                out = String.valueOf(out) + "\r\n\t";
            }
            j = 0;
            while (j < 8) {
                out = String.valueOf(out) + LEDTreeDataMap.str((int)(this.treex[this.seqid[i]] + PApplet.parseInt((float)(this.ledd[j] * LEDTreeDataMap.sin((float)(LEDTreeDataMap.radians((float)(this.treer[this.seqid[i]] * 45)) + this.leda[j])))))) + ",";
                ++j;
            }
            ++i;
        }
        out = out.substring(0, out.length() - 1);
        out = String.valueOf(out) + "\r\n\t};\r\n";
        out = String.valueOf(out) + "int led_pixel_y_coord[LED_PIXEL_COUNT]={";
        i = 1;
        while (i < this.nexttree + 1) {
            if ((i & 1) == 1) {
                out = String.valueOf(out) + "\r\n\t";
            }
            j = 0;
            while (j < 8) {
                out = String.valueOf(out) + LEDTreeDataMap.str((int)(this.treey[this.seqid[i]] - PApplet.parseInt((float)(this.ledd[j] * LEDTreeDataMap.cos((float)(LEDTreeDataMap.radians((float)(this.treer[this.seqid[i]] * 45)) + this.leda[j])))))) + ",";
                ++j;
            }
            ++i;
        }
        out = out.substring(0, out.length() - 1);
        out = String.valueOf(out) + "\r\n\t};\r\n\r\n";
        if (k == 99) {
            GClip.copy(out);
        }
        if (k == 100) {
            LEDTreeDataMap.print((String)out);
        }
    }

    public void drawTree(int n) {
        this.pushMatrix();
        this.translate(this.treex[n], this.treey[n]);
        this.rotateZ(LEDTreeDataMap.radians((float)(this.treer[n] * 45)));
        this.image(this.tree, 0 - this.tree.width / 2, 0 - this.tree.height);
        this.translate(60.0f, 110.0f);
        if (this.treeseq[n] > 9) {
            this.translate(-10.0f, 0.0f);
        }
        this.fill(this.color(0, 0, 0));
        this.text(LEDTreeDataMap.str((int)this.treeseq[n]), 0 - this.tree.width / 2, 0 - this.tree.height);
        this.popMatrix();
    }

    public void rebuildTree() {
        int n = 1;
        int tree = 0;
        int k = 0;
        int i = 0;
        while (i < 100) {
            this.treeseq[i] = 0;
            ++i;
        }
        this.treeseq[tree] = n;
        while (n < this.nexttree && k < 300) {
            ++k;
            if (this.child1[tree] > 0 && this.treeseq[this.child1[tree]] == 0) {
                tree = this.child1[tree];
                this.treeseq[tree] = ++n;
                this.seqid[n] = tree;
                continue;
            }
            if (this.child2[tree] > 0 && this.treeseq[this.child2[tree]] == 0) {
                tree = this.child2[tree];
                this.treeseq[tree] = ++n;
                this.seqid[n] = tree;
                continue;
            }
            if (this.child3[tree] > 0 && this.treeseq[this.child3[tree]] == 0) {
                tree = this.child3[tree];
                this.treeseq[tree] = ++n;
                this.seqid[n] = tree;
                continue;
            }
            tree = this.parent[tree];
        }
    }

    public int checkTree(int x, int y, int n) {
        long y0;
        long thresh = 225L;
        int retval = 0;
        long x0 = this.treex[n] + PApplet.parseInt((float)(this.d1 * LEDTreeDataMap.sin((float)(LEDTreeDataMap.radians((float)(this.treer[n] * 45)) + this.a1))));
        if (((long)x - x0) * ((long)x - x0) + ((long)y - (y0 = (long)(this.treey[n] - PApplet.parseInt((float)(this.d1 * LEDTreeDataMap.cos((float)(LEDTreeDataMap.radians((float)(this.treer[n] * 45)) + this.a1))))))) * ((long)y - y0) < thresh) {
            retval = 1;
        }
        if (((long)x - (x0 = (long)(this.treex[n] + PApplet.parseInt((float)(this.d2 * LEDTreeDataMap.sin((float)(LEDTreeDataMap.radians((float)(this.treer[n] * 45)) + this.a2))))))) * ((long)x - x0) + ((long)y - (y0 = (long)(this.treey[n] - PApplet.parseInt((float)(this.d2 * LEDTreeDataMap.cos((float)(LEDTreeDataMap.radians((float)(this.treer[n] * 45)) + this.a2))))))) * ((long)y - y0) < thresh) {
            retval = 2;
        }
        if (((long)x - (x0 = (long)(this.treex[n] + PApplet.parseInt((float)(this.d3 * LEDTreeDataMap.sin((float)(LEDTreeDataMap.radians((float)(this.treer[n] * 45)) + this.a3))))))) * ((long)x - x0) + ((long)y - (y0 = (long)(this.treey[n] - PApplet.parseInt((float)(this.d3 * LEDTreeDataMap.cos((float)(LEDTreeDataMap.radians((float)(this.treer[n] * 45)) + this.a3))))))) * ((long)y - y0) < thresh) {
            retval = 3;
        }
        int r = 0;
        while (r < 8) {
            x0 = this.treex[n] + PApplet.parseInt((float)(this.ledd[r] * LEDTreeDataMap.sin((float)(LEDTreeDataMap.radians((float)(this.treer[n] * 45)) + this.leda[r]))));
            if (((long)x - x0) * ((long)x - x0) + ((long)y - (y0 = (long)(this.treey[n] - PApplet.parseInt((float)(this.ledd[r] * LEDTreeDataMap.cos((float)(LEDTreeDataMap.radians((float)(this.treer[n] * 45)) + this.leda[r]))))))) * ((long)y - y0) < thresh / 4L) {
                retval = 5 + r;
            }
            ++r;
        }
        return retval;
    }

    public void settings() {
        this.size(640, 640, "processing.opengl.PGraphics3D");
    }

    public static void main(String[] passedArgs) {
        String[] appletArgs = new String[]{"LEDTreeDataMap"};
        if (passedArgs != null) {
            PApplet.main((String[])LEDTreeDataMap.concat((String[])appletArgs, (String[])passedArgs));
        } else {
            PApplet.main((String[])appletArgs);
        }
    }
}

