/*
 * Decompiled with CFR 0.152.
 */
package processing.core;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.PathIterator;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import processing.core.PApplet;
import processing.core.PConstants;
import processing.core.PImage;
import processing.core.PShape;

public class PFont
implements PConstants {
    protected int glyphCount;
    protected Glyph[] glyphs;
    protected String name;
    protected String psname;
    protected int size;
    protected int density = 1;
    protected boolean smooth;
    protected int ascent;
    protected int descent;
    protected int[] ascii;
    protected boolean lazy;
    protected Font font;
    protected boolean stream;
    protected boolean subsetting;
    protected boolean fontSearched;
    protected static Font[] fonts;
    protected static HashMap<String, Font> fontDifferent;
    protected BufferedImage lazyImage;
    protected Graphics2D lazyGraphics;
    protected FontMetrics lazyMetrics;
    protected int[] lazySamples;
    static final char[] EXTRA_CHARS;
    public static char[] CHARSET;

    static {
        EXTRA_CHARS = new char[]{'\u0080', '\u0081', '\u0082', '\u0083', '\u0084', '\u0085', '\u0086', '\u0087', '\u0088', '\u0089', '\u008a', '\u008b', '\u008c', '\u008d', '\u008e', '\u008f', '\u0090', '\u0091', '\u0092', '\u0093', '\u0094', '\u0095', '\u0096', '\u0097', '\u0098', '\u0099', '\u009a', '\u009b', '\u009c', '\u009d', '\u009e', '\u009f', '\u00a0', '\u00a1', '\u00a2', '\u00a3', '\u00a4', '\u00a5', '\u00a6', '\u00a7', '\u00a8', '\u00a9', '\u00aa', '\u00ab', '\u00ac', '\u00ad', '\u00ae', '\u00af', '\u00b0', '\u00b1', '\u00b4', '\u00b5', '\u00b6', '\u00b7', '\u00b8', '\u00ba', '\u00bb', '\u00bf', '\u00c0', '\u00c1', '\u00c2', '\u00c3', '\u00c4', '\u00c5', '\u00c6', '\u00c7', '\u00c8', '\u00c9', '\u00ca', '\u00cb', '\u00cc', '\u00cd', '\u00ce', '\u00cf', '\u00d1', '\u00d2', '\u00d3', '\u00d4', '\u00d5', '\u00d6', '\u00d7', '\u00d8', '\u00d9', '\u00da', '\u00db', '\u00dc', '\u00dd', '\u00df', '\u00e0', '\u00e1', '\u00e2', '\u00e3', '\u00e4', '\u00e5', '\u00e6', '\u00e7', '\u00e8', '\u00e9', '\u00ea', '\u00eb', '\u00ec', '\u00ed', '\u00ee', '\u00ef', '\u00f1', '\u00f2', '\u00f3', '\u00f4', '\u00f5', '\u00f6', '\u00f7', '\u00f8', '\u00f9', '\u00fa', '\u00fb', '\u00fc', '\u00fd', '\u00ff', '\u0102', '\u0103', '\u0104', '\u0105', '\u0106', '\u0107', '\u010c', '\u010d', '\u010e', '\u010f', '\u0110', '\u0111', '\u0118', '\u0119', '\u011a', '\u011b', '\u0131', '\u0139', '\u013a', '\u013d', '\u013e', '\u0141', '\u0142', '\u0143', '\u0144', '\u0147', '\u0148', '\u0150', '\u0151', '\u0152', '\u0153', '\u0154', '\u0155', '\u0158', '\u0159', '\u015a', '\u015b', '\u015e', '\u015f', '\u0160', '\u0161', '\u0162', '\u0163', '\u0164', '\u0165', '\u016e', '\u016f', '\u0170', '\u0171', '\u0178', '\u0179', '\u017a', '\u017b', '\u017c', '\u017d', '\u017e', '\u0192', '\u02c6', '\u02c7', '\u02d8', '\u02d9', '\u02da', '\u02db', '\u02dc', '\u02dd', '\u03a9', '\u03c0', '\u2013', '\u2014', '\u2018', '\u2019', '\u201a', '\u201c', '\u201d', '\u201e', '\u2020', '\u2021', '\u2022', '\u2026', '\u2030', '\u2039', '\u203a', '\u2044', '\u20ac', '\u2122', '\u2202', '\u2206', '\u220f', '\u2211', '\u221a', '\u221e', '\u222b', '\u2248', '\u2260', '\u2264', '\u2265', '\u25ca', '\uf8ff', '\ufb01', '\ufb02'};
        CHARSET = new char[94 + EXTRA_CHARS.length];
        int index = 0;
        int i = 33;
        while (i <= 126) {
            PFont.CHARSET[index++] = (char)i;
            ++i;
        }
        i = 0;
        while (i < EXTRA_CHARS.length) {
            PFont.CHARSET[index++] = EXTRA_CHARS[i];
            ++i;
        }
    }

    public PFont() {
    }

    public PFont(Font font, boolean smooth) {
        this(font, smooth, null);
    }

    public PFont(Font font, boolean smooth, char[] charset) {
        this.font = font;
        this.smooth = smooth;
        this.name = font.getName();
        this.psname = font.getPSName();
        this.size = font.getSize();
        int initialCount = 10;
        this.glyphs = new Glyph[initialCount];
        this.ascii = new int[128];
        Arrays.fill(this.ascii, -1);
        int mbox3 = this.size * 3;
        this.lazyImage = new BufferedImage(mbox3, mbox3, 1);
        this.lazyGraphics = (Graphics2D)this.lazyImage.getGraphics();
        this.lazyGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, smooth ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
        this.lazyGraphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, smooth ? RenderingHints.VALUE_TEXT_ANTIALIAS_ON : RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        this.lazyGraphics.setFont(font);
        this.lazyMetrics = this.lazyGraphics.getFontMetrics();
        this.lazySamples = new int[mbox3 * mbox3];
        if (charset == null) {
            this.lazy = true;
        } else {
            Arrays.sort(charset);
            this.glyphs = new Glyph[charset.length];
            this.glyphCount = 0;
            char[] cArray = charset;
            int n = charset.length;
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                if (font.canDisplay(c)) {
                    Glyph glyf = new Glyph(c);
                    if (glyf.value < 128) {
                        this.ascii[glyf.value] = this.glyphCount;
                    }
                    glyf.index = this.glyphCount;
                    this.glyphs[this.glyphCount++] = glyf;
                }
                ++n2;
            }
            if (this.glyphCount != charset.length) {
                this.glyphs = (Glyph[])PApplet.subset(this.glyphs, 0, this.glyphCount);
            }
        }
        if (this.ascent == 0) {
            if (font.canDisplay('d')) {
                new Glyph('d');
            } else {
                this.ascent = this.lazyMetrics.getAscent();
            }
        }
        if (this.descent == 0) {
            if (font.canDisplay('p')) {
                new Glyph('p');
            } else {
                this.descent = this.lazyMetrics.getDescent();
            }
        }
    }

    public PFont(Font font, boolean smooth, char[] charset, boolean stream, int density) {
        this(font, smooth, charset);
        this.stream = stream;
        this.density = density;
    }

    public PFont(InputStream input) throws IOException {
        DataInputStream is = new DataInputStream(input);
        this.glyphCount = is.readInt();
        int version = is.readInt();
        this.size = is.readInt();
        is.readInt();
        this.ascent = is.readInt();
        this.descent = is.readInt();
        this.glyphs = new Glyph[this.glyphCount];
        this.ascii = new int[128];
        Arrays.fill(this.ascii, -1);
        int i = 0;
        while (i < this.glyphCount) {
            Glyph glyph = new Glyph(is);
            if (glyph.value < 128) {
                this.ascii[glyph.value] = i;
            }
            glyph.index = i;
            this.glyphs[i] = glyph;
            ++i;
        }
        if (this.ascent == 0 && this.descent == 0) {
            throw new RuntimeException("Please use \"Create Font\" to re-create this font.");
        }
        Glyph[] glyphArray = this.glyphs;
        int n = this.glyphs.length;
        int n2 = 0;
        while (n2 < n) {
            Glyph glyph = glyphArray[n2];
            glyph.readBitmap(is);
            ++n2;
        }
        if (version >= 10) {
            this.name = is.readUTF();
            this.psname = is.readUTF();
        }
        if (version == 11) {
            this.smooth = is.readBoolean();
        }
    }

    public void save(OutputStream output) throws IOException {
        DataOutputStream os = new DataOutputStream(output);
        os.writeInt(this.glyphCount);
        if (this.name == null || this.psname == null) {
            this.name = "";
            this.psname = "";
        }
        os.writeInt(11);
        os.writeInt(this.size);
        os.writeInt(0);
        os.writeInt(this.ascent);
        os.writeInt(this.descent);
        int i = 0;
        while (i < this.glyphCount) {
            this.glyphs[i].writeHeader(os);
            ++i;
        }
        i = 0;
        while (i < this.glyphCount) {
            this.glyphs[i].writeBitmap(os);
            ++i;
        }
        os.writeUTF(this.name);
        os.writeUTF(this.psname);
        os.writeBoolean(this.smooth);
        os.flush();
    }

    protected void addGlyph(char c) {
        Glyph glyph = new Glyph(c);
        if (this.glyphCount == this.glyphs.length) {
            this.glyphs = (Glyph[])PApplet.expand(this.glyphs);
        }
        if (this.glyphCount == 0) {
            glyph.index = 0;
            this.glyphs[this.glyphCount] = glyph;
            if (glyph.value < 128) {
                this.ascii[glyph.value] = 0;
            }
        } else if (this.glyphs[this.glyphCount - 1].value < glyph.value) {
            this.glyphs[this.glyphCount] = glyph;
            if (glyph.value < 128) {
                this.ascii[glyph.value] = this.glyphCount;
            }
        } else {
            int i = 0;
            while (i < this.glyphCount) {
                if (this.glyphs[i].value > c) {
                    int j = this.glyphCount;
                    while (j > i) {
                        this.glyphs[j] = this.glyphs[j - 1];
                        if (this.glyphs[j].value < 128) {
                            this.ascii[this.glyphs[j].value] = j;
                        }
                        --j;
                    }
                    glyph.index = i;
                    this.glyphs[i] = glyph;
                    if (c >= '\u0080') break;
                    this.ascii[c] = i;
                    break;
                }
                ++i;
            }
        }
        ++this.glyphCount;
    }

    public String getName() {
        return this.name;
    }

    public String getPostScriptName() {
        return this.psname;
    }

    public void setNative(Object font) {
        this.font = (Font)font;
    }

    @Deprecated
    public Font getFont() {
        return this.font;
    }

    public Object getNative() {
        if (this.subsetting) {
            return null;
        }
        return this.font;
    }

    public int getSize() {
        return this.size;
    }

    public int getDefaultSize() {
        return this.size / this.density;
    }

    public boolean isSmooth() {
        return this.smooth;
    }

    public boolean isStream() {
        return this.stream;
    }

    public void setSubsetting() {
        this.subsetting = true;
    }

    public Object findNative() {
        if (this.font == null && !this.fontSearched) {
            this.font = new Font(this.name, 0, this.size);
            if (!this.font.getPSName().equals(this.psname)) {
                this.font = new Font(this.psname, 0, this.size);
            }
            if (!this.font.getPSName().equals(this.psname)) {
                this.font = null;
            }
            this.fontSearched = true;
        }
        return this.font;
    }

    public Glyph getGlyph(char c) {
        int index = this.index(c);
        return index == -1 ? null : this.glyphs[index];
    }

    protected int index(char c) {
        if (this.lazy) {
            int index = this.indexActual(c);
            if (index != -1) {
                return index;
            }
            if (this.font != null && this.font.canDisplay(c)) {
                this.addGlyph(c);
                return this.indexActual(c);
            }
            return -1;
        }
        return this.indexActual(c);
    }

    protected int indexActual(char c) {
        if (this.glyphCount == 0) {
            return -1;
        }
        if (c < '\u0080') {
            return this.ascii[c];
        }
        return this.indexHunt(c, 0, this.glyphCount - 1);
    }

    protected int indexHunt(int c, int start, int stop) {
        int pivot = (start + stop) / 2;
        if (c == this.glyphs[pivot].value) {
            return pivot;
        }
        if (start >= stop) {
            return -1;
        }
        if (c < this.glyphs[pivot].value) {
            return this.indexHunt(c, start, pivot - 1);
        }
        return this.indexHunt(c, pivot + 1, stop);
    }

    public float kern(char a, char b) {
        return 0.0f;
    }

    public float ascent() {
        return (float)this.ascent / (float)this.size;
    }

    public float descent() {
        return (float)this.descent / (float)this.size;
    }

    public float width(char c) {
        if (c == ' ') {
            return this.width('i');
        }
        int cc = this.index(c);
        if (cc == -1) {
            return 0.0f;
        }
        return (float)this.glyphs[cc].setWidth / (float)this.size;
    }

    public int getGlyphCount() {
        return this.glyphCount;
    }

    public Glyph getGlyph(int i) {
        return this.glyphs[i];
    }

    public PShape getShape(char ch) {
        return this.getShape(ch, 0.0f);
    }

    public PShape getShape(char ch, float detail) {
        Font font = (Font)this.getNative();
        if (font == null) {
            throw new IllegalArgumentException("getShape() only works on fonts loaded with createFont()");
        }
        PShape s = new PShape(102);
        float[] iterPoints = new float[6];
        char[] textArray = new char[]{ch};
        FontRenderContext frc = Toolkit.getDefaultToolkit().getFontMetrics(font).getFontRenderContext();
        GlyphVector gv = font.createGlyphVector(frc, textArray);
        Shape shp = gv.getOutline();
        PathIterator iter = detail == 0.0f ? shp.getPathIterator(null) : shp.getPathIterator(null, detail);
        int contours = 0;
        while (!iter.isDone()) {
            int type = iter.currentSegment(iterPoints);
            switch (type) {
                case 0: {
                    if (contours == 0) {
                        s.beginShape();
                    } else {
                        s.beginContour();
                    }
                    ++contours;
                    s.vertex(iterPoints[0], iterPoints[1]);
                    break;
                }
                case 1: {
                    s.vertex(iterPoints[0], iterPoints[1]);
                    break;
                }
                case 2: {
                    s.quadraticVertex(iterPoints[0], iterPoints[1], iterPoints[2], iterPoints[3]);
                    break;
                }
                case 3: {
                    s.quadraticVertex(iterPoints[0], iterPoints[1], iterPoints[2], iterPoints[3], iterPoints[4], iterPoints[5]);
                    break;
                }
                case 4: {
                    if (contours <= true) break;
                    s.endContour();
                }
            }
            iter.next();
        }
        s.endShape(2);
        return s;
    }

    public static String[] list() {
        PFont.loadFonts();
        String[] list = new String[fonts.length];
        int i = 0;
        while (i < list.length) {
            list[i] = fonts[i].getName();
            ++i;
        }
        return list;
    }

    public static void loadFonts() {
        if (fonts == null) {
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            fonts = ge.getAllFonts();
            if (PApplet.platform == 2) {
                fontDifferent = new HashMap();
                Font[] fontArray = fonts;
                int n = fonts.length;
                int n2 = 0;
                while (n2 < n) {
                    Font font = fontArray[n2];
                    fontDifferent.put(font.getName(), font);
                    ++n2;
                }
            }
        }
    }

    public static Font findFont(String name) {
        Font maybe;
        PFont.loadFonts();
        if (PApplet.platform == 2 && (maybe = fontDifferent.get(name)) != null) {
            return maybe;
        }
        return new Font(name, 0, 1);
    }

    public class Glyph {
        public PImage image;
        public int value;
        public int height;
        public int width;
        public int index;
        public int setWidth;
        public int topExtent;
        public int leftExtent;

        public Glyph() {
            this.index = -1;
        }

        public Glyph(DataInputStream is) throws IOException {
            this.index = -1;
            this.readHeader(is);
        }

        protected void readHeader(DataInputStream is) throws IOException {
            this.value = is.readInt();
            this.height = is.readInt();
            this.width = is.readInt();
            this.setWidth = is.readInt();
            this.topExtent = is.readInt();
            this.leftExtent = is.readInt();
            is.readInt();
            if (this.value == 100 && PFont.this.ascent == 0) {
                PFont.this.ascent = this.topExtent;
            }
            if (this.value == 112 && PFont.this.descent == 0) {
                PFont.this.descent = -this.topExtent + this.height;
            }
        }

        protected void writeHeader(DataOutputStream os) throws IOException {
            os.writeInt(this.value);
            os.writeInt(this.height);
            os.writeInt(this.width);
            os.writeInt(this.setWidth);
            os.writeInt(this.topExtent);
            os.writeInt(this.leftExtent);
            os.writeInt(0);
        }

        protected void readBitmap(DataInputStream is) throws IOException {
            this.image = new PImage(this.width, this.height, 4);
            int bitmapSize = this.width * this.height;
            byte[] temp = new byte[bitmapSize];
            is.readFully(temp);
            int w = this.width;
            int h = this.height;
            int[] pixels = this.image.pixels;
            int y = 0;
            while (y < h) {
                int x = 0;
                while (x < w) {
                    pixels[y * this.width + x] = temp[y * w + x] & 0xFF;
                    ++x;
                }
                ++y;
            }
        }

        protected void writeBitmap(DataOutputStream os) throws IOException {
            int[] pixels = this.image.pixels;
            int y = 0;
            while (y < this.height) {
                int x = 0;
                while (x < this.width) {
                    os.write(pixels[y * this.width + x] & 0xFF);
                    ++x;
                }
                ++y;
            }
        }

        protected Glyph(char c) {
            int mbox3 = PFont.this.size * 3;
            PFont.this.lazyGraphics.setColor(Color.white);
            PFont.this.lazyGraphics.fillRect(0, 0, mbox3, mbox3);
            PFont.this.lazyGraphics.setColor(Color.black);
            PFont.this.lazyGraphics.drawString(String.valueOf(c), PFont.this.size, PFont.this.size * 2);
            WritableRaster raster = PFont.this.lazyImage.getRaster();
            raster.getDataElements(0, 0, mbox3, mbox3, PFont.this.lazySamples);
            int minX = 1000;
            int maxX = 0;
            int minY = 1000;
            int maxY = 0;
            boolean pixelFound = false;
            int y = 0;
            while (y < mbox3) {
                int x = 0;
                while (x < mbox3) {
                    int sample = PFont.this.lazySamples[y * mbox3 + x] & 0xFF;
                    if (sample != 255) {
                        if (x < minX) {
                            minX = x;
                        }
                        if (y < minY) {
                            minY = y;
                        }
                        if (x > maxX) {
                            maxX = x;
                        }
                        if (y > maxY) {
                            maxY = y;
                        }
                        pixelFound = true;
                    }
                    ++x;
                }
                ++y;
            }
            if (!pixelFound) {
                minY = 0;
                minX = 0;
                maxY = 0;
                maxX = 0;
            }
            this.value = c;
            this.height = maxY - minY + 1;
            this.width = maxX - minX + 1;
            this.setWidth = PFont.this.lazyMetrics.charWidth(c);
            this.topExtent = PFont.this.size * 2 - minY;
            this.leftExtent = minX - PFont.this.size;
            this.image = new PImage(this.width, this.height, 4);
            int[] pixels = this.image.pixels;
            int y2 = minY;
            while (y2 <= maxY) {
                int x = minX;
                while (x <= maxX) {
                    int val = 255 - (PFont.this.lazySamples[y2 * mbox3 + x] & 0xFF);
                    int pindex = (y2 - minY) * this.width + (x - minX);
                    pixels[pindex] = val;
                    ++x;
                }
                ++y2;
            }
            if (this.value == 100 && PFont.this.ascent == 0) {
                PFont.this.ascent = this.topExtent;
            }
            if (this.value == 112 && PFont.this.descent == 0) {
                PFont.this.descent = -this.topExtent + this.height;
            }
        }
    }
}

