//change pins to suit connections
#define DI_PIN 2
#define CK_PIN 3
#define LT_PIN 4

//set this to suit (8 x number of boards)
#define LEDCOUNT 8

char leds[LEDCOUNT];  //LED states are held here, 1=ON, 0=OFF
int n=0;

void setup() {
  pinMode(DI_PIN,OUTPUT);
  digitalWrite(DI_PIN,LOW);
  pinMode(CK_PIN,OUTPUT);
  digitalWrite(CK_PIN,LOW);
  pinMode(LT_PIN,OUTPUT);
  digitalWrite(LT_PIN,LOW);
  for(int i=0;i<LEDCOUNT;i++){leds[i]=0;}     //start with all off

}

void loop() {  
  for(int i=0;i<LEDCOUNT;i++){leds[i]=0;}     //start with all off
  leds[n]=1;                                  //turn on one at a time
  n=n+1;                                      //switch to next one
  if(n>=LEDCOUNT){n=0;}
  doLeds();                                   //output the array
  delay(300);                                 //extend delay to slow down
}

void doLeds(){
  int i=LEDCOUNT;     //position 0=>LED1 on PCB 1, 7=> LED8 on PCB 1, 8=> LED1 on PCB2 etc
  while(i){
    --i;              //data is output backwards so that correct LED is lit, even if some are missing
    digitalWrite(DI_PIN,leds[i]);   //set the data
    digitalWrite(CK_PIN,HIGH);      //toggle clock
    digitalWrite(CK_PIN,LOW);    
  }
  digitalWrite(LT_PIN,LOW);         //toggle latch
  digitalWrite(LT_PIN,HIGH);
}

