'picaxe 08M2 digital thermometer with 4 digit i2c LED display utilising HT16K33 chip JULY 2018
'at bootup displays AL (ALARM) temperature
'displays temperature t, Hi (24hr), rHi (since RESET), Lo (24hr) and rLo (since RESET) temperatures
'when in ALARM, outputs a physical alarm on pinc.0 and flashes LED display at 1Hz until the power is cycled

'---------------
'RAM allocations

'$50 - $5f - stored 2's complement MAX WORD values
'$60 - $6f - stored 2's complement MIN WORD values

'$70 - $71 - lowest  MIN temp since RESET
'$72 - $73 - highest MAX temp since RESET
'$74 - $75 - lowest  MIN temp in the last 24hrs
'$76 - $77 - highest MAX temp in the last 24hrs

'$78 - $79 - 2's complement value of talarm
'$7a - $7b 2's complement current temp
'$7e - $7f 2's complement value of temp to be displayed (used to determine sign in segment_set subroutine)

#picaxe 08M2
#no_data

'----------------------------------
'max temp alarm point (user select)
symbol talarm_sign = "-"	' - or +
symbol talarm = 145		'talarm value x10 (145= 14.5 degC)
gosub talarm_convert		'convert talarm to 2's complement value & store in $78 -$79

'---------------
'initialise 08M2
dirsC = %00000001		' set c.0 as an output
pinc.0= 0			' set c.0 low (TEMPERATURE ALARM output off)

'-----------
'set symbols
symbol digit4=b24		'digits to be displayed on LED display
symbol digit3=b25
symbol digit2=b26
symbol digit1=b27

symbol Lcon=b20		'LED display control byte (on, off, flashing, see HT16K33 datasheet))
Lcon=$81			'initial value (display ON, no flashing)

symbol newT = w8		'temperature comparison variables
symbol oldT = w9

'-----------------------
'initialise HT16K33 chip
symbol addrA=$E0	'address of HT16K33
Hi2cSETUP  i2cmaster,addrA, i2cfast, i2cbyte
PAUSE 1 		'chip boot time
Hi2cOUT ($21) 	'start oscillator
Hi2cOUT ($A0)	'set all rows on
Hi2cOUT ($80) 	'turn off the display
Hi2cOUT ($EF) 	'LED dimming value (E0 to EF)

'---------------------
'initialise RAM arrays
gosub get_temp
gosub minmax_initialise 'set all stored 2's complement min max values to current 2's complement temp
gosub alarm_display

'=================
'MAIN PROGRAM LOOP
'=================

main:

	gosub display
	
	gosub check_timer

	goto main
end

'======================
'SUBROUTINES START HERE
'======================

'-------------
alarm_display:

digit1=$00	'
digit2=$00	'
digit3=$77	'A
digit4=$38	'L
gosub display_write

peek $78, word w0		'fetch 2's complement talarm value
gosub convert_temp	'convert to displayable chars
gosub segment_set		'7 segment set and display i2c write
 

return

'-------
display:

'--------------------
'AMBIENT TEMP DISPLAY
digit1=$00	'
digit2=$00	'	
digit3=$00	'
digit4=$78	't
gosub display_write

gosub get_temp		'returns w0
gosub convert_temp	'convert to displayable chars
gosub segment_set		'7 segment set and display i2c write

'-------------------------------
'MAXIMUM TEMP LAST 24hrs DISPLAY
digit1=$00
digit2=$00
digit3=$76	'H
digit4=$04	'i
gosub display_write

'test for new MAX temp 
peek $7a, word newT	'fetch current temp
peek $50, word oldT	'fetch previous MAX temp
gosub max_compare		'compare and update MAX temp if required
poke $50, word oldT

'now look to see if there is a higher value in the other 3hr time slots
gosub find_Hi
peek $76, word w0		
gosub convert_temp	'convert to displayable chars
gosub segment_set		'7 segment set and display i2c write

'--------------------------------
'MAXIMUM TEMP SINCE RESET DISPLAY
digit1=$00	'
digit2=$50	'r
digit3=$76	'H
digit4=$04	'i
gosub display_write

'test for new MAX temp since RESET and display it
peek $7a, word newT	'fetch current temp
peek $72, word oldT	'fetch previous max temp
gosub max_compare		'compare and update max temp if required
poke $72, word oldT	'store new temp max RESET


gosub alarm_check

w0=oldT 
gosub convert_temp	'convert to displayable chars
gosub segment_set		'7 segment set and display i2c write

'-------------------------------
'MINIMUM TEMP LAST 24hrs DISPLAY
digit1=$00
digit2=$00
digit3=$38	'L
digit4=$5c	'o
gosub display_write

'test for new MIN temp 
peek $7a, word newT	'fetch current temp
peek $60, word oldT	'fetch previous MIN temp
gosub min_compare		'compare and update MIN temp if required
poke $60, word oldT

'now look to see if there is a lower value in the other 3hr time slots
gosub find_Lo
peek $74, word w0		
gosub convert_temp	'convert to displayable chars
gosub segment_set		'7 segment set and display i2c write

'--------------------------------
'MINIMUM TEMP SINCE RESET DISPLAY
digit1=$00	'
digit2=$50	'r
digit3=$38	'L
digit4=$5c	'o
gosub display_write

'test for new MIN temp since RESET and display it
peek $7a, word newT	'fetch current temp
peek $70, word oldT	'fetch previous min temp
gosub min_compare		'compare and update min temp if required
poke $70, word oldT	'store new temp min RESET

w0=oldT 
gosub convert_temp	'convert to displayable chars
gosub segment_set		'7 segment set and display i2c write	

return

'-------------
segment_set:
'imports b11, b12, b10
'determine which 7 segments of each digit need to be activated

lookup b11, ($3f,$06,$5b,$4f,$66,$6d,$7d,$07,$7f,$6f,$00,$00,$00,$00,$00,$00), digit1
lookup b12, ($bf,$86,$db,$cf,$e6,$ed,$fd,$87,$ff,$ef,$00,$00,$00,$00,$00,$00), digit2 'this digit always has the decimal point DP on (add $80)
lookup b10, ($3f,$06,$5b,$4f,$66,$6d,$7d,$07,$7f,$6f,$00,$00,$00,$00,$00,$00), digit3
digit4=$58	'c (degC symbol)

if b11=0 then :digit1=$00 :endif	'blank leading zero digit1

peek $7e, word w7
if w7<= $07d0 then :goto L10 :endif	'check for +ve temp

if b9 >=10 then :digit4=digit3 :digit3=digit2 :digit2=digit1 :endif 'if -ve shuffle digits right to allow for minus sign on display
digit1=$40	'set minus sign

L10:
gosub display_write

return

'------------
display_write:
'LED display i2c write and timing
'write HT16K33 (data address pointer,digit1,ff,digit2,ff,colon,ff,digit2,ff,digit4,ff) see HT16K33 datasheet
Hi2cout (0x00, digit1, 0xff, digit2, 0xff, 0x00, 0xff, digit3, 0xff, digit4, 0xff)

Hi2cOUT(Lcon)	'display on (steady or flashing)
pause 2500

Hi2cOUT($81)	'display steady
pause 1500

Hi2cOUT($80)	'display off
pause 1000

return

'--------
get_temp:
'reads DS18B20 and stores 2's complement value

readtemp12 c.4,w0
poke $7a, word w0	'store temp

return

'------------
convert_temp:
'downconvert 2's complement value to displayable decimal numbers (see DS18B20 datasheet)

poke $7e, word w0		'used to determine sign of temperature in segment_set subroutine

if bit11=1 then :w0= NOT w0 :w0=w0+1 :endif 'if -ve then invert and add 1

b7=b1&$07*16
b8=b0&$F0/16
b9=b7+b8	'b9 temp - interger part (whole degrees)

b11=b9/10	'b11 temp tens  digit - used in display subroutine
b12=b9//10	'b12 temp units digit - used in display subroutine

w1=bit0*625
w1=bit1*1250+w1
w1=bit2*2500+w1
w1=bit3*5000+w1
b10=w1/1000	'b10 temp - fractional digit - used in display subroutine

'EXITS with b11= temp tens digit, b12= temp units digit, b10= temp first decimal point digit

return

'-----------------
minmax_initialise:
'initialise all stored array MIN & MAX temps to current temp
peek $7a, word w8	'fetch current temp

	bptr=$60
	for b13=1 to 8
		@bptrinc=b16 :@bptrinc=b17	'store w8
	next b13

	bptr=$50
	for b13=1 to 8
		@bptrinc=b16 :@bptrinc=b17	'store w8
	next b13

poke $70, word w8 :poke $72, word w8 'initialise stored min and max temps since RESET to current temp
poke $74, word w8 :poke $76, word w8 'initialise stored min and max temps to current temp

return

'-----------
check_timer:
'uses the picaxe TIME function to track an approx 3HR (10800 secs) period
'$50-$5F and $60-$6F function as two 8 word FIFO arrays to store 3 hourly MIN and MAX values
'the Hi and Lo displays show the MAX and MIN values encountered over the last 24 hours (8x3)

if time < 10800 then :return :endif	'3hrs since power up or time reset

time=0	'reset time

'ripple stored array MAX values,oldest value in $5e,$5f drops off 
for b13=$5c to $50 step -2
	b6=b13+2
	peek b13, word w9 :poke b6, word w9
next b13


'ripple stored array MIN values, oldest value in $6e,$6f drops off
for b13=$6c to $60 step -2
	b6=b13+2
	peek b13, word w9 :poke b6, word w9
next b13


'initialise current min & max values using current temp
peek $7a,word w9 :poke $60,word w9 :poke $50,word w9

return

'-------
find_Hi:
'compare MAX array words to determine highest MAX value
	peek $50, word oldT

	for b13=$52 to $5e step 2
		peek b13,word newT :gosub max_compare
	next b13

	poke $76, word oldT	'$76 holds highest MAX value

return

'-------
find_Lo:
'compare MIN array words to determine lowest MIN value
	peek $60, word oldT 

	for b13=$62 to $6e step 2
		peek b13,word newT :gosub min_compare
	next b13

	poke $74, word oldT	'$74 holds lowest MIN value

return

'-----------
max_compare:
'compares two temps and sets a new MAX
'imports w8,w9  exports w9
'$07d0 = +125.0 degC = max temperature for DS18B20
'$fc90 = -55.0  degC = min temperature for DS18B20 (see data DS18B20 sheet)

	if newT<=$07d0 AND oldT>=$fc90 then :oldT=newT :return :endif
	if newT>=$fc90 AND oldT<=$07d0 then :return :endif
	if newT>oldT then :oldT=newT :endif

return

'-----------
min_compare:
'compares two temps and sets a new MIN
'imports w8,w9  exports w9
'$07d0 = +125.0 degC = max temperature for DS18B20
'$fc90 = -55.0  degC = min temperature for DS18B20 (see data DS18B20 sheet)

	if newT<=$07d0 AND oldT>=$fc90 then :return :endif
	if newT>=$fc90 AND oldT<=$07d0 then :oldT=newT :return :endif
	if newT<oldT then :oldT=newT :endif

return

'-----------
alarm_check:

peek $78, word w3		'fetch talarm 2's complement value
peek $72, word w2		'fetch MAX temperature since RESET

'now check for alarm condition (temp higher than alarm point)
'w2=min temperature, w3=alarm point
'$07d0 = +125.0 degC = max temperature for DS18B20
'$fc90 = -55.0  degC = min temperature for DS18B20 (see data DS18B20 sheet)

'+- condition
if w2<=$07d0 AND w3>=$fc90 then :pinc.0=1 :Lcon=$85 :return :endif	'alarm out and flash LED display

'-+ condition
if w2>=$fc90 AND w3<=$07d0 then :return :endif	'no alarm

'++ or -- condition
if w2>=w3 then :pinc.0=1 :Lcon=$85 :endif	'alarm out and flash LED display

return

'--------------
talarm_convert:
'upconvert talarm value to 2's complement value for comparison purposes
'uses w0 which allows direct individual access to bit15 to bit0

'begin to populate w0
w1=talarm/10 *16 'integer part of talarm shifted into w0 bits 10 - 4

w3=talarm//10	'w2=decimal fraction of talarm
w3=w3*1000		'x1000 since smallest DS18B20 temp is 0.0625

w0=0			'reset w0 to zero
bit3=w3/5000	'0.500 deg
if w3>=5000 then :w3=w3-5000 :endif

bit2=w3/2500	'0.250 deg
if w3>=2500 then :w3=w3-2500 :endif

bit1=w3/1250	'0.125 deg
if w3>= 1250 then :w3=w3-1250 :endif

bit0=w3/625		'0.062 deg

w3=w1+w0		'w3 = value for conversion to 2's complement value

b21=talarm_sign
if b21="-" then :w3= NOT w3 :w3=w3+1 :endif	'w3 now holds 2's complement talarm value

poke $78, word w3 'store

return