'Accessory Power Control. Version 1, GM, 16/06/24
'Detects when engine is started by measuring Battery Volts. When engine is running, sets Acc switch ON.
'The system is low power when engine is off. This is achieved by careful design of hardware and
'placing the Picaxe into periodic "nap".
'SW is designed for HW "Cam_ps1-Schematic".

'Pin 2 (C.5)is Prog Port Serial In
'Pin 3 (C.4)is Battery Voltage Detect (ADC) scaled by tba.
'Pin 4 (C.3)debug o/p
'Pin 5 (C.2)NU
'Pin 6 (C.1)is O/P Drive
'Pin 7 (C.0)is Prog port Serial Out

symbol OffV = 717			'low voltage definition for determining Engine Off. Change this value to suit implementation. Typical 12.9v = 716
symbol OnV = 721			'high voltage definition for determining Engine On. Change this value to suit implementation. Typical 13.4v = 721

symbol Batt = C.4			'Batt input scaled to approx V/3 but affected by resistor tollerance, CPU ADC i/p loading and actual Vcc level. ADC10 = ~4.9mv/step, 15v Max.
symbol debug1 =C.3		'output for debugging
symbol load = C.1			'output to drive load on/off. Active High
symbol Inpv = w2			'input voltage storage
symbol Filtloop = b0		'filter loop counter
symbol Filt_cnt = b1		'filter counter for number of filter checks
symbol Glitch_duration = 100	'Glitch duration in ms. 
symbol Trip = b2			'Filter trip point
symbol Glitch_tests = 6		'number of tests for On glitch filter
symbol noise=2			'noise value for Filter check

					'I/P protection zenner is 4.7v therefore 14.1v max batt input will be read.
symbol Pwr_save = 6		'nap value for power saving (about 1.1 sec), subject to temperature +100%/-50%
symbol crank_time = 9000   	'engine cranking duration (ms) to prevent switch off when starting the engine. Change this value to suit implementation.

'start program
	high load			'set load off

On_loop:				'Power ON & fully awake CPU
	readadc10 Batt, Inpv	'read battery voltage
	if Inpv < OffV then goto Ofchk			'If volts are lo check glitch filter
	pause Glitch_duration
goto On_loop	

sleep_loop:
	nap Pwr_save		'go to low power mode for the timeout
	readadc10 Batt, Inpv	'read battery voltage
	if Inpv > OnV then goto Onchk				'If volts are hi check glitch filter
goto sleep_loop

Onchk:				'check for noise and switch On
	Filt_cnt=0
	for Filtloop=1 to Glitch_tests
		readadc10 Batt, Inpv				'read battery voltage
		if  Inpv > OnV then
			inc Filt_cnt				'incr Filter if input still high
		endif
		pause Glitch_duration
	next Filtloop
	Trip=Glitch_tests-noise		'reduce Trip value by assumed noise
	if Filt_cnt => Trip then			'if Trip value - noise is high then switch On
		high load		'switch load On
		pause 500
		goto On_loop	'change state to On
	endif	
	goto sleep_loop		'It was a Glitch, stay in current Off state
	
Ofchk:				'check if we need to change state and switch Off
	Filt_cnt=0
	pause crank_time    'avoid shutdown when cranking engine.
	for Filtloop=1 to Glitch_tests
		readadc10 Batt, Inpv				'read battery voltage
		if  Inpv < OffV then
			inc Filt_cnt				'incr Filter if input still low
		endif
		pause Glitch_duration
	next Filtloop
	Trip=Glitch_tests-noise		'reduce Trip value by assumed noise
	if Filt_cnt => Trip then				'if Trip value - noise is high then switch Off
		low load						'switch load Off
		goto sleep_loop	'change state to Off
	endif
	goto On_loop		'it was a Glitch, stay in current On state

end
