// Uses TimerOne to generate a 58us interrupt for track signal
// Service Mode CV scanner
// bit verify working, giving complementary output (hi bits and lo bits)
// read/write CVs
// does verify by bit and checks complement
// write CV by byte and check for ack

#include "TimerOne.h"
//pins: DIR=5, EN=11, I=A1 is the same as DCCPP hardware
#define SIGPIN 5
#define ENPIN 11
#define ISENSEPIN A1

//nominally 3 and 5 required
#define RESETPACKETS 4
#define SERVICEPACKETS 5

struct loco {unsigned int id=0;byte speed=0;bool dir=0;byte funcs=0;byte func2=0;};
loco dcc;

byte txpacket[10];                        //actual packet being sent
int txpacketlen=0;
bool packetready=0;                       //set to 1 to start, tx sets to 0 on done 
char buf[80];
int n,val;

#define ISENSER (2.0)
#define ICONST (5000.0/(1024.0*ISENSER))
#define ITHRESHOLD (30)

void setup() {
  pinMode(SIGPIN,OUTPUT);
  pinMode(ENPIN,OUTPUT);  
  digitalWrite(SIGPIN,LOW);
  digitalWrite(ENPIN,LOW);
  Serial.begin(115200);
  Serial.println("USE Rcv to read a CV");
  Serial.println("USE Wcv:val to write a value to CV"); 
  Timer1.initialize(58);                //58us is minimum period
  Timer1.attachInterrupt(setDCCoutput);
  digitalWrite(ENPIN,HIGH);
}

void loop() {
  int k;
  k=checkSerial();
  if(k==1){
    //digitalWrite(ENPIN,HIGH);
    delay(100);
    doRead(n);
    //digitalWrite(ENPIN,LOW);
  }
  if(k==2){
    //digitalWrite(ENPIN,HIGH);
    delay(100);
    doWrite(n,val);
    //digitalWrite(ENPIN,LOW);
  }
  delay(100);
  if(!packetready){resetpacket();packetready=1;}
}

void setDCCoutput(){
  static const byte bitmasks[]={0,128,64,32,16,8,4,2,1};
  static char phase=0;                      //0-3, gets double stepped on 1's so 1's get 58us per phase, 0's get 116us per phase
  static bool bittosend=1;
  static char byteptr=-3;                   //which byte of packet are we sending? -2 and -1 are preamble, 0 is first byte (set to -3 for service mode programming
  static char bitptr=0;                     //9 bits per bytes due to '0' start bit
  //do bit twiddling first to minimise jitter
  if(phase==2){                             //first half of cycle
    digitalWrite(SIGPIN,HIGH);
  }else if(phase>3){                       //second half of cycle
    digitalWrite(SIGPIN,LOW);
    phase=0;                                //next bit
    bitptr++;
    if(bitptr>8){
      bitptr=0;                             //next byte
      byteptr++;
      if(byteptr>=txpacketlen){
        byteptr=-3;                         //ready for next packet
        packetready=0;                      //flag that we're waiting
      }
    }
  }
  if(!packetready){                         //keep sending 1's/preamble if no packet ready
    byteptr=-3;
    bitptr=0;  
  }
  if(phase==0){                             //get next bit ready
    if(byteptr<0){
      bittosend=1;                          //preamble bits are always one
    }else{
      bittosend=(txpacket[byteptr]&bitmasks[bitptr])?1:0;
    }
  }
  phase++;
  phase+=bittosend;                         //double step on 1's

}

void addchecksum(){                     //add checksum to otherwise formed packet
  byte cx=0;
  for(int i=0;i<txpacketlen;i++){       //calculcate checksum
    cx^=txpacket[i];
  }
  txpacket[txpacketlen]=cx;             //add to end of packet
  txpacketlen++;
}

void idlepacket(){                      //construct an idle packet
  txpacket[0]=255;
  txpacket[1]=0;
  txpacketlen=2;
  addchecksum();
}
void resetpacket(){
  txpacket[0]=0;
  txpacket[1]=0;
  txpacketlen=2;
  addchecksum();    //should be zero as well  
}

void servicepacketverifybyte(int cv, byte data){        //verify cv has data  
  cv=(cv-1)&0x3FF;            //CV1= HW address 0, 10 bits only
  txpacket[0]=0x74|(cv>>8);   //2 msb of address
  txpacket[1]=cv&0xFF;        //8 lsb of address
  txpacket[2]=data;
  txpacketlen=3;
  addchecksum();  
}

void servicepacketverifybit(int cv, byte bt, byte bv){  //verify that cv has bit bt equal to bv
  cv=(cv-1)&0x3FF;            //CV1= HW address 0, 10 bits only
  txpacket[0]=0x78|(cv>>8);   //2 msb of address
  txpacket[1]=cv&0xFF;        //8 lsb of address
  txpacket[2]=0xE0|((bv&1)<<3)|(bt&7);
  txpacketlen=3;
  addchecksum();      
}

void servicepacketwritebyte(int cv, byte data){         //write data to cv
  cv=(cv-1)&0x3FF;            //CV1= HW address 0, 10 bits only
  txpacket[0]=0x7C|(cv>>8);   //2 msb of address
  txpacket[1]=cv&0xFF;        //8 lsb of address
  txpacket[2]=data;
  txpacketlen=3;
  addchecksum();    
}

void servicepacketwritebit(int cv, byte bt, byte bv){  //write cv with bit bt(0-7) equal to bv    //not tested
  cv=(cv-1)&0x3FF;            //CV1= HW address 0, 10 bits only
  txpacket[0]=0x78|(cv>>8);   //2 msb of address
  txpacket[1]=cv&0xFF;        //8 lsb of address
  txpacket[2]=0xF0|((bv&1)<<3)|(bt&7);
  txpacketlen=3;
  addchecksum();      
}

int checkSerial(){
  static char buf[80];
  int i=0;
  int cindex=0;
  while(Serial.available()){
  int d=Serial.read();
  if(d==13){
      if(toUpperCase(buf[0])=='R'){     //read
        n=atoi(buf+1);
        buf[0]=0;
        Serial.print("READ from CV");
        Serial.println(n);
        return 1;  
      }
      else if(toUpperCase(buf[0])=='W'){     //write
        n=atoi(buf+1);        
        while(buf[i]){
          if(buf[i]==':'){
            cindex=i;
          }
          i++;            
        }
        if(cindex){          
          val=atoi(buf+cindex+1);
          buf[0]=0;
          Serial.print("WRITE ");
          Serial.print(val);
          Serial.print(" to CV");
          Serial.println(n);          
          return 2;            
        }else{
        buf[0]=0;
        Serial.println("ERROR");
        return 0;
        }        
      }else{              //unrecognised
        buf[0]=0;
        return 0;
      }
    }
    if(d>31){
      buf[strlen(buf)+1]=0;
      buf[strlen(buf)]=d;
      buf[79]=0;
    }
  }
  return 0;
}


void doRead(int n){ //read cv n
  int ack=0;
  byte cval=0,cvalbar=0;
  int d;
  static int d0=0;
  byte bt=0;
  byte bv=0;
  int cv;
  int p=0;
  bool done=0;
  int bc=0;
  cv=n;
  if(cv==0){done=1;Serial.println("Can't Read 0");return;}
  Serial.print("Reading ");
  Serial.println(cv);
  while(!done){
  if((!packetready)){
    p++;
    if(p<RESETPACKETS+1){                 //send reset packets
      resetpacket();
      packetready=1;
    }else{
      servicepacketverifybit(cv,bt,bv);   //send read packets
      packetready=1;
      if(p>RESETPACKETS+SERVICEPACKETS){
        if(ack>2){                    
          bc++;
          if(bv){
            cval=cval|(1<<bt);            //record bit on ack
          }else{
            cvalbar=cvalbar|(1<<bt);            
          }
        }
        p=0;
        bv++;
        ack=0;
        if(bv>1){
          bv=0;
          bt++;
          if(bt>7){
            if(cval==(255-cvalbar)){
              Serial.print("Confirmed CV ");
              Serial.print(cv);
              Serial.print("=");
              Serial.println(cval);              
            }else{
              Serial.print("CV:");
              Serial.println(cval);
              Serial.print("CVbar:");
              Serial.println(255-cvalbar);
              Serial.print("Acks (out of 16):");
              Serial.println(bc);
            }
            cval=0;
            cvalbar=0;
            bt=0;
            cv=0;
            done=1;
            }
          }
        }
      }
    }
    d=analogRead(ISENSEPIN);
    if((p<RESETPACKETS)&&(p>1)){d0=d;}              //set baseline
    if(((d-d0)>ITHRESHOLD)&&(p>RESETPACKETS)){        //detect ack
      ack++;
    }
  }
}

void doWrite(int n,int val){  //write value p to cv n
  int d;
  static int d0=0;
  bool ack=0;
  int cv;
  int p=0;
  bool done=0;
  cv=n;
  if(cv==0){done=1;Serial.println("Can't Write 0");}
  Serial.print("Set CV");
  Serial.print(cv);
  Serial.print(" to ");
  Serial.println(val);
  while(!done){
    delay(1);                   //seems to be necessary
    if((!packetready)){
      p++;
      if(p<RESETPACKETS+1){     //start with reset packet
        resetpacket();
        packetready=1;
      }else{
        servicepacketwritebyte(cv, val);    //write packet
        packetready=1;
        if(p>RESETPACKETS+SERVICEPACKETS*3){    //do extra packets
          done=1;
          if(ack){
            Serial.println("ACKED");        //check ack
          }else{
            Serial.println("NOT ACKED");              
          }
        }
      }
    }
    d=analogRead(ISENSEPIN);
    if((p<RESETPACKETS)&&(p>1)){d0=d;}              //set baseline
    if(((d-d0)>ITHRESHOLD)&&(p>RESETPACKETS)){        //detect ack
      ack++;
    }
  }
}

