/*****************************************************************************
* File Name: main.c
*
* Version: 1.0
*
* Description:
*   The main C file for the Temperature measurement with Thermistor project. 
* 
* Note:
* 	The main project includes the ADC and other components required for the
*   temperature measurement. The Thermistor component is a complete firmware component
*   as decribed in the component datahseet and application note
******************************************************************************
* Copyright (C) 2013, Cypress Semiconductor Corporation.
******************************************************************************
* This software is owned by Cypress Semiconductor Corporation (Cypress) and is
* protected by and subject to worldwide patent protection (United States and
* foreign), United States copyright laws and international treaty provisions.
* Cypress hereby grants to licensee a personal, non-exclusive, non-transferable
* license to copy, use, modify, create derivative works of, and compile the
* Cypress Source Code and derivative works for the sole purpose of creating
* custom software in support of licensee product to be used only in conjunction
* with a Cypress integrated circuit as specified in the applicable agreement.
* Any reproduction, modification, translation, compilation, or representation of
* this software except as specified above is prohibited without the express
* written permission of Cypress.
*
* Disclaimer: CYPRESS MAKES NO WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, WITH
* REGARD TO THIS MATERIAL, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
* Cypress reserves the right to make changes without further notice to the
* materials described herein. Cypress does not assume any liability arising out
* of the application or use of any product or circuit described herein. Cypress
* does not authorize its products for use as critical components in life-support
* systems where a malfunction or failure may reasonably be expected to result in
* significant injury to the user. The inclusion of Cypress' product in a life-
* support systems application implies that the manufacturer assumes all risk of
* such use and in doing so indemnifies Cypress against all charges. Use may be
* limited by and subject to the applicable Cypress software license agreement.
*****************************************************************************/
#include <device.h>
#include <stdio.h>
#include <stdbool.h>
#include "removeOffsetNoise.h"
#include "measurement.h"
#include "math.h"

int main()
{
	/* Voltages across reference resistor and thermistor*/
	int16 iVref, iVtherm, iVolts;
    char8 s[16]={};
    int   disp = 0;
    
	/* Resistance of Thermistor*/
	uint32 iRes;
	
	/* Temperature value in 100ths of a degree C*/
	int32 iTemp; 

	/*Start all the hardware components required*/
	ADC_Start();
	AMux_Start();
    LCD_Start();
    
	/*Enable Global Interrupts*/
	CyGlobalIntEnable;
    
	for(;;)
    {
        LCD_ClearDisplay();

        /* Measure Voltage Across Thermistor*/
    	iVtherm = MeasureResistorVoltage(AMUX_1_VT); 
		
		/* Measure Voltage Across Reference Resistor*/
    	iVref = MeasureResistorVoltage(AMUX_1_VREF);
        
	   	/* Use the thermistor component API function call to obtain the temperature corresponding to the voltages measured*/	
    	iRes = Thermistor_1_GetResistance(iVref, iVtherm);
    	iTemp = Thermistor_1_GetTemperature(iRes);

        sprintf(s, "%d.%02d%cc", (uint16)iTemp / 100, (uint)iTemp % 100, 178);
        LCD_PrintString(s);

        if(disp <= 10) {
            /* Measure Solar Panel Voltage*/
        	iVolts = ADC_CountsTo_mVolts(0, MeasureResistorVoltage(AMUX_1_VBAT)); 
            sprintf(s, "VBat = %u.%02u v", iVolts / 1000, iVolts % 1000);
        } else {
            /* Measure Solar Panel Voltage*/
        	iVolts = ADC_CountsTo_mVolts(0, MeasureResistorVoltage(AMUX_1_VDD)); 
            sprintf(s, "VDD = %u.%02u v", iVolts / 1000, iVolts % 1000);
        }
        
        if(++disp > 20) disp = 0;
        
        LCD_Position(1, 0);
        LCD_PrintString(s);

        CyDelay(500);
    }
}

/* [] END OF FILE */
