#include <SPI.h>
#include <Adafruit_GFX.h>
#include <TFT_ILI9163C.h>

/* 
Want to load 24 bit iamges directly? This demo it's cool to understand how it works. 
The 24bit data can also be stored in a flash if you like!
be careful, big ram requirements!! Only Teensy or DUE probably work
You need the utility lcd-image-converter in the utility folder.
Open an image with lcd-image-converter, go to menu->Options->Conversion...
'Prepare' sub-menu tag should be set as follow:
Type: color
Main Scan Direction: Top to Bottom
Line Scan Direction: Forwaed
All the rest should be unchecked.
Go to sub-menu tag 'Image'
Prefix:0x
Block size: 24bit
Delimeter:,
Byte Order: Little-Endian
Done. Now save preset if you like!
Now go to menu File->Convert and save .c file
Open with any text editor, you need to copy in your sketch only the data so the array
that start with static const uint24_t yourimage[16384] = { ....};
Change uint24_t to uint32_t.

*/
/*
Teensy3.x and Arduino's
You are using 4 wire SPI here, so:
 MOSI:  11//Teensy3.x/Arduino UNO (for MEGA/DUE refere to arduino site)
 MISO:  12//Teensy3.x/Arduino UNO (for MEGA/DUE refere to arduino site)
 SCK:   13//Teensy3.x/Arduino UNO (for MEGA/DUE refere to arduino site)
 the rest of pin below:
 */
#define __CS 10
#define __DC 9
/*
Teensy 3.x can use: 2,6,9,10,15,20,21,22,23
Arduino's 8 bit: any
DUE: check arduino site
If you do not use reset, tie it to +3V3
*/


TFT_ILI9163C tft = TFT_ILI9163C(__CS, __DC);


static const uint32_t image_data_batman_ume[16384] = {
    0x976a40, 0xaa8a3f, 0xb49f42, 0xb3a044, 0xb19b45, 0xac983f, 0xaa963d, 0xaf9946, 0xb2a054, 0xa79668, 0x8f826f, 0x827b6b, 0x9d9976, 0xc2b684, 0xccb684, 0xcfba81, 0xcbb373, 0xae9a55, 0xac9142, 0xb19d46, 0xb8aa49, 0xabaa50, 0xb9ac50, 0xf8e55b, 0xfff256, 0xfde954, 0xfde755, 0xffea51, 0xffe84c, 0xffe64b, 0xfee749, 0xfee646, 0xfde441, 0xfbe440, 0xfee33a, 0xfce034, 0xfde336, 0xfde233, 0xffe12e, 0xfee12d, 0xfee028, 0xfee026, 0xfce027, 0xffe127, 0xfee226, 0xfee12d, 0xffde37, 0xfcd538, 0xffcd33, 0xefbf37, 0xc0a151, 0x6f562e, 0x3e3120, 0x483517, 0x694c14, 0x956c14, 0xc28b14, 0xc2881a, 0xc28918, 0xc28b17, 0xc4911e, 0xc99528, 0xcd972b, 0xce982e, 0xcb9729, 0xc99424, 0xc69225, 0xc58f22, 0xcb8d20, 0xaa771e, 0x826930, 0x746546, 0x52371c, 0x5c3611, 0x6f4014, 0x8f4514, 0xc86512, 0xeb7b15, 0xf08116, 0xf98b18, 0xfa9219, 0xf9971a, 0xf79c1a, 0xf79e1e, 0xf9a221, 0xf7a31f, 0xf6a522, 0xf6a728, 0xf5ab24, 0xf5ad25, 0xf4b125, 0xf4b125, 0xf5b225, 0xf5b426, 0xf3b429, 0xf2b529, 0xf3b32b, 0xefb530, 0xf4b12e, 0xf0ab2a, 0xf2c54e, 0xf4dc7a, 0xfcda80, 0xeec164, 0xbd9138, 0xb68735, 0xc09044, 0xbe9253, 0xc0965a, 0xcea261, 0xcda162, 0xb98a44, 0xa8742b, 0xa26922, 0xa76729, 0xa46427, 0x9a5d24, 0x995d2b, 0x925622, 0x864913, 0x82470d, 0x884b12, 0x8e4c10, 0x844212, 0x71360e, 0x5f2e0d, 0x44260e, 0x31200c, 0xb59e3e, 0xbba53f, 0xb29b3d, 0xaf973d, 0xb8a144, 0xbda646, 0xb3a248, 0x9c8d4a, 0x827757, 0x6e6754, 0x615f53, 0x69665d, 0x787264, 0x87785b, 0x937e53, 0x988656, 0x968047, 0x997e3b, 0xa88d3e, 0xb69d43, 0xb3a94a, 0xaaa348, 0xe1cd5a, 0xfff660, 0xfcee57, 0xfeea55, 0xffe955, 0xffea53, 0xfde84f, 0xffe84c, 0xfee749, 0xffe948, 0xfde543, 0xfde441, 0xfee33a, 0xfde137, 0xfee439, 0xfee334, 0xffe22f, 0xfee12d, 0xfee02a, 0xfee028, 0xfde02a, 0xffe129, 0xfee227, 0xfee12d, 0xffde37, 0xfdd538, 0xffcb37, 0xebbc3a, 0xb69649, 0x70582c, 0x3f331d, 0x493616, 0x755113, 0x7f5813, 0x815c16, 0x7f5712, 0xa07727, 0xac8c35, 0xac8e36, 0xc6974f, 0xd79e5b, 0xd3a05e, 0xd19f60, 0xcf9d56, 0xcc9a53, 0xcc9957, 0xd29b5b, 0xa97c45, 0x6d5129, 0x594427, 0x523517, 0x5d3a12, 0x6e3e16, 0x894518, 0xc66919, 0xe58316, 0xed8719, 0xfa8f1b, 0xfd971b, 0xfc9d1d, 0xfaa21d, 0xf9a21f, 0xf8a420, 0xf9a720, 0xf9ab25, 0xf8ab27, 0xf6ac27, 0xf6ae26, 0xf5b027, 0xf4b125, 0xf4b325, 0xf5b327, 0xf4b52a, 0xf3b62a, 0xf2b42d, 0xf3b431, 0xf1b02e, 0xf2b938, 0xf2c64b, 0xf5be4a, 0xe8be5c, 0xeecb71, 0xc99742, 0xa07121, 0x996d22, 0x996f25, 0x98732f, 0x91733d, 0xa48a59, 0xbc9e6c, 0xbb9c66, 0xa57c48, 0x956229, 0x92571f, 0x9c5829, 0x9a5625, 0x8a4816, 0x7f3d0d, 0x84410d, 0x884510, 0x88470f, 0x914c0b, 0x974d10, 0x873d0c, 0x77360c, 0x622d0e, 0xb29f39, 0xb2993d, 0xbca33e, 0xbaa645, 0xa49142, 0x998749, 0x7b6e4b, 0x565246, 0x4c453b, 0x4e4b3c, 0x5d5747, 0x514b3b, 0x3e372f, 0x42362a, 0x695935, 0x7c6836, 0x87743c, 0x98813d, 0xa38c40, 0xb4963e, 0xafa045, 0xbfad49, 0xfde966, 0xfef260, 0xfeee5b, 0xfeec5a, 0xfeea57, 0xffeb58, 0xfde954, 0xfde84f, 0xfde64a, 0xfeea4b, 0xfde545, 0xfde442, 0xfde43f, 0xfee33a, 0xfde239, 0xfee437, 0xfde432, 0xfde22f, 0xffe02e, 0xffe02d, 0xfee12d, 0xffe22c, 0xfce229, 0xfee12e, 0xfedd38, 0xfdd43a, 0xfecb32, 0xeabf3f, 0xae944a, 0x725728, 0x4c3a22, 0x453416, 0x725313, 0x815c18, 0x7a5715, 0x7a5715, 0x9c7730, 0xa8883d, 0x9a7f32, 0xaa8541, 0xba8d4c, 0xb68d4b, 0xb68d4f, 0xb58c4e, 0xb5884f, 0xb28750, 0xb2854c, 0xab864f, 0x745b32, 0x4d351b, 0x563919, 0x623b14, 0x6f4014, 0x944816, 0xc36819, 0xe78918, 0xee8d1a, 0xf7971e, 0xfc9d1d, 0xfda21e, 0xfca821, 0xfcaa22, 0xfbaa23, 0xfbae24, 0xfab127, 0xf9af28, 0xf8b028, 0xf7b229, 0xf8b328, 0xf7b428, 0xf7b628, 0xf5b728, 0xf3b628, 0xf3b62a, 0xf3b32b, 0xf4b631, 0xf3b931, 0xf4be3a, 0xf3b136, 0xf7a92d, 0xe6a733, 0xc8a446, 0xcfa251, 0xaa7b2d, 0xa37430, 0x9d702c, 0x8a6727, 0x785d28, 0x735823, 0x745c2c, 0x8e774e, 0x967f55, 0x856d41, 0x7d643c, 0x74542d, 0x754119, 0x813a10, 0x8c400e, 0x89400d, 0x843d0f, 0x8a400f, 0x89400b, 0x8a400f, 0x954510, 0x994b0d, 0x8f420a, 0xbda239, 0xbca442, 0xa08d3e, 0x7a6b40, 0x594f43, 0x4f4a44, 0x4e4a3f, 0x554d40, 0x544c39, 0x4e4631, 0x4e432f, 0x4a3f2b, 0x483f2e, 0x40382d, 0x574831, 0x756335, 0x826d34, 0x927a3a, 0xa0863c, 0xaf9541, 0xad953b, 0xdbc152, 0xfff871, 0xfcee6b, 0xffed63, 0xffef64, 0xfceb5f, 0xfdea5d, 0xfcec5b, 0xfeea57, 0xfee950, 0xfde94c, 0xfee749, 0xfee445, 0xfee542, 0xfee63e, 0xfde23b, 0xfee439, 0xfce535, 0xfee533, 0xffe22f, 0xfee12d, 0xfee12d, 0xffe22c, 0xfde32c, 0xfee12e, 0xfedb37, 0xfed53d, 0xffca32, 0xe9c348, 0xb49c54, 0x72572a, 0x43341d, 0x47361c, 0x6f5216, 0x7d5b14, 0x7f5a13, 0x805b17, 0x845d18, 0x845d18, 0x825b16, 0x835d1c, 0x86601f, 0x855d1f, 0x825b20, 0x805c1e, 0x815b1c, 0x7e5619, 0x81571b, 0x7a561c, 0x684f26, 0x523e25, 0x523817, 0x623c15, 0x704115, 0x8b471a, 0xc6681e, 0xe3901a, 0xee961b, 0xf89a1c, 0xfea31f, 0xfba720, 0xfdad22, 0xfdb024, 0xfcb124, 0xfbb426, 0xfab529, 0xfab529, 0xfab929, 0xfab72a, 0xf9b627, 0xf9b828, 0xf8ba29, 0xf6ba28, 0xf6b92a, 0xf6b92b, 0xf7b930, 0xf3bb30, 0xf5bb35, 0xf3b733, 0xf7b138, 0xf0ae34, 0xffac32, 0xd8942f, 0xaa862e, 0xaa8431, 0xa2782c, 0x98732f, 0x8b6d2f, 0x826730, 0x7b5f2d, 0x6a532a, 0x5c4523, 0x544121, 0x55432d, 0x65553e, 0x4d492e, 0x2c2d1b, 0x3d2d14, 0x63390f, 0x853e12, 0x97410e, 0x8b3d0c, 0x853b0e, 0x8b3d0f, 0x8c400f, 0x92430b, 0x97470c, 0xa48f40, 0x716239, 0x4c433a, 0x433e38, 0x51493e, 0x544d3b, 0x564e39, 0x554b32, 0x514932, 0x4f4732, 0x4e4331, 0x4e432f, 0x48402b, 0x413b2f, 0x47392c, 0x695532, 0x7d6934, 0x8b7239, 0x9e8038, 0xa48f3e, 0xb3903c, 0xf2cf5b, 0xfdfb72, 0xfeec6c, 0xfeec6c, 0xfff06f, 0xfdec6a, 0xfcea64, 0xfded64, 0xfeeb60, 0xffea59, 0xfee952, 0xfeea4d, 0xfee648, 0xfce442, 0xfee540, 0xfee33c, 0xfde53b, 0xfce63a, 0xffe637, 0xfde432, 0xffe22f, 0xfce22d, 0xffe22c, 0xfde42f, 0xfee030, 0xfedb37, 0xfed53f, 0xffc934, 0xedc353, 0xc6aa60, 0x3b2b12, 0x1f1a14, 0x574021, 0x6f5218, 0x7d5c17, 0x7d5c17, 0x7e5819, 0x835d1c, 0x845e1d, 0x83601e, 0x876122, 0x896221, 0x855f21, 0x835d1f, 0x815d1f, 0x866022, 0x825921, 0x83591d, 0x805c22, 0x674e26, 0x514026, 0x583a18, 0x633d18, 0x77481a, 0x372416, 0xa9591a, 0xf2981d, 0xef991e, 0xf5a021, 0xfea722, 0xfeac24, 0xfdb225, 0xfcb326, 0xfcb527, 0xfcb829, 0xfcb92a, 0xfcba28, 0xfbbe28, 0xfabc29, 0xfabc29, 0xfcbe2b, 0xfbbf2b, 0xf9bd2b, 0xf8bb2c, 0xf9ba2d, 0xf5bd32, 0xf6bd30, 0xf6be37, 0xf4bb36, 0xf6b43a, 0xf4b23a, 0xf5a832, 0xfda632, 0xbd872f, 0xa37931, 0xa3772e, 0x95702c, 0x8b6b2e, 0x84672f, 0x795e2f, 0x6d562c, 0x634b25, 0x554023, 0x4b3a26, 0x43321e, 0x352213, 0x2c1f0e, 0x2c260e, 0x2b2912, 0x3c3113, 0x5e320f, 0x863e0c, 0x9b460d, 0x923f0b, 0x8c3f0b, 0x90400b, 0x913e08, 0x4c4437, 0x3f3534, 0x4e4639, 0x554b32, 0x534633, 0x514433, 0x524735, 0x564b39, 0x544933, 0x504533, 0x4b432c, 0x4d422c, 0x463e29, 0x423b2b, 0x3c3226, 0x53412b, 0x746230, 0x846f36, 0x977c37, 0x9e8737, 0xbe9140, 0xfbd75f, 0xfff86c, 0xffeb6b, 0xfced70, 0xfcee73, 0xfeee74, 0xfdeb6d, 0xffee6c, 0xfeeb68, 0xffea63, 0xffea5b, 0xffeb54, 0xffe84c, 0xfde545, 0xfde642, 0xfee63e, 0xfee63e, 0xfde53b, 0xfde638, 0xfce533, 0xfde22f, 0xfde32e, 0xfde32e, 0xfce631, 0xffe131, 0xfdda38, 0xfed440, 0xffca34, 0xf6cb5b, 0xb09757, 0x000000, 0x221e1b, 0x5c4621, 0x6d5016, 0x7e5b17, 0x7f5c1a, 0x7e5b19, 0x86611d, 0x855f1e, 0x836121, 0x886023, 0x8b6222, 0x866321, 0x836020, 0x876122, 0x855d20, 0x835c25, 0x835c21, 0x7c5b26, 0x674f2b, 0x574225, 0x593b19, 0x664019, 0x8b5622, 0x04020d, 0x5a340d, 0xffa823, 0xeb9b20, 0xfba126, 0xfda923, 0xffaf28, 0xffb329, 0xfdb628, 0xfcb829, 0xfebb2c, 0xfdbc2c, 0xfcbf29, 0xffc32d, 0xfbc22b, 0xfbc22b, 0xfcc32c, 0xfac12a, 0xfac12c, 0xfac02e, 0xfcbf30, 0xfbc131, 0xf6c133, 0xf8c037, 0xf7bb37, 0xf9ba39, 0xf7af36, 0xf7a832, 0xfeab31, 0xd89433, 0x9e762e, 0x9d7831, 0x907130, 0x8a6c30, 0x7f642d, 0x725b2f, 0x695429, 0x5c4825, 0x513f29, 0x4f3d27, 0x3b2915, 0x291808, 0x301d0c, 0x311c07, 0x35230d, 0x2b250d, 0x211e0d, 0x39250c, 0x5e3309, 0x8c430c, 0xa34708, 0x914209, 0x8e410d, 0x443e30, 0x4d4433, 0x4e4331, 0x4f442e, 0x524532, 0x524534, 0x514630, 0x514934, 0x564732, 0x504332, 0x4d4530, 0x49412a, 0x4a3d2a, 0x453a26, 0x3d3423, 0x3f3229, 0x66502b, 0x7c6730, 0x8c7434, 0x9d7f36, 0xc39540, 0xfcdc63, 0xfff369, 0xffee6c, 0xffed71, 0xfeee74, 0xfeef78, 0xfded74, 0xfeeb72, 0xffed6f, 0xfeeb6a, 0xfde964, 0xfde859, 0xfde753, 0xfce54a, 0xfde545, 0xfde642, 0xfde43f, 0xfde43f, 0xfde53b, 0xfee63b, 0xfee334, 0xfee332, 0xfee330, 0xfce533, 0xfee032, 0xfdda38, 0xffd342, 0xffc83a, 0xfdd863, 0x837351, 0x000002, 0x342d1a, 0x5a4623, 0x705319, 0x7e5c1d, 0x7c5a1b, 0x795c1a, 0x82611c, 0x86601f, 0x846121, 0x876327, 0x8b6527, 0x856125, 0x816126, 0x865f24, 0x865f26, 0x825d26, 0x835f23, 0x7b5c26, 0x654e2c, 0x584121, 0x5b3d19, 0x6c451c, 0x8f5822, 0x150d0b, 0x14110a, 0xf4a127, 0xf4a225, 0xf8a628, 0xfdac27, 0xfeb22b, 0xfeb72b, 0xfdb92a, 0xfdbc2c, 0xfec031, 0xfdc12f, 0xffc32d, 0xfec72e, 0xfdc82e, 0xfcc92f, 0xfcc92f, 0xfdc82e, 0xfdc82e, 0xfcc630, 0xfbc531, 0xfcc433, 0xfcc439, 0xfbc33a, 0xfac03b, 0xf8bc38, 0xf8b236, 0xfbab32, 0xffaa36, 0xdd9a31, 0xa17c2e, 0x987730, 0x8e7233, 0x86692f, 0x7c622f, 0x72572c, 0x624c27, 0x594427, 0x54422a, 0x40311c, 0x2b1c09, 0x2f1d09, 0x35200b, 0x33210d, 0x331c0a, 0x321b0b, 0x32200c, 0x281d0b, 0x1e180a, 0x311f0b, 0x6c360a, 0xa04c0c, 0xa04808, 0x463d2c, 0x493e2c, 0x4c4030, 0x4d422e, 0x4e442b, 0x50452f, 0x4e432d, 0x50452f, 0x4d452e, 0x50452f, 0x4d422e, 0x493f26, 0x493d27, 0x433b24, 0x3f3923, 0x392c23, 0x4a3927, 0x76602e, 0x826e31, 0x947630, 0xc59942, 0xffde63, 0xffe864, 0xfeed69, 0xffee70, 0xfdee71, 0xfdef75, 0xfeed79, 0xffeb76, 0xffec73, 0xfced6e, 0xfee96c, 0xfee861, 0xfee95a, 0xfee652, 0xfee54b, 0xfee644, 0xfce442, 0xffe442, 0xfee540, 0xffe73d, 0xfee238, 0xfee334, 0xffe433, 0xfce535, 0xfee032, 0xffd938, 0xffd344, 0xf9ca3c, 0xf8d265, 0x524a3d, 0x010101, 0x40311c, 0x5d4626, 0x6e5421, 0x7e5f1f, 0x7d591d, 0x7f5b1f, 0x836121, 0x856324, 0x856324, 0x876528, 0x876526, 0x85622a, 0x816229, 0x856127, 0x876029, 0x835e2a, 0x876027, 0x7a5a29, 0x614c2f, 0x5a4324, 0x62421b, 0x6d4722, 0x8e5923, 0x2c1d16, 0x000105, 0xc78926, 0xffaf28, 0xf5a729, 0xfeb22b, 0xfdb52d, 0xfdb82d, 0xfdbc2c, 0xfec02f, 0xfdc333, 0xfcc431, 0xfec72e, 0xfec92f, 0xfdca30, 0xfcce30, 0xfcce30, 0xfbce2d, 0xfece30, 0xfdcc31, 0xf9cb30, 0xfacc38, 0xfeca38, 0xfdc638, 0xfcc43d, 0xfabe39, 0xfcb332, 0xfaae36, 0xfdaa32, 0xeaa435, 0xa67f30, 0x947233, 0x8e7034, 0x836831, 0x735e31, 0x6b5229, 0x5d4627, 0x58442b, 0x4a391f, 0x311e0d, 0x2e1c08, 0x37230a, 0x362009, 0x341f0a, 0x2e1d09, 0x322008, 0x2f1d09, 0x301b08, 0x351f0a, 0x221608, 0x1a1309, 0x4a290a, 0x854508, 0x463b27, 0x473c2a, 0x493e2c, 0x4d422c, 0x4d432a, 0x4d422c, 0x4d422e, 0x4d422c, 0x4b432c, 0x50442c, 0x4d412b, 0x453d28, 0x463c23, 0x473b23, 0x403521, 0x3d3121, 0x372d21, 0x5e4a27, 0x7d672d, 0x896d2c, 0xc29b40, 0xffdd62, 0xffe160, 0xfded64, 0xfeed6b, 0xffec71, 0xfcec73, 0xffee78, 0xfeeb75, 0xfdea71, 0xfdeb6f, 0xffea6d, 0xfde868, 0xfeea65, 0xfee75b, 0xfee554, 0xfee74c, 0xfee447, 0xffe443, 0xfce442, 0xfde640, 0xfee33e, 0xfee439, 0xfde338, 0xffe435, 0xffdf36, 0xfed73c, 0xffd243, 0xffd148, 0xdab861, 0x211f20, 0x000004, 0x46381e, 0x5c472a, 0x6e5222, 0x7d5f23, 0x7d5d22, 0x7c5c21, 0x846225, 0x866427, 0x83632a, 0x846429, 0x89662c, 0x84642b, 0x82632c, 0x83632a, 0x84602c, 0x815e28, 0x856228, 0x795a2c, 0x624f31, 0x5c4525, 0x62441e, 0x704b21, 0x945b26, 0x382717, 0x000002, 0x7f5c1a, 0xffbe30, 0xf0a92d, 0xfbb22f, 0xfeb532, 0xfdb932, 0xfdbe31, 0xffc234, 0xfcc336, 0xfec737, 0xfdc935, 0xfccb30, 0xfdcf33, 0xfdcf31, 0xfed130, 0xfdd22e, 0xfdd331, 0xfdd333, 0xfed336, 0xfed337, 0xfdce38, 0xfccc3a, 0xfbc839, 0xfcbe35, 0xfdb636, 0xfdb235, 0xf9ad33, 0xefaa35, 0xaa8433, 0x8c6f35, 0x8a6d33, 0x7e6431, 0x71592d, 0x634b27, 0x5b472e, 0x513f27, 0x362410, 0x2d1b07, 0x372308, 0x362207, 0x37210a, 0x321d0a, 0x311f09, 0x331f07, 0x311f0b, 0x321d0a, 0x301b08, 0x2e1c08, 0x2b1809, 0x201003, 0x271a0a, 0x453923, 0x473c28, 0x453a26, 0x493e2a, 0x4b402a, 0x4c412b, 0x4d422c, 0x4b402a, 0x4b402a, 0x4c412b, 0x4e422c, 0x4b402a, 0x463b25, 0x43371f, 0x40341e, 0x3d321e, 0x392b22, 0x433222, 0x745f2a, 0x82652b, 0xbd9742, 0xfdd75c, 0xffde60, 0xfce861, 0xfeed69, 0xfeec6e, 0xfeeb73, 0xffec76, 0xfeeb73, 0xfce971, 0xffec73, 0xffe96f, 0xfde86b, 0xfce968, 0xfee861, 0xffe658, 0xffe753, 0xfee54b, 0xfee447, 0xfde545, 0xfee743, 0xffe43d, 0xfde336, 0xfde338, 0xfee33a, 0xfede3b, 0xfdd63b, 0xfed047, 0xffdb71, 0xb9965e, 0x030712, 0x000207, 0x4a3925, 0x624d2e, 0x6d5525, 0x7f5f22, 0x7d5e25, 0x7d5e25, 0x836328, 0x85652a, 0x83642d, 0x86662d, 0x8b6830, 0x86652f, 0x84652f, 0x86652f, 0x82612e, 0x81602b, 0x89662c, 0x795c30, 0x635032, 0x5e4725, 0x664824, 0x744e27, 0x96612b, 0x3e281a, 0x000000, 0x3b2b14, 0xfeb836, 0xf8ae33, 0xfbb232, 0xfdb735, 0xfeba35, 0xfdbd35, 0xfdc238, 0xfec53a, 0xfdc83c, 0xffcb3a, 0xfdce3a, 0xfed13a, 0xfed337, 0xfed434, 0xfed432, 0xfdd633, 0xfdd736, 0xfdd736, 0xfed73a, 0xfed53b, 0xffd33c, 0xfbcc38, 0xfcc334, 0xfebb36, 0xfbb436, 0xf5b136, 0xeeb037, 0xad8837, 0x8a6d35, 0x886a38, 0x795e2f, 0x6b5229, 0x60482e, 0x57462a, 0x3f2d15, 0x2f1a07, 0x362209, 0x37230b, 0x342005, 0x331f07, 0x341f0a, 0x331f07, 0x2f1d09, 0x331f06, 0x2f1d07, 0x2f1a07, 0x2e1906, 0x2c1b09, 0x2d1b07, 0x271708, 0x42361e, 0x443820, 0x463b25, 0x443925, 0x493e2a, 0x493e28, 0x4c4028, 0x4b3f27, 0x4b3f27, 0x483d29, 0x4b402a, 0x4c4028, 0x463b25, 0x42381f, 0x42361c, 0x3e321a, 0x3b2e1e, 0x36281f, 0x564323, 0x7b5c25, 0xb89440, 0xf6d053, 0xf9d656, 0xffe35e, 0xfdeb63, 0xfeeb6b, 0xfeea71, 0xffea73, 0xfeeb73, 0xfbe870, 0xfee972, 0xfde970, 0xfee86e, 0xfbe868, 0xfde966, 0xffe55d, 0xfee557, 0xffe552, 0xfee54b, 0xffe64b, 0xfde543, 0xffe540, 0xfee13b, 0xfee33c, 0xfde23d, 0xfede3d, 0xfdd63b, 0xfecd56, 0xfee388, 0xa68856, 0x00010d, 0x000105, 0x4e422a, 0x655231, 0x6f5729, 0x81602a, 0x7e602a, 0x7e6129, 0x85652c, 0x87672e, 0x856731, 0x866731, 0x896832, 0x866834, 0x846632, 0x886732, 0x826233, 0x836330, 0x88682f, 0x785c34, 0x645335, 0x624c27, 0x6b4d29, 0x785128, 0x9b672e, 0x3d2c18, 0x010000, 0x0a080b, 0xdc9f35, 0xfeb937, 0xf9b337, 0xfdb839, 0xfebb39, 0xfebf3c, 0xfdc33e, 0xffc740, 0xfec841, 0xfeca42, 0xfdcf46, 0xfdd247, 0xfdd245, 0xfed442, 0xfdd53f, 0xfcd83c, 0xfdd93b, 0xfdd93a, 0xfcd83a, 0xfcd93d, 0xfed53d, 0xfccd39, 0xfdc636, 0xfdc034, 0xf8b735, 0xf0b537, 0xedb638, 0xab8837, 0x846934, 0x816536, 0x725a2a, 0x654c2d, 0x5e4a31, 0x48361e, 0x2e1c06, 0x342005, 0x3a240c, 0x372109, 0x342008, 0x2f1d05, 0x331f06, 0x321c05, 0x311f07, 0x2e1c04, 0x2f1b03, 0x2f1a05, 0x2f1a05, 0x2d1805, 0x2c1a06, 0x2b1a08, 0x3e321c, 0x41351d, 0x443820, 0x453a26, 0x423725, 0x473c28, 0x483c24, 0x4a3e24, 0x4c3d26, 0x443925, 0x473c26, 0x4a3e26, 0x463a22, 0x3f351c, 0x40341a, 0x413318, 0x3c3219, 0x34281a, 0x3b2b1b, 0x6a4d21, 0xa98837, 0xebc94e, 0xf4ce51, 0xfddb56, 0xfee75d, 0xfdeb65, 0xfeea6d, 0xfee972, 0xffed77, 0xfee972, 0xfee870, 0xfee972, 0xfce86d, 0xfce86b, 0xfee969, 0xfde55f, 0xfde35a, 0xffe554, 0xfde34e, 0xfee34a, 0xfee648, 0xffe546, 0xffe141, 0xfee13f, 0xfcdf3b, 0xfddb3c, 0xfdd43e, 0xfecc5d, 0xffe08b, 0x826c47, 0x02000d, 0x000004, 0x51452d, 0x675434, 0x70582c, 0x80622e, 0x7d622d, 0x80622e, 0x866731, 0x886933, 0x866834, 0x866834, 0x896936, 0x846836, 0x896b39, 0x8b6a37, 0x826337, 0x856735, 0x8a6933, 0x795f3a, 0x67563a, 0x664e2a, 0x6e502c, 0x7b542b, 0xa06c33, 0x3f3019, 0x000002, 0x000000, 0xa3792d, 0xfec93f, 0xf7b239, 0xfab93b, 0xfdbc3c, 0xfec142, 0xfec341, 0xfdc741, 0xfeca43, 0xfcca43, 0xfece46, 0xffd14a, 0xfed24b, 0xfed44c, 0xfed44a, 0xfed94d, 0xfedb4d, 0xffdc4c, 0xfdda48, 0xfedb43, 0xfcd53a, 0xfccd37, 0xfec737, 0xfbc036, 0xf6bb39, 0xeeb83a, 0xeab83b, 0xaa893c, 0x806538, 0x796230, 0x6a532a, 0x624c34, 0x514024, 0x33210d, 0x321e05, 0x3a250a, 0x372207, 0x38220a, 0x321d08, 0x342005, 0x321e06, 0x341e07, 0x311d05, 0x2e1c04, 0x301c03, 0x2b1903, 0x2e1906, 0x301c04, 0x2d1b07, 0x2b1807, 0x392e1c, 0x3f331b, 0x43351a, 0x443820, 0x3f3722, 0x413924, 0x453a24, 0x4a3b24, 0x483c24, 0x453921, 0x443923, 0x463a22, 0x463a22, 0x41351d, 0x3e321a, 0x403217, 0x3e3317, 0x382d17, 0x302416, 0x49331e, 0x997833, 0xdebd4c, 0xebc548, 0xfbd451, 0xffe158, 0xffe85e, 0xfdea67, 0xfce970, 0xfeeb75, 0xffeb72, 0xfde76f, 0xfee972, 0xfbe76c, 0xfee96c, 0xffe769, 0xfee765, 0xfde35b, 0xffe457, 0xfde14f, 0xfde44c, 0xfee54b, 0xfee648, 0xffe242, 0xffdf3f, 0xfddd3d, 0xfdd83f, 0xfed23e, 0xfcce54, 0xfbd17b, 0x4e453c, 0x040612, 0x020003, 0x59472f, 0x6f5c3b, 0x705930, 0x7f642f, 0x7e6230, 0x816533, 0x896936, 0x8a6a37, 0x866a3a, 0x8b6d3b, 0x8c6e3c, 0x866a3a, 0x896d3b, 0x8c6c3b, 0x84673b, 0x88693a, 0x8a6a37, 0x78623d, 0x68573b, 0x6a522e, 0x705331, 0x805b31, 0xa3703b, 0x41301e, 0x000002, 0x000000, 0x7a5b25, 0xfed049, 0xf4b33d, 0xf9b93e, 0xfdbd41, 0xfec144, 0xfec343, 0xfdc741, 0xfeca43, 0xfdcb44, 0xffce45, 0xfed046, 0xfed349, 0xfed44c, 0xfdd54f, 0xfed954, 0xfedb59, 0xfedb59, 0xffdc5a, 0xffd952, 0xfdd349, 0xfecd44, 0xfec63d, 0xf9c138, 0xf0be37, 0xeab938, 0xe7b93f, 0xa07f3a, 0x846c40, 0x7b6637, 0x61492d, 0x5e4a2f, 0x3a2a11, 0x301c04, 0x3d2509, 0x38220a, 0x382308, 0x331f07, 0x372207, 0x341e06, 0x362008, 0x341e06, 0x311d04, 0x341e06, 0x2c1a04, 0x2e1a02, 0x301b06, 0x2b1a06, 0x2b1905, 0x2c1b09, 0x352d1a, 0x3b2f19, 0x413319, 0x40341a, 0x423721, 0x3f3722, 0x433822, 0x453923, 0x463a22, 0x483a20, 0x42381f, 0x413620, 0x473821, 0x443820, 0x3e321a, 0x3d2f14, 0x402f13, 0x3a2f13, 0x332616, 0x34211b, 0x755526, 0xd2ad42, 0xe3c040, 0xf1ca49, 0xfeda52, 0xffe359, 0xffe960, 0xfdea6a, 0xfde970, 0xffea72, 0xfde76d, 0xfde76f, 0xfde96e, 0xffe86c, 0xfde567, 0xfee767, 0xfee35e, 0xffe258, 0xfee252, 0xffe44f, 0xfee54b, 0xfde449, 0xffe244, 0xffdc42, 0xfed942, 0xfed440, 0xfed140, 0xfdd54f, 0xd5af64, 0x2a2b2f, 0x0f131c, 0x000100, 0x5b4a30, 0x75613e, 0x725c33, 0x816736, 0x816736, 0x826837, 0x8a6c3a, 0x8b6d3b, 0x876c3d, 0x8b6f40, 0x8c7040, 0x876c3f, 0x8a6e3f, 0x8b6f3f, 0x866b40, 0x8b6c3d, 0x8b6c3e, 0x786443, 0x6e5b3d, 0x705836, 0x775b36, 0x856036, 0xa6743f, 0x3d2d1d, 0x010002, 0x010101, 0x53411d, 0xffcc4d, 0xf3b73f, 0xf5b941, 0xfcbe45, 0xfcbe43, 0xfec343, 0xffc744, 0xfec842, 0xffcc44, 0xffce45, 0xffcf47, 0xfed349, 0xfed44c, 0xfed650, 0xfed955, 0xfddc59, 0xfedc5e, 0xfeda62, 0xfed55f, 0xffd05c, 0xffca58, 0xfdc450, 0xf6c449, 0xebbf42, 0xe6ba3f, 0xdfb549, 0x947439, 0x7f683e, 0x75613e, 0x5f4b30, 0x48341b, 0x2e1d03, 0x3b2307, 0x3c2408, 0x382308, 0x342008, 0x362207, 0x362104, 0x372109, 0x341f04, 0x321e05, 0x331e03, 0x301c04, 0x2f1a05, 0x2f1d05, 0x2b1901, 0x2a1706, 0x2c1b09, 0x2c1c05, 0x362b15, 0x362b15, 0x3a2e18, 0x40311a, 0x40341a, 0x42361e, 0x40351f, 0x423721, 0x443820, 0x46381e, 0x43371d, 0x41351d, 0x40341c, 0x43341d, 0x3f3117, 0x3d2f14, 0x3f2f0e, 0x3d2f14, 0x392a13, 0x2f1e16, 0x4d341e, 0xbd993b, 0xdebc41, 0xe8c140, 0xf6d049, 0xffdb51, 0xffe558, 0xfee85f, 0xfce767, 0xffe96f, 0xfde76d, 0xfde569, 0xfde76d, 0xffe56a, 0xfde567, 0xfde666, 0xffe35e, 0xfde257, 0xfde253, 0xfee250, 0xfee34a, 0xfde44a, 0xffe047, 0xfed845, 0xfed643, 0xffd243, 0xfcd144, 0xffdd59, 0xac935b, 0x171b27, 0x1b1b23, 0x000103, 0x5a4c32, 0x7a6643, 0x766037, 0x826a3c, 0x836b3d, 0x846c3c, 0x8a703f, 0x8b7041, 0x887042, 0x8b7345, 0x8d7245, 0x897145, 0x8d7245, 0x8a7244, 0x856c43, 0x8e6f41, 0x8a6f44, 0x7a6747, 0x73603f, 0x735c3c, 0x7c6039, 0x89643a, 0xa47942, 0x332b18, 0x010002, 0x000000, 0x241e12, 0xf2bd4d, 0xf9be48, 0xf5ba44, 0xfabd48, 0xfbbf45, 0xffc446, 0xffc645, 0xfec842, 0xffcb43, 0xfecd44, 0xfecf45, 0xfed046, 0xfed349, 0xfdd54f, 0xfed955, 0xfdda5a, 0xfeda5f, 0xffd765, 0xfdd25f, 0xffce5b, 0xfec85b, 0xf9c45e, 0xf1c363, 0xe8bd5e, 0xe4bc5a, 0xd2ad55, 0x856a35, 0x735b37, 0x6c543a, 0x523f21, 0x342008, 0x392405, 0x3e2507, 0x3a2508, 0x362008, 0x362106, 0x3a2508, 0x352005, 0x372205, 0x331d06, 0x341f04, 0x331d05, 0x301c04, 0x2f1b02, 0x2c1a04, 0x2b1a06, 0x2d1b03, 0x2c1c05, 0x2e1c06, 0x372b11, 0x342913, 0x342915, 0x3c3018, 0x413117, 0x423219, 0x40341c, 0x3c341f, 0x43341d, 0x45361f, 0x45371d, 0x42341a, 0x3c301a, 0x413319, 0x423218, 0x3c3016, 0x3b2d12, 0x3c2b0f, 0x3d2d13, 0x372614, 0x2e1b15, 0x916f30, 0xdab83d, 0xdeb83b, 0xedc740, 0xfbd44b, 0xfede4f, 0xfee453, 0xfce65d, 0xfbe868, 0xfce86d, 0xfee566, 0xfee66a, 0xfee567, 0xfee668, 0xfde463, 0xfee25d, 0xfce156, 0xfde253, 0xfee04e, 0xffe14f, 0xfde34e, 0xfedf49, 0xfed847, 0xfed547, 0xffd147, 0xf8ce44, 0xffde62, 0x968152, 0x0c1125, 0x1a1b1f, 0x010000, 0x534633, 0x816d4a, 0x79633c, 0x836e3f, 0x856d3f, 0x887042, 0x8e7344, 0x8c7446, 0x8a7347, 0x8d764a, 0x8f774b, 0x8c754b, 0x8e764a, 0x8c754b, 0x897248, 0x957648, 0x8a7148, 0x7a6a49, 0x786642, 0x776040, 0x7f633e, 0x916a41, 0xa47c49, 0x2f2519, 0x000100, 0x000100, 0x020109, 0xcea042, 0xffc750, 0xf3ba46, 0xf8bd49, 0xfcc048, 0xffc347, 0xfec446, 0xffc945, 0xfdc942, 0xffca48, 0xfdcd45, 0xfed046, 0xfed346, 0xffd64a, 0xfed84f, 0xfed955, 0xffda5b, 0xfed559, 0xfbd15b, 0xfeca5c, 0xfec55c, 0xf5c45e, 0xecc163, 0xe4bc65, 0xe2bc69, 0xbd9a56, 0x745c2c, 0x6f573b, 0x624b2b, 0x3b270c, 0x372205, 0x3e2708, 0x3d2406, 0x352106, 0x382308, 0x392105, 0x372205, 0x372205, 0x321e06, 0x362106, 0x351d03, 0x321c04, 0x311b03, 0x2e1c04, 0x2c1a04, 0x2e1c06, 0x2e1c06, 0x2e1c04, 0x2f1d05, 0x362a12, 0x362a10, 0x322a13, 0x332b16, 0x3d2f15, 0x423113, 0x423419, 0x3d3119, 0x3e311e, 0x42331c, 0x45351b, 0x423419, 0x3d3117, 0x3d2e17, 0x3f3117, 0x3b3014, 0x3a2b14, 0x3a2a10, 0x3e2e0d, 0x3d2c10, 0x291b12, 0x593e23, 0xc8a237, 0xd4b237, 0xe4bd3a, 0xf3cc43, 0xfbd647, 0xffda4d, 0xfde253, 0xfde561, 0xffe868, 0xfee668, 0xfde466, 0xfde567, 0xffe365, 0xfee362, 0xfee25b, 0xfcdf53, 0xfde152, 0xfedf50, 0xfde14f, 0xffe14f, 0xffda4f, 0xfbd64a, 0xfbd448, 0xfdd14a, 0xf4c947, 0xffdb6d, 0x716044, 0x020919, 0x1c1d1f, 0x000000, 0x51452f, 0x897552, 0x7a6641, 0x866f43, 0x897047, 0x8b7347, 0x8d764a, 0x8d784b, 0x8d784d, 0x907b50, 0x917a50, 0x907950, 0x917c4f, 0x907950, 0x8d764d, 0x987c4c, 0x8a744f, 0x7e6f52, 0x786844, 0x7c6545, 0x866844, 0x937245, 0xa27c4b, 0x242014, 0x010000, 0x010103, 0x000000, 0xae883d, 0xffce55, 0xeeba4d, 0xf6bd4a, 0xf8c049, 0xfec449, 0xffc448, 0xffc744, 0xfec844, 0xfdcb44, 0xffce45, 0xfecf43, 0xfed346, 0xffd64a, 0xffd54b, 0xfed650, 0xfed754, 0xfdd04f, 0xffcd58, 0xfbc759, 0xf6c55f, 0xf1c15d, 0xe8bd61, 0xdcb665, 0xdbba6b, 0xa28245, 0x674e2f, 0x685537, 0x463114, 0x371f03, 0x402804, 0x402709, 0x392405, 0x3a2206, 0x3b2307, 0x3a2206, 0x3a2206, 0x371f05, 0x341f04, 0x362106, 0x321d02, 0x321e05, 0x311d04, 0x321e06, 0x301b06, 0x301c04, 0x321e06, 0x2f1d05, 0x2c1a06, 0x2e2611, 0x342810, 0x372b11, 0x332812, 0x362a14, 0x3f2f15, 0x413117, 0x3d3117, 0x3b2f17, 0x3e2f18, 0x42341a, 0x413318, 0x3f2f15, 0x3c2d16, 0x3a2e14, 0x3d2d13, 0x3b2c0f, 0x37290f, 0x3d2d0c, 0x3f2c0c, 0x382713, 0x341912, 0x94722a, 0xd4b038, 0xd8b237, 0xe7bf39, 0xf8cd43, 0xfdd542, 0xfedb49, 0xfce352, 0xfde65a, 0xffe564, 0xfce460, 0xfee564, 0xfee360, 0xfde25d, 0xfee25a, 0xfcdf53, 0xfedf51, 0xffdf50, 0xfedd50, 0xfdde52, 0xffd952, 0xfdd64b, 0xffd04e, 0xfacd4c, 0xf1ca49, 0xf7d373, 0x4e4536, 0x101626, 0x1d1d1f, 0x000100, 0x49402f, 0x8e7c58, 0x7e6c46, 0x86734b, 0x8b764b, 0x8c774c, 0x907a51, 0x927c55, 0x927a54, 0x957e55, 0x947e57, 0x907c57, 0x987f56, 0x937b55, 0x917a58, 0x957c53, 0x8d7654, 0x847153, 0x7e6e4d, 0x826e4d, 0x8a7149, 0x9b794c, 0x9e7c4f, 0x1e1a17, 0x010100, 0x010302, 0x010000, 0x96773e, 0xffd660, 0xeebc4d, 0xf2bd4b, 0xf7bf4e, 0xfbc048, 0xffc448, 0xffc648, 0xffc847, 0xfec945, 0xffcb43, 0xfdce42, 0xffd245, 0xfdd446, 0xfdd446, 0xfdd448, 0xfcd248, 0xfed047, 0xffc847, 0xfcc455, 0xf4c55d, 0xebc15d, 0xe2bb5e, 0xdab366, 0xccab5a, 0x917545, 0x7a6248, 0x523d22, 0x382101, 0x3f2808, 0x402907, 0x3d250b, 0x3b2309, 0x3e2507, 0x3a2304, 0x3b2309, 0x382006, 0x371f03, 0x382004, 0x341e06, 0x331d05, 0x321d02, 0x301c04, 0x301c03, 0x311d05, 0x311d05, 0x301e06, 0x2d1b05, 0x2d1b03, 0x2c2411, 0x322713, 0x37290f, 0x37290e, 0x332812, 0x372b15, 0x3e2e15, 0x3e3013, 0x403217, 0x3a2e16, 0x3b2f17, 0x403016, 0x403016, 0x3d2d14, 0x392910, 0x3b2b11, 0x3f2e12, 0x37270d, 0x39280a, 0x412e0d, 0x3d2d0c, 0x301c11, 0x52341c, 0xbb9834, 0xd5ae2f, 0xddb637, 0xecc23c, 0xf6cf43, 0xfdd341, 0xfed847, 0xffe051, 0xfee459, 0xfde159, 0xfde15a, 0xfde15a, 0xfee159, 0xfee157, 0xfdde52, 0xfddc51, 0xfddc51, 0xffd952, 0xfed954, 0xfdd856, 0xfdd551, 0xfecd4d, 0xf6cb49, 0xf3ce59, 0xe2c174, 0x353128, 0x1d212c, 0x1c1c1e, 0x000002, 0x3f352b, 0x967f5f, 0x87704e, 0x8b7752, 0x8c7951, 0x917b52, 0x967f55, 0x957f56, 0x927f57, 0x96825d, 0x95815e, 0x94805d, 0x99835e, 0x937f5c, 0x96805b, 0x9a8158, 0x907c59, 0x887857, 0x817251, 0x86724f, 0x917850, 0xa17f52, 0x9c7d4e, 0x16120f, 0x010000, 0x020305, 0x000002, 0x786135, 0xffd56c, 0xebba53, 0xf1bc4c, 0xf3be4c, 0xf7c04b, 0xfac249, 0xfdc647, 0xfec746, 0xfec748, 0xfec945, 0xfdcc43, 0xffd046, 0xfcd146, 0xfed348, 0xffd248, 0xfdce44, 0xfeca42, 0xffc442, 0xf7c44e, 0xebc04d, 0xe4bd56, 0xdbb65e, 0xd4ae5b, 0xb79653, 0x9f8960, 0x786346, 0x392203, 0x402605, 0x432b09, 0x3f2808, 0x3b2405, 0x3e2604, 0x3d2406, 0x3a2103, 0x392105, 0x3a2208, 0x392203, 0x371f03, 0x341f04, 0x341f04, 0x331d05, 0x352005, 0x321e05, 0x331f04, 0x331f06, 0x2c1a06, 0x2f1d05, 0x2e1e04, 0x2d2210, 0x2c2411, 0x31270e, 0x382a10, 0x342810, 0x322711, 0x392b11, 0x3f3013, 0x3f3013, 0x3c3016, 0x372b13, 0x3e2e15, 0x3f2f15, 0x3e2e14, 0x3c2b11, 0x36260c, 0x3b2a0e, 0x3b2c0d, 0x39280c, 0x3b2b0a, 0x412d0a, 0x3f2c0e, 0x2d1511, 0x785722, 0xd2ac31, 0xd5ae2f, 0xdfb932, 0xebc63a, 0xf6cd3d, 0xfbd141, 0xffd648, 0xffde51, 0xfddd54, 0xfddb53, 0xfede55, 0xfedc54, 0xfedc54, 0xfddb53, 0xfed851, 0xfed851, 0xfed652, 0xfed653, 0xfdd657, 0xfbd455, 0xf9cb51, 0xf2c94d, 0xf9d370, 0xcdb06e, 0x262221, 0x262932, 0x1e201f, 0x010000, 0x3a3426, 0x988660, 0x887554, 0x907c57, 0x937d58, 0x957f5a, 0x9b8860, 0x9f8d65, 0xa59268, 0xb19c71, 0xb29c73, 0xab9772, 0xaf9c72, 0xaa9673, 0xaa926c, 0xa48d64, 0x938062, 0x8d7c60, 0x867758, 0x8c7857, 0x957b58, 0xab8b5c, 0x8d714c, 0x07080c, 0x000200, 0x030200, 0x000100, 0x4e3a21, 0xffcc70, 0xebbd5f, 0xf1ba55, 0xf3bf4f, 0xf3c04b, 0xf8c14a, 0xf8c546, 0xfbc646, 0xfcc544, 0xfeca43, 0xffcc44, 0xffcd46, 0xfece46, 0xffd148, 0xffcf46, 0xfec841, 0xfbc53f, 0xf4c342, 0xedc144, 0xe8be46, 0xddb74a, 0xd4ae4b, 0xc9a54d, 0xa5885c, 0x816e50, 0x453011, 0x3a2200, 0x442a05, 0x422a06, 0x3e2506, 0x402709, 0x3e2604, 0x3c2305, 0x3a2005, 0x3c2506, 0x3a2304, 0x382004, 0x382006, 0x352003, 0x331f04, 0x362008, 0x331e03, 0x342005, 0x331f06, 0x2e1a02, 0x301f05, 0x2e1d03, 0x2e1d03, 0x31250d, 0x2c210f, 0x2a2110, 0x332711, 0x38280e, 0x362710, 0x332711, 0x3a2c11, 0x3d2e11, 0x3f2e14, 0x3b2d13, 0x372b13, 0x3b2b11, 0x3d2e11, 0x3b2c0f, 0x37270d, 0x392a0d, 0x3b2b0a, 0x3c2909, 0x382709, 0x422b09, 0x432c0a, 0x372511, 0x3b1f14, 0x9f7627, 0xd5b02e, 0xd6af2e, 0xe2ba34, 0xecc53a, 0xf6cb3e, 0xfad046, 0xfcd647, 0xfdd74e, 0xffd751, 0xffd952, 0xfed851, 0xfed851, 0xfdd752, 0xfed350, 0xfdd552, 0xfdd454, 0xfed353, 0xfbd359, 0xfad260, 0xf5cb5d, 0xf0c960, 0xfcd882, 0xbea165, 0x14181b, 0x272a33, 0x202123, 0x010000, 0x2f2b20, 0x998761, 0x927e5d, 0x9f8868, 0xab986d, 0xb19c71, 0xab956e, 0x978463, 0x88795c, 0x7d6f55, 0x74684e, 0x796d53, 0x7c6e53, 0x746852, 0x8b7c5f, 0x9d8d69, 0xa89876, 0xae9c78, 0x9b8d6a, 0x92805c, 0x987e5b, 0xb59765, 0x796648, 0x000104, 0x050409, 0x020106, 0x000200, 0x352315, 0xeab361, 0xf1c266, 0xedbb5a, 0xf0bd52, 0xf2bf4a, 0xf6bf48, 0xf6c24a, 0xfbc446, 0xfac344, 0xfcc743, 0xfeca43, 0xffca46, 0xfecc47, 0xfdcd47, 0xfeca43, 0xfdc43f, 0xf5c242, 0xefc243, 0xeabe45, 0xe3b94b, 0xd6b043, 0xcea83d, 0xb69454, 0x8f7a5d, 0x573f25, 0x381e00, 0x482e0b, 0x422a06, 0x3f2705, 0x422709, 0x402806, 0x3f2607, 0x3d2406, 0x3c2305, 0x3d2405, 0x3a2303, 0x371f03, 0x371f03, 0x362104, 0x362104, 0x331e03, 0x352106, 0x331f04, 0x311d04, 0x331f06, 0x311d02, 0x321e05, 0x311d05, 0x32280f, 0x302310, 0x2b1f0f, 0x2a220f, 0x36280d, 0x39290f, 0x34250e, 0x31250d, 0x3b2b11, 0x3e2d11, 0x3f3013, 0x392b11, 0x37290f, 0x3b2c0f, 0x392a0b, 0x3a2b0e, 0x352609, 0x3b270c, 0x3d2a0a, 0x372608, 0x3e2708, 0x432b07, 0x402e0a, 0x301c11, 0x512b16, 0xb48a26, 0xdaaf2d, 0xdbb02d, 0xe2bc37, 0xf1c339, 0xf4c93c, 0xf6d047, 0xf9d249, 0xfdd34d, 0xfcd44e, 0xfdd24f, 0xfed350, 0xfbd350, 0xfcd151, 0xfbd050, 0xfdd156, 0xf9d05a, 0xf7d067, 0xf6ce6c, 0xf4cb6f, 0xeac670, 0xffdf8d, 0xa18a56, 0x080b14, 0x2b2b35, 0x202425, 0x000100, 0x1d1814, 0xad9b77, 0xa89670, 0x8f8061, 0x6f604b, 0x473e2d, 0x29241e, 0x151515, 0x040509, 0x000002, 0x010100, 0x000000, 0x010000, 0x000000, 0x050706, 0x1a1915, 0x373529, 0x615642, 0x8a7a61, 0xb39b77, 0xbba075, 0xc9a970, 0x6e5d41, 0x010101, 0x070508, 0x010302, 0x000100, 0x231a13, 0xd09b57, 0xedba61, 0xedc05b, 0xeabc4d, 0xefbb4d, 0xf0be4b, 0xf3c04a, 0xf7c049, 0xf9c347, 0xfbc547, 0xfac747, 0xfbc848, 0xfcca47, 0xfac845, 0xf9c442, 0xf7c03f, 0xf1c145, 0xe9bd44, 0xe5b845, 0xdbb248, 0xd0aa3f, 0xc19f48, 0xa78e65, 0x725d40, 0x422805, 0x462a03, 0x442a07, 0x412907, 0x422a08, 0x422805, 0x3f2703, 0x3e2506, 0x3d2405, 0x412809, 0x3c2305, 0x382004, 0x392202, 0x3a2304, 0x392407, 0x352003, 0x352204, 0x331f04, 0x321e06, 0x352106, 0x331f04, 0x352108, 0x331f04, 0x321e05, 0x2d220e, 0x35270d, 0x33250b, 0x2b200e, 0x2d220e, 0x342609, 0x38290c, 0x33240d, 0x35250c, 0x3b2c0f, 0x3e2d0f, 0x3d2c10, 0x382a10, 0x37290e, 0x3c2b0d, 0x3a2a09, 0x362509, 0x35240a, 0x39280a, 0x3b2808, 0x3d2607, 0x432d06, 0x452f08, 0x3d2a0a, 0x361f11, 0x6a4318, 0xbb8e29, 0xdab22e, 0xdcb830, 0xe5bb35, 0xedc235, 0xf0c640, 0xf6cc46, 0xf8cd4a, 0xfacf4d, 0xfbd050, 0xfacf4f, 0xf9cd50, 0xf8cf53, 0xf8cc53, 0xf7cc5b, 0xf7cd67, 0xf3ce76, 0xf2cc79, 0xefc978, 0xe9c577, 0xffe08d, 0x7b6941, 0x00020f, 0x2e2d32, 0x272b2c, 0x040807, 0x0b090a, 0x4e4639, 0x322c20, 0x0b0c07, 0x000100, 0x000000, 0x000000, 0x000000, 0x000002, 0x020204, 0x020204, 0x010204, 0x010204, 0x040203, 0x000000, 0x020100, 0x000100, 0x000100, 0x08080a, 0x35312e, 0x6b5c47, 0xbba375, 0x60513a, 0x000000, 0x080808, 0x030200, 0x010000, 0x0e110a, 0xbb9155, 0xdda85a, 0xeabe5d, 0xebbf52, 0xecb950, 0xeec051, 0xf0be4b, 0xf1be49, 0xf5c147, 0xf6c346, 0xf6c447, 0xf9c848, 0xf9c744, 0xf5c340, 0xf3c040, 0xf0bf3f, 0xeabc44, 0xe3ba44, 0xdbb342, 0xd1aa41, 0xc39e45, 0xb89962, 0x97845a, 0x513913, 0x432501, 0x4b2d09, 0x432904, 0x452b08, 0x432906, 0x412905, 0x3d2604, 0x3f2407, 0x412907, 0x3d2503, 0x392203, 0x3a2206, 0x3c2505, 0x3b2404, 0x392105, 0x3a2304, 0x352003, 0x331f06, 0x352106, 0x342005, 0x331f04, 0x321e03, 0x321e05, 0x332002, 0x2c210b, 0x2f230b, 0x37270d, 0x31220b, 0x271f0a, 0x2c210b, 0x36260c, 0x38290a, 0x32230c, 0x352609, 0x3c2c0b, 0x3b2a0c, 0x37270d, 0x35270d, 0x38290a, 0x402909, 0x3c2807, 0x352406, 0x36270a, 0x3f2806, 0x3e2708, 0x3e2a05, 0x452e05, 0x46300b, 0x36240c, 0x442a11, 0x7b531f, 0xab7e23, 0xd8ab2e, 0xe1bb36, 0xe5ba37, 0xeabe3b, 0xefc442, 0xf1c848, 0xf5c84b, 0xf6ca4d, 0xf5cc50, 0xf5c950, 0xf3cb52, 0xf4ca54, 0xf3c963, 0xf3ca70, 0xeec877, 0xefcb7f, 0xebc779, 0xf0cb7d, 0xf6d284, 0x584b29, 0x000613, 0x2d2f2c, 0x2c2b31, 0x171518, 0x000000, 0x000100, 0x000000, 0x000004, 0x050507, 0x070506, 0x070707, 0x050505, 0x060606, 0x070506, 0x070506, 0x060608, 0x060606, 0x070508, 0x030708, 0x060606, 0x030406, 0x060604, 0x010000, 0x010000, 0x010100, 0x121011, 0x121013, 0x12110f, 0x040404, 0x020403, 0x000100, 0x020202, 0xa58850, 0xd3a45c, 0xd5a551, 0xecbf5a, 0xecbc50, 0xeaba4b, 0xf0bc4e, 0xf0bd4a, 0xf3c04a, 0xf3c04a, 0xf3c148, 0xf4c448, 0xf3c242, 0xf2bc3e, 0xefbd42, 0xeabb45, 0xe5b845, 0xdcb443, 0xd3ad48, 0xc7a249, 0xbc985e, 0xb4976f, 0x6e552d, 0x412500, 0x4b2e04, 0x482c05, 0x472f03, 0x472b03, 0x452806, 0x3f2806, 0x3d2904, 0x452904, 0x402605, 0x3e2506, 0x3c2505, 0x3c2505, 0x3b2307, 0x3b2307, 0x3b2405, 0x382102, 0x341f04, 0x382304, 0x352204, 0x362207, 0x342005, 0x331f04, 0x352204, 0x342005, 0x2e220c, 0x2e220a, 0x312309, 0x36270a, 0x32230c, 0x281d09, 0x2e2208, 0x38290c, 0x37270d, 0x302009, 0x36270a, 0x3c2c0b, 0x3d2a0a, 0x382709, 0x36270a, 0x3c290b, 0x3b2807, 0x3a2508, 0x382505, 0x3a2804, 0x3b2706, 0x3a2506, 0x422c07, 0x4b2f08, 0x402c0b, 0x36240e, 0x5b3d17, 0x7e571e, 0x9f7022, 0xc69a2f, 0xe4ba34, 0xedbf36, 0xe8bd3b, 0xebc244, 0xeec44b, 0xf0c449, 0xf0c64d, 0xf0c650, 0xf0c650, 0xf1c759, 0xeec76c, 0xedc474, 0xedc677, 0xebc77b, 0xebc982, 0xe6c57e, 0xdcb66b, 0x453d26, 0x070a19, 0x2d2f2e, 0x2f3034, 0x17181d, 0x000000, 0x060606, 0x060604, 0x060606, 0x060606, 0x060606, 0x060606, 0x070707, 0x040404, 0x060606, 0x060606, 0x070506, 0x060606, 0x060606, 0x060606, 0x050505, 0x050505, 0x050505, 0x050505, 0x050505, 0x030303, 0x000000, 0x0d0d0d, 0x1a1a1a, 0x000000, 0x030303, 0x000000, 0x000000, 0x8c7647, 0xd5ae63, 0xbe934f, 0xd8a554, 0xefc058, 0xedbf50, 0xeaba4e, 0xedbb4a, 0xeebb48, 0xf1be48, 0xf2c148, 0xeec048, 0xedbb42, 0xecb93c, 0xe9b93d, 0xe5b843, 0xdfb444, 0xd6ae4c, 0xcba55a, 0xbd9965, 0xbe9e77, 0x856941, 0x442700, 0x4e2d00, 0x4a2e09, 0x472e06, 0x492e03, 0x462a03, 0x422805, 0x432906, 0x442a05, 0x412905, 0x3d2606, 0x3e2602, 0x3d2503, 0x3d2405, 0x3e2506, 0x3c2505, 0x362104, 0x372205, 0x382304, 0x392203, 0x3a2304, 0x352204, 0x342103, 0x352003, 0x321e03, 0x2c1a02, 0x2f2107, 0x2f2009, 0x2d2107, 0x32240a, 0x36270a, 0x31210a, 0x2c1d0a, 0x2c2006, 0x3a2707, 0x362708, 0x32220b, 0x39280a, 0x3f2c0b, 0x3b2b0a, 0x362509, 0x372608, 0x3a2707, 0x3d2908, 0x392405, 0x362303, 0x3d2908, 0x3d2904, 0x402804, 0x492f0a, 0x4b3209, 0x3d2607, 0x43290e, 0x735318, 0x81601b, 0x906822, 0xb38730, 0xd6a838, 0xe8bd3b, 0xedc23f, 0xeec245, 0xedc148, 0xefc34a, 0xeec44c, 0xeec454, 0xecc163, 0xe9c46c, 0xe9c273, 0xe9c476, 0xedc97f, 0xeac783, 0xd2b16c, 0xd0ac62, 0x3f3724, 0x080c18, 0x303133, 0x35363a, 0x2e2f33, 0x080808, 0x040404, 0x060604, 0x050505, 0x050505, 0x060606, 0x040404, 0x030303, 0x060606, 0x050505, 0x060606, 0x060606, 0x050505, 0x050505, 0x060606, 0x060606, 0x060606, 0x050505, 0x050505, 0x030303, 0x020202, 0x060606, 0x141414, 0x0b0b0b, 0x010101, 0x020202, 0x010101, 0x000000, 0x78643f, 0xdab469, 0xb89656, 0xbb9250, 0xd1a451, 0xe7bb52, 0xecbe4e, 0xefbd4c, 0xeebd47, 0xeebb46, 0xedbc45, 0xebba41, 0xebb83b, 0xe7b73b, 0xe0b544, 0xdeb34d, 0xd7ad59, 0xcea660, 0xc39e67, 0xbf9f6c, 0x91754d, 0x472905, 0x4c2d01, 0x4f3208, 0x4b2f07, 0x4c2f05, 0x482c04, 0x442b03, 0x462a03, 0x472b06, 0x452d09, 0x412702, 0x402601, 0x3f2705, 0x3d2405, 0x3f2705, 0x3d2606, 0x392203, 0x3c2506, 0x3b2607, 0x3c2304, 0x382306, 0x362303, 0x382101, 0x3a2304, 0x301f05, 0x2d1b03, 0x321f01, 0x2f2106, 0x2d1e09, 0x2e220a, 0x2e2208, 0x312108, 0x382807, 0x2f1f08, 0x281d09, 0x312205, 0x392908, 0x342506, 0x312108, 0x3c2908, 0x3d2906, 0x3b2808, 0x3a2707, 0x392608, 0x3d2906, 0x3e2705, 0x382304, 0x382504, 0x412b06, 0x432904, 0x442c06, 0x4f330b, 0x482f06, 0x3a2208, 0x5a3a11, 0x816019, 0x8c6721, 0x8e6726, 0x987426, 0xb68e36, 0xc7a03b, 0xd2ad43, 0xd4af45, 0xd8b34b, 0xdab655, 0xdcb95b, 0xe3bf69, 0xe8c373, 0xecc779, 0xe9c57b, 0xdfbd76, 0xd1af6f, 0xc0a15e, 0xcbaa63, 0x352f21, 0x0b0f1b, 0x2b2c2e, 0x323337, 0x242527, 0x0c0c0c, 0x050505, 0x050505, 0x0a0a0c, 0x070707, 0x080808, 0x0e0e0e, 0x0b0b0b, 0x050706, 0x050706, 0x050706, 0x060807, 0x070707, 0x060606, 0x060606, 0x060606, 0x050505, 0x040404, 0x040404, 0x030303, 0x020202, 0x040404, 0x030303, 0x040404, 0x030303, 0x020202, 0x020202, 0x000000, 0x6c5a36, 0xd9b569, 0xb89956, 0xb99656, 0xb79152, 0xc29850, 0xd5a950, 0xe0b650, 0xe3b94b, 0xe3b94b, 0xe3b848, 0xe4b446, 0xe3b347, 0xddb24c, 0xd8b156, 0xd9b05e, 0xd6b069, 0xcba564, 0xb79660, 0x927549, 0x52350d, 0x492c02, 0x53360c, 0x4e3105, 0x4d3004, 0x4e3107, 0x482c05, 0x452c03, 0x4b3005, 0x472b04, 0x422805, 0x432a02, 0x452902, 0x412704, 0x402806, 0x402708, 0x392405, 0x3d2606, 0x3e2604, 0x3c2505, 0x3d2606, 0x382101, 0x3b2405, 0x382306, 0x311d02, 0x341f04, 0x362104, 0x2d1b03, 0x291c09, 0x2e2006, 0x2f1e0a, 0x2f2009, 0x302205, 0x332309, 0x392a0b, 0x302007, 0x291a05, 0x312309, 0x392907, 0x342305, 0x322107, 0x3e2a09, 0x412907, 0x3f2806, 0x382306, 0x3c2805, 0x412b04, 0x3f2904, 0x3a2506, 0x402907, 0x442a05, 0x422a04, 0x4c3106, 0x513408, 0x432b05, 0x40260b, 0x6f4c14, 0x89641d, 0x967228, 0xa18230, 0xa8863c, 0xab8a3b, 0xbb9b4e, 0xc9ad5a, 0xd1b260, 0xd8b86b, 0xdaba6d, 0xddb96b, 0xd9b569, 0xd3af63, 0xc5a35c, 0xbd9c59, 0xb99a5a, 0xc1a261, 0xc4a765, 0x2e2a21, 0x0f131e, 0x292a2c, 0x2b2b2d, 0x0e0f11, 0x050505, 0x0d0d0d, 0x0e0e0e, 0x0d0d0f, 0x141414, 0x1a1a1c, 0x18181a, 0x19191b, 0x18191b, 0x101113, 0x050706, 0x080808, 0x060606, 0x050505, 0x060606, 0x060606, 0x050505, 0x040404, 0x030303, 0x020202, 0x020202, 0x040404, 0x050505, 0x060606, 0x030303, 0x020202, 0x020202, 0x000000, 0x5f5033, 0xd6b16b, 0xba9757, 0xba9753, 0xb89754, 0xbd9854, 0xc49e53, 0xc7a357, 0xcda95b, 0xd4b45d, 0xdeb75c, 0xe3b55d, 0xe1b761, 0xe0b664, 0xdcb065, 0xcea75c, 0xb6944d, 0x9c7941, 0x806037, 0x583b13, 0x4f2f00, 0x553607, 0x4e3109, 0x533405, 0x503105, 0x4b2e06, 0x4a2d05, 0x4d3008, 0x482f07, 0x432a02, 0x472b04, 0x452b06, 0x432904, 0x432a02, 0x402804, 0x3c2505, 0x3f2705, 0x3f2703, 0x3f2806, 0x3e2602, 0x392502, 0x3d2405, 0x372203, 0x311d04, 0x362104, 0x352003, 0x2c1a02, 0x2f1b02, 0x281b08, 0x291d07, 0x2f1f08, 0x2f1f06, 0x322209, 0x2e1f08, 0x312205, 0x3b2807, 0x311f07, 0x261b07, 0x312107, 0x3d2904, 0x322105, 0x352108, 0x412903, 0x422a06, 0x3e2707, 0x3b2706, 0x3e2803, 0x422a04, 0x3f2806, 0x3d2405, 0x422805, 0x462f06, 0x4a2e07, 0x503103, 0x4f3208, 0x3c2708, 0x56370b, 0x7f5a13, 0x8d671e, 0x9b7628, 0xaa8733, 0xb6923c, 0xb69643, 0xba9b4b, 0xc1a14e, 0xc3a251, 0xbd9c4f, 0xb8924b, 0xb38e47, 0xb59147, 0xb4934e, 0xb79857, 0xba9a5d, 0xc5a666, 0xb79a5e, 0x25211e, 0x151922, 0x262729, 0x131315, 0x050706, 0x0d0d0d, 0x0e0e10, 0x131416, 0x19191b, 0x202123, 0x252628, 0x212226, 0x212226, 0x212226, 0x202123, 0x141416, 0x090909, 0x060606, 0x060606, 0x060606, 0x050505, 0x040404, 0x030303, 0x020202, 0x020202, 0x020202, 0x010101, 0x060606, 0x040404, 0x040404, 0x020202, 0x010101, 0x000000, 0x52482f, 0xd8b36d, 0xba9755, 0xb69552, 0xb89555, 0xbd9750, 0xc19e4d, 0xc6a153, 0xcaa557, 0xd0ac58, 0xd6ad55, 0xd4aa54, 0xc9a551, 0xbf9c4b, 0xb28c45, 0x977535, 0x836028, 0x775728, 0x63431a, 0x543506, 0x573706, 0x563607, 0x533405, 0x513204, 0x513005, 0x4b2e04, 0x4f3208, 0x4d3008, 0x472b04, 0x472b04, 0x482c05, 0x452b06, 0x432b05, 0x432904, 0x3f2703, 0x402804, 0x412702, 0x432b07, 0x3f2806, 0x3c2400, 0x3f2607, 0x372203, 0x332002, 0x392203, 0x341f04, 0x2e1a02, 0x321e03, 0x341f04, 0x302207, 0x291c09, 0x291a03, 0x2f1f06, 0x2e1d09, 0x302104, 0x2f1f05, 0x352204, 0x3d2906, 0x2f1f06, 0x291b01, 0x362305, 0x3f2806, 0x352204, 0x382504, 0x422c05, 0x432b05, 0x3e2803, 0x3e2705, 0x452b06, 0x452c04, 0x3e2602, 0x412704, 0x462d05, 0x472e05, 0x4f3405, 0x523607, 0x493008, 0x462909, 0x6e4710, 0x866017, 0x886217, 0x8f6a1c, 0x9c7623, 0x9e7728, 0x9e782d, 0xa37d34, 0xa68238, 0xa78639, 0xad893f, 0xb18f48, 0xb7924b, 0xb79653, 0xb99758, 0xb9995c, 0xc8a86b, 0xad945e, 0x151515, 0x15181d, 0x151517, 0x080808, 0x080a09, 0x111111, 0x131315, 0x1e1f21, 0x28282a, 0x2b2c2e, 0x37383c, 0x404145, 0x35363a, 0x292a2e, 0x28272c, 0x212123, 0x131114, 0x090909, 0x070707, 0x060606, 0x040404, 0x030303, 0x020202, 0x020202, 0x020202, 0x020202, 0x040404, 0x050505, 0x050505, 0x030303, 0x020202, 0x020202, 0x000000, 0x493e28, 0xd5b270, 0xb79857, 0xb89752, 0xb6914b, 0xb89048, 0xb69045, 0xb28d46, 0xb38e3e, 0xb68d3b, 0xb48a38, 0xaa8334, 0xa27d2f, 0x9b752a, 0x936e2a, 0x88642a, 0x83622c, 0x715223, 0x5a3a0b, 0x5a3b05, 0x583a06, 0x563605, 0x593707, 0x513408, 0x503105, 0x523304, 0x4e3203, 0x482b01, 0x4b2e06, 0x4c3008, 0x462d05, 0x472b04, 0x422a04, 0x402804, 0x422803, 0x452902, 0x442a05, 0x3f2703, 0x3e2602, 0x402907, 0x392202, 0x362104, 0x3a2506, 0x341f02, 0x2f1b02, 0x352003, 0x382004, 0x321e05, 0x2e1e05, 0x302207, 0x2b1c05, 0x291a07, 0x2e1e04, 0x312107, 0x312203, 0x301e06, 0x382504, 0x3c2805, 0x301f03, 0x2a1a01, 0x3a2506, 0x3f2b06, 0x311e00, 0x392502, 0x432c03, 0x442c06, 0x412905, 0x412903, 0x452c03, 0x452c04, 0x432904, 0x452b06, 0x4e3203, 0x4b2f08, 0x533708, 0x553a05, 0x462a05, 0x58350d, 0x7d5812, 0x8a621a, 0x8d6821, 0x957123, 0xa07b2b, 0xa37e2e, 0xa48034, 0xa6843c, 0xa9873d, 0xac8b44, 0xb08e47, 0xb6914b, 0xb59451, 0xb99758, 0xba9a5d, 0xcaaa6d, 0x9f8958, 0x0d0e10, 0x0a0e11, 0x0a0a0c, 0x080808, 0x101211, 0x101012, 0x1e1e20, 0x353638, 0x404143, 0x47484a, 0x4c4c4e, 0x545358, 0x515055, 0x424347, 0x353537, 0x29292b, 0x1b1b1d, 0x0b0b0b, 0x060606, 0x050505, 0x040404, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x010101, 0x050505, 0x060606, 0x040404, 0x020202, 0x020202, 0x010101, 0x3f3323, 0xceac6d, 0xb89959, 0xb69455, 0xb79452, 0xb8934c, 0xb18c46, 0xad8b43, 0xb0893a, 0xb08536, 0xac8334, 0xa67f34, 0xa47c36, 0x9d7631, 0x906e2e, 0x8a662c, 0x79592a, 0x634310, 0x5e3e05, 0x5b3909, 0x583809, 0x593906, 0x573706, 0x503404, 0x543506, 0x563607, 0x4e2f01, 0x4c2f05, 0x4f3004, 0x4c2f05, 0x4b2f07, 0x462a03, 0x452904, 0x432a02, 0x472b04, 0x4a2e09, 0x402804, 0x402802, 0x422a06, 0x392203, 0x392405, 0x3e2604, 0x331e03, 0x2f1e02, 0x392202, 0x382102, 0x342005, 0x382004, 0x2c1b09, 0x2c1c03, 0x312205, 0x2e2005, 0x2b1c07, 0x2d1d04, 0x2f2003, 0x312205, 0x2e2005, 0x3c2503, 0x3f2806, 0x2e1e04, 0x291b00, 0x3d2405, 0x422805, 0x342005, 0x412a01, 0x492d05, 0x462d04, 0x412903, 0x432904, 0x4c3008, 0x462d04, 0x422803, 0x4a2f04, 0x4e3105, 0x553407, 0x5b3a07, 0x553607, 0x493007, 0x6b4812, 0x865e16, 0x89631c, 0x906c1e, 0x9c7625, 0xa07a29, 0xa07c32, 0xa47f39, 0xab853c, 0xac8540, 0xad8b44, 0xb28d49, 0xb39151, 0xb69455, 0xb7975c, 0xccac71, 0x988157, 0x07080c, 0x07080a, 0x070508, 0x0e0e0e, 0x0f1110, 0x131315, 0x36353a, 0x535458, 0x6a6b6d, 0x767678, 0x6c6c6e, 0x646466, 0x5d5d5f, 0x535456, 0x434446, 0x2a2a2c, 0x212123, 0x0f0f0f, 0x070707, 0x050505, 0x040404, 0x030303, 0x030303, 0x020202, 0x020202, 0x020202, 0x020202, 0x040404, 0x060606, 0x040404, 0x040404, 0x030303, 0x000000, 0x332d1f, 0xcba86e, 0xba9b5b, 0xb69454, 0xb79450, 0xb18e4a, 0xae8d4a, 0xb18b40, 0xb28b3e, 0xac8739, 0xa98436, 0xa78035, 0xa07a33, 0x93702e, 0x88682d, 0x805f2a, 0x6d4c19, 0x613e08, 0x603c0a, 0x5f3b07, 0x623d08, 0x573706, 0x513505, 0x593707, 0x563603, 0x4d3004, 0x513108, 0x523305, 0x4d3004, 0x4c2f05, 0x492c04, 0x452904, 0x4a2d05, 0x4b2e06, 0x482c05, 0x432904, 0x432904, 0x412907, 0x3c2505, 0x3d2405, 0x3e2506, 0x341f02, 0x341f00, 0x3a2304, 0x372205, 0x382304, 0x3b2203, 0x3a2304, 0x2e1e04, 0x2e1e05, 0x2e1e04, 0x312002, 0x2e1e04, 0x2b1d03, 0x2f1f05, 0x321e05, 0x332206, 0x352003, 0x3c2505, 0x412a08, 0x301f05, 0x301e06, 0x422a06, 0x3f2902, 0x352504, 0x492d08, 0x4c2f05, 0x4b3005, 0x422b02, 0x4b3005, 0x4b3003, 0x492c04, 0x4a2f04, 0x523307, 0x513203, 0x5d3905, 0x5f3e0b, 0x50350a, 0x59370a, 0x7c5416, 0x89611b, 0x8d651d, 0x967123, 0x9d762b, 0x9e7a30, 0x9f7d33, 0xa7803b, 0xa7853e, 0xab8844, 0xad8b4c, 0xb29051, 0xb49555, 0xb5965f, 0xccae72, 0x927f57, 0x020307, 0x040404, 0x090909, 0x111111, 0x101010, 0x1c1c1e, 0x4d4d4f, 0x676769, 0x7d7d7f, 0x868688, 0x858587, 0x78787a, 0x606062, 0x555658, 0x444547, 0x2e2f31, 0x1f2024, 0x151517, 0x0a0a0c, 0x060606, 0x030303, 0x030303, 0x030303, 0x020202, 0x020202, 0x020202, 0x020202, 0x050505, 0x070707, 0x050505, 0x030303, 0x030303, 0x000000, 0x262219, 0xc1a46a, 0xbc9d5d, 0xb79556, 0xb49350, 0xae8c4c, 0xae8b47, 0xb28b40, 0xae863e, 0xac853a, 0xa78035, 0xa27c35, 0x98732f, 0x8f6b2f, 0x88652d, 0x785420, 0x69450b, 0x65420a, 0x643e0d, 0x633f0b, 0x5b3c06, 0x543604, 0x583805, 0x5c3806, 0x523104, 0x543506, 0x523304, 0x523305, 0x4f3206, 0x492c02, 0x492d05, 0x4a2f02, 0x4d3101, 0x4b2e04, 0x452c04, 0x462d05, 0x422805, 0x3e2604, 0x402a05, 0x3a2303, 0x332002, 0x3b2404, 0x3c2505, 0x3d2405, 0x3d2604, 0x3b2704, 0x3c2304, 0x301c04, 0x2e1c04, 0x2e2006, 0x301f05, 0x2c1c02, 0x312205, 0x2e1d01, 0x2c1c03, 0x322103, 0x302104, 0x372302, 0x352001, 0x3c2803, 0x422a04, 0x352001, 0x331f04, 0x452c04, 0x402804, 0x3e2803, 0x4c2f03, 0x4c2f03, 0x4c3106, 0x462d05, 0x4f3304, 0x503405, 0x4b2e04, 0x503103, 0x563605, 0x563605, 0x63400a, 0x5d3d0a, 0x53360c, 0x6c4712, 0x875f19, 0x89631c, 0x8f6b21, 0x9a7328, 0x9d772e, 0x9c7a32, 0xa27d36, 0xa88241, 0xa98644, 0xab894a, 0xb08e4f, 0xb29255, 0xb5945e, 0xcfaf72, 0x8d7954, 0x000004, 0x010101, 0x0b0b0b, 0x1b1b1d, 0x111113, 0x1f1f21, 0x616264, 0x727274, 0x838385, 0x8d8e90, 0x969799, 0x858587, 0x666668, 0x535456, 0x47484a, 0x333438, 0x212025, 0x161618, 0x0c0c0c, 0x070707, 0x050505, 0x040404, 0x020202, 0x020202, 0x030303, 0x030303, 0x020202, 0x050505, 0x070707, 0x060606, 0x040404, 0x030303, 0x000000, 0x1b1811, 0xba9d65, 0xbfa060, 0xb49555, 0xb39151, 0xac8a4a, 0xaf8c48, 0xaf8942, 0xac863d, 0xaa823a, 0xa47e37, 0x9d7631, 0x956f30, 0x8c682c, 0x7d5a22, 0x6e4b15, 0x6c450c, 0x68430f, 0x674305, 0x623f07, 0x5a3808, 0x5c3804, 0x5d3907, 0x563603, 0x573706, 0x5a380a, 0x533406, 0x543506, 0x4d2e02, 0x4c2f05, 0x4f3002, 0x4f3208, 0x4b3005, 0x482c05, 0x4e2e07, 0x422803, 0x402804, 0x442a05, 0x3a2303, 0x341f04, 0x3d2604, 0x3e2507, 0x3c2505, 0x402804, 0x422803, 0x362104, 0x301c04, 0x3a2200, 0x2f1f06, 0x2f1e00, 0x2b1d00, 0x302006, 0x2e1d03, 0x332208, 0x332002, 0x2d1d04, 0x2f2003, 0x312006, 0x3c2601, 0x382304, 0x3f2904, 0x472f09, 0x341f00, 0x3b2203, 0x4b3005, 0x402a03, 0x432a02, 0x533207, 0x4f3004, 0x4d3205, 0x4c3104, 0x563603, 0x543405, 0x4e3306, 0x593707, 0x5a3906, 0x5e3d08, 0x67420b, 0x5c3c0b, 0x5e3d12, 0x7d5615, 0x87611a, 0x8a651e, 0x956d25, 0x9c742c, 0x997632, 0x9c7935, 0xa5803c, 0xa78442, 0xa98748, 0xae8c4d, 0xaf8f54, 0xb4935d, 0xd0b073, 0x826f4e, 0x000002, 0x040404, 0x0e0e10, 0x1f1f21, 0x141416, 0x252628, 0x68696b, 0x777779, 0x808082, 0x8f9092, 0x9b9c9e, 0x8c8d8f, 0x6d6e70, 0x5e5f61, 0x4c4d51, 0x35363a, 0x1f1e23, 0x161618, 0x0c0c0c, 0x080808, 0x060606, 0x030303, 0x020202, 0x030303, 0x020202, 0x020202, 0x020202, 0x040404, 0x060606, 0x060606, 0x040404, 0x020202, 0x000000, 0x0f0e09, 0xb09462, 0xc2a363, 0xb29456, 0xae8e51, 0xae8c4c, 0xae8c45, 0xac8741, 0xaa843d, 0xa7813a, 0xa17a37, 0x96702f, 0x916b2d, 0x876329, 0x775319, 0x6c480e, 0x6b460f, 0x6e4609, 0x664208, 0x5c3b05, 0x623e04, 0x623d06, 0x593707, 0x593805, 0x5b3a05, 0x553504, 0x573708, 0x513204, 0x4e3203, 0x563607, 0x533408, 0x513003, 0x4a2f02, 0x4b2e02, 0x432702, 0x462a05, 0x482c05, 0x392502, 0x3b2402, 0x402804, 0x402806, 0x3e2803, 0x442801, 0x422505, 0x331f04, 0x352003, 0x3e2604, 0x3a2304, 0x2a1a03, 0x2f1f05, 0x312004, 0x2f1f05, 0x312004, 0x341f02, 0x372406, 0x332204, 0x2f1e02, 0x302104, 0x372205, 0x3e2705, 0x362102, 0x432a02, 0x472e05, 0x382004, 0x412905, 0x513204, 0x432b07, 0x4b2d07, 0x573706, 0x553705, 0x4f3206, 0x553504, 0x593803, 0x513506, 0x543403, 0x5f3a06, 0x5c3c09, 0x65420a, 0x6b440b, 0x5c3d0e, 0x724a16, 0x865f1a, 0x89641d, 0x8e6722, 0x987028, 0x99742e, 0x997737, 0xa27d37, 0xa58242, 0xa98547, 0xac8a4b, 0xae8e55, 0xb2935c, 0xd0b073, 0x786449, 0x010101, 0x060606, 0x111113, 0x222224, 0x18191b, 0x2c2d2f, 0x5d5e60, 0x707072, 0x777779, 0x7a7b7d, 0x7f8082, 0x7e7f81, 0x6d6e70, 0x5b5c60, 0x47484c, 0x323337, 0x1f2024, 0x18181a, 0x0d0d0d, 0x090909, 0x060606, 0x030303, 0x020202, 0x010101, 0x010101, 0x020202, 0x020202, 0x040404, 0x060606, 0x060606, 0x050505, 0x030303, 0x000000, 0x060604, 0xa78c5d, 0xc6a467, 0xb09158, 0xad8d50, 0xb18e4e, 0xaf8a46, 0xab8642, 0xa6813b, 0xa27d39, 0x9b7534, 0x956f31, 0x8b672b, 0x80591e, 0x744d12, 0x70490e, 0x6d490d, 0x6f470a, 0x65400b, 0x664208, 0x674005, 0x5d3a04, 0x5b3c06, 0x5f3a06, 0x583704, 0x573603, 0x543405, 0x553506, 0x573706, 0x553607, 0x533205, 0x503103, 0x4c2f03, 0x452904, 0x492e03, 0x452c03, 0x3b2404, 0x3f2703, 0x442b03, 0x422805, 0x412905, 0x432904, 0x3f2703, 0x331f04, 0x3c2506, 0x422805, 0x341f02, 0x331e01, 0x2f2106, 0x2c1a06, 0x301c03, 0x312002, 0x312006, 0x352204, 0x362303, 0x352202, 0x382304, 0x352201, 0x322105, 0x3a2303, 0x412a01, 0x3f2705, 0x472e05, 0x482f06, 0x3b2404, 0x462a02, 0x513506, 0x452e04, 0x503404, 0x5a3906, 0x583704, 0x543507, 0x5a3a07, 0x5b3a07, 0x563603, 0x5a3906, 0x61400b, 0x65420a, 0x6e470e, 0x68450d, 0x6b4514, 0x7e5619, 0x87601b, 0x896322, 0x956f28, 0x9b752a, 0x997636, 0x9d7a38, 0xa48141, 0xa78345, 0xaa8849, 0xac8d56, 0xb0915a, 0xd1af72, 0x6f5e44, 0x000000, 0x060606, 0x171719, 0x2c2c2e, 0x191a1c, 0x333436, 0x545557, 0x5f5f61, 0x6c6c6e, 0x6f6f71, 0x6f6f71, 0x707072, 0x68696d, 0x525357, 0x3f4044, 0x2a2b2f, 0x1f2024, 0x1a1a1c, 0x0e0e0e, 0x0b0b0b, 0x060606, 0x030303, 0x020202, 0x010101, 0x020202, 0x020202, 0x010101, 0x040404, 0x070707, 0x060606, 0x060606, 0x040404, 0x000000, 0x010101, 0x9b8556, 0xc8a669, 0xae8f58, 0xaf9050, 0xae8b49, 0xac8645, 0xa8833f, 0xa47f3b, 0x9d7736, 0x987234, 0x936c31, 0x876025, 0x795217, 0x764e11, 0x774f11, 0x724a0d, 0x68430c, 0x6b4409, 0x6c4407, 0x623f09, 0x5f3c06, 0x633f05, 0x613e06, 0x593906, 0x583606, 0x563603, 0x5a3904, 0x593707, 0x543405, 0x523304, 0x4e3105, 0x482c05, 0x4a2f02, 0x462d05, 0x3f2904, 0x442b02, 0x482c05, 0x422807, 0x472b03, 0x482a06, 0x392504, 0x3a2506, 0x432c03, 0x3f2703, 0x371f05, 0x372203, 0x3c2304, 0x2b1c05, 0x352204, 0x301c03, 0x2e1a01, 0x352204, 0x322103, 0x362104, 0x362102, 0x382304, 0x3d2606, 0x352202, 0x372203, 0x3f2607, 0x412b04, 0x422803, 0x4c3102, 0x4e3107, 0x3d2702, 0x4d3004, 0x543506, 0x4a2f02, 0x563605, 0x5f3c06, 0x5c3b08, 0x583606, 0x5f3a06, 0x5e3e05, 0x593906, 0x623e0a, 0x694509, 0x6b470d, 0x744c0f, 0x67430f, 0x744d16, 0x875e1c, 0x896322, 0x8e6925, 0x997129, 0x997332, 0x9c7939, 0xa07e3e, 0xa58143, 0xa9874a, 0xab8c55, 0xae905a, 0xd0ad73, 0x695940, 0x000000, 0x060608, 0x1e1e20, 0x303032, 0x18191b, 0x404143, 0x555658, 0x494a4c, 0x555557, 0x5d5d5f, 0x656567, 0x656567, 0x58575c, 0x414246, 0x303135, 0x252628, 0x242527, 0x1b1b1b, 0x0d0d0d, 0x0b0b0b, 0x070707, 0x030303, 0x020202, 0x020202, 0x020202, 0x010101, 0x010101, 0x050505, 0x080808, 0x060606, 0x060606, 0x040404, 0x000000, 0x000002, 0x937e53, 0xc7a568, 0xae8f59, 0xaf9050, 0xac8949, 0xaa8446, 0xa57f3e, 0xa37d3c, 0x9a7435, 0x967032, 0x8e682a, 0x805a1c, 0x7c5417, 0x7b5315, 0x785012, 0x71490c, 0x6e470c, 0x6e480a, 0x684108, 0x643f08, 0x684106, 0x663f06, 0x604007, 0x5a3906, 0x593906, 0x5e3b05, 0x5c3b06, 0x573505, 0x563605, 0x4e3105, 0x4c2f03, 0x4e3306, 0x452c03, 0x412903, 0x4c2f05, 0x4b2e04, 0x442b02, 0x4a2f04, 0x442b03, 0x3d2604, 0x432a02, 0x462a03, 0x3d2405, 0x372205, 0x3e2506, 0x412704, 0x3c2304, 0x2b1903, 0x2c1c03, 0x352106, 0x2e1c04, 0x301c03, 0x362302, 0x382504, 0x382403, 0x392405, 0x3a2304, 0x3d2604, 0x3a2605, 0x392405, 0x3e2604, 0x492d05, 0x452c04, 0x533406, 0x4e3403, 0x412903, 0x563107, 0x563806, 0x4d3101, 0x5e3a08, 0x634006, 0x5f3a05, 0x5e3a06, 0x644006, 0x613e06, 0x613e08, 0x6c450a, 0x6d460d, 0x724a0d, 0x704c12, 0x704b16, 0x815818, 0x88631f, 0x8b6526, 0x976f2a, 0x9a7531, 0x997634, 0x9e7a3c, 0xa48042, 0xa8854b, 0xa98a51, 0xad8f59, 0xcfac74, 0x67593f, 0x000000, 0x09090b, 0x262628, 0x2e2e30, 0x1d1d1f, 0x545557, 0x5c5d5f, 0x424345, 0x3b3b3d, 0x38393b, 0x3c3c3e, 0x3c3c3e, 0x313035, 0x28292b, 0x242527, 0x232426, 0x202123, 0x171717, 0x0c0c0c, 0x0a0a0a, 0x070707, 0x030303, 0x020202, 0x020202, 0x010101, 0x020202, 0x030303, 0x060606, 0x090909, 0x060606, 0x070707, 0x050505, 0x010101, 0x000002, 0x8a774f, 0xc8a669, 0xb0915a, 0xaf8d50, 0xaa8848, 0xa98345, 0xa37d3e, 0x9d7739, 0x987234, 0x936d2f, 0x896124, 0x7f5719, 0x7e5716, 0x7b5315, 0x754d0f, 0x744c0e, 0x734b0d, 0x6b4409, 0x674307, 0x6c4407, 0x6a4205, 0x664206, 0x5f3c06, 0x603d07, 0x633f05, 0x5d3c07, 0x593805, 0x5a3904, 0x523304, 0x523305, 0x4f3206, 0x482c05, 0x492c02, 0x503105, 0x4a2e06, 0x4c2f05, 0x4e2f03, 0x412704, 0x422805, 0x472e05, 0x452b06, 0x3d2406, 0x3e2506, 0x422805, 0x3f2705, 0x3e2604, 0x3c2304, 0x362209, 0x2d1d06, 0x2a1a03, 0x332204, 0x342103, 0x331f06, 0x362303, 0x3a2603, 0x3d2604, 0x3a2605, 0x3f2705, 0x422b02, 0x3d2700, 0x3f2705, 0x402806, 0x493105, 0x4c2f05, 0x563502, 0x573507, 0x462d05, 0x573706, 0x593707, 0x533304, 0x633f05, 0x684203, 0x623d06, 0x654009, 0x664206, 0x663f06, 0x68410a, 0x70490e, 0x724c0d, 0x76500f, 0x704b16, 0x7b5318, 0x886120, 0x896324, 0x916a27, 0x99722f, 0x9b7534, 0x9d793b, 0xa37f41, 0xa7844a, 0xa88950, 0xac8c59, 0xcfaa73, 0x695b41, 0x000000, 0x0a0b0f, 0x2b2a2f, 0x2e2d32, 0x1f1f21, 0x5f6062, 0x626365, 0x454648, 0x2b2c2e, 0x262729, 0x232426, 0x212224, 0x1f1e23, 0x202022, 0x202022, 0x1b1b1d, 0x131315, 0x101010, 0x0d0d0d, 0x080808, 0x050505, 0x050505, 0x020202, 0x020202, 0x020202, 0x020202, 0x030303, 0x060606, 0x080808, 0x050505, 0x060606, 0x050505, 0x010101, 0x000000, 0x82704c, 0xc8a86d, 0xaf9059, 0xad8b4e, 0xa78546, 0xa58143, 0xa17b3d, 0x9a7338, 0x977035, 0x8f672a, 0x865e20, 0x825b1a, 0x805918, 0x7b5315, 0x774f12, 0x774f11, 0x71490b, 0x6f4709, 0x6f4709, 0x6d4507, 0x684106, 0x623d06, 0x663f08, 0x684204, 0x623d06, 0x5f3b07, 0x5b3b08, 0x563603, 0x563804, 0x523606, 0x4c2d01, 0x4e3105, 0x543506, 0x513204, 0x513206, 0x4d3006, 0x432a02, 0x482c05, 0x4a2f04, 0x422803, 0x3e2403, 0x3f2904, 0x452b08, 0x432904, 0x3e2602, 0x3a2005, 0x362106, 0x301e0a, 0x392405, 0x352202, 0x2d1d04, 0x331f04, 0x392405, 0x341e06, 0x372403, 0x3c2505, 0x3f2705, 0x412905, 0x412905, 0x432b05, 0x422a06, 0x402802, 0x452c04, 0x503103, 0x4d3004, 0x5c3b06, 0x583807, 0x4a2d01, 0x5c3b08, 0x5c3804, 0x593707, 0x684106, 0x684106, 0x674005, 0x6c4407, 0x6e4609, 0x664206, 0x6f480d, 0x774e10, 0x774f11, 0x7a5415, 0x775015, 0x845c1f, 0x8b6222, 0x8e6628, 0x96702f, 0x9c7436, 0x9a7839, 0xa17d41, 0xa68349, 0xa78851, 0xad8c59, 0xccac71, 0x716245, 0x000000, 0x0d0e10, 0x29292b, 0x232124, 0x1d1c21, 0x65696c, 0x5c6164, 0x474b4c, 0x353537, 0x232428, 0x202123, 0x202123, 0x1f1f21, 0x1c1c1e, 0x161618, 0x151517, 0x101211, 0x0c0c0e, 0x0c0c0c, 0x060606, 0x050505, 0x040404, 0x020202, 0x020202, 0x020202, 0x010100, 0x050505, 0x0e0e0e, 0x0a0a0a, 0x040404, 0x060606, 0x050505, 0x010103, 0x000100, 0x866f4d, 0xcba86e, 0xae8f58, 0xab8850, 0xa78548, 0xa28043, 0x9c783e, 0x9a7338, 0x936d2f, 0x8a6224, 0x87601f, 0x855d1f, 0x7d5517, 0x7c5313, 0x7c5311, 0x764f0e, 0x754c0c, 0x744b0b, 0x704908, 0x6b4305, 0x674005, 0x6b4308, 0x6c4406, 0x684106, 0x644006, 0x5e3a06, 0x5a3906, 0x5a3a07, 0x543405, 0x4f2f06, 0x553607, 0x533405, 0x533205, 0x553407, 0x4b2e04, 0x492e03, 0x4e3105, 0x4a2d05, 0x432a02, 0x462a03, 0x472b04, 0x482c05, 0x432904, 0x3e2604, 0x3c2305, 0x3a2005, 0x3a2103, 0x241808, 0x2b1c05, 0x3d2607, 0x3a2206, 0x302104, 0x301f03, 0x3d2604, 0x3a2206, 0x392405, 0x3f2904, 0x412903, 0x452c04, 0x462e02, 0x492e03, 0x482c05, 0x442b03, 0x492e03, 0x523607, 0x543507, 0x613c05, 0x5e3a08, 0x503405, 0x603d05, 0x5b3a07, 0x623d06, 0x6c4406, 0x6c4407, 0x6a4405, 0x6f470a, 0x6f470a, 0x6a460a, 0x784f11, 0x7a5214, 0x7a5312, 0x7c5618, 0x81591c, 0x8a6322, 0x8b6325, 0x946c2e, 0x9b7433, 0x987637, 0x9f7b41, 0xa5824a, 0xa88751, 0xac8b58, 0xc8a86f, 0x726346, 0x000002, 0x101113, 0x262628, 0x121214, 0x222126, 0x5e6265, 0x474b4e, 0x595a5c, 0x474749, 0x25262a, 0x232428, 0x232428, 0x232227, 0x19181d, 0x111015, 0x1a1a1c, 0x101012, 0x090909, 0x070707, 0x050505, 0x060606, 0x030303, 0x040404, 0x010101, 0x030303, 0x000000, 0x040404, 0x111111, 0x0a0a0a, 0x040404, 0x070707, 0x070707, 0x010103, 0x000000, 0x8a744f, 0xcaa76d, 0xac8d56, 0xab8850, 0xa68349, 0x9e7a40, 0x9d763b, 0x997134, 0x91692b, 0x8d6625, 0x886120, 0x835c1b, 0x825919, 0x7f5614, 0x7b5210, 0x784f0d, 0x784c0b, 0x744b0b, 0x71490b, 0x6d4508, 0x6f4608, 0x6f4608, 0x694305, 0x663f08, 0x613c07, 0x603d05, 0x5c3b06, 0x533205, 0x563603, 0x5c3b05, 0x583606, 0x583807, 0x533406, 0x4a2d03, 0x4d3207, 0x4d3205, 0x492d05, 0x472b04, 0x4a2c06, 0x4c2f05, 0x4a2d05, 0x432904, 0x3e2506, 0x3b2405, 0x3b2404, 0x3b2301, 0x3d2405, 0x35230b, 0x2a1d0a, 0x251909, 0x362305, 0x422a06, 0x352204, 0x322103, 0x422805, 0x3a2603, 0x3d2700, 0x442b03, 0x472b04, 0x4a2f04, 0x4c3106, 0x4d3008, 0x4b3001, 0x482f06, 0x4b3005, 0x573505, 0x593707, 0x654105, 0x5d3a02, 0x563708, 0x634006, 0x603d05, 0x694207, 0x704803, 0x6e4608, 0x6d4508, 0x73490d, 0x734b0d, 0x744c0e, 0x7c5313, 0x7e5515, 0x7f5719, 0x81591c, 0x8a6320, 0x8f6626, 0x91692c, 0x9b7433, 0x9a7638, 0x9d793f, 0xa38048, 0xa88751, 0xac8b56, 0xc7a76e, 0x746548, 0x000002, 0x111113, 0x1f1f21, 0x070709, 0x323337, 0x3c3d41, 0x212224, 0x4f5052, 0x565759, 0x36373b, 0x25262a, 0x242529, 0x26272b, 0x1e1f23, 0x212025, 0x272729, 0x0d0d0d, 0x070705, 0x070705, 0x050505, 0x030303, 0x030303, 0x020202, 0x040404, 0x000000, 0x060608, 0x232325, 0x121214, 0x010101, 0x060606, 0x060606, 0x060606, 0x020403, 0x000000, 0x8d7750, 0xc8a56b, 0xab8c56, 0xa7874e, 0xa38048, 0x9f7a43, 0x9d7739, 0x976f31, 0x90682a, 0x8e6726, 0x896020, 0x855c1a, 0x845b19, 0x825615, 0x7e5211, 0x7f540f, 0x7a4e0d, 0x744b0b, 0x714808, 0x734a0a, 0x704707, 0x6c4406, 0x6a4406, 0x643f08, 0x623e04, 0x603d07, 0x593805, 0x5e3a06, 0x5f3c06, 0x5b3a05, 0x5e3a06, 0x543506, 0x513301, 0x563508, 0x503103, 0x472b03, 0x4a2e07, 0x4e3203, 0x502f02, 0x4b2f07, 0x432a02, 0x3f2703, 0x3f2705, 0x3e2604, 0x422807, 0x412809, 0x3d2405, 0x422d10, 0x3e2b0d, 0x2f200b, 0x251903, 0x2f1e04, 0x442c06, 0x3f2902, 0x372203, 0x402804, 0x432b09, 0x3d2702, 0x462f05, 0x4e2f03, 0x4e2f01, 0x4f3304, 0x513206, 0x503405, 0x4b3005, 0x523106, 0x5a3b05, 0x5c3b06, 0x694207, 0x663f04, 0x5d3c06, 0x664208, 0x663d05, 0x6e4608, 0x734a08, 0x71480a, 0x754c0a, 0x794d0c, 0x744c0f, 0x7b5210, 0x835716, 0x815816, 0x835b1d, 0x886120, 0x916828, 0x90682b, 0x967031, 0x9d7738, 0x9c783e, 0xa08047, 0xa6854f, 0xaa8b54, 0xc6a66d, 0x746546, 0x000000, 0x0e0d12, 0x1d1e20, 0x121315, 0x3e3f43, 0x212025, 0x141416, 0x272729, 0x505153, 0x4e4f51, 0x353638, 0x222325, 0x18191d, 0x232428, 0x323335, 0x2b2b2d, 0x080808, 0x080808, 0x070707, 0x040404, 0x020202, 0x020202, 0x010101, 0x000000, 0x060606, 0x1a1b1f, 0x2e2d32, 0x1b1b1d, 0x010101, 0x050505, 0x060606, 0x060606, 0x020403, 0x000000, 0x89734c, 0xc6a36b, 0xa98b55, 0xa5844e, 0xa17e48, 0x9f7b41, 0x997334, 0x966e30, 0x926a2c, 0x8e6527, 0x896020, 0x895d1c, 0x865b17, 0x815612, 0x805413, 0x7d520d, 0x7a4e0d, 0x77490b, 0x774a09, 0x734a08, 0x6f4807, 0x6a4205, 0x6b4306, 0x664204, 0x603d07, 0x603b04, 0x674005, 0x623d06, 0x613c08, 0x5e3b05, 0x573704, 0x553506, 0x563804, 0x513204, 0x4e2f03, 0x533304, 0x533304, 0x503405, 0x492e01, 0x442d04, 0x412704, 0x422805, 0x462d05, 0x462d05, 0x412704, 0x3c2305, 0x3a2206, 0x35250e, 0x402c13, 0x442d0b, 0x39250a, 0x281c04, 0x2c1c03, 0x402909, 0x442c06, 0x3e2506, 0x432906, 0x4a2e07, 0x442b03, 0x462d04, 0x4e3203, 0x533302, 0x553705, 0x543405, 0x533503, 0x513506, 0x553407, 0x5c3b06, 0x613e06, 0x6d4404, 0x684108, 0x623e04, 0x6c4206, 0x694106, 0x734a08, 0x794c09, 0x754c0a, 0x78500b, 0x7b4f0e, 0x79500e, 0x835716, 0x875c18, 0x845d1c, 0x886023, 0x906725, 0x936c2b, 0x956f31, 0x9d7537, 0x9d793d, 0xa07d45, 0xa5844e, 0xa98a53, 0xc5a56c, 0x786847, 0x010101, 0x141318, 0x030406, 0x3e3f41, 0x909193, 0x2e2e30, 0x111113, 0x0d0d0f, 0x313234, 0x55565a, 0x3c3d41, 0x232428, 0x0e0f13, 0x202125, 0x47484a, 0x3a3a3c, 0x060606, 0x0b0b0d, 0x060606, 0x030303, 0x010100, 0x000000, 0x000000, 0x09090b, 0x19191b, 0x25262a, 0x222126, 0x171719, 0x0a0a0a, 0x050505, 0x040404, 0x070707, 0x030504, 0x000002, 0x846e49, 0xc8a56d, 0xa88a54, 0xa3824c, 0xa07d47, 0x9d793b, 0x9a7435, 0x976f31, 0x926a2c, 0x8e6527, 0x8b6222, 0x8a5f1b, 0x865b17, 0x855815, 0x835615, 0x7b5210, 0x7b4e0a, 0x7f500a, 0x794e0a, 0x734a08, 0x6e4505, 0x6f4608, 0x6d4508, 0x643f08, 0x663f04, 0x6a4308, 0x663f04, 0x674005, 0x633e07, 0x5b3a05, 0x5a3904, 0x593805, 0x513506, 0x4f3504, 0x553705, 0x573708, 0x503405, 0x452c03, 0x452b08, 0x422805, 0x492d05, 0x4a2f04, 0x452b06, 0x402708, 0x3d2405, 0x3f2504, 0x472b06, 0x362511, 0x33240d, 0x3b2a0c, 0x462d0e, 0x462d0e, 0x312205, 0x2c1c03, 0x3f2705, 0x4b2e04, 0x402907, 0x422a04, 0x4c2f05, 0x4b2e06, 0x4d3207, 0x523304, 0x573706, 0x5a3906, 0x583606, 0x573704, 0x533503, 0x5b3707, 0x613e04, 0x634008, 0x744608, 0x6a4205, 0x683f07, 0x6e4507, 0x6e4505, 0x7a4d09, 0x7b4e0b, 0x79510c, 0x82530f, 0x7e530f, 0x825615, 0x8a5f1a, 0x8a5e1d, 0x896022, 0x8e6726, 0x956e2b, 0x967032, 0x9c7638, 0x9f7b3f, 0x9f7c44, 0xa4834e, 0xaa8b54, 0xc6a36b, 0x806d4d, 0x010005, 0x0e0d12, 0x18181a, 0x2b2d2c, 0x49494b, 0x5b5b5d, 0x343436, 0x070709, 0x101113, 0x3a3b3f, 0x38393d, 0x2d2e32, 0x27282c, 0x2d2e32, 0x606165, 0x3e3e40, 0x020204, 0x141318, 0x0e0e10, 0x070707, 0x000000, 0x020202, 0x18181a, 0x2b2b2d, 0x2f2e33, 0x202022, 0x0d0d0f, 0x08080a, 0x0d0d0d, 0x080808, 0x060606, 0x050505, 0x010302, 0x000002, 0x88724d, 0xc5a26a, 0xa58751, 0xa4834d, 0xa27f47, 0x9e7b3b, 0x9d7538, 0x976f31, 0x916a29, 0x8f6626, 0x8f6322, 0x8b5e1b, 0x895c19, 0x865916, 0x815411, 0x7f530c, 0x805310, 0x7d500f, 0x794d0c, 0x754a05, 0x764b06, 0x6f4606, 0x694008, 0x6d4309, 0x6d4605, 0x6b4506, 0x6a4308, 0x613f02, 0x603d03, 0x613c08, 0x5a3906, 0x583608, 0x583704, 0x593a03, 0x573907, 0x503307, 0x492d05, 0x482c05, 0x4d3102, 0x503309, 0x4b2f07, 0x432b05, 0x3f2806, 0x422805, 0x4a2c08, 0x512d09, 0x532d08, 0x473312, 0x3d290e, 0x34240d, 0x362509, 0x422b0b, 0x493008, 0x402907, 0x312006, 0x362303, 0x4c2f05, 0x4c2f03, 0x462d04, 0x4e3105, 0x4f3206, 0x503309, 0x543405, 0x593707, 0x613e08, 0x5f3c06, 0x5b3a05, 0x5b3a04, 0x5d3907, 0x663f06, 0x6e4507, 0x754a06, 0x6e4609, 0x6d4307, 0x724909, 0x754908, 0x7e5207, 0x7e510e, 0x825210, 0x835612, 0x855815, 0x895c19, 0x8d601c, 0x8b5f1e, 0x8d6625, 0x956e2b, 0x9a7234, 0x9d7739, 0xa27c3e, 0xa17d43, 0xa3824f, 0xa98a53, 0xc6a16a, 0x877352, 0x000105, 0x111113, 0x292929, 0x030303, 0x000000, 0x080808, 0x363636, 0x373739, 0x0d0d0f, 0x0d0e12, 0x2d2e32, 0x3a3b3f, 0x4d4e52, 0x323337, 0x67686c, 0x434345, 0x000000, 0x242426, 0x202022, 0x000002, 0x0a0b0d, 0x2f3032, 0x434345, 0x38383a, 0x18181a, 0x030303, 0x010101, 0x010101, 0x010101, 0x050505, 0x050505, 0x050505, 0x000002, 0x000002, 0x917b52, 0xc29f67, 0xa78852, 0xa6834d, 0xa17e44, 0xa07a39, 0x9c7437, 0x976f31, 0x946b2b, 0x916924, 0x906521, 0x8d601c, 0x8c5d19, 0x885915, 0x845511, 0x865510, 0x80530f, 0x7a4f0a, 0x774c07, 0x774c08, 0x724607, 0x6e4505, 0x744807, 0x734706, 0x6e4505, 0x6b4306, 0x664204, 0x654105, 0x623d06, 0x5e3b05, 0x603a09, 0x603b07, 0x5f3b07, 0x593a04, 0x513505, 0x4e3105, 0x4f2e01, 0x533405, 0x503605, 0x4a2d01, 0x472b04, 0x452c04, 0x4b2e06, 0x533008, 0x562f08, 0x583108, 0x5f380d, 0x503910, 0x4e3610, 0x462f0d, 0x37260a, 0x32220b, 0x3f2a0d, 0x4c3408, 0x482f07, 0x382505, 0x392407, 0x4a2e07, 0x533304, 0x4b2e06, 0x4f3407, 0x573905, 0x553504, 0x593805, 0x613c05, 0x644006, 0x623d06, 0x623d06, 0x613c07, 0x613c07, 0x6a4406, 0x6d4404, 0x7c4d07, 0x714806, 0x714a09, 0x784d09, 0x7b4e0d, 0x83540e, 0x84550f, 0x845713, 0x875a17, 0x885b1a, 0x91621c, 0x916420, 0x8d6527, 0x936c2b, 0x9d7432, 0x9d7738, 0xa27c3d, 0xa58145, 0xa3824f, 0xa98a53, 0xc7a067, 0x8b7452, 0x000105, 0x131416, 0x0c0c0c, 0x000000, 0x010101, 0x000000, 0x000100, 0x1e1e1e, 0x2a2a2c, 0x131315, 0x0c0d0f, 0x27282a, 0x595a5e, 0x141318, 0x515153, 0x5d5d5d, 0x000000, 0x303030, 0x1c1c1c, 0x08090b, 0x424347, 0x48494d, 0x292a2c, 0x090909, 0x000000, 0x030301, 0x040404, 0x010101, 0x000000, 0x010101, 0x040404, 0x050505, 0x010103, 0x020204, 0x978056, 0xc09c62, 0xa88855, 0xa5824a, 0xa48044, 0xa07a3b, 0x9b7338, 0x987130, 0x976e2c, 0x946924, 0x916420, 0x8f601c, 0x8d5e1a, 0x8a5b15, 0x8a5b15, 0x855610, 0x83530b, 0x7f500a, 0x784d09, 0x724909, 0x754908, 0x784b0a, 0x764b07, 0x744807, 0x6e4507, 0x6a4205, 0x6b4308, 0x663f08, 0x643d06, 0x644006, 0x634006, 0x613e04, 0x5c3b06, 0x533408, 0x543507, 0x573905, 0x573708, 0x503405, 0x493008, 0x452e05, 0x503009, 0x583108, 0x5c3107, 0x5f350b, 0x603b0e, 0x613f11, 0x644415, 0x5c4513, 0x573f11, 0x563b10, 0x543810, 0x462f0d, 0x35240a, 0x3b260b, 0x483108, 0x533708, 0x462f05, 0x3d2607, 0x472b06, 0x563709, 0x533406, 0x553504, 0x5e3905, 0x5a3a07, 0x5d3a04, 0x633f03, 0x6a4207, 0x6b4308, 0x663f04, 0x653e03, 0x674307, 0x6f4608, 0x744706, 0x7c5009, 0x774c08, 0x774b0a, 0x7d4d0b, 0x82530d, 0x86580d, 0x885810, 0x8b5a15, 0x8d5e1a, 0x8f621e, 0x936622, 0x936824, 0x946b29, 0x997332, 0xa0783a, 0xa47c3e, 0xa88148, 0xa4844b, 0xab8755, 0xc6a369, 0x89734c, 0x000309, 0x08090b, 0x000000, 0x020100, 0x040406, 0x050507, 0x030504, 0x000000, 0x000000, 0x131315, 0x100f14, 0x111216, 0x262a2d, 0x000000, 0x3e3e3e, 0x5d5f5e, 0x000000, 0x444446, 0x373739, 0x39393b, 0x3a3a3c, 0x161618, 0x000000, 0x000000, 0x040404, 0x040404, 0x020202, 0x010101, 0x010101, 0x010101, 0x020202, 0x050505, 0x000000, 0x070705, 0x9b845a, 0xbf9c64, 0xa98a54, 0xa78548, 0xa27e42, 0xa17b3d, 0x9c7534, 0x9b7433, 0x966e29, 0x936823, 0x926521, 0x91621e, 0x905f1a, 0x8e5e16, 0x89590f, 0x86560c, 0x84540c, 0x7f500c, 0x794c09, 0x7b4e0a, 0x7c5009, 0x794c08, 0x774a07, 0x724909, 0x6f4805, 0x6c4607, 0x694209, 0x6b440b, 0x6b4305, 0x6c4407, 0x663f08, 0x593805, 0x573905, 0x5d3c07, 0x5f3b07, 0x573706, 0x513505, 0x4d3205, 0x513408, 0x5a3509, 0x5c3307, 0x62350b, 0x683c0f, 0x684211, 0x6c4814, 0x6e4d18, 0x704d17, 0x604917, 0x644914, 0x674913, 0x5c4511, 0x5b4110, 0x56390f, 0x422b09, 0x3c240c, 0x462c09, 0x593a0c, 0x563806, 0x452c04, 0x472e06, 0x563806, 0x583805, 0x563508, 0x613c07, 0x5d3c07, 0x613c08, 0x664208, 0x6d4605, 0x6f4606, 0x6d4508, 0x6c4206, 0x6a4308, 0x724907, 0x7a4b07, 0x815109, 0x7e4f07, 0x7d500c, 0x82530b, 0x87570f, 0x8a5a10, 0x8e5e16, 0x91601b, 0x91621c, 0x936622, 0x966b27, 0x946b29, 0x997231, 0xa1793b, 0xa57d3f, 0xa68248, 0xa7874e, 0xaa8956, 0xc6a36b, 0x91784f, 0x010206, 0x09090b, 0x080806, 0x070705, 0x010101, 0x040406, 0x020202, 0x282828, 0x575958, 0x000201, 0x000100, 0x0d1112, 0x0f1314, 0x000002, 0x171717, 0x303030, 0x010103, 0x272729, 0x333333, 0x161616, 0x020202, 0x000000, 0x000000, 0x030303, 0x000000, 0x000000, 0x010101, 0x000000, 0x020202, 0x020202, 0x010101, 0x040404, 0x000000, 0x090907, 0xa2875c, 0xbd9a62, 0xaa8953, 0xa7844c, 0xa27f45, 0xa07a3c, 0x9f7638, 0x9b7232, 0x996e2a, 0x966925, 0x966721, 0x93641c, 0x916119, 0x8d5d13, 0x8a5a12, 0x885712, 0x83520d, 0x805006, 0x825409, 0x805109, 0x7b4c08, 0x7b4e0b, 0x784b07, 0x744807, 0x724607, 0x714508, 0x734708, 0x6f4606, 0x6b4507, 0x644006, 0x603d05, 0x613c07, 0x623f05, 0x604007, 0x593906, 0x523807, 0x523708, 0x5d370a, 0x60350a, 0x673908, 0x6a3e0d, 0x6c4410, 0x714d13, 0x775317, 0x775518, 0x765319, 0x74541b, 0x694e17, 0x6c4f15, 0x6d4f13, 0x6f5017, 0x6c4d16, 0x684b13, 0x604412, 0x53370f, 0x402b0c, 0x3f2a0b, 0x53360e, 0x623e0e, 0x503309, 0x4a3206, 0x553703, 0x5b3909, 0x5d3905, 0x654107, 0x654107, 0x644006, 0x6c4409, 0x744809, 0x764905, 0x734706, 0x6e4608, 0x71480a, 0x764906, 0x805008, 0x855509, 0x84560b, 0x82530b, 0x88560f, 0x8c5c10, 0x906016, 0x936319, 0x94651d, 0x966721, 0x9a6d29, 0x996d2c, 0x9a7131, 0xa0783a, 0xa57d3f, 0xa78347, 0xa98950, 0xaa8b55, 0xbc9c63, 0xaa8e5f, 0x131210, 0x14171c, 0x1f2022, 0x0b0b09, 0x060606, 0x000000, 0x010101, 0x32312f, 0xb2acac, 0x61605c, 0x1a1917, 0x010101, 0x000100, 0x060405, 0x000000, 0x000000, 0x040406, 0x000000, 0x000000, 0x000000, 0x000000, 0x010101, 0x010101, 0x000000, 0x010101, 0x010101, 0x010101, 0x000000, 0x010101, 0x010101, 0x000000, 0x030303, 0x000000, 0x171611, 0xb39466, 0xb99660, 0xab8852, 0xa7844c, 0xa37f43, 0xa37b3d, 0x9f7638, 0x9c702f, 0x9b6e2b, 0x9a6b25, 0x976820, 0x96661a, 0x936317, 0x8f5f15, 0x8b5b13, 0x885712, 0x84540a, 0x88570a, 0x855408, 0x815107, 0x805008, 0x794d06, 0x774a07, 0x754a06, 0x734a08, 0x764a09, 0x724907, 0x6b4506, 0x674307, 0x674309, 0x6d460b, 0x69450b, 0x60410a, 0x593e09, 0x5c3b08, 0x663e0d, 0x693a0c, 0x6d3b0a, 0x6f400c, 0x724710, 0x7a5014, 0x7f5817, 0x7f5a16, 0x7e5819, 0x7b571b, 0x77571c, 0x76581c, 0x745419, 0x70561b, 0x71571a, 0x795718, 0x795717, 0x765716, 0x765414, 0x705013, 0x634511, 0x51350e, 0x462f0d, 0x4d340c, 0x61400b, 0x5e3f09, 0x4f3409, 0x563708, 0x5f4009, 0x623e0c, 0x674309, 0x6b4305, 0x6b4308, 0x6f4709, 0x764b07, 0x7a4d09, 0x7a4b05, 0x724605, 0x754908, 0x7c4f0b, 0x835309, 0x8a590c, 0x8a580f, 0x8a580f, 0x8c5c10, 0x916014, 0x95631a, 0x98681e, 0x9a6a22, 0x9e6f29, 0x9f722f, 0x9e7231, 0xa0783a, 0xa57d3f, 0xa98547, 0xad8a52, 0xae8f59, 0xb5945f, 0xc4a370, 0x29251c, 0x0a0e17, 0x2d2e33, 0x0e0e10, 0x0c0c0c, 0x060807, 0x020403, 0x0e0a09, 0x2f2725, 0x645454, 0x433535, 0x0a0404, 0x010101, 0x000000, 0x010101, 0x000000, 0x030102, 0x000000, 0x000000, 0x010101, 0x010101, 0x010101, 0x010101, 0x020202, 0x000000, 0x010101, 0x000000, 0x010101, 0x010101, 0x010101, 0x010101, 0x030303, 0x000000, 0x342e22, 0xc5a471, 0xaf915b, 0xaa8953, 0xa8854b, 0xa88043, 0xa47d3c, 0x9e7736, 0xa07330, 0xa0712d, 0x9e6e26, 0x9a6a20, 0x97671b, 0x956417, 0x905f13, 0x8d5b12, 0x8d5c0f, 0x8d5c10, 0x88570b, 0x87560a, 0x85530a, 0x805008, 0x7d4e08, 0x784c05, 0x7a4d09, 0x7d4e08, 0x774c08, 0x6f470a, 0x6c4608, 0x724b08, 0x724b0a, 0x6a460a, 0x5f420a, 0x61420b, 0x68430c, 0x70400f, 0x753d0c, 0x77420c, 0x794b0d, 0x825713, 0x855d17, 0x865d1b, 0x845d1c, 0x835d1e, 0x805d1b, 0x825f1d, 0x825f1f, 0x7d591b, 0x775d22, 0x7b5f20, 0x7a5d1b, 0x7b5e1a, 0x83611a, 0x87621b, 0x84621a, 0x856019, 0x825c15, 0x775317, 0x674613, 0x523513, 0x4a3210, 0x5e3e0f, 0x694410, 0x5d3f0b, 0x5b390c, 0x5f400a, 0x6a430a, 0x6e440a, 0x72490b, 0x70480a, 0x6f4807, 0x7d4e08, 0x82520a, 0x805008, 0x7c4f0c, 0x794c08, 0x83540c, 0x88570b, 0x905d0e, 0x8d5c0f, 0x8d5c10, 0x936216, 0x98671b, 0x99691d, 0x9d6d23, 0xa07028, 0xa2732d, 0xa17632, 0xa17a39, 0xa67e40, 0xab8547, 0xb08b54, 0xb0915b, 0xb39360, 0xcfae78, 0x3e3524, 0x010008, 0x323137, 0x1f1f21, 0x070707, 0x0c0e0d, 0x121212, 0x080808, 0x090806, 0x080904, 0x20201e, 0x292929, 0x191b1a, 0x0e0e10, 0x0a0a0a, 0x050706, 0x000100, 0x010101, 0x000000, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x000000, 0x020202, 0x010101, 0x010101, 0x010101, 0x050505, 0x000000, 0x4e4232, 0xcead77, 0xad8f59, 0xab8a54, 0xaa864c, 0xa98144, 0xa57c3c, 0xa27a35, 0xa37632, 0xa1722c, 0xa07026, 0x9d6d23, 0x9a691d, 0x986418, 0x956115, 0x956115, 0x935e0e, 0x905d0e, 0x8c5b0e, 0x87560a, 0x845209, 0x835309, 0x835309, 0x84540a, 0x815308, 0x7a4f0a, 0x734b06, 0x774f0a, 0x794e0a, 0x754c0e, 0x6a460a, 0x634507, 0x6a450e, 0x71440b, 0x7f440c, 0x83480e, 0x805010, 0x895c18, 0x8e641c, 0x91651c, 0x8c641c, 0x8c641e, 0x8a641d, 0x8b651e, 0x8a651e, 0x88631c, 0x84611d, 0x815f1f, 0x766225, 0x7e6320, 0x866520, 0x886720, 0x89691e, 0x8f6b1f, 0x916b20, 0x956e1f, 0x946a1e, 0x8a691a, 0x84621a, 0x7c5919, 0x624314, 0x4b3412, 0x543810, 0x70470f, 0x6a4711, 0x643f0b, 0x694209, 0x6c450a, 0x70480a, 0x784c0b, 0x794c0b, 0x794c08, 0x81520a, 0x88570b, 0x855408, 0x825208, 0x83530b, 0x88570b, 0x8f5c0d, 0x956213, 0x966216, 0x976317, 0x9c681c, 0x9d6c1f, 0xa17023, 0xa37226, 0xa5752d, 0xa67a33, 0xa47b39, 0xa88140, 0xac8648, 0xb18c55, 0xb3925d, 0xb59562, 0xd6b57f, 0x5d4f34, 0x000002, 0x343436, 0x242426, 0x0c0c0c, 0x070908, 0x111312, 0x151515, 0x212121, 0x2b292a, 0x262427, 0x1f2022, 0x262a2b, 0x37383c, 0x323335, 0x252628, 0x070506, 0x000000, 0x010101, 0x000000, 0x010101, 0x010101, 0x010101, 0x010101, 0x000000, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x020202, 0x050505, 0x000000, 0x685841, 0xd0af79, 0xaf9059, 0xae8a56, 0xaa864c, 0xa88045, 0xaa7e3f, 0xa97c38, 0xa87933, 0xa5752b, 0xa37226, 0xa06f23, 0x9e6a1f, 0x9c671b, 0x9b6616, 0x9a6515, 0x986111, 0x925d0d, 0x8d5a0b, 0x88570a, 0x88570a, 0x89580b, 0x88570b, 0x84520b, 0x7c510d, 0x7e510d, 0x83520f, 0x7f520f, 0x704d0b, 0x694a0a, 0x724a0d, 0x7e4a0e, 0x844a0b, 0x8d4b0f, 0x8c5713, 0x8f6318, 0x986a1c, 0x986a1d, 0x986c21, 0x996b1e, 0x946d1e, 0x956e21, 0x956b1f, 0x956b21, 0x916b20, 0x8b661f, 0x836121, 0x7f5f22, 0x806727, 0x85692a, 0x856824, 0x8d6b21, 0x927120, 0x967321, 0x9c7623, 0x9b7721, 0x9d7724, 0xa77923, 0xa77820, 0xa0701e, 0x9a661b, 0x825419, 0x5e3d14, 0x523813, 0x664417, 0x744e0d, 0x6f480f, 0x6e470c, 0x71490b, 0x76490e, 0x7f500a, 0x7e540c, 0x805109, 0x85530a, 0x8d5a09, 0x8d5a0b, 0x88570a, 0x89580b, 0x905c10, 0x976212, 0x9c6717, 0x9b6616, 0x9f6a1a, 0xa37021, 0xa37223, 0xa67528, 0xaa782f, 0xac7c34, 0xad803c, 0xac8341, 0xad8749, 0xb28e54, 0xb79660, 0xb99b67, 0xd5b680, 0x887451, 0x000100, 0x252628, 0x2c2b30, 0x17181a, 0x070908, 0x010101, 0x080808, 0x151314, 0x171719, 0x0f0f11, 0x1b1c1e, 0x414548, 0x45464a, 0x2a2b2f, 0x292a2c, 0x0a0809, 0x000000, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x000000, 0x020202, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x020202, 0x010101, 0x010101, 0x8d7958, 0xcaab75, 0xb1905b, 0xb18c57, 0xaf864e, 0xac8246, 0xb08340, 0xaf7e39, 0xac7c34, 0xaa792d, 0xa87428, 0xa57223, 0xa46f21, 0xa46d1d, 0xa16a18, 0x9b6714, 0x9a6310, 0x945f0f, 0x915c0e, 0x905d0c, 0x905d0c, 0x8c590a, 0x87560a, 0x865509, 0x89580b, 0x87570f, 0x7d550f, 0x74520b, 0x7f5312, 0x8f4e14, 0x994810, 0xa64d11, 0xaf5c16, 0xb8661a, 0xb86d1c, 0xb26f1e, 0xa97522, 0x9f7521, 0xa27522, 0xa17725, 0xa07624, 0x9d7422, 0x987122, 0x946e25, 0x8f6a26, 0x8b6828, 0x8a6727, 0x896626, 0x886d2a, 0x8a6d2b, 0x90722a, 0x917428, 0x947427, 0x9d7a29, 0xa17f26, 0xa98227, 0xbf8728, 0xc48126, 0xcd8129, 0xd18b2b, 0xce8c2b, 0xc78223, 0xb77622, 0x8d591d, 0x603e18, 0x5f3b17, 0x764d17, 0x7d5112, 0x774b0e, 0x774e0c, 0x79510c, 0x83540e, 0x87570f, 0x88580c, 0x8b5a0d, 0x925e0b, 0x945f0f, 0x915d11, 0x925f10, 0x976214, 0x9d6915, 0xa46d1b, 0xa36f1c, 0xa67322, 0xa97625, 0xad792d, 0xae7d31, 0xb08036, 0xb4833e, 0xb18544, 0xb1894b, 0xb28f55, 0xb6955f, 0xbea06c, 0xceaf79, 0xaf966e, 0x0a0809, 0x141319, 0x2c2f36, 0x26272b, 0x191919, 0x121210, 0x0b0b0b, 0x020605, 0x0f1012, 0x343436, 0x555557, 0x5d5d5f, 0x3b3b3d, 0x242527, 0x2b2c2e, 0x080808, 0x000000, 0x010101, 0x010101, 0x010101, 0x020202, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x000000, 0x020202, 0x000000, 0x0c0c0c, 0xb0956a, 0xc0a26e, 0xb2915e, 0xb48c58, 0xb5884d, 0xb58948, 0xb5843f, 0xb3823f, 0xb17f36, 0xaf7b30, 0xac7729, 0xaa7525, 0xaa7321, 0xa6701a, 0xa36c19, 0x9d6916, 0x9b6414, 0x9b6412, 0x99620f, 0x965f0d, 0x915c0e, 0x8f5b0f, 0x8d5c0f, 0x8c5d0d, 0x8a5a10, 0x80560e, 0x845713, 0x955515, 0xa45010, 0xba5f19, 0xbf711c, 0xcb8928, 0xdb9e33, 0xdba136, 0xd69833, 0xcf8a2b, 0xc77d26, 0xb67d26, 0xa98028, 0xaa7d28, 0xa67c28, 0x9e7728, 0x98742a, 0x977329, 0x977128, 0x976f27, 0x936e2a, 0x8e6b2b, 0x927330, 0x947630, 0x96742a, 0x987b2f, 0xa07b2a, 0x9a802b, 0xa8842c, 0xce872f, 0xd08a2a, 0xdb9b31, 0xebb134, 0xf0bc34, 0xf1bd35, 0xeeba32, 0xe9b02d, 0xe0a42a, 0xc28922, 0x90641d, 0x68451f, 0x6e4819, 0x845915, 0x80530f, 0x805312, 0x835410, 0x865510, 0x905b0d, 0x915b11, 0x915d11, 0x9b6310, 0x9c6513, 0x9a6612, 0x9d6616, 0xa06c18, 0xa96f1d, 0xad7321, 0xab7723, 0xae7a27, 0xb27d2f, 0xb38235, 0xb58539, 0xb98740, 0xb68c44, 0xb68d4d, 0xb89253, 0xba9662, 0xc1a16e, 0xcaab7c, 0xd1b283, 0x2c281f, 0x010103, 0x18191d, 0x1f2227, 0x191e24, 0x1e2629, 0x222625, 0x2a2b2f, 0x3d3d3f, 0x5a5a5c, 0x555356, 0x36373b, 0x24292d, 0x28292d, 0x2f2f2d, 0x070908, 0x000000, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x000201, 0x010101, 0x020100, 0x000201, 0x000002, 0x030102, 0x000000, 0x241f1b, 0xc0a173, 0xbf9e69, 0xb7935f, 0xb9905a, 0xbd8f53, 0xbe8c4d, 0xba8a42, 0xb7873b, 0xb68237, 0xb18031, 0xb47d2b, 0xb27a27, 0xae7724, 0xab7320, 0xa76d1b, 0xa16a17, 0xa56815, 0xa06917, 0x9c6513, 0x9a6110, 0x966310, 0x966314, 0x935e10, 0x8c5e10, 0x855e11, 0x955c19, 0xa95614, 0xbb6417, 0xc87f20, 0xdb9b2d, 0xe7ac38, 0xebb33c, 0xecb33f, 0xebb741, 0xf3bb42, 0xeebb46, 0xe6ac3e, 0xd08b2c, 0xb37f2c, 0xa9842c, 0xa9802e, 0xa87f2d, 0xa57c2c, 0xa27b2c, 0x9e792b, 0x99742d, 0x926f2d, 0x8e6c2d, 0x917836, 0x9a7c36, 0x9e7d36, 0xa37e2e, 0xa3852d, 0xab8731, 0xc78934, 0xd18f31, 0xe5b537, 0xf9ca40, 0xfbc73d, 0xf9c33d, 0xfcc439, 0xfbc434, 0xfcc537, 0xf5bd32, 0xedb730, 0xe4ae2a, 0xbf8b25, 0x795420, 0x69471a, 0x875a19, 0x895813, 0x875812, 0x8a5b15, 0x8c5a11, 0x946112, 0x976310, 0x9c6312, 0xa06815, 0xa46e18, 0xa56d1a, 0xa66f1c, 0xaa7320, 0xb07825, 0xb37c29, 0xb27e2a, 0xb8812e, 0xbd8636, 0xbd893d, 0xbe8d41, 0xbf8e49, 0xbe9251, 0xbf9658, 0xbd9a62, 0xc0a26c, 0xc7ab79, 0xe3c28c, 0x524735, 0x010000, 0x000100, 0x0d0908, 0x2d2324, 0x1a1e21, 0x0b1517, 0x272d39, 0x393d3c, 0x373739, 0x282c2f, 0x222627, 0x24252a, 0x2c2c2e, 0x353439, 0x07080a, 0x000000, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x030102, 0x010101, 0x000002, 0x040404, 0x000000, 0x2a231d, 0xc5a375, 0xc29e6e, 0xbf9763, 0xc1985a, 0xc39854, 0xc2914c, 0xbf8f45, 0xbf8b40, 0xbc8739, 0xb98532, 0xb5812e, 0xb37f2c, 0xb27928, 0xae7621, 0xab731c, 0xa9711e, 0xa56d16, 0x9f6b17, 0x9e6a17, 0xa16912, 0x9d6616, 0x976415, 0x916117, 0x906215, 0xa26016, 0xb8611a, 0xcd7c21, 0xdf9e2a, 0xecb133, 0xedb234, 0xedb135, 0xf1b33c, 0xf2b83d, 0xf1b942, 0xf1ba43, 0xf2b945, 0xf2c34d, 0xeeba4a, 0xcf8e30, 0xb2832b, 0xb18931, 0xad852e, 0xa88231, 0xa37e30, 0x9c7a30, 0x997632, 0x987734, 0x957334, 0x9f7e3b, 0x9b7d35, 0xa08536, 0xa58634, 0xa88a34, 0xc48c37, 0xd79132, 0xebb93c, 0xf7cc41, 0xf2c43b, 0xf8c73e, 0xfdc83c, 0xffc73c, 0xffc83d, 0xfeca39, 0xfeca38, 0xfdc435, 0xf9bb32, 0xf4b931, 0xdaa22b, 0x946924, 0x754f22, 0x85581d, 0x916014, 0x926017, 0x916115, 0x966216, 0x9d6614, 0xa06916, 0xa46e18, 0xa87117, 0xac751b, 0xae751e, 0xac7822, 0xb27c26, 0xb8802b, 0xbb832e, 0xbd8633, 0xbf8b38, 0xbf8f3b, 0xc59146, 0xc4964b, 0xc19953, 0xc59c5e, 0xc69d65, 0xc4a36e, 0xcbac7d, 0xe9c990, 0x625745, 0x000002, 0x010101, 0x19100b, 0x815b50, 0x967468, 0x634e49, 0x231e22, 0x161e29, 0x242d34, 0x292d30, 0x272b2e, 0x27252a, 0x2d2e32, 0x444645, 0x080705, 0x000000, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x020202, 0x020001, 0x040203, 0x030102, 0x030104, 0x010101, 0x030406, 0x000000, 0x332a21, 0xcaa976, 0xc8a06f, 0xc89d66, 0xca9d5c, 0xc99a56, 0xcb9650, 0xc49347, 0xc88e44, 0xc38c3a, 0xc2893a, 0xbe8534, 0xb9812c, 0xb67d26, 0xb37b24, 0xae7820, 0xac741d, 0xaa711a, 0xa9711c, 0xa76f1a, 0xa16d17, 0x9e6919, 0x9a691c, 0x9b6618, 0xaf651e, 0xc76d1f, 0xdb9325, 0xefb02f, 0xf3b230, 0xf6b233, 0xf7b636, 0xf9ba37, 0xfbbc3b, 0xf9be3e, 0xf9bf42, 0xf7bf48, 0xf5be47, 0xeebd46, 0xf4c34c, 0xf2b948, 0xc18e33, 0xac8736, 0xac8834, 0xa98434, 0xa78232, 0xa48034, 0x9e7b37, 0x9d7b34, 0x9a7936, 0x9b823f, 0xa2843c, 0xa98839, 0xab8c3a, 0xb68e39, 0xd0933a, 0xe5b23c, 0xf8ca41, 0xf7c33c, 0xf9c740, 0xfbca41, 0xfdcc3f, 0xfdcc3f, 0xfccb3e, 0xfece3e, 0xfece3c, 0xffd03d, 0xffcc3b, 0xfec337, 0xffc335, 0xf0b12e, 0xb17f2a, 0x885e24, 0x885f21, 0x905f1a, 0x9a6718, 0x9b6618, 0x9d681a, 0xa26e18, 0xa87019, 0xad741b, 0xaf791f, 0xb57c22, 0xb77e25, 0xb88029, 0xbb842a, 0xc18831, 0xc28c36, 0xc4903c, 0xcb9442, 0xcf9649, 0xd19e4f, 0xd09f53, 0xcda160, 0xc8a468, 0xc8a772, 0xd0b183, 0xf6d39d, 0x605541, 0x010000, 0x010000, 0x2d1f1c, 0xb7846f, 0xd99f89, 0xe9b4a2, 0xb49382, 0x4c3932, 0x0c0a0d, 0x0c151c, 0x252c32, 0x22252a, 0x34353a, 0x52534e, 0x030303, 0x000000, 0x010101, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x040203, 0x040203, 0x030303, 0x040203, 0x030104, 0x000000, 0x020305, 0x010101, 0x352b1f, 0xd7ac77, 0xd9a66d, 0xd8a667, 0xd8a361, 0xd39e58, 0xd39b50, 0xcb9849, 0xcc9543, 0xca9340, 0xc78f3a, 0xc38a33, 0xbf8531, 0xbb832e, 0xb77f28, 0xb57c23, 0xb37a23, 0xb07720, 0xac741d, 0xab731e, 0xa97021, 0xa76e1d, 0xa86b1b, 0xbe7320, 0xd37b24, 0xe7992d, 0xf9b633, 0xfab62f, 0xfbb835, 0xfebe3a, 0xffbe3c, 0xfec23e, 0xfdc441, 0xfec343, 0xfdc345, 0xf9c146, 0xf5c147, 0xf5c04e, 0xf2bd4b, 0xf6c952, 0xd8aa48, 0xaf8839, 0xb48e3b, 0xb08a39, 0xae8738, 0xaa8439, 0xa8833d, 0xa17e3c, 0x9c7a3a, 0x9d8643, 0xa08542, 0xa78c3f, 0xa98e3d, 0xc6923f, 0xdea33d, 0xf4c746, 0xf4c843, 0xf8c840, 0xfbcc42, 0xfccd3f, 0xfdce42, 0xffd044, 0xffd241, 0xfdd33f, 0xfdd341, 0xfdd33f, 0xffd33f, 0xffd241, 0xfece3e, 0xffcb39, 0xf9be36, 0xc48e2c, 0xa3742c, 0x996a22, 0x95651b, 0xa06d1e, 0xa46f1f, 0xa8701d, 0xac741f, 0xb17924, 0xb47b21, 0xb98026, 0xbf842a, 0xbe872c, 0xc08a30, 0xca8f35, 0xd49339, 0xd6963f, 0xd99749, 0xdf9d49, 0xe3a252, 0xe4a659, 0xe0a762, 0xd7ab6c, 0xd3aa76, 0xcead78, 0xfddfa1, 0x5a4f39, 0x000100, 0x000004, 0x46312c, 0xda9f81, 0xcb937a, 0xdeaf9d, 0xeac0b2, 0x9a6c5f, 0x87665f, 0x655b59, 0x0d090a, 0x0f131e, 0x55545a, 0x6f6f71, 0x020305, 0x000000, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x040203, 0x040203, 0x030102, 0x020202, 0x040203, 0x030102, 0x010000, 0x020202, 0x000000, 0x33291f, 0xecb177, 0xedb071, 0xe7ae69, 0xe4a862, 0xe3a55a, 0xe1a454, 0xdda050, 0xd59848, 0xcc9545, 0xc8923c, 0xca9138, 0xc88c34, 0xc08730, 0xbf832b, 0xbf832b, 0xb87f25, 0xb37d27, 0xb07a22, 0xb07624, 0xb57422, 0xb77922, 0xcb8128, 0xe3882b, 0xeda02c, 0xfeba33, 0xffbb32, 0xfebe38, 0xffc139, 0xffc43a, 0xfdc941, 0xfcc63f, 0xffc442, 0xffc648, 0xfdc647, 0xfec749, 0xfac44a, 0xf7c451, 0xf5c352, 0xf6c755, 0xedbe54, 0xc19647, 0xb78e3f, 0xb38d3c, 0xb18c3e, 0xac8740, 0xa8863f, 0xa58343, 0xa18242, 0xa58c4a, 0xa98e4b, 0xa98d44, 0xac9144, 0xc89345, 0xe7b544, 0xfacb49, 0xf8c744, 0xfbc944, 0xfdcb46, 0xfecf45, 0xffd042, 0xffd344, 0xfdd343, 0xfdd542, 0xffd843, 0xfed643, 0xfed643, 0xfed53f, 0xfed444, 0xffd447, 0xffd541, 0xfcc63f, 0xd29b37, 0xc08c36, 0xab7829, 0x9e6a1f, 0xa77226, 0xae7724, 0xaf7923, 0xb27a25, 0xbc8125, 0xc08529, 0xc1882f, 0xca8d34, 0xd39035, 0xd99439, 0xde973f, 0xe59e42, 0xeaa945, 0xf1af4e, 0xf7b459, 0xf8b95c, 0xf5bc63, 0xf2b96c, 0xe9b579, 0xe3b47c, 0xe8c490, 0x302c21, 0x000000, 0x000000, 0x53423b, 0xeeb69d, 0xc6927a, 0xd2a590, 0xca998a, 0xa47a6c, 0xe0b6a6, 0xe5bead, 0xa3887f, 0x514642, 0x252b29, 0x293335, 0x000000, 0x010101, 0x030303, 0x030303, 0x020202, 0x020202, 0x040203, 0x040203, 0x040203, 0x040203, 0x020202, 0x030102, 0x010101, 0x040301, 0x020202, 0x000000, 0x2e251e, 0xfbbd72, 0xfcbf6e, 0xfabd6d, 0xf8ba67, 0xf8b65f, 0xf6b358, 0xf7b152, 0xefaa4f, 0xe19f48, 0xd69843, 0xcc8f3c, 0xcb923b, 0xcb9238, 0xc2892f, 0xbf862d, 0xbd842b, 0xbc832c, 0xbd7f2a, 0xc07e2a, 0xc58629, 0xd28e2b, 0xea9431, 0xf59f30, 0xffbc35, 0xffc038, 0xfec337, 0xfcc439, 0xfec63f, 0xffc841, 0xfdc740, 0xfdc941, 0xfec841, 0xffc847, 0xfcc949, 0xfec949, 0xffc94f, 0xfbc852, 0xf8c550, 0xf7c353, 0xf4c455, 0xc8a152, 0xb8914c, 0xb79242, 0xb38e40, 0xb18c46, 0xb08b44, 0xad8c47, 0xa8884b, 0xa89052, 0xac914a, 0xb2944e, 0xb9984b, 0xd39b48, 0xeebe4f, 0xf7cb48, 0xf7ca49, 0xffca4c, 0xfecc45, 0xffd046, 0xffd147, 0xfed442, 0xffd742, 0xffd742, 0xfed640, 0xfdda42, 0xffd742, 0xfed442, 0xffd241, 0xffd245, 0xfdd343, 0xfed94a, 0xfdcb44, 0xe2af44, 0xe0aa48, 0xbc842f, 0xaa7525, 0xaf7c29, 0xb67e27, 0xba8127, 0xbb852b, 0xc48830, 0xce8f32, 0xda9133, 0xe19236, 0xe69d3e, 0xefac44, 0xf9b64b, 0xfdb94e, 0xfcbe51, 0xfebe5c, 0xffc363, 0xfbc668, 0xfec872, 0xfac575, 0xfcd683, 0xdcb278, 0x08090d, 0x000002, 0x050908, 0x29211e, 0xe6b7a3, 0xdfa081, 0xc0886f, 0xb28474, 0xba9080, 0xd2a995, 0xc39d90, 0xf9ded5, 0xeecabc, 0x927066, 0x392019, 0x19110e, 0x010101, 0x020202, 0x020202, 0x030102, 0x030102, 0x030102, 0x030102, 0x040203, 0x040203, 0x020003, 0x030102, 0x030303, 0x030303, 0x020200, 0x000100, 0x100c09, 0xf1b96e, 0xffd073, 0xffc16c, 0xfec26c, 0xffc063, 0xffbb5c, 0xfeb952, 0xfbb553, 0xfeb04b, 0xf1a943, 0xe2a042, 0xd2943f, 0xce9a44, 0xd39d43, 0xc68831, 0xc78632, 0xca892f, 0xd08d34, 0xd39130, 0xd89834, 0xeb9c33, 0xf8a233, 0xfebe3a, 0xffc438, 0xfec43c, 0xfcc73d, 0xfec93f, 0xfec841, 0xffca40, 0xfeca40, 0xfacf45, 0xfdcd45, 0xfdcd47, 0xfecb4b, 0xfdca4b, 0xfcc850, 0xfec752, 0xfcc551, 0xf6c455, 0xf3c458, 0xd6b45d, 0xcda95d, 0xc29d4f, 0xb99348, 0xbb9451, 0xb6914d, 0xb18f50, 0xae8d57, 0xac9456, 0xb39454, 0xb29752, 0xbc9a53, 0xdfa34d, 0xf2c253, 0xf6ca4d, 0xfbca51, 0xfcd04d, 0xfed24d, 0xfdd248, 0xfdd34b, 0xfed44c, 0xfcd647, 0xfcd741, 0xfcd645, 0xfcd740, 0xfcd643, 0xfed545, 0xfed444, 0xfcd347, 0xfcd049, 0xffd148, 0xffd749, 0xf6cb4b, 0xf2c659, 0xeeb94f, 0xcd912f, 0xbd8331, 0xba822f, 0xbf862f, 0xc28c32, 0xce8e34, 0xda9039, 0xe3983b, 0xeba83f, 0xf8b542, 0xffb846, 0xffb84c, 0xfebb52, 0xfdbc58, 0xffbf5f, 0xfbc364, 0xffc66d, 0xfcca75, 0xfec673, 0xfef495, 0x9b7e54, 0x010000, 0x040507, 0x171b1a, 0x000002, 0x7f6558, 0xffcdb0, 0xc48b70, 0xa87b66, 0xad8677, 0xba8a73, 0x876961, 0xa57d7b, 0x86635f, 0x6a4646, 0x58332b, 0x291a15, 0x010101, 0x010101, 0x010101, 0x030102, 0x030102, 0x030102, 0x030102, 0x040203, 0x060203, 0x040205, 0x030102, 0x010302, 0x020202, 0x010000, 0x000100, 0x000000, 0xc09759, 0xfee07e, 0xfdc46d, 0xfdc36f, 0xffbf65, 0xffbb60, 0xfeba57, 0xfdb757, 0xfdb350, 0xfbb44a, 0xffb248, 0xf0a643, 0xd59c42, 0xe1a954, 0xe29e49, 0xd08f33, 0xda993b, 0xde9d39, 0xdca236, 0xeba43a, 0xf4a53e, 0xf9bc3d, 0xffca3c, 0xffc53d, 0xffc83a, 0xfec841, 0xfccb40, 0xfdce42, 0xfcce44, 0xfed144, 0xffce45, 0xffcf49, 0xfdcf48, 0xfecb4b, 0xfcca4d, 0xfdcb52, 0xfbc853, 0xfbc956, 0xf7c759, 0xf3c661, 0xf1c86c, 0xf1c974, 0xd0a95e, 0xbc9550, 0xbc9655, 0xb99557, 0xb3935a, 0xb0915b, 0xb1975c, 0xb2985d, 0xb39a57, 0xbe9b57, 0xdea556, 0xf0c554, 0xf8ca52, 0xfeca54, 0xffcf53, 0xffd14f, 0xfed351, 0xfcd64d, 0xfed94c, 0xfbda4d, 0xfdd84b, 0xffd646, 0xfdd448, 0xfed346, 0xffd744, 0xfdd542, 0xfdd446, 0xfcd248, 0xfdd349, 0xfdd248, 0xfdcf48, 0xf8cd5c, 0xffd76b, 0xf1c258, 0xdea440, 0xd09a3a, 0xc69036, 0xcf8f38, 0xda943c, 0xe59d39, 0xf8af40, 0xfeb846, 0xffb548, 0xfeb74b, 0xfcbc50, 0xfcbd54, 0xffc15e, 0xffc564, 0xfcc568, 0xfec870, 0xfdc674, 0xffdf80, 0xfeda7c, 0x1a1914, 0x010101, 0x08080a, 0x13120e, 0x13171a, 0x040203, 0xc49a82, 0xffc4a2, 0xb07d68, 0x8b6155, 0x906457, 0xb99b91, 0xcaada5, 0xc19a95, 0xad7874, 0x653f3e, 0x402b2a, 0x0b0203, 0x020001, 0x010101, 0x040203, 0x040203, 0x040203, 0x040203, 0x030303, 0x040203, 0x040203, 0x040203, 0x030303, 0x000000, 0x010101, 0x030303, 0x000000, 0x6c5938, 0xffed84, 0xffc46c, 0xfdc56e, 0xfec367, 0xfec168, 0xfebc5e, 0xfeb95a, 0xffb755, 0xfeb54e, 0xfcb14c, 0xfcb549, 0xf9aa45, 0xeaa74c, 0xfab95d, 0xeaa847, 0xd9a23d, 0xdea740, 0xe1ab3f, 0xefab3e, 0xf8b540, 0xffcb43, 0xfdc83c, 0xffc942, 0xffcb43, 0xfdce44, 0xfecf45, 0xffd248, 0xfed046, 0xfdd248, 0xfed047, 0xfdcf46, 0xfecd4c, 0xffcc4f, 0xfecc53, 0xfdcc55, 0xfecb58, 0xffcb5b, 0xfbca63, 0xf7c773, 0xf8ca7f, 0xfccc82, 0xd8ad69, 0xbc9655, 0xbe9a5c, 0xbe9a5e, 0xbb975d, 0xb69761, 0xb59c64, 0xba9c60, 0xbc9f5d, 0xc19e5c, 0xdfac5b, 0xf2ca5b, 0xf7cc5c, 0xfbcc5a, 0xfdcf57, 0xfed257, 0xfed353, 0xfcd64f, 0xfed652, 0xffd950, 0xfddd4c, 0xffda4b, 0xfdd849, 0xfbd449, 0xffd34a, 0xffd244, 0xfdd341, 0xfdd247, 0xffd148, 0xfcd248, 0xfed24b, 0xfdd156, 0xfcd16b, 0xffd670, 0xfcd266, 0xedb954, 0xe0a140, 0xe29b3f, 0xeda13f, 0xfbb546, 0xfbb845, 0xfdb748, 0xffb94f, 0xfcbd53, 0xfebd57, 0xffc25b, 0xffc361, 0xfbc666, 0xfec86e, 0xfcc872, 0xffd076, 0xfef78c, 0x645430, 0x000002, 0x090a0c, 0x050608, 0x0a0809, 0x1e231f, 0x010609, 0x1c1211, 0xe7af94, 0xf6b693, 0x956551, 0x845f57, 0xd5b7af, 0xe8c5af, 0xa57767, 0x8e524a, 0x794c49, 0x482c2b, 0x0a0404, 0x000000, 0x020202, 0x030303, 0x040203, 0x040203, 0x050102, 0x030301, 0x040203, 0x030102, 0x020202, 0x020202, 0x010101, 0x010101, 0x020202, 0x010101, 0x0b0c07, 0xf1c471, 0xfddd78, 0xfbc46a, 0xfec76d, 0xfcc36c, 0xffbd66, 0xfbbf5d, 0xfdbe57, 0xfcb857, 0xffb755, 0xfbb34f, 0xffb64b, 0xf8b544, 0xfaba56, 0xfdc862, 0xe9b64d, 0xdcad43, 0xecad46, 0xf6b342, 0xfdc846, 0xfcca43, 0xffcb44, 0xfdce44, 0xfece46, 0xffd046, 0xfdd247, 0xfed348, 0xffd249, 0xfdd14c, 0xfcd04d, 0xffcf4f, 0xfdd14e, 0xffcf53, 0xfecd54, 0xfdce58, 0xfbcc5a, 0xffcc5f, 0xfcca69, 0xf7ca77, 0xf7c880, 0xf8cc85, 0xd5ae6b, 0xc29b5a, 0xc49e5f, 0xbd9d62, 0xbf9c64, 0xbe9a68, 0xd1b77a, 0xccaf75, 0xc4a668, 0xc1a262, 0xdcae61, 0xf4c961, 0xf7ce5c, 0xfbcd5d, 0xffd05a, 0xfed15a, 0xfbd55a, 0xfed65a, 0xffd754, 0xfeda52, 0xffdb53, 0xfed851, 0xfdd74e, 0xfed84f, 0xfcd64d, 0xfed549, 0xfdd248, 0xfed24b, 0xfdd248, 0xffd346, 0xffd245, 0xfcd14e, 0xfcd063, 0xfed26f, 0xf9d46a, 0xebc058, 0xeeb450, 0xf6b750, 0xffbd4c, 0xfeb648, 0xffb74e, 0xfbbb51, 0xffbc53, 0xffbe58, 0xfdc25e, 0xfdc360, 0xfcc767, 0xfec96d, 0xfec872, 0xfecb70, 0xfef888, 0x967b44, 0x000103, 0x0c0d0f, 0x111214, 0x080806, 0x080a07, 0x1b1b1b, 0x1c1c1e, 0x000002, 0x291f1d, 0xecb193, 0xf1b495, 0xa87f6d, 0xb9897b, 0xc6927d, 0x875749, 0x4a2e23, 0x090400, 0x000100, 0x000002, 0x000103, 0x030305, 0x020001, 0x050304, 0x030303, 0x040205, 0x020202, 0x030102, 0x020001, 0x010101, 0x020202, 0x020202, 0x010101, 0x010101, 0x020202, 0x000004, 0x53452a, 0xfff084, 0xffcc70, 0xfcc36c, 0xfdc56e, 0xfdc46a, 0xffbf63, 0xfebd5f, 0xfcbb5d, 0xffb957, 0xfebb53, 0xfbbe53, 0xffbd4c, 0xfcbc4e, 0xffcb65, 0xefbf5b, 0xdead46, 0xf1b248, 0xfbc144, 0xffd147, 0xfecd44, 0xfece48, 0xfed047, 0xffcf47, 0xffd048, 0xfed24b, 0xfdd14c, 0xffd14f, 0xfed150, 0xfdd252, 0xffd255, 0xfed056, 0xfecf5b, 0xfdce5c, 0xfccf5c, 0xfdcd5f, 0xfdcc63, 0xfccb6e, 0xfbca7d, 0xfac984, 0xf6c781, 0xd1aa67, 0xc6a05f, 0xc9a364, 0xc5a167, 0xc3a06a, 0xbd9f6b, 0x7b6b49, 0xa99469, 0xc9b379, 0xe4c17f, 0xf9c879, 0xffd86f, 0xfcd065, 0xfbcc62, 0xfed060, 0xffd161, 0xfdd25f, 0xfdd55b, 0xffd75b, 0xffd95a, 0xfcdc55, 0xfddb55, 0xfcda55, 0xffd753, 0xfed650, 0xfdd752, 0xfdd54f, 0xfed44c, 0xffd34c, 0xffd14a, 0xfdd14a, 0xfdd14a, 0xfdd14c, 0xfed561, 0xe9c25b, 0xe5b851, 0xf4c156, 0xfecf5b, 0xffcc56, 0xffc056, 0xfcbb53, 0xfbbc53, 0xffbf5b, 0xffc15c, 0xfcc560, 0xfdc566, 0xffc86b, 0xfdc56e, 0xffcd74, 0xfff788, 0xa38b4f, 0x000002, 0x0d0c14, 0x1f1e1c, 0x111514, 0x0c0807, 0x030303, 0x181617, 0x242422, 0x13171a, 0x000000, 0x31241e, 0xebb294, 0xefb7a0, 0xc7a091, 0xc8a295, 0xaa897a, 0xa9887f, 0x6f5852, 0x251717, 0x120807, 0x010000, 0x020204, 0x040203, 0x030102, 0x030303, 0x040203, 0x060105, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x020202, 0x020400, 0x000004, 0x987a48, 0xfff589, 0xffce72, 0xffc36d, 0xfcc66e, 0xfbc56b, 0xfcbf64, 0xfbbf5d, 0xfebf5e, 0xfdbf58, 0xfec059, 0xffc157, 0xfcc34f, 0xffc756, 0xebb956, 0xe9b349, 0xf6c24a, 0xfecd4a, 0xfece48, 0xffcf49, 0xffcf49, 0xffd04e, 0xffd04c, 0xffd14f, 0xffd251, 0xfed351, 0xfdd454, 0xfcd556, 0xfdd559, 0xffd25b, 0xffd05e, 0xfcce5e, 0xfdcf60, 0xfccc5d, 0xffcc5f, 0xfdca61, 0xfbc968, 0xf9c879, 0xfccc8a, 0xeec17d, 0xcba564, 0xcaa66a, 0xd2ab72, 0xd5b177, 0xdeba7e, 0xdebd87, 0x000000, 0x070604, 0x2d271b, 0x595236, 0x987c4c, 0xe4be6b, 0xffe779, 0xfff27f, 0xffec7b, 0xffe36d, 0xffd666, 0xffd562, 0xffd660, 0xffd75e, 0xfdda5c, 0xffd75e, 0xffd95d, 0xffda58, 0xfdd854, 0xfdd653, 0xfed853, 0xfdd750, 0xfcd450, 0xfbd252, 0xfed353, 0xffd350, 0xfed24b, 0xfbd350, 0xf0c650, 0xf6c755, 0xffce58, 0xffd05c, 0xfacf5e, 0xfdcd61, 0xfdc75d, 0xffc65f, 0xfcc05e, 0xffc361, 0xfcc664, 0xfec86e, 0xfdc56e, 0xfde07a, 0xfff086, 0x927d46, 0x010000, 0x090e11, 0x232122, 0x171c18, 0x191a1c, 0x151611, 0x050304, 0x0d0e12, 0x242321, 0x1e2221, 0x060709, 0x000002, 0x2c211d, 0xd6a690, 0xfccaaf, 0xe4c6bb, 0xe9d1cd, 0xe6cdc6, 0xc4a299, 0x89675b, 0x653f36, 0x2d1c15, 0x050402, 0x000002, 0x030104, 0x030303, 0x030303, 0x020202, 0x020202, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x040203, 0x010101, 0x000000, 0x947c4c, 0xffef85, 0xfddc7b, 0xfdc36f, 0xffc370, 0xfec470, 0xfcc56a, 0xfcc465, 0xfbc460, 0xfcc55e, 0xfdc459, 0xfec456, 0xffc853, 0xf7c353, 0xfac751, 0xfed152, 0xffd052, 0xffcf53, 0xffd052, 0xffd050, 0xfdd252, 0xffd153, 0xffd356, 0xfcd357, 0xffd35a, 0xffd25b, 0xffd25d, 0xfed15e, 0xfcd15e, 0xfdce62, 0xfece5f, 0xfccb64, 0xffcb65, 0xffc766, 0xffcb69, 0xfed36a, 0xfed97e, 0xffe294, 0xfdd689, 0xeac27d, 0xe0bc7e, 0xccae78, 0xb29a6e, 0x94805d, 0x776c50, 0x010300, 0x010000, 0x000002, 0x000103, 0x000000, 0x11100b, 0x4a3f2b, 0x806e3e, 0xb79b52, 0xe8c766, 0xffea77, 0xfcfb7c, 0xfdf876, 0xffe46c, 0xffd863, 0xfdda62, 0xffd95c, 0xfed85d, 0xffda5f, 0xffd75b, 0xfed758, 0xfed758, 0xfed758, 0xfdd657, 0xfed557, 0xfcd353, 0xfed557, 0xfdd154, 0xffd356, 0xfed557, 0xfed559, 0xfecf5b, 0xffcd60, 0xffcb65, 0xfacf67, 0xffcb68, 0xfdc86a, 0xfcc66c, 0xfdc66c, 0xfdce72, 0xfef083, 0xedc56d, 0x56482b, 0x000100, 0x121117, 0x1f2324, 0x1b1d1c, 0x1d1d1f, 0x202221, 0x1f211e, 0x0a0c0b, 0x090907, 0x181d20, 0x272928, 0x151314, 0x030000, 0x000100, 0x1f1715, 0xaa7c6c, 0xd2a794, 0xdab9b2, 0xdab9b2, 0xb28c7f, 0x845a4e, 0x704840, 0x3a2721, 0x050402, 0x000002, 0x030305, 0x020202, 0x010302, 0x000201, 0x010101, 0x000000, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x020202, 0x020204, 0x050505, 0x020001, 0x000000, 0x655232, 0xeecf72, 0xfef087, 0xffcc74, 0xfcc56b, 0xfec671, 0xfdc669, 0xfdc765, 0xfbc660, 0xfdca5f, 0xffc95d, 0xfbcb5c, 0xfecf59, 0xffd258, 0xfdcf57, 0xfecd56, 0xfdcf55, 0xfdd158, 0xffd25a, 0xfcd259, 0xffd25b, 0xffd35c, 0xfed15c, 0xffd25f, 0xffd161, 0xfdce62, 0xfdcd61, 0xffcd62, 0xffd167, 0xfeda6c, 0xffe57a, 0xffe97a, 0xffe77d, 0xffd87b, 0xf0c672, 0xc9a96c, 0x9c845e, 0x7f6b4a, 0x5c4d38, 0x42382c, 0x23201b, 0x070b0a, 0x000000, 0x010000, 0x030102, 0x020202, 0x060203, 0x020202, 0x030303, 0x000000, 0x000100, 0x010000, 0x000000, 0x1b1c16, 0x504529, 0x82733c, 0xb89f4b, 0xefd566, 0xfff97c, 0xfefe7c, 0xffec6f, 0xfddf65, 0xfcd762, 0xfed964, 0xffd660, 0xffd55d, 0xffd75e, 0xffd55d, 0xfad65b, 0xffd65d, 0xfed45b, 0xfed65d, 0xfdd55c, 0xfdd45e, 0xfed561, 0xfcd55c, 0xfdd261, 0xfdce66, 0xfecc6b, 0xfccb6e, 0xfdca6f, 0xfdd170, 0xfdeb7d, 0xffe67f, 0xa38950, 0x130e0a, 0x010000, 0x171b1c, 0x1f2022, 0x202125, 0x212322, 0x202022, 0x20201e, 0x26252a, 0x191917, 0x050704, 0x151714, 0x262628, 0x212322, 0x080607, 0x000201, 0x010002, 0x000100, 0x62453d, 0x926957, 0x7b5749, 0x694535, 0x482b23, 0x251b19, 0x0c0b09, 0x010101, 0x020202, 0x010101, 0x010101, 0x020001, 0x020001, 0x000000, 0x000000, 0x010101, 0x010101, 0x010101, 0x010101, 0x020202, 0x030303, 0x010302, 0x020403, 0x040601, 0x010103, 0x000000, 0x18140b, 0xa3894e, 0xffe481, 0xffe880, 0xffcb70, 0xfdc66b, 0xffca6c, 0xfdcd6b, 0xfccd63, 0xfdcd5e, 0xfbcc62, 0xfcce5f, 0xfece60, 0xfecc5d, 0xfed15e, 0xfdd05b, 0xfed15e, 0xfdd261, 0xfed060, 0xfcd35f, 0xffd061, 0xfece62, 0xfdd164, 0xffd86a, 0xffe572, 0xffee7c, 0xffed7d, 0xfedb75, 0xebbe6b, 0xbf9a56, 0x937c4a, 0x685439, 0x3e3428, 0x16170f, 0x020106, 0x000200, 0x000000, 0x000100, 0x000000, 0x010000, 0x000002, 0x020001, 0x000000, 0x010204, 0x000201, 0x020200, 0x020401, 0x020204, 0x030104, 0x010302, 0x040404, 0x040404, 0x00000c, 0x000005, 0x00000d, 0x0e0e1a, 0x2b2b21, 0x5b5731, 0x9c8b43, 0xe5ce64, 0xfefa7d, 0xffff7a, 0xffe86e, 0xffda68, 0xfdd866, 0xfdd865, 0xffd664, 0xffd662, 0xfed464, 0xffd565, 0xfed762, 0xffd863, 0xffd765, 0xfed466, 0xfed464, 0xfed36a, 0xfdd26c, 0xfbcd6b, 0xffd171, 0xffed84, 0xfdec82, 0xbba35d, 0x443923, 0x000100, 0x00070f, 0x1c2021, 0x1e1e1c, 0x1e201f, 0x222423, 0x252527, 0x232426, 0x25262a, 0x2a2a2c, 0x26252a, 0x0c0e0d, 0x0f0f0d, 0x242422, 0x2a2b2d, 0x111715, 0x050402, 0x030303, 0x010000, 0x000002, 0x130707, 0x080500, 0x080403, 0x000000, 0x000000, 0x000000, 0x030303, 0x020200, 0x000201, 0x010101, 0x030102, 0x000201, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x020202, 0x030200, 0x020202, 0x030303, 0x040404, 0x030207, 0x000000, 0x010000, 0x453e22, 0xc8ac62, 0xfee682, 0xffed7f, 0xfdcf71, 0xfcc96d, 0xfecc6d, 0xffca6a, 0xfdcd67, 0xfdcc65, 0xffcc66, 0xffce65, 0xfcd063, 0xfdd166, 0xffd068, 0xfecf65, 0xffce65, 0xfecf65, 0xffdb70, 0xffef7d, 0xffee7c, 0xf9d26d, 0xd5ac5c, 0x9a8149, 0x695532, 0x3b3320, 0x130f0c, 0x000000, 0x010100, 0x000100, 0x000100, 0x000000, 0x000002, 0x010204, 0x060503, 0x060606, 0x050505, 0x000000, 0x010101, 0x282725, 0x4c4d4f, 0x020202, 0x010101, 0x020202, 0x020202, 0x020202, 0x030303, 0x040404, 0x040404, 0x020202, 0x000000, 0x010101, 0x0b0c0e, 0x16171c, 0x131521, 0x0f1223, 0x0b0d22, 0x2a2927, 0x595730, 0xa49949, 0xecd669, 0xfffe83, 0xfefa7f, 0xffdc6e, 0xffdc6c, 0xfee070, 0xffe071, 0xffde6d, 0xffdb6b, 0xffd76b, 0xffd56d, 0xffd66d, 0xfdd36d, 0xfed36d, 0xffdb76, 0xfdf883, 0xffeb7e, 0xb9a455, 0x4b4126, 0x000002, 0x010000, 0x121212, 0x1c1c1c, 0x191919, 0x1c1c1c, 0x202221, 0x202221, 0x242527, 0x28292b, 0x2b2d2c, 0x323433, 0x3d3f3c, 0x1f2120, 0x0c0c0c, 0x1f1f1f, 0x393939, 0x252525, 0x080808, 0x040404, 0x040404, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x020202, 0x010101, 0x010101, 0x000201, 0x010101, 0x010101, 0x000000, 0x010101, 0x020202, 0x020202, 0x000000, 0x000000, 0x000000, 0x000000, 0x010101, 0x010101, 0x010101, 0x020202, 0x020202, 0x040404, 0x020202, 0x000000, 0x000000, 0x4c4229, 0xbda25f, 0xfee980, 0xffeb7e, 0xfccd71, 0xffc96f, 0xfbcd6d, 0xfdcc70, 0xfdcd6b, 0xffce6b, 0xffd670, 0xfbdf72, 0xffe276, 0xfee275, 0xffed7d, 0xffef83, 0xf0cd6f, 0xb1924f, 0x5c522f, 0x201c13, 0x030000, 0x000002, 0x000000, 0x000000, 0x000000, 0x010101, 0x030303, 0x050505, 0x050505, 0x050505, 0x050505, 0x050505, 0x050505, 0x000000, 0x000000, 0x1c1c1c, 0x464646, 0x4f4f4f, 0x232325, 0x060606, 0x000000, 0x010101, 0x020202, 0x020202, 0x020202, 0x030303, 0x020202, 0x030305, 0x030303, 0x060604, 0x010100, 0x000000, 0x000100, 0x0d0e10, 0x1d1e20, 0x1a1d24, 0x161a33, 0x111022, 0x252722, 0x625a2c, 0xbfae56, 0xfbf982, 0xfff780, 0xffe675, 0xffe576, 0xffe979, 0xfeed7b, 0xfff47e, 0xfff981, 0xfff981, 0xfff883, 0xfef880, 0xfcdb74, 0xa6954d, 0x463f23, 0x000100, 0x010005, 0x080c0f, 0x131313, 0x101010, 0x121212, 0x171717, 0x222222, 0x222222, 0x252525, 0x292b2a, 0x2f3130, 0x3c3e3d, 0x454746, 0x595b5a, 0x4a4c4b, 0x171717, 0x171719, 0x404042, 0x363638, 0x0b0b0b, 0x090909, 0x080808, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x000000, 0x030303, 0x000000, 0x010101, 0x010101, 0x010101, 0x020202, 0x000000, 0x000000, 0x030303, 0x030303, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x010101, 0x010101, 0x010101, 0x010101, 0x020202, 0x020202, 0x010101, 0x040404, 0x010103, 0x000002, 0x020003, 0x474127, 0xc1a55c, 0xffea80, 0xfef181, 0xfee980, 0xffe87e, 0xffee84, 0xffe780, 0xfed579, 0xf0c26d, 0xe3b963, 0xddba68, 0xb49952, 0x5d5433, 0x13150a, 0x010103, 0x030000, 0x000100, 0x000103, 0x050304, 0x020605, 0x040404, 0x050505, 0x050505, 0x040404, 0x060606, 0x040404, 0x050505, 0x050505, 0x000000, 0x000000, 0x101010, 0x424242, 0x595959, 0x323232, 0x000000, 0x000000, 0x1a1a1a, 0x0f0f0f, 0x000000, 0x010101, 0x030303, 0x020202, 0x010101, 0x020202, 0x030303, 0x030303, 0x030303, 0x030303, 0x050505, 0x050505, 0x000000, 0x000000, 0x000000, 0x111214, 0x242529, 0x262932, 0x03081c, 0x090810, 0x443f1f, 0x504726, 0x3b3320, 0x36301a, 0x3f391f, 0x4c4322, 0x63562a, 0x84703d, 0x927c43, 0x957d41, 0x72643d, 0x242215, 0x000200, 0x030000, 0x0b0c10, 0x121116, 0x11110f, 0x0f1110, 0x121212, 0x141414, 0x171717, 0x1a1a1a, 0x232323, 0x2f2f2f, 0x353535, 0x424242, 0x4f4f4d, 0x585a57, 0x585a59, 0x686a69, 0x3a3a3a, 0x121214, 0x48484a, 0x555557, 0x151515, 0x050505, 0x0d0d0d, 0x070707, 0x000000, 0x010101, 0x000000, 0x020202, 0x020202, 0x010101, 0x020202, 0x020202, 0x030303, 0x000000, 0x000000, 0x020202, 0x010101, 0x020202, 0x010101, 0x000000, 0x000000, 0x000000, 0x000000, 0x010101, 0x010101, 0x000000, 0x000000, 0x000000, 0x020202, 0x030303, 0x010101, 0x030303, 0x030303, 0x030504, 0x000000, 0x000103, 0x000200, 0x53452a, 0x998047, 0xba9753, 0xbe9851, 0xa08b4a, 0x5d512b, 0x291f15, 0x14110c, 0x050601, 0x060606, 0x000002, 0x010000, 0x000000, 0x020204, 0x050608, 0x050706, 0x050507, 0x060407, 0x060604, 0x040404, 0x060606, 0x050505, 0x050505, 0x050505, 0x070707, 0x000000, 0x000000, 0x0b0b0b, 0x3e3e3e, 0x585858, 0x444444, 0x070707, 0x000000, 0x010101, 0x000000, 0x292929, 0x282828, 0x141414, 0x000000, 0x030303, 0x010101, 0x010101, 0x020202, 0x010302, 0x030303, 0x030303, 0x030305, 0x050507, 0x040404, 0x060606, 0x070707, 0x040402, 0x000000, 0x010000, 0x050505, 0x232321, 0x32323a, 0x121328, 0x000100, 0x000000, 0x000000, 0x010103, 0x000002, 0x000100, 0x000100, 0x000100, 0x000000, 0x010000, 0x000100, 0x020403, 0x070908, 0x0a0a0a, 0x0d0c0a, 0x0e0e0e, 0x101012, 0x101010, 0x101010, 0x121212, 0x111111, 0x1a1a1a, 0x272727, 0x323232, 0x3d3d3d, 0x464644, 0x41413f, 0x3c3e3d, 0x424242, 0x2d2d2d, 0x171719, 0x2c2c2e, 0x383838, 0x131313, 0x030303, 0x060606, 0x0d0d0d, 0x070707, 0x000000, 0x030303, 0x000000, 0x010101, 0x010101, 0x000000, 0x020202, 0x000000, 0x000000, 0x070707, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x020202, 0x030303, 0x010101, 0x000000, 0x000000, 0x020202, 0x040404, 0x050505, 0x030303, 0x040404, 0x050304, 0x040603, 0x080607, 0x060608, 0x000000, 0x000100, 0x000100, 0x010000, 0x000100, 0x000002, 0x010000, 0x000100, 0x000100, 0x010101, 0x010000, 0x000105, 0x070707, 0x060405, 0x070707, 0x050706, 0x050503, 0x040406, 0x060709, 0x070707, 0x050505, 0x030303, 0x060606, 0x080808, 0x020202, 0x000000, 0x040404, 0x333333, 0x565656, 0x4b4b4b, 0x121212, 0x000000, 0x000000, 0x010101, 0x060606, 0x0c0c0c, 0x313131, 0x2e2e2e, 0x2f2f2f, 0x151515, 0x020202, 0x030303, 0x010101, 0x010101, 0x020202, 0x020202, 0x030303, 0x030303, 0x040402, 0x030301, 0x040402, 0x060604, 0x060405, 0x040500, 0x010204, 0x020001, 0x000000, 0x070c08, 0x302f35, 0x3e3f43, 0x2b2c2e, 0x000000, 0x020001, 0x080607, 0x0a0a0a, 0x070707, 0x060807, 0x050706, 0x070705, 0x050507, 0x030305, 0x010302, 0x030303, 0x040605, 0x070906, 0x0a0a0a, 0x0a0a0a, 0x0b0b0b, 0x0c0c0c, 0x0c0c0c, 0x090909, 0x090909, 0x0d0d0d, 0x0c0c0c, 0x0a0a08, 0x070705, 0x050505, 0x010101, 0x080808, 0x161616, 0x111111, 0x080808, 0x0a0a0a, 0x050505, 0x030303, 0x050505, 0x0d0d0d, 0x070707, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x000000, 0x040404, 0x3e3e3e, 0x343434, 0x020202, 0x000000, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x010101, 0x010101, 0x010101, 0x050505, 0x080808, 0x090909, 0x080808, 0x080808, 0x0c0c0c, 0x0b0b0b, 0x090b0a, 0x0a0a0a, 0x0b0b0b, 0x0b0b0b, 0x0c0a0d, 0x09090b, 0x000403, 0x000004, 0x000103, 0x040404, 0x060606, 0x060807, 0x08080a, 0x060608, 0x060805, 0x060606, 0x050608, 0x050706, 0x050505, 0x070508, 0x070506, 0x080705, 0x060407, 0x060606, 0x070707, 0x040404, 0x000000, 0x020202, 0x2a2a2a, 0x4e4e4e, 0x4f4f4f, 0x181818, 0x000000, 0x010101, 0x000000, 0x0a0a0a, 0x0b0b0b, 0x0f0f0f, 0x181818, 0x2f2f2f, 0x2a2a2a, 0x2f2f2f, 0x2a2a2a, 0x0e0e0e, 0x0b0b0b, 0x0b0b0b, 0x030303, 0x010000, 0x020202, 0x030303, 0x030303, 0x010101, 0x050505, 0x040406, 0x050507, 0x050507, 0x050304, 0x050304, 0x010103, 0x000000, 0x010002, 0x010000, 0x131313, 0x3e3e40, 0x454545, 0x151714, 0x010100, 0x090708, 0x070506, 0x080808, 0x0c0c0c, 0x060606, 0x050402, 0x040605, 0x040404, 0x040001, 0x000201, 0x020202, 0x050304, 0x0a0a0a, 0x0c0c0c, 0x0e0e0e, 0x141414, 0x121212, 0x111111, 0x0e0e0e, 0x131313, 0x1d1d1d, 0x181818, 0x1b1b1b, 0x252525, 0x2b2b2b, 0x323232, 0x313131, 0x1d1d1d, 0x070707, 0x030303, 0x040404, 0x020202, 0x050505, 0x0f0f0f, 0x111111, 0x040404, 0x000000, 0x000000, 0x000000, 0x0c0c0c, 0x3a3a3a, 0x4f5150, 0x262626, 0x101010, 0x010101, 0x010101, 0x020202, 0x030303, 0x020202, 0x020202, 0x020202, 0x000000, 0x010101, 0x020202, 0x040404, 0x060606, 0x060606, 0x050505, 0x060606, 0x080808, 0x080808, 0x070506, 0x060608, 0x070506, 0x070604, 0x060503, 0x050706, 0x040406, 0x040205, 0x050304, 0x050503, 0x080808, 0x090909, 0x070705, 0x070707, 0x040404, 0x030504, 0x060405, 0x050304, 0x050706, 0x040402, 0x050503, 0x040605, 0x080806, 0x060606, 0x000000, 0x000000, 0x242424, 0x505050, 0x4d4d4d, 0x1c1c1c, 0x010101, 0x000000, 0x000000, 0x060606, 0x0e0e0e, 0x111111, 0x151515, 0x191919, 0x262626, 0x1e1e1e, 0x232323, 0x1f1f1f, 0x2b2b2b, 0x242424, 0x0e0e0e, 0x121212, 0x111111, 0x030303, 0x000000, 0x020202, 0x020202, 0x030303, 0x020202, 0x030303, 0x030303, 0x020403, 0x030504, 0x070908, 0x030504, 0x010200, 0x020001, 0x010000, 0x000100, 0x000100, 0x242422, 0x444444, 0x232323, 0x000201, 0x0a0c0b, 0x121214, 0x131114, 0x0c0c0c, 0x0c0a0b, 0x111113, 0x161415, 0x181816, 0x1a1a1c, 0x201f24, 0x2b2d2c, 0x353535, 0x373737, 0x3e3e3e, 0x4a4a4a, 0x505050, 0x545454, 0x59595b, 0x656567, 0x6e6e70, 0x6a6a6c, 0x6a6a6a, 0x707070, 0x686868, 0x535353, 0x434343, 0x2b2d2c, 0x101010, 0x020202, 0x040404, 0x040404, 0x030303, 0x080808, 0x121212, 0x131313, 0x0b0b0b, 0x090909, 0x101010, 0x252525, 0x3a3a3a, 0x262626, 0x171717, 0x141414, 0x070707, 0x020202, 0x000000, 0x010101, 0x010101, 0x010101, 0x010101, 0x000000, 0x040404, 0x040404, 0x020202, 0x020202, 0x020202, 0x040404, 0x040404, 0x030303, 0x030502, 0x010302, 0x030504, 0x010504, 0x040406, 0x030303, 0x040301, 0x030102, 0x060604, 0x0a0809, 0x0d0b0c, 0x0c0c0c, 0x060807, 0x060606, 0x070705, 0x050505, 0x060407, 0x060606, 0x060606, 0x060405, 0x070709, 0x08080a, 0x060608, 0x000000, 0x000000, 0x1c1c1c, 0x474747, 0x5b5b5b, 0x292929, 0x000000, 0x010101, 0x000000, 0x000000, 0x0c0c0c, 0x131313, 0x141414, 0x131313, 0x171717, 0x1f1f1f, 0x262626, 0x070707, 0x0e0e0e, 0x121212, 0x171717, 0x252525, 0x1b1b1b, 0x0d0d0d, 0x141414, 0x151515, 0x0a0a0a, 0x010103, 0x000103, 0x020204, 0x020202, 0x020202, 0x020202, 0x040203, 0x050503, 0x060503, 0x090708, 0x050507, 0x030301, 0x000000, 0x010000, 0x010000, 0x010002, 0x0a0a0c, 0x3d3d3f, 0x282828, 0x070705, 0x141613, 0x161817, 0x151716, 0x202020, 0x222224, 0x262827, 0x303433, 0x383838, 0x3b3d3a, 0x414340, 0x454547, 0x515151, 0x585858, 0x626262, 0x6e6e6e, 0x777779, 0x828186, 0x7b7a7f, 0x7f7e83, 0x858587, 0x818183, 0x7a7a7a, 0x6c6c6c, 0x515151, 0x303231, 0x252726, 0x161616, 0x050505, 0x040404, 0x040404, 0x050505, 0x070707, 0x0a0a0a, 0x0e0e0e, 0x101010, 0x0d0d0d, 0x131313, 0x1c1c1c, 0x212121, 0x1d1d1d, 0x1d1d1d, 0x131313, 0x111111, 0x090909, 0x020202, 0x000000, 0x020202, 0x020202, 0x010101, 0x020202, 0x050505, 0x050505, 0x030303, 0x030303, 0x040404, 0x040404, 0x040404, 0x040404, 0x030303, 0x050306, 0x060608, 0x060405, 0x040402, 0x010101, 0x020202, 0x0d0d0b, 0x11110f, 0x0d0e10, 0x0d0e10, 0x0b0b0b, 0x080607, 0x060407, 0x040406, 0x060503, 0x050601, 0x050706, 0x070709, 0x060606, 0x050704, 0x010100, 0x010000, 0x1d1d1d, 0x424242, 0x4c4c4c, 0x2d2d2d, 0x070707, 0x000000, 0x000000, 0x020202, 0x040404, 0x0c0c0c, 0x151515, 0x141414, 0x101010, 0x101010, 0x121212, 0x101010, 0x0f0f0f, 0x020202, 0x010101, 0x040404, 0x040404, 0x090909, 0x111111, 0x111111, 0x0d0d0d, 0x161616, 0x181818, 0x0b0b0b, 0x050505, 0x040404, 0x010101, 0x020202, 0x020202, 0x030303, 0x030303, 0x020202, 0x050505, 0x070707, 0x080808, 0x030303, 0x000000, 0x000000, 0x020202, 0x000000, 0x010101, 0x343434, 0x333333, 0x090909, 0x111111, 0x1a1a1a, 0x212121, 0x232323, 0x212121, 0x262626, 0x2a2a2a, 0x232323, 0x242424, 0x2a2a2c, 0x353535, 0x3f3f3f, 0x474747, 0x565656, 0x636363, 0x6f6f6f, 0x707072, 0x6d6b6c, 0x6b6b6d, 0x626763, 0x5b5d5c, 0x535351, 0x3d383c, 0x272528, 0x1a1c1b, 0x121315, 0x0e0e0e, 0x070908, 0x040404, 0x070506, 0x060606, 0x090708, 0x080806, 0x0a0a0a, 0x090b0a, 0x151515, 0x1c1c1c, 0x191b1a, 0x161618, 0x131514, 0x111310, 0x100b0f, 0x080c0b, 0x070707, 0x020204, 0x010101, 0x020200, 0x020401, 0x050306, 0x040404, 0x040404, 0x040404, 0x040404, 0x030303, 0x040404, 0x050505, 0x040404, 0x050505, 0x040404, 0x040404, 0x040404, 0x020202, 0x070707, 0x111111, 0x151515, 0x151515, 0x0f0f0f, 0x0c0c0c, 0x0b0b0b, 0x080808, 0x040404, 0x050505, 0x060606, 0x060606, 0x060606, 0x050505, 0x010101, 0x000000, 0x1b1b1b, 0x484848, 0x515153, 0x282828, 0x010101, 0x000000, 0x000000, 0x030303, 0x040404, 0x070707, 0x0c0c0c, 0x101010, 0x0f0f0f, 0x0b0b0b, 0x060606, 0x050505, 0x050505, 0x040404, 0x010101, 0x020202, 0x020202, 0x020202, 0x000000, 0x000000, 0x030303, 0x070707, 0x080808, 0x0c0c0c, 0x131313, 0x151515, 0x0e0e0e, 0x080808, 0x050505, 0x010101, 0x020202, 0x010101, 0x020202, 0x020202, 0x020202, 0x040404, 0x090909, 0x080808, 0x030303, 0x000000, 0x000000, 0x010101, 0x010101, 0x000000, 0x272727, 0x2b2b2b, 0x030303, 0x090909, 0x151515, 0x111111, 0x0f0f0f, 0x121212, 0x121212, 0x131313, 0x0f0f0f, 0x101010, 0x0d0d0d, 0x070707, 0x101010, 0x181818, 0x262626, 0x373737, 0x404040, 0x424242, 0x3c3c3c, 0x343233, 0x3a383b, 0x323232, 0x20201e, 0x171b1a, 0x141414, 0x141416, 0x131311, 0x090b0a, 0x030504, 0x08080a, 0x0c0a0d, 0x0d0d0d, 0x0e0f11, 0x0f0f0f, 0x0d0f0c, 0x151314, 0x171719, 0x11110f, 0x0f0b0c, 0x09070a, 0x0b0708, 0x080a07, 0x080609, 0x090907, 0x070709, 0x020202, 0x030102, 0x060405, 0x040406, 0x040404, 0x040404, 0x030303, 0x040404, 0x030303, 0x040404, 0x040404, 0x040404, 0x050505, 0x040404, 0x050505, 0x020202, 0x090909, 0x181818, 0x161616, 0x141414, 0x121212, 0x101010, 0x0c0c0c, 0x090909, 0x060606, 0x060606, 0x050505, 0x050505, 0x000000, 0x000000, 0x000000, 0x1b1b1b, 0x3e3e3e, 0x4e4e4e, 0x343434, 0x040404, 0x000000, 0x000000, 0x020202, 0x050505, 0x050505, 0x050505, 0x080808, 0x0a0a0a, 0x080808, 0x040404, 0x010101, 0x020202, 0x030303, 0x020202, 0x010101, 0x010101, 0x010101, 0x020202, 0x010101, 0x030303, 0x030303, 0x010101, 0x020202, 0x010101, 0x030303, 0x080808, 0x131313, 0x121212, 0x080808, 0x080808, 0x080808, 0x030303, 0x010101, 0x010101, 0x040404, 0x030303, 0x020202, 0x020202, 0x050505, 0x060606, 0x020202, 0x000000, 0x000000, 0x010101, 0x010101, 0x010101, 0x1c1c1c, 0x2c2c2c, 0x040404, 0x010101, 0x141414, 0x222222, 0x303030, 0x3b3b3b, 0x414141, 0x434343, 0x3f3f3f, 0x353535, 0x262626, 0x1b1b1b, 0x0c0c0c, 0x020202, 0x090909, 0x151515, 0x1e1e1e, 0x242321, 0x212322, 0x20201e, 0x1d1d1b, 0x181c1d, 0x161616, 0x0e0e10, 0x0f0f0d, 0x171918, 0x15161b, 0x020b12, 0x00010e, 0x00010e, 0x030014, 0x000211, 0x010012, 0x01000e, 0x01000e, 0x00010e, 0x00020f, 0x00060c, 0x0f1314, 0x0c0c0c, 0x040406, 0x050608, 0x050400, 0x0a0a08, 0x09070a, 0x030207, 0x040402, 0x030406, 0x040404, 0x040404, 0x050505, 0x030303, 0x040404, 0x040404, 0x050505, 0x040404, 0x040404, 0x060606, 0x020202, 0x101010, 0x202020, 0x222222, 0x1f1f1f, 0x1d1d1d, 0x151515, 0x0d0d0d, 0x090909, 0x0d0d0d, 0x060606, 0x010101, 0x000000, 0x000000, 0x101010, 0x303030, 0x4b4b4b, 0x4d4d4d, 0x2b2b2b, 0x010101, 0x000000, 0x000000, 0x040404, 0x030303, 0x030303, 0x050505, 0x030303, 0x050505, 0x040404, 0x030303, 0x010101, 0x010101, 0x020202, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x000000, 0x020202, 0x020202, 0x010101, 0x020202, 0x020202, 0x010101, 0x000000, 0x040404, 0x0e0e0e, 0x0c0c0c, 0x070707, 0x060606, 0x050505, 0x040404, 0x030303, 0x030303, 0x020202, 0x030303, 0x020202, 0x020202, 0x030303, 0x040404, 0x020202, 0x000000, 0x000000, 0x010101, 0x010101, 0x010101, 0x202020, 0x303030, 0x030303, 0x202020, 0x464646, 0x474747, 0x404040, 0x363636, 0x343434, 0x2a2a2a, 0x2b2b2b, 0x2f2f2f, 0x353535, 0x434343, 0x434343, 0x252525, 0x131313, 0x1b1b19, 0x262425, 0x232426, 0x21201e, 0x1e1e1e, 0x0e100f, 0x141416, 0x232728, 0x15212f, 0x051127, 0x070b16, 0x251611, 0x412710, 0x503115, 0x5e3d10, 0x6b4312, 0x724714, 0x6b460f, 0x5e3b11, 0x513416, 0x392210, 0x151112, 0x000317, 0x010119, 0x0c1019, 0x0f0b08, 0x060709, 0x070304, 0x090907, 0x050608, 0x050304, 0x050507, 0x050505, 0x050505, 0x030303, 0x020202, 0x030303, 0x030303, 0x010101, 0x030303, 0x050505, 0x010101, 0x181818, 0x2b2b2b, 0x2b2b2b, 0x222222, 0x1e1e1e, 0x1a1a1a, 0x111111, 0x0b0b0b, 0x020202, 0x000000, 0x040404, 0x181818, 0x343434, 0x3e3e3e, 0x464646, 0x454545, 0x2e2e2e, 0x010101, 0x000000, 0x000000, 0x020202, 0x030303, 0x050505, 0x040404, 0x030303, 0x010101, 0x020202, 0x030303, 0x020202, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x000000, 0x010101, 0x000000, 0x000000, 0x010101, 0x020202, 0x010101, 0x020202, 0x000000, 0x010101, 0x060606, 0x080808, 0x060606, 0x060606, 0x030303, 0x030303, 0x030303, 0x030303, 0x020202, 0x030303, 0x020202, 0x020202, 0x030303, 0x020202, 0x000000, 0x000000, 0x000000, 0x020202, 0x020202, 0x000000, 0x212121, 0x303030, 0x020202, 0x010101, 0x010101, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x030303, 0x050505, 0x101010, 0x2a2a2a, 0x444444, 0x3f3f3f, 0x242426, 0x242625, 0x232522, 0x151517, 0x0c0b09, 0x2f3336, 0x121f30, 0x151a2d, 0x422b19, 0x8c5103, 0xcc860c, 0xeb9e1a, 0xfca91b, 0xffaf1b, 0xffb611, 0xfebd19, 0xffb913, 0xffc00e, 0xfdbb1e, 0xfdb71b, 0xfeaa24, 0xf7a71e, 0xbf8313, 0x674917, 0x19181d, 0x01011b, 0x0a0e19, 0x0d0c0a, 0x020605, 0x050608, 0x050402, 0x050304, 0x050505, 0x040404, 0x020202, 0x000000, 0x030303, 0x000000, 0x010101, 0x060606, 0x000000, 0x171717, 0x2f2f2f, 0x252525, 0x242424, 0x202020, 0x151515, 0x070707, 0x000000, 0x121212, 0x2c2c2c, 0x3b3b3b, 0x4a4a4a, 0x4d4d4d, 0x3f3f3f, 0x222222, 0x080808, 0x000000, 0x000000, 0x000000, 0x030303, 0x020202, 0x020202, 0x030303, 0x030303, 0x020202, 0x000000, 0x010101, 0x030303, 0x000000, 0x010101, 0x010101, 0x020202, 0x010101, 0x000000, 0x010101, 0x020202, 0x010101, 0x010101, 0x010101, 0x020202, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x040404, 0x050505, 0x040404, 0x030303, 0x010101, 0x010101, 0x030303, 0x020202, 0x030303, 0x030303, 0x020202, 0x030303, 0x020202, 0x020202, 0x000000, 0x000000, 0x000000, 0x040404, 0x010101, 0x000000, 0x202020, 0x2f2f2f, 0x000000, 0x010101, 0x121212, 0x121212, 0x191919, 0x202020, 0x212121, 0x212121, 0x1e201f, 0x161817, 0x070707, 0x030303, 0x2e2e2e, 0x3d3d3d, 0x28282a, 0x060606, 0x21201e, 0x4a545e, 0x1a293e, 0x4c2909, 0xbf7200, 0xfecb20, 0xfed138, 0xd9a128, 0xfbb519, 0xfebf1c, 0xfbb812, 0xeec142, 0xffca29, 0xffdb2f, 0xfec746, 0xf3b114, 0xfbb30f, 0xffcd46, 0xd6a13b, 0xfdb60e, 0xffed27, 0xf6af19, 0x755719, 0x0c0e1a, 0x020822, 0x0f0f0f, 0x020202, 0x060606, 0x030301, 0x030303, 0x010101, 0x020202, 0x030303, 0x000000, 0x040404, 0x060606, 0x000000, 0x181617, 0x2d2b2c, 0x272526, 0x1f1d1e, 0x121212, 0x090909, 0x161616, 0x2e2e2e, 0x414141, 0x4e4e4e, 0x444444, 0x2d2d2d, 0x1c1c1c, 0x030303, 0x000000, 0x000000, 0x000000, 0x020202, 0x030303, 0x020202, 0x010101, 0x020202, 0x020202, 0x020202, 0x010101, 0x000000, 0x020202, 0x010101, 0x000000, 0x020202, 0x010101, 0x010101, 0x000000, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x020202, 0x020202, 0x010101, 0x010101, 0x000000, 0x000000, 0x010101, 0x010101, 0x000000, 0x020202, 0x000000, 0x010101, 0x010101, 0x000000, 0x020202, 0x020202, 0x030303, 0x020202, 0x010101, 0x000000, 0x010101, 0x030303, 0x040404, 0x030303, 0x020202, 0x030303, 0x020202, 0x000000, 0x000000, 0x000000, 0x010101, 0x030303, 0x010101, 0x000000, 0x222222, 0x303030, 0x060606, 0x0e0e0e, 0x1d1d1d, 0x262626, 0x2e2e2e, 0x373737, 0x3c3e3d, 0x3a3c3b, 0x2b2d2c, 0x212322, 0x161616, 0x010101, 0x303030, 0x1b1b1b, 0x50514c, 0x8592a5, 0x38303b, 0x8d4700, 0xffd328, 0xffdb4e, 0x928139, 0x202924, 0x83551a, 0xf7bb1f, 0xf9b923, 0xffbf17, 0xc1a156, 0x7e6431, 0x9d8d42, 0x987b43, 0xfab414, 0xf7b523, 0xfcbb19, 0xc89d2a, 0x282514, 0x78560e, 0xfdb918, 0xffef19, 0xd1a218, 0x2e2516, 0x02031f, 0x101010, 0x040404, 0x040404, 0x010101, 0x020202, 0x010101, 0x010101, 0x060606, 0x0a0a0a, 0x010101, 0x1b1b1b, 0x2f2d2e, 0x252324, 0x161616, 0x191919, 0x343434, 0x454545, 0x484848, 0x414141, 0x323232, 0x101010, 0x000000, 0x000000, 0x000000, 0x000000, 0x030303, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x000000, 0x010101, 0x020202, 0x010101, 0x010101, 0x000000, 0x010101, 0x000000, 0x010101, 0x010101, 0x010101, 0x000000, 0x000000, 0x010101, 0x020202, 0x020202, 0x010101, 0x020202, 0x030303, 0x010101, 0x010101, 0x010101, 0x010101, 0x020202, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x020202, 0x010101, 0x010101, 0x010101, 0x020202, 0x020202, 0x000000, 0x010101, 0x000000, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x000000, 0x000000, 0x000000, 0x000000, 0x030303, 0x030303, 0x000000, 0x000000, 0x1c1c1c, 0x1e1e1e, 0x080808, 0x141414, 0x242424, 0x323232, 0x404241, 0x4d4f4e, 0x565855, 0x464845, 0x2c2e2d, 0x1e201f, 0x101010, 0x131313, 0x322e2f, 0xa1aebe, 0x5c534e, 0xba6c00, 0xfef862, 0x9d965f, 0x132330, 0x000100, 0x1e0701, 0xfcba1d, 0xffc11e, 0xf3b31d, 0xffcd1e, 0xb39650, 0x00000c, 0x000000, 0x4e2900, 0xfcc625, 0xf6b920, 0xf3ab19, 0xffdb17, 0x867235, 0x000000, 0x0e0905, 0x90600e, 0xffde1d, 0xffd11b, 0x4d3318, 0x00011a, 0x0b0d0c, 0x020202, 0x020202, 0x020202, 0x000000, 0x080808, 0x060606, 0x000000, 0x212121, 0x303030, 0x1e1c1d, 0x222021, 0x353535, 0x4e4e4e, 0x505050, 0x323232, 0x0d0d0d, 0x000000, 0x000000, 0x000000, 0x020202, 0x030303, 0x010101, 0x020202, 0x020202, 0x030303, 0x020202, 0x020202, 0x010101, 0x010101, 0x020202, 0x010101, 0x000000, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x020202, 0x000000, 0x010101, 0x000000, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x030303, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x020202, 0x020202, 0x020202, 0x010101, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x010101, 0x020202, 0x010101, 0x000000, 0x010101, 0x030303, 0x010101, 0x000000, 0x010101, 0x000000, 0x080808, 0x131313, 0x0e0e0e, 0x0c0c0c, 0x131313, 0x202020, 0x262626, 0x303030, 0x414141, 0x404040, 0x252525, 0x131313, 0x070508, 0x565d65, 0x323337, 0xbc6601, 0xfffd9c, 0x707e87, 0x000000, 0x000000, 0x000000, 0x1d1101, 0xf5a51a, 0xfedc22, 0xffab0a, 0xffe73c, 0x908359, 0x000100, 0x000100, 0x261209, 0xfdbb1e, 0xfec714, 0xfebe04, 0xffff81, 0x7b7461, 0x000000, 0x010000, 0x000100, 0x4d2c0b, 0xffc71b, 0xfed929, 0x332e1b, 0x00020f, 0x050706, 0x000000, 0x000000, 0x090909, 0x070707, 0x070707, 0x222222, 0x272727, 0x303030, 0x3c3c3c, 0x3d3d3d, 0x373737, 0x1c1c1c, 0x010101, 0x000000, 0x000000, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x010101, 0x020202, 0x020202, 0x020202, 0x020202, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x030303, 0x010101, 0x000000, 0x000000, 0x010101, 0x010101, 0x010101, 0x010101, 0x000000, 0x010101, 0x000000, 0x000000, 0x000000, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x020202, 0x020202, 0x010101, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x010101, 0x010101, 0x000000, 0x000000, 0x020202, 0x030303, 0x030303, 0x000000, 0x010101, 0x000000, 0x010101, 0x070707, 0x050505, 0x030303, 0x000000, 0x000000, 0x040404, 0x1a1a1a, 0x2f2f2f, 0x272727, 0x0b0b0b, 0x2b2b29, 0x203246, 0x7b3501, 0xfff152, 0x807e71, 0x010300, 0x000002, 0x020003, 0x020001, 0x000002, 0x231709, 0xb28a18, 0xffc51c, 0xe4c666, 0x2b292e, 0x010103, 0x000000, 0x000000, 0x8e5a0e, 0xf2c029, 0xd0b447, 0x6e6f6a, 0x000519, 0x000000, 0x000000, 0x000201, 0x000000, 0x4f2b07, 0xffe526, 0xc99d30, 0x01000e, 0x040308, 0x000000, 0x0a0a0a, 0x050505, 0x0a0a0a, 0x2e2e2e, 0x373737, 0x3b3b3b, 0x3e3e3e, 0x2d2d2d, 0x080808, 0x000000, 0x000000, 0x000000, 0x020202, 0x030303, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x000000, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x030303, 0x040404, 0x030303, 0x020202, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x000000, 0x000000, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x000000, 0x000000, 0x000000, 0x010101, 0x010101, 0x010101, 0x010101, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x010101, 0x030303, 0x030303, 0x040404, 0x010101, 0x000000, 0x000000, 0x000000, 0x010101, 0x030303, 0x0a0a0a, 0x0a0a0a, 0x010101, 0x000000, 0x0b0b0b, 0x212121, 0x0d0d0d, 0x222834, 0x322e2f, 0xec8c04, 0xe1bc52, 0x020109, 0x010002, 0x010204, 0x030301, 0x030104, 0x020202, 0x000002, 0x010100, 0x222617, 0x0e0f13, 0x020001, 0x000100, 0x020100, 0x010002, 0x000100, 0x131114, 0x000316, 0x000000, 0x000200, 0x010002, 0x020003, 0x000002, 0x000100, 0x000000, 0xbd710f, 0xffde39, 0x2c2a1e, 0x000103, 0x000000, 0x000000, 0x1a1a1a, 0x3e3e3e, 0x3f3f3f, 0x383838, 0x292929, 0x030305, 0x000000, 0x000000, 0x020202, 0x020202, 0x030303, 0x020202, 0x010101, 0x020202, 0x030303, 0x030303, 0x020202, 0x020202, 0x030303, 0x030303, 0x020202, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x020202, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x060606, 0x080808, 0x080808, 0x050505, 0x030303, 0x020202, 0x020202, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x020202, 0x010101, 0x010101, 0x000000, 0x000000, 0x010101, 0x020202, 0x020202, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x010101, 0x030303, 0x070707, 0x040404, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x141414, 0x272727, 0x0b0b0b, 0x010101, 0x0a0a0a, 0x121212, 0x010d1d, 0x4b2f17, 0xffc621, 0x9c7e38, 0x000000, 0x000002, 0x000100, 0x000100, 0x020204, 0x000200, 0x020100, 0x010000, 0x000103, 0x000002, 0x000000, 0x010101, 0x010103, 0x000103, 0x000000, 0x000100, 0x000000, 0x020005, 0x000000, 0x000000, 0x000201, 0x000000, 0x000000, 0x010000, 0x572c00, 0xffe742, 0x676238, 0x010000, 0x0e0e0e, 0x333333, 0x434343, 0x2f2f2f, 0x1c1c1c, 0x050505, 0x000000, 0x000000, 0x020202, 0x030303, 0x020202, 0x030303, 0x010101, 0x010101, 0x020202, 0x020202, 0x030303, 0x030303, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x020202, 0x020202, 0x020202, 0x010101, 0x010101, 0x010101, 0x020202, 0x030303, 0x040404, 0x050505, 0x050505, 0x040404, 0x020202, 0x020202, 0x020202, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x000000, 0x000000, 0x010101, 0x010101, 0x020202, 0x020202, 0x010101, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x020202, 0x020202, 0x080808, 0x070707, 0x040404, 0x020202, 0x030303, 0x030303, 0x020202, 0x010101, 0x020202, 0x161616, 0x232323, 0x0a0a0a, 0x000000, 0x060606, 0x010415, 0x493115, 0xffcb20, 0x8f7835, 0x000002, 0x000105, 0x160e0c, 0x050001, 0x000102, 0x030200, 0x000201, 0x000105, 0x030303, 0x050503, 0x000000, 0x000002, 0x020202, 0x010100, 0x000103, 0x030102, 0x020001, 0x010100, 0x040404, 0x010101, 0x000002, 0x000100, 0x020003, 0x010002, 0x4d2b00, 0xffe341, 0x7c753f, 0x000000, 0x131313, 0x222222, 0x090909, 0x010101, 0x000000, 0x010101, 0x020202, 0x020202, 0x030303, 0x030303, 0x030303, 0x010101, 0x030303, 0x020202, 0x010101, 0x010101, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x010101, 0x010101, 0x020202, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x020202, 0x020202, 0x030303, 0x020202, 0x010101, 0x020202, 0x030303, 0x030303, 0x020202, 0x020202, 0x020202, 0x020202, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x000000, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x000000, 0x000000, 0x010101, 0x010101, 0x010101, 0x020202, 0x020202, 0x000000, 0x000000, 0x000000, 0x010101, 0x010101, 0x0d0d0d, 0x0d0d0d, 0x060606, 0x040404, 0x000000, 0x030303, 0x020202, 0x030303, 0x010101, 0x000000, 0x050505, 0x0b0b0b, 0x000000, 0x000000, 0x000511, 0x30231a, 0xffb317, 0xc1912b, 0x01010b, 0x3b230b, 0xefa214, 0xd9a22b, 0x292421, 0x010101, 0x000007, 0x020003, 0x000002, 0x090909, 0x050503, 0x000200, 0x010002, 0x000201, 0x040301, 0x010000, 0x000000, 0x000200, 0x000105, 0x000009, 0x56340e, 0xc49016, 0x8b5d10, 0x000103, 0x532900, 0xfee749, 0x51533e, 0x000002, 0x000000, 0x000000, 0x000000, 0x010101, 0x010101, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x010101, 0x010101, 0x000000, 0x010101, 0x020202, 0x010101, 0x010101, 0x010101, 0x020202, 0x020202, 0x010101, 0x010101, 0x010101, 0x010101, 0x020202, 0x030303, 0x020202, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x010101, 0x010101, 0x020202, 0x020202, 0x010101, 0x010101, 0x020202, 0x020202, 0x020202, 0x030303, 0x030303, 0x020202, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x000000, 0x000000, 0x000000, 0x010101, 0x030303, 0x030303, 0x020202, 0x000000, 0x000000, 0x020202, 0x000000, 0x0c0c0c, 0x141414, 0x0c0c0c, 0x090909, 0x070707, 0x030303, 0x030303, 0x010101, 0x020202, 0x020202, 0x010101, 0x000000, 0x020202, 0x000000, 0x040205, 0x0b0e1d, 0xd58313, 0xffd425, 0x010818, 0x895a12, 0xfecc15, 0xffe029, 0x9b9062, 0x00000c, 0x59330c, 0x513f0d, 0x000000, 0x020204, 0x0d090a, 0x020204, 0x030303, 0x040605, 0x010101, 0x000000, 0x0f0307, 0x543e0c, 0x15100a, 0x28160c, 0xffbd21, 0xffd308, 0xfed641, 0x03051e, 0xac6203, 0xffd55c, 0x060f16, 0x000000, 0x020202, 0x030303, 0x020202, 0x010101, 0x020202, 0x020202, 0x020202, 0x010101, 0x010101, 0x020202, 0x000000, 0x020202, 0x010101, 0x010101, 0x000000, 0x010101, 0x010101, 0x020202, 0x020202, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x020202, 0x030303, 0x020202, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x030303, 0x020202, 0x010101, 0x020202, 0x040404, 0x030303, 0x020202, 0x020202, 0x020202, 0x010101, 0x020202, 0x030303, 0x040404, 0x040404, 0x030303, 0x000000, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x000000, 0x000000, 0x010101, 0x020202, 0x010101, 0x000000, 0x010101, 0x010101, 0x0a0a0a, 0x161616, 0x121212, 0x0d0d0d, 0x0c0c0c, 0x090909, 0x080808, 0x060606, 0x040404, 0x020202, 0x010101, 0x020202, 0x000000, 0x000000, 0x000000, 0x00051b, 0x5a3d1d, 0xffda1b, 0x927a18, 0x512f13, 0xffc121, 0xf8bc1d, 0xd6a838, 0xc58722, 0xffbf1b, 0xfed521, 0xa47e1b, 0x05040a, 0x040507, 0x010302, 0x020403, 0x090506, 0x010000, 0x32200a, 0xe79a18, 0xffc91e, 0xeaac25, 0xce9224, 0xfeb91e, 0xfdc915, 0xa19759, 0x451e00, 0xfced4a, 0x6c654b, 0x010000, 0x020202, 0x030303, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x000000, 0x030303, 0x000000, 0x020202, 0x010101, 0x010101, 0x010101, 0x010101, 0x020202, 0x020202, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x030303, 0x020202, 0x010101, 0x010101, 0x010101, 0x020202, 0x030303, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x030303, 0x020202, 0x020202, 0x020202, 0x020202, 0x040404, 0x050505, 0x020202, 0x040404, 0x050505, 0x040404, 0x060606, 0x040404, 0x010101, 0x030303, 0x050505, 0x030303, 0x030303, 0x040404, 0x020202, 0x020202, 0x020202, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x020202, 0x010101, 0x000000, 0x000000, 0x010101, 0x010101, 0x010101, 0x020202, 0x000000, 0x090909, 0x1c1c1c, 0x161616, 0x111111, 0x0f0f0f, 0x0d0d0d, 0x0e0e0e, 0x0b0b0b, 0x0a0a0a, 0x090909, 0x070707, 0x040404, 0x010101, 0x020202, 0x020204, 0x000201, 0x030a24, 0x7c4d15, 0xffe220, 0x967317, 0xb47822, 0xf9bf2f, 0xfcbf26, 0xffc525, 0xf5bc2d, 0xffb514, 0xfed94a, 0x16232b, 0x000100, 0x0a0a08, 0x030301, 0x010103, 0x000100, 0x845310, 0xffde2a, 0xf7b523, 0xffc32a, 0xfec627, 0xfab31b, 0xd6bf61, 0x74501c, 0xfece48, 0xb7ad7a, 0x020008, 0x000200, 0x020200, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x030303, 0x020202, 0x010101, 0x020202, 0x030303, 0x020202, 0x020202, 0x020202, 0x030303, 0x020202, 0x010101, 0x010101, 0x010101, 0x010101, 0x000000, 0x020202, 0x020202, 0x020202, 0x020202, 0x010101, 0x010101, 0x020202, 0x020202, 0x040404, 0x020202, 0x020202, 0x030303, 0x030303, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x030303, 0x020202, 0x030303, 0x020202, 0x020202, 0x040404, 0x050505, 0x040404, 0x030303, 0x030303, 0x050505, 0x050505, 0x040404, 0x030303, 0x020202, 0x050505, 0x060606, 0x030303, 0x010101, 0x010101, 0x020202, 0x030303, 0x020202, 0x020202, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x000000, 0x000000, 0x010101, 0x010101, 0x010101, 0x010101, 0x0b0b0b, 0x212121, 0x1f1f1f, 0x181818, 0x161616, 0x121212, 0x111111, 0x0d0d0d, 0x0c0c0c, 0x0d0d0d, 0x0c0c0c, 0x0c0c0c, 0x0c0c0c, 0x0c0c0c, 0x0b0b09, 0x040205, 0x000308, 0x00011a, 0x714812, 0xfdce1e, 0xf0b422, 0xefa925, 0xf2bc3e, 0xefba2e, 0xf2bb2d, 0xfdbf20, 0xdfb142, 0x4f392b, 0x1f100b, 0x010004, 0x000105, 0x010002, 0x3a220a, 0xae7619, 0xf9cc29, 0xf3b929, 0xf4bf31, 0xf1b324, 0xfbb61d, 0xd2a138, 0xffd06e, 0xbec6ae, 0x01000e, 0x000000, 0x020001, 0x020106, 0x020202, 0x020202, 0x020202, 0x020202, 0x030303, 0x030303, 0x040404, 0x030303, 0x020202, 0x030303, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x010101, 0x020202, 0x020202, 0x020202, 0x010101, 0x010101, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x030303, 0x020202, 0x020202, 0x030303, 0x020202, 0x020202, 0x030303, 0x020202, 0x010101, 0x020202, 0x030303, 0x020202, 0x020202, 0x020202, 0x030303, 0x040404, 0x030303, 0x020202, 0x020202, 0x030303, 0x030303, 0x020202, 0x040404, 0x030303, 0x030303, 0x050505, 0x040404, 0x040404, 0x050505, 0x050505, 0x050505, 0x030303, 0x040404, 0x050505, 0x030303, 0x020202, 0x030303, 0x020202, 0x020202, 0x020202, 0x020202, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x040404, 0x000000, 0x0a0a0a, 0x252525, 0x2b2b2d, 0x272729, 0x262626, 0x222222, 0x212121, 0x1b1b1b, 0x19191b, 0x19191b, 0x1a1a1a, 0x1b1b1b, 0x1c1c1c, 0x1a1a1c, 0x1a181b, 0x181914, 0x0a0a0a, 0x000004, 0x000005, 0x3a2510, 0xdca01c, 0xfed022, 0xffcb2a, 0xf4b627, 0xeeb424, 0xf2b72d, 0xe8aa21, 0xffb11b, 0xf5b91b, 0x473d1a, 0x09040b, 0xc78318, 0xfdc125, 0xfdb92a, 0xf4b228, 0xf5b327, 0xf2b123, 0xffb812, 0xffda2f, 0xfdd454, 0x787c6e, 0x02000a, 0x000002, 0x010302, 0x010302, 0x020204, 0x020202, 0x020202, 0x030303, 0x040404, 0x050505, 0x040404, 0x040404, 0x030303, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x030303, 0x020202, 0x020202, 0x010101, 0x010101, 0x010101, 0x010101, 0x020202, 0x020202, 0x030303, 0x020202, 0x020202, 0x040404, 0x030303, 0x020202, 0x030303, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x030303, 0x020202, 0x020202, 0x030303, 0x040404, 0x050505, 0x050505, 0x050505, 0x040404, 0x030303, 0x020202, 0x020202, 0x020202, 0x040404, 0x030303, 0x050505, 0x050505, 0x040404, 0x050505, 0x040404, 0x040404, 0x040404, 0x030303, 0x030303, 0x020202, 0x020202, 0x030303, 0x020202, 0x020202, 0x030303, 0x020202, 0x020202, 0x020202, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x020202, 0x000000, 0x0a0a0a, 0x29292b, 0x343436, 0x2a2a2c, 0x262628, 0x2b2b2d, 0x272729, 0x252527, 0x262628, 0x29292b, 0x29292b, 0x2a2a2c, 0x2b2b2d, 0x2b2b2d, 0x2b2a2f, 0x28292b, 0x2b2a26, 0x191816, 0x030504, 0x010006, 0x01000c, 0x7c5a1a, 0xd2981a, 0xffbd1e, 0xffd227, 0xfec925, 0xfdbf1e, 0xfebc1d, 0xfdca0d, 0xd7ae44, 0x9a7034, 0xfdcc17, 0xffb71a, 0xfeba19, 0xffbd1e, 0xffcf1d, 0xffd630, 0xf1c54a, 0x99945c, 0x212733, 0x000002, 0x010002, 0x020200, 0x030102, 0x020202, 0x020200, 0x050505, 0x050505, 0x050505, 0x050505, 0x040404, 0x040404, 0x040404, 0x040404, 0x030303, 0x020202, 0x020202, 0x020202, 0x020202, 0x030303, 0x030303, 0x020202, 0x030303, 0x020202, 0x010101, 0x020202, 0x020202, 0x030303, 0x030303, 0x020202, 0x030303, 0x020202, 0x030303, 0x030303, 0x020202, 0x020202, 0x020202, 0x030303, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x030303, 0x040404, 0x040404, 0x030303, 0x030303, 0x040404, 0x060606, 0x050505, 0x030303, 0x030303, 0x070707, 0x0a0a0a, 0x070707, 0x050505, 0x050505, 0x050505, 0x040404, 0x030303, 0x030303, 0x040404, 0x030303, 0x030303, 0x030303, 0x020202, 0x020202, 0x020202, 0x030303, 0x020202, 0x010101, 0x020202, 0x020202, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x020202, 0x000000, 0x040404, 0x242426, 0x363638, 0x2f2f31, 0x2b2b2d, 0x2e2e30, 0x313133, 0x333335, 0x333335, 0x313133, 0x313133, 0x353537, 0x363638, 0x333335, 0x333438, 0x2d3132, 0x292a2c, 0x2a2627, 0x1e201d, 0x0d0c0a, 0x000200, 0x000106, 0x00010d, 0x412c0d, 0x866216, 0xc18c18, 0xe6a418, 0xffb71d, 0xfec01f, 0xffca2c, 0xffcd2c, 0xffca22, 0xffc62e, 0xf9c12e, 0xdfaa28, 0xa7882d, 0x655e32, 0x151e23, 0x000002, 0x000002, 0x010000, 0x000000, 0x000103, 0x030102, 0x060405, 0x040404, 0x040404, 0x040404, 0x040404, 0x040404, 0x030303, 0x040404, 0x040404, 0x050505, 0x040404, 0x040404, 0x020202, 0x020202, 0x020202, 0x030303, 0x030303, 0x020202, 0x030303, 0x020202, 0x020202, 0x020202, 0x030303, 0x030303, 0x030303, 0x020202, 0x030303, 0x030303, 0x020202, 0x030303, 0x020202, 0x030303, 0x030303, 0x030303, 0x020202, 0x020202, 0x020202, 0x030303, 0x020202, 0x020202, 0x020202, 0x020202, 0x030303, 0x030303, 0x020202, 0x020202, 0x030303, 0x050505, 0x040404, 0x040404, 0x141414, 0x0f0f0f, 0x090909, 0x040404, 0x030303, 0x040404, 0x030303, 0x030303, 0x020202, 0x020202, 0x020202, 0x010101, 0x020202, 0x020202, 0x020202, 0x020202, 0x060606, 0x030303, 0x020202, 0x020202, 0x020202, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x020202, 0x020202, 0x030303, 0x212123, 0x373739, 0x353537, 0x343436, 0x353537, 0x39393b, 0x373739, 0x38383a, 0x3d3d3f, 0x3e3e40, 0x3c3c3e, 0x3c3c3e, 0x3e3e40, 0x414141, 0x35343a, 0x2d2c32, 0x262827, 0x232227, 0x262626, 0x141416, 0x010101, 0x000002, 0x000000, 0x010103, 0x000004, 0x0e0905, 0x322310, 0x4b3716, 0x593e0f, 0x583e0d, 0x513f19, 0x4f3f1e, 0x2a2b1d, 0x050912, 0x010005, 0x010000, 0x000100, 0x000100, 0x010103, 0x000200, 0x050505, 0x020607, 0x040807, 0x09070a, 0x060606, 0x040404, 0x040404, 0x040404, 0x040404, 0x040404, 0x040404, 0x040404, 0x040404, 0x040404, 0x030303, 0x020202, 0x020202, 0x020202, 0x020202, 0x030303, 0x030303, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x030303, 0x020202, 0x030303, 0x020202, 0x020202, 0x030303, 0x020202, 0x020202, 0x020202, 0x030303, 0x030303, 0x020202, 0x020202, 0x020202, 0x010101, 0x020202, 0x030303, 0x030303, 0x020202, 0x020202, 0x030303, 0x030303, 0x040404, 0x0d0d0d, 0x070707, 0x040404, 0x030303, 0x020202, 0x030303, 0x030303, 0x020202, 0x020202, 0x020202, 0x030303, 0x020202, 0x020202, 0x030303, 0x030303, 0x040404, 0x050505, 0x020202, 0x020202, 0x030303, 0x020202, 0x010101, 0x010101, 0x020202, 0x010101, 0x010101, 0x010101, 0x010101, 0x020202, 0x020202, 0x010101, 0x010101, 0x000000, 0x020202, 0x010101, 0x151515, 0x343436, 0x363638, 0x38383a, 0x404042, 0x424244, 0x464648, 0x48484a, 0x4a4a4c, 0x49494b, 0x464648, 0x464648, 0x48484a, 0x49474c, 0x434047, 0x373739, 0x2a2b2d, 0x202020, 0x292a25, 0x232227, 0x151714, 0x0b0b09, 0x040404, 0x030303, 0x000002, 0x010000, 0x000100, 0x000002, 0x000000, 0x010000, 0x010002, 0x000002, 0x000201, 0x030000, 0x000100, 0x000000, 0x020001, 0x060105, 0x060805, 0x0b0b09, 0x0b0a08, 0x0e090d, 0x070707, 0x070904, 0x060606, 0x040404, 0x040404, 0x040404, 0x040404, 0x040404, 0x040404, 0x040404, 0x030303, 0x030303, 0x030303, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x010101, 0x020202, 0x030303, 0x020202, 0x010101, 0x020202, 0x020202, 0x020202, 0x020202, 0x030303, 0x030303, 0x020202, 0x020202, 0x020202, 0x030303, 0x030303, 0x030303, 0x020202, 0x020202, 0x020202, 0x040404, 0x040404, 0x020202, 0x040404, 0x070707, 0x050505, 0x020202, 0x040404, 0x040404, 0x020202, 0x020202, 0x040404, 0x030303, 0x030303, 0x030303, 0x020202, 0x030303, 0x030303, 0x020202, 0x050505, 0x050505, 0x020202, 0x020202, 0x030303, 0x020202, 0x010101, 0x010101, 0x010101, 0x020202, 0x010101, 0x010101, 0x020202, 0x030303, 0x020202, 0x020202, 0x020202, 0x010101, 0x010101, 0x010101, 0x0b0b0b, 0x29292b, 0x353537, 0x3c3c3e, 0x424244, 0x48484a, 0x4e4e50, 0x515153, 0x505052, 0x4e4e50, 0x4b4b4d, 0x4a4a4c, 0x4a4a4c, 0x4b4c4e, 0x49484d, 0x3d3b3e, 0x2d2e30, 0x1e1f21, 0x222222, 0x272727, 0x232323, 0x151314, 0x0d0d0f, 0x0a0a08, 0x050706, 0x070508, 0x050505, 0x040301, 0x020202, 0x000201, 0x020202, 0x010101, 0x000000, 0x0f1012, 0x1f2022, 0x20221f, 0x1e1e20, 0x1c1e1d, 0x171717, 0x161614, 0x121214, 0x090909, 0x08080a, 0x070705, 0x070604, 0x050505, 0x050505, 0x050505, 0x050505, 0x040404, 0x040404, 0x040404, 0x040404, 0x030303, 0x040404, 0x030303, 0x030303, 0x020202, 0x020202, 0x020202, 0x020202, 0x030303, 0x020202, 0x020202, 0x020202, 0x030303, 0x020202, 0x020202, 0x030303, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x030303, 0x020202, 0x020202, 0x020202, 0x030303, 0x030303, 0x020202, 0x020202, 0x030303, 0x020202, 0x010101, 0x040404, 0x080808, 0x060606, 0x030303, 0x030303, 0x030303, 0x020202, 0x050505, 0x040404, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x030303, 0x030303, 0x060606, 0x030303, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x010101, 0x010101, 0x020202, 0x020202, 0x010101, 0x010101, 0x010101, 0x030303, 0x030303, 0x020202, 0x020202, 0x020202, 0x020202, 0x050505, 0x161616, 0x2e2e2e, 0x363638, 0x373739, 0x424244, 0x4a4a4c, 0x505052, 0x525254, 0x525254, 0x525254, 0x4e4e50, 0x4c4c4e, 0x4c4c4e, 0x464648, 0x38383a, 0x303030, 0x242424, 0x232323, 0x292929, 0x292929, 0x1b1b1b, 0x0e0e0e, 0x0b0b0b, 0x070707, 0x060606, 0x060606, 0x050505, 0x030303, 0x030303, 0x010101, 0x000002, 0x2d2d2f, 0x5a5a5c, 0x5b5b5d, 0x48484a, 0x3e3e40, 0x333333, 0x1e1e1e, 0x131313, 0x141414, 0x0d0d0d, 0x060606, 0x070707, 0x070707, 0x050505, 0x050505, 0x060606, 0x060606, 0x050505, 0x040404, 0x040404, 0x040404, 0x040404, 0x040404, 0x020202, 0x010101, 0x020202, 0x020202, 0x020202, 0x030303, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x030303, 0x030303, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x030303, 0x030303, 0x020202, 0x020202, 0x040404, 0x020202, 0x030303, 0x030303, 0x030303, 0x050505, 0x040404, 0x040404, 0x030303, 0x020202, 0x080808, 0x040404, 0x040404, 0x020202, 0x030303, 0x050505, 0x040404, 0x020202, 0x020202, 0x020202, 0x010101, 0x020202, 0x020202, 0x020202, 0x030303, 0x050505, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x010101, 0x010101, 0x010101, 0x020202, 0x020202, 0x010101, 0x010101, 0x010101, 0x020202, 0x030303, 0x040404, 0x020202, 0x020202, 0x030303, 0x020202, 0x0a0a0a, 0x181818, 0x292929, 0x323234, 0x373739, 0x434345, 0x48484a, 0x4c4c4e, 0x4f4f51, 0x4f4f51, 0x4c4c4e, 0x4a4a4c, 0x434345, 0x3b3b3d, 0x313133, 0x2d2d2d, 0x2b2b2b, 0x2c2c2c, 0x2c2c2c, 0x282828, 0x141414, 0x090909, 0x050505, 0x060606, 0x070707, 0x050505, 0x050505, 0x050505, 0x020202, 0x020202, 0x272729, 0x505052, 0x4d4d4d, 0x383838, 0x2d2d2f, 0x2f2f31, 0x272727, 0x1c1c1c, 0x121212, 0x111111, 0x0e0e0e, 0x080808, 0x060606, 0x080808, 0x050505, 0x050505, 0x050505, 0x050505, 0x050505, 0x030303, 0x030303, 0x040404, 0x030303, 0x030303, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x030303, 0x030303, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x030303, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x010101, 0x010101, 0x020202, 0x030303, 0x060606, 0x060606, 0x030303, 0x030303, 0x070707, 0x070707, 0x030303, 0x010101, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x050505, 0x030303, 0x020202, 0x020202, 0x020202, 0x020202, 0x010101, 0x010101, 0x010101, 0x010101, 0x020202, 0x020202, 0x010101, 0x010101, 0x010101, 0x010101, 0x020202, 0x030303, 0x020202, 0x030303, 0x020202, 0x020202, 0x050505, 0x070707, 0x131313, 0x212121, 0x29292b, 0x323234, 0x3a3a3c, 0x3a3a3c, 0x3c3c3e, 0x404042, 0x3d3d3f, 0x3b3b3d, 0x343434, 0x2b2b2b, 0x282828, 0x252525, 0x212121, 0x181818, 0x121212, 0x0c0c0c, 0x040404, 0x040404, 0x040404, 0x040404, 0x050505, 0x050505, 0x050505, 0x030303, 0x010101, 0x131313, 0x3a3a3a, 0x2e2e2e, 0x1e1e1e, 0x131313, 0x131313, 0x161616, 0x171717, 0x131313, 0x0d0d0d, 0x0b0b0b, 0x0b0b0b, 0x080808, 0x070707, 0x080808, 0x060606, 0x050505, 0x050505, 0x050505, 0x050505, 0x040404, 0x030303, 0x040404, 0x040404, 0x040404, 0x040404, 0x030303, 0x030303, 0x020202, 0x020202, 0x020202, 0x020202, 0x030303, 0x030303, 0x020202, 0x020202, 0x020202, 0x010101, 0x020202, 0x020202, 0x020202, 0x040404, 0x030303, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x010101, 0x020202, 0x020202, 0x010101, 0x010101, 0x020202, 0x020202, 0x030303, 0x020202, 0x020202, 0x010101, 0x010101, 0x020202, 0x040404, 0x080808, 0x060606, 0x040404, 0x070707, 0x090909, 0x050505, 0x020202, 0x020202, 0x030303, 0x020202, 0x020202, 0x020202, 0x020202, 0x040404, 0x070707, 0x040404, 0x020202, 0x020202, 0x020202, 0x020202, 0x010101, 0x010101, 0x010101, 0x010101, 0x020202, 0x020202, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x010101, 0x020202, 0x050505, 0x0b0b0b, 0x111111, 0x1a1a1a, 0x1c1c1c, 0x1b1b1b, 0x1f1f1f, 0x232323, 0x232323, 0x202020, 0x1b1b1b, 0x191919, 0x121212, 0x090909, 0x060606, 0x010101, 0x010101, 0x010101, 0x040404, 0x050505, 0x030303, 0x020202, 0x030303, 0x040404, 0x040404, 0x040404, 0x070707, 0x111111, 0x141414, 0x101010, 0x0a0a0a, 0x060606, 0x040404, 0x030303, 0x030303, 0x030303, 0x030303, 0x050505, 0x050505, 0x050505, 0x050505, 0x040404, 0x050505, 0x050505, 0x050505, 0x040404, 0x050505, 0x040404, 0x040404, 0x040404, 0x030303, 0x040404, 0x040404, 0x040404, 0x030303, 0x020202, 0x020202, 0x020202, 0x010101, 0x030303, 0x030303, 0x020202, 0x020202, 0x020202, 0x010101, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x030303, 0x020202, 0x010101, 0x020202, 0x020202, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x020202, 0x020202, 0x030303, 0x020202, 0x010101, 0x010101, 0x020202, 0x0a0a0a, 0x050505, 0x090909, 0x0a0a0a, 0x060606, 0x040404, 0x010101, 0x020202, 0x020202, 0x010101, 0x030303, 0x030303, 0x020202, 0x070707, 0x080808, 0x040404, 0x020202, 0x020202, 0x020202, 0x020202, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x020202, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x020202, 0x020202, 0x020202, 0x020202, 0x030303, 0x010101, 0x030303, 0x010101, 0x020202, 0x030303, 0x060606, 0x040404, 0x060606, 0x0a0a0a, 0x0b0b0b, 0x0c0c0c, 0x090909, 0x050505, 0x040404, 0x010101, 0x000000, 0x020202, 0x030303, 0x030303, 0x010101, 0x000000, 0x020202, 0x060606, 0x0a0a0a, 0x0b0b0b, 0x080808, 0x040404, 0x040404, 0x0a0a0a, 0x0b0b0b, 0x080808, 0x101010, 0x151515, 0x121212, 0x0e0e0e, 0x040404, 0x030303, 0x030303, 0x030303, 0x040404, 0x040404, 0x040404, 0x040404, 0x030303, 0x040404, 0x040404, 0x040404, 0x040404, 0x040404, 0x040404, 0x040404, 0x030303, 0x020202, 0x020202, 0x030303, 0x030303, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x010101, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x030303, 0x030303, 0x020202, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x020202, 0x030303, 0x040404, 0x030303, 0x030303, 0x020202, 0x020202, 0x060606, 0x0a0a0a, 0x0b0b0b, 0x070707, 0x040404, 0x040404, 0x030303, 0x020202, 0x020202, 0x020202, 0x040404, 0x030303, 0x060606, 0x0d0d0d, 0x090909, 0x020202, 0x010101, 0x020202, 0x020202, 0x020202, 0x010101, 0x010101, 0x010101, 0x010101, 0x020202, 0x020202, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x030303, 0x020202, 0x020202, 0x020202, 0x020202, 0x040404, 0x010101, 0x010101, 0x020202, 0x020202, 0x000000, 0x010101, 0x030303, 0x020202, 0x010101, 0x010101, 0x010101, 0x020202, 0x020202, 0x000000, 0x000000, 0x000000, 0x010101, 0x010101, 0x060606, 0x0c0c0c, 0x101010, 0x181818, 0x191919, 0x101010, 0x050505, 0x020202, 0x070707, 0x090909, 0x090909, 0x050505, 0x0c0c0c, 0x0c0c0c, 0x0f0f0f, 0x181818, 0x0d0d0d, 0x040404, 0x040404, 0x030303, 0x030303, 0x030303, 0x030303, 0x030303, 0x040404, 0x040404, 0x030303, 0x030303, 0x030303, 0x030303, 0x020202, 0x030303, 0x020202, 0x030303, 0x020202, 0x020202, 0x020202, 0x020202, 0x010101, 0x010101, 0x010101, 0x030303, 0x020202, 0x020202, 0x020202, 0x020202, 0x010101, 0x010101, 0x020202, 0x020202, 0x030303, 0x030303, 0x020202, 0x020202, 0x020202, 0x020202, 0x040404, 0x030303, 0x020202, 0x020202, 0x010101, 0x000000, 0x010101, 0x010101, 0x010101, 0x020202, 0x020202, 0x030303, 0x040404, 0x040404, 0x060606, 0x050505, 0x030303, 0x080808, 0x0e0e0e, 0x080808, 0x030303, 0x030303, 0x030303, 0x020202, 0x010101, 0x030303, 0x040404, 0x040404, 0x020202, 0x070707, 0x0d0d0d, 0x070707, 0x010101, 0x010101, 0x020202, 0x020202, 0x030303, 0x020202, 0x020202, 0x010101, 0x010101, 0x020202, 0x020202, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x020202, 0x030303, 0x020202, 0x020202, 0x020202, 0x020202, 0x010101, 0x030303, 0x020202, 0x020202, 0x020202, 0x000000, 0x000000, 0x020202, 0x010101, 0x010101, 0x010101, 0x010101, 0x000000, 0x020202, 0x0d0d0d, 0x121212, 0x181818, 0x1a1a1a, 0x1d1d1d, 0x1c1c1c, 0x171717, 0x0d0d0d, 0x030303, 0x010101, 0x050505, 0x070707, 0x060606, 0x060606, 0x060606, 0x030303, 0x060606, 0x070707, 0x040404, 0x060606, 0x0b0b0b, 0x090909, 0x080808, 0x060606, 0x030303, 0x020202, 0x030303, 0x040404, 0x040404, 0x030303, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x030303, 0x020202, 0x010101, 0x020202, 0x020202, 0x020202, 0x010101, 0x020202, 0x020202, 0x020202, 0x020202, 0x030303, 0x020202, 0x010101, 0x020202, 0x020202, 0x030303, 0x020202, 0x020202, 0x010101, 0x020202, 0x030303, 0x030303, 0x040404, 0x030303, 0x020202, 0x020202, 0x020202, 0x020202, 0x030303, 0x020202, 0x020202, 0x020202, 0x010101, 0x010101, 0x030303, 0x040404, 0x060606, 0x060606, 0x040404, 0x0d0d0d, 0x080808, 0x030303, 0x020202, 0x030303, 0x030303, 0x020202, 0x030303, 0x030303, 0x030303, 0x030303, 0x030303, 0x080808, 0x080808, 0x040404, 0x030303, 0x020202, 0x030303, 0x030303, 0x040404, 0x020202, 0x020202, 0x020202, 0x020202, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x020202, 0x010101, 0x010101, 0x020202, 0x020202, 0x010101, 0x020202, 0x030303, 0x040404, 0x010101, 0x040404, 0x070707, 0x141414, 0x292929, 0x1e1e1e, 0x070707, 0x000000, 0x020202, 0x050505, 0x0f0f0f, 0x232323, 0x2e2e2e, 0x2d2d2d, 0x282828, 0x292929, 0x212121, 0x101010, 0x040404, 0x000000, 0x000000, 0x0a0a0a, 0x101010, 0x0e0e0e, 0x080808, 0x020202, 0x010101, 0x0e0e0e, 0x151515, 0x111111, 0x0a0a0a, 0x060606, 0x060606, 0x050505, 0x060606, 0x090909, 0x080808, 0x050505, 0x040404, 0x040404, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x030303, 0x030303, 0x020202, 0x020202, 0x020202, 0x020202, 0x010101, 0x020202, 0x030303, 0x020202, 0x020202, 0x030303, 0x020202, 0x030303, 0x020202, 0x020202, 0x020202, 0x030303, 0x030303, 0x030303, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x030303, 0x040404, 0x030303, 0x020202, 0x020202, 0x020202, 0x020202, 0x030303, 0x020202, 0x020202, 0x030303, 0x020202, 0x010101, 0x010101, 0x020202, 0x030303, 0x040404, 0x040404, 0x080808, 0x010101, 0x020202, 0x030303, 0x020202, 0x020202, 0x040404, 0x050505, 0x030303, 0x030303, 0x030303, 0x090909, 0x0b0b0b, 0x040404, 0x010101, 0x030303, 0x040404, 0x020202, 0x030303, 0x030303, 0x020202, 0x030303, 0x020202, 0x020202, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x030303, 0x060606, 0x0a0a0a, 0x252525, 0x2b2b2b, 0x151515, 0x050505, 0x0f0f0f, 0x111111, 0x080808, 0x232323, 0x474747, 0x353535, 0x222222, 0x191919, 0x101010, 0x030303, 0x000000, 0x020202, 0x090909, 0x101010, 0x1a1a1a, 0x171717, 0x0f0f0f, 0x040404, 0x030303, 0x000000, 0x0f0f0f, 0x282828, 0x1e1e1e, 0x111111, 0x070707, 0x040404, 0x050505, 0x040404, 0x050505, 0x050505, 0x050505, 0x040404, 0x030303, 0x030303, 0x030303, 0x020202, 0x030303, 0x020202, 0x030303, 0x030303, 0x020202, 0x020202, 0x020202, 0x020202, 0x010101, 0x020202, 0x020202, 0x030303, 0x020202, 0x010101, 0x010101, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x030303, 0x010101, 0x030303, 0x020202, 0x020202, 0x030303, 0x020202, 0x030303, 0x020202, 0x000000, 0x010101, 0x020202, 0x030303, 0x010101, 0x020202, 0x020202, 0x010101, 0x020202, 0x040404, 0x040404, 0x030303, 0x030303, 0x010101, 0x020202, 0x040404, 0x040404, 0x050505, 0x040404, 0x030303, 0x030303, 0x0b0b0b, 0x090909, 0x030303, 0x020202, 0x010101, 0x030303, 0x030303, 0x030303, 0x040404, 0x030303, 0x030303, 0x030303, 0x010101, 0x000000, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x020202, 0x030303, 0x040404, 0x080808, 0x131313, 0x181818, 0x070707, 0x000000, 0x151515, 0x1e1e1e, 0x1c1c1c, 0x090909, 0x181818, 0x2e2e2e, 0x1d1d1d, 0x101010, 0x070707, 0x000000, 0x000000, 0x0f0f0f, 0x171717, 0x1b1b1b, 0x171717, 0x131313, 0x111111, 0x080808, 0x020202, 0x050505, 0x010101, 0x050505, 0x272727, 0x272727, 0x131313, 0x0c0c0c, 0x060606, 0x040404, 0x030303, 0x030303, 0x030303, 0x030303, 0x030303, 0x030303, 0x030303, 0x030303, 0x030303, 0x020202, 0x030303, 0x020202, 0x040404, 0x020202, 0x040404, 0x040404, 0x030303, 0x020202, 0x020202, 0x010101, 0x020202, 0x020202, 0x020202, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x020202, 0x020202, 0x010101, 0x010101, 0x010101, 0x020202, 0x010101, 0x020202, 0x040404, 0x020202, 0x020202, 0x030303, 0x030303, 0x020202, 0x020202, 0x010101, 0x040404, 0x040404, 0x010101, 0x010101, 0x010101, 0x000000, 0x000000, 0x030303, 0x020202, 0x040404, 0x030303, 0x020202, 0x030303, 0x040404, 0x040404, 0x050505, 0x040404, 0x020202, 0x040404, 0x0b0b0b, 0x060606, 0x030303, 0x030303, 0x020202, 0x010101, 0x010101, 0x020202, 0x050505, 0x040404, 0x020202, 0x020202, 0x000000, 0x000000, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x020202, 0x040404, 0x080808, 0x121212, 0x090909, 0x000000, 0x0a0a0a, 0x171717, 0x1b1b1b, 0x1c1c1c, 0x0d0d0d, 0x0d0d0d, 0x171717, 0x0d0d0d, 0x010101, 0x000000, 0x040404, 0x212121, 0x262626, 0x222222, 0x1e1e1e, 0x181818, 0x111111, 0x090909, 0x030303, 0x030303, 0x010101, 0x020202, 0x040404, 0x212121, 0x272727, 0x151515, 0x0e0e0e, 0x090909, 0x040404, 0x030303, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x020202, 0x030303, 0x030303, 0x020202, 0x060606, 0x050505, 0x020202, 0x020202, 0x030303, 0x020202, 0x030303, 0x020202, 0x010101, 0x010101, 0x010101, 0x020202, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x020202, 0x020202, 0x010101, 0x000000, 0x010101, 0x030303, 0x030303, 0x040404, 0x050505, 0x030303, 0x030303, 0x040404, 0x040404, 0x030303, 0x020202, 0x020202, 0x050505, 0x050505, 0x020202, 0x010101, 0x020202, 0x010101, 0x010101, 0x020202, 0x020202, 0x020202, 0x020202, 0x040404, 0x040404, 0x040404, 0x050505, 0x050505, 0x040404, 0x030303, 0x070707, 0x080808, 0x030303, 0x020202, 0x020202, 0x030303, 0x020202, 0x010101, 0x020202, 0x030303, 0x020202, 0x020202, 0x020202, 0x030303, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x020202, 0x020202, 0x010101, 0x010101, 0x010101, 0x010101, 0x030303, 0x060606, 0x010101, 0x020202, 0x0a0a0a, 0x0e0e0e, 0x1d1d1d, 0x1f1f1f, 0x0f0f0f, 0x040404, 0x0a0a0a, 0x040404, 0x000000, 0x080808, 0x282828, 0x2f2f2f, 0x242424, 0x232323, 0x1c1c1c, 0x141414, 0x0e0e0e, 0x040404, 0x030303, 0x030303, 0x020202, 0x000000, 0x050505, 0x191919, 0x1e1e1e, 0x161616, 0x0a0a0a, 0x080808, 0x030303, 0x030303, 0x020202, 0x020202, 0x010101, 0x010101, 0x010101, 0x020202, 0x020202, 0x030303, 0x020202, 0x020202, 0x090909, 0x090909, 0x010101, 0x010101, 0x010101, 0x020202, 0x020202, 0x010101, 0x010101, 0x010101, 0x000000, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x020202, 0x030303, 0x030303, 0x030303, 0x040404, 0x020202, 0x040404, 0x040404, 0x020202, 0x030303, 0x030303, 0x040404, 0x030303, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x020202, 0x030303, 0x040404, 0x040404, 0x040404, 0x040404, 0x050505, 0x030303, 0x030303, 0x050505, 0x080808, 0x050505, 0x020202, 0x010101, 0x000000, 0x020202, 0x020202, 0x010101, 0x020202, 0x030303, 0x020202, 0x010101, 0x010101, 0x010101, 0x000000, 0x010101, 0x010101, 0x000000, 0x000000, 0x000000, 0x010101, 0x020202, 0x010101, 0x020202, 0x020202, 0x010101, 0x010101, 0x020202, 0x010101, 0x000000, 0x000000, 0x010101, 0x020202, 0x070707, 0x0c0c0c, 0x131313, 0x181818, 0x101010, 0x040404, 0x010101, 0x000000, 0x080808, 0x282828, 0x2e2e2e, 0x242424, 0x1e1e1e, 0x1d1d1d, 0x161616, 0x0f0f0f, 0x0b0b0b, 0x040404, 0x030303, 0x020202, 0x020202, 0x000000, 0x030303, 0x141414, 0x1c1c1c, 0x141414, 0x070707, 0x040404, 0x030303, 0x020202, 0x020202, 0x020202, 0x010101, 0x010101, 0x010101, 0x010101, 0x030303, 0x030303, 0x010101, 0x020202, 0x0b0b0b, 0x070707, 0x000000, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x000000, 0x010101, 0x010101, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x030303, 0x020202, 0x030303, 0x030303, 0x010101, 0x020202, 0x040404, 0x020202, 0x030303, 0x030303, 0x040404, 0x040404, 0x020202, 0x010101, 0x010101, 0x010101, 0x000000, 0x020202, 0x040404, 0x060606, 0x040404, 0x040404, 0x040404, 0x050505, 0x030303, 0x030303, 0x050505, 0x060606, 0x030303, 0x020202, 0x010101, 0x010101, 0x010101, 0x020202, 0x020202, 0x010101, 0x020202, 0x010101, 0x010101, 0x020202, 0x020202, 0x000000, 0x010101, 0x010101, 0x000000, 0x000000, 0x000000, 0x010101, 0x010101, 0x010101, 0x010101, 0x020202, 0x020202, 0x020202, 0x050505, 0x040404, 0x020202, 0x010101, 0x000000, 0x000000, 0x050505, 0x080808, 0x0a0a0a, 0x111111, 0x0e0e0e, 0x020202, 0x000000, 0x040404, 0x1c1c1c, 0x252525, 0x202020, 0x1d1d1d, 0x181818, 0x181818, 0x101010, 0x0a0a0a, 0x050505, 0x030303, 0x020202, 0x030303, 0x020202, 0x010101, 0x010101, 0x0d0d0d, 0x171717, 0x0e0e0e, 0x050505, 0x030303, 0x030303, 0x020202, 0x020202, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x020202, 0x020202, 0x010101, 0x050505, 0x0c0c0c, 0x030303, 0x010101, 0x010101, 0x020202, 0x010101, 0x010101, 0x010101, 0x010101, 0x020202, 0x010101, 0x010101, 0x010101, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x010101, 0x010101, 0x010101, 0x000000, 0x010101, 0x010101, 0x010101, 0x010101, 0x020202, 0x040404, 0x030303, 0x020202, 0x020202, 0x030303, 0x030303, 0x020202, 0x030303, 0x020202, 0x020202, 0x020202, 0x010101, 0x010101, 0x010101, 0x000000, 0x040404, 0x050505, 0x040404, 0x030303, 0x020202, 0x030303, 0x030303, 0x040404, 0x050505, 0x060606, 0x040404, 0x020202, 0x010101, 0x010101, 0x020202, 0x010101, 0x000000, 0x010101, 0x010101, 0x020202, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x000000, 0x000000, 0x000000, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x020202, 0x030303, 0x050505, 0x060606, 0x060606, 0x060606, 0x030303, 0x000000, 0x020202, 0x040404, 0x060606, 0x090909, 0x0b0b0b, 0x020202, 0x000000, 0x0c0c0c, 0x1b1b1b, 0x181818, 0x181818, 0x151515, 0x141414, 0x0f0f0f, 0x080808, 0x040404, 0x010101, 0x030303, 0x020202, 0x010101, 0x020202, 0x000000, 0x010101, 0x060606, 0x0d0d0d, 0x080808, 0x030303, 0x040404, 0x020202, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x020202, 0x090909, 0x070707, 0x020202, 0x000000, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x010101, 0x010101, 0x010101, 0x020202, 0x020202, 0x020202, 0x010101, 0x020202, 0x030303, 0x020202, 0x030303, 0x020202, 0x030303, 0x030303, 0x020202, 0x030303, 0x020202, 0x020202, 0x020202, 0x020202, 0x010101, 0x010101, 0x000000, 0x030303, 0x040404, 0x030303, 0x020202, 0x000000, 0x020202, 0x020202, 0x020202, 0x060606, 0x060606, 0x030303, 0x010101, 0x010101, 0x020202, 0x010101, 0x010101, 0x010101, 0x010101, 0x020202, 0x010101, 0x010101, 0x020202, 0x000000, 0x010101, 0x010101, 0x010101, 0x010101, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x010101, 0x010101, 0x010101, 0x020202, 0x020202, 0x030303, 0x050505, 0x080808, 0x080808, 0x060606, 0x010101, 0x000000, 0x010101, 0x020202, 0x040404, 0x090909, 0x060606, 0x000000, 0x040404, 0x0e0e0e, 0x101010, 0x101010, 0x101010, 0x0e0e0e, 0x070707, 0x020202, 0x000000, 0x020202, 0x020202, 0x020202, 0x000000, 0x010101, 0x010101, 0x010101, 0x040404, 0x050505, 0x040404, 0x020202, 0x020202, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x020202, 0x010101, 0x010101, 0x050505, 0x070707, 0x030303, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x000000, 0x010101, 0x000000, 0x010101, 0x010101, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x010101, 0x010101, 0x010101, 0x000000, 0x010101, 0x000000, 0x010101, 0x010101, 0x020202, 0x020202, 0x020202, 0x020202, 0x010101, 0x010101, 0x010101, 0x020202, 0x020202, 0x020202, 0x010101, 0x010101, 0x020202, 0x010101, 0x010101, 0x000000, 0x030303, 0x030303, 0x020202, 0x020202, 0x020202, 0x020202, 0x030303, 0x030303, 0x030303, 0x020202, 0x020202, 0x020202, 0x020202, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x010101, 0x010101, 0x020202, 0x030303, 0x040404, 0x050505, 0x030303, 0x010101, 0x010101, 0x000000, 0x000000, 0x010101, 0x030303, 0x060606, 0x020202, 0x000000, 0x050505, 0x080808, 0x090909, 0x090909, 0x040404, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x030303, 0x050505, 0x040404, 0x010101, 0x010101, 0x010101, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x020202, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x000000, 0x020202, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x020202, 0x020202, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x000000, 0x000000, 0x000000, 0x000000, 0x010101, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x010101, 0x010101, 0x010101, 0x000000, 0x000000, 0x010101, 0x000000, 0x000000, 0x000000, 0x000000, 0x030303, 0x020202, 0x000000, 0x020202, 0x030303, 0x040404, 0x040404, 0x000000, 0x000000, 0x000000, 0x000000, 0x010101, 0x010101, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x020202, 0x020202, 0x010101, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x000000, 0x000000, 0x000000, 0x010101, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x010101, 0x010101, 0x010101, 0x010101, 0x010101, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x010101, 0x010101, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x010101, 0x010101, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x010101, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x010101, 0x010101, 0x010101, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x010101, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x010101, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x010101, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x010101, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000
};

void setup() {
  tft.begin();
  tft.writeScreen24bit(image_data_batman_ume);
}


void loop(void) {

}