  'Port of PN532 Arduino Library to Micromite Basic
  'Appears to be based on Adafruit code https://github.com/adafruit/Adafruit-PN532
  'Downloaded from https://www.elecrow.com/wiki/index.php?title=File:PN532_SPI.zip
  'See very end for MAIN
  
  'SPI pins here
  CONST PN532_CSPIN = 18  'changeable, 18 as per exmaple
  CONST PN532_SOFTSPIDO% = 21
  CONST PN532_SOFTSPIDI% = 22
  CONST PN532_SOFTSPICK% = 24
  
  OPTION EXPLICIT
  OPTION BASE 0
  'Constants
  CONST PN532_SPI_SPEED = 1000000 'Arduino sets 1/16 of sysclk (1MHz on Uno etc), PN532 datasheet specs 5MHz maximum
  CONST PN532_PREAMBLE = &H00
  CONST PN532_STARTCODE1 = &H00
  CONST PN532_STARTCODE2 = &HFF
  CONST PN532_POSTAMBLE = &H00
  CONST PN532_HOSTTOPN532 = &HD4
  CONST PN532_FIRMWAREVERSION = &H02
  CONST PN532_GETGENERALSTATUS = &H04
  CONST PN532_SAMCONFIGURATION =  &H14
  CONST PN532_INLISTPASSIVETARGET = &H4A
  CONST PN532_INDATAEXCHANGE = &H40
  CONST PN532_INJUMPFORDEP = &H56
  CONST PN532_TGINITASTARGET = &H8C
  CONST PN532_TGGETDATA = &H86
  CONST PN532_TGSETDATA = &H8E
  CONST PN532_MIFARE_READ = &H30
  CONST PN532_MIFARE_WRITE = &HA0
  CONST PN532_AUTH_WITH_KEYA = &H60
  CONST PN532_AUTH_WITH_KEYB = &H61
  CONST PN532_WAKEUP = &H55
  CONST PN532_SPI_STATREAD =  &H02
  CONST PN532_SPI_DATAWRITE = &H01
  CONST PN532_SPI_DATAREAD =  &H03
  CONST PN532_SPI_READY =  &H01
  CONST PN532_MIFARE_ISO14443A = &H0
  CONST KEY_A = 1
  CONST KEY_B = 2
  CONST PN532_BAUDRATE_201K = 1
  CONST PN532_BAUDRATE_424K = 2
  'CONST PN532_SOFTSPISPD% = 4    '~80 divider => <1MHz usually
  CONST PN532_SOFTSPISPD% = 0    '~160 divider
  '"Private" variables
  DIM PN532_PACKETBUFFER%(64)
  DIM PN532_BLOCKDATA%(16)      '16 elements to read
  DIM PN532_BLOCKDATAWRITE%(16)      '16 elements to write
  DIM PN532_KEYS%(5)=(255,255,255,255,255,255)              'default encryption keys here
  DIM PN532_ACKPACKET%(5)=(0,0,255,0,255,0)
  DIM PN532_RESPONSEFIRMWAREVERSION%(5)=(0,255,6,250,213,3)
  DIM PN532_CONFIGPEERBUFFER%(37)=(&H8C,&H00,&H08,&H00,&H12,&H34,&H56,&H40,&H01,&HFE,&HA2,&HA3,&HA4,&HA5,&HA6,&HA7,&HC0,&HC1,&HC2,&HC3,&HC4,&HC5,&HC6,&HC7,&HFF,&HFF,&HAA,&H99,&H88,&H77,&H66,&H55,&H44,&H33,&H22,&H11,&H00,&H00)
  'Functions
  'Low level functions
SUB PN532_WRITEBYTE (PN532_data%)
  LOCAL JUNK%
  'PRINT "w";PN532_data%
  'hardware SPI uses single line below
  'JUNK%=SPI(PN532_REVERSE(PN532_data%))
  'software SPI (CFunction)
  JUNK% = SPIPort(PN532_SOFTSPIDI%,PN532_SOFTSPIDO%,PN532_SOFTSPICK%,PN532_REVERSE(PN532_data%),PN532_SOFTSPISPD%)
END SUB
  
FUNCTION PN532_READBYTE()           'read single byte
  LOCAL rxdata%
  'hardware SPI uses single line below
  'rxdata%=SPI(0)
  'software SPI (CFunction)
  rxdata% = SPIPort(PN532_SOFTSPIDI%,PN532_SOFTSPIDO%,PN532_SOFTSPICK%,0,PN532_SOFTSPISPD%)
  PN532_READBYTE=PN532_REVERSE(rxdata%)      'value to be returned
  'PRINT   "r";PN532_READBYTE
END FUNCTION
  
  'Mid level Functions
FUNCTION PN532_READSTATUS()
  PIN(PN532_CSPIN) = 0      'CS low
  PAUSE 2
  PN532_WRITEBYTE(PN532_SPI_STATREAD)
  PN532_READSTATUS=PN532_READBYTE()
  PIN(PN532_CSPIN) = 1      'CS high
end FUNCTION
  
  'Higher level
SUB PN532_READBUFFER(nbytes%)         'read into buffer (occasionally gives off by one error?)
  LOCAL I%
  PIN(PN532_CSPIN) = 0      'CS low
  PAUSE 2
  PN532_WRITEBYTE(PN532_SPI_DATAREAD)
  IF nbytes%>64 THEN nbytes%=64   'array limit
  FOR I% = 0 to nbytes%-1
    PAUSE 1
    PN532_PACKETBUFFER%(I%)=PN532_READBYTE()
  NEXT I%
  PIN(PN532_CSPIN) = 1      'CS high
END SUB
  
SUB PN532_WRITECOMMAND(nbytes%)        'write from buffer, inserts preamble etc
  LOCAL bytesbar%,I%
  LOCAL CHECKSUM%=PN532_PREAMBLE+PN532_PREAMBLE+PN532_STARTCODE2+PN532_HOSTTOPN532
  PIN(PN532_CSPIN) = 0      'CS low
  PAUSE 2
  nbytes%=nbytes%+1     'for checksum?
  PN532_WRITEBYTE(PN532_SPI_DATAWRITE)
  PN532_WRITEBYTE(PN532_PREAMBLE)
  PN532_WRITEBYTE(PN532_PREAMBLE)
  PN532_WRITEBYTE(PN532_STARTCODE2)
  PN532_WRITEBYTE(nbytes%)
  bytesbar% = 256-nbytes%
  PN532_WRITEBYTE(bytesbar%)
  PN532_WRITEBYTE(PN532_HOSTTOPN532)
  FOR I% =0 to nbytes%-2  'not -1 because we added 1
    PN532_WRITEBYTE(PN532_PACKETBUFFER%(I%)  )
    CHECKSUM%=CHECKSUM%+PN532_PACKETBUFFER%(I%)
  NEXT I%
  CHECKSUM%=CHECKSUM% MOD 256
  PN532_WRITEBYTE(255-CHECKSUM%)
  PN532_WRITEBYTE(PN532_POSTAMBLE)
  PIN(PN532_CSPIN) = 1      'CS high
END SUB
  
FUNCTION PN532_CHECKACK()
  LOCAL I%
  PN532_CHECKACK=1    'assume success
  PN532_READBUFFER(6)
  for I% =0 to 5
    if PN532_PACKETBUFFER%(I%) <> PN532_ACKPACKET%(I%) THEN PN532_CHECKACK =0
  NEXT I%
END FUNCTION
  
SUB PN532_BEGIN
  LOCAL TEMP%
  SETPIN PN532_CSPIN ,DOUT
  PIN(PN532_CSPIN) = 1      'CS high
  'SPI Mode 0, set CS pin, LSB first (Micromite hardwired to MSB first, need bit reverse function)
  'hardware SPI uses single line below
  'SPI OPEN PN532_SPI_SPEED, 0, 8    'Mode 0, 8 bits
  'software SPI (CFunction) uses these lines for setup, init is done in call
  SETPIN PN532_SOFTSPIDO ,DOUT
  PIN(PN532_SOFTSPIDO)=0
  SETPIN PN532_SOFTSPICK ,DOUT
  PIN(PN532_SOFTSPICK)=0
  PIN(PN532_CSPIN) = 0      'CS low
  PN532_PACKETBUFFER%(0)=PN532_FIRMWAREVERSION
  TEMP%=PN532_SENDCMDCHECKACK(1)
  'don't need to put CS hi again?
  PAUSE 1000
END SUB
  
FUNCTION PN532_SENDCMDCHECKACK(nbytes% AS INTEGER)  ''use default buffer, assume 1s timeout
  PN532_SENDCMDCHECKACK=1
  LOCAL T%=0
  PN532_WRITECOMMAND(nbytes%)
  do WHILE (PN532_READSTATUS() <> PN532_SPI_READY) AND (T%<1000)
    T%=T%+10
    PAUSE 10
  LOOP
  if T%>=1000 THEN PN532_SENDCMDCHECKACK=0: EXIT FUNCTION
  if PN532_CHECKACK() = 0 THEN PN532_SENDCMDCHECKACK=0: EXIT FUNCTION
  T%=0
  do WHILE (PN532_READSTATUS() <> PN532_SPI_READY) AND (T%<1000)
    T%=T%+10
    PAUSE 10
  LOOP
  if T%>=1000 THEN PN532_SENDCMDCHECKACK=0
END FUNCTION
  
FUNCTION PN532_REVERSE (bits) 'for 8 bits
  PN532_REVERSE=0
  IF (bits AND 1) > 0 THEN PN532_REVERSE=128
  IF (bits AND 2) > 0 THEN PN532_REVERSE=PN532_REVERSE+64
  IF (bits AND 4) > 0 THEN PN532_REVERSE=PN532_REVERSE+32
  IF (bits AND 8) > 0 THEN PN532_REVERSE=PN532_REVERSE+16
  IF (bits AND 16) > 0 THEN PN532_REVERSE=PN532_REVERSE+8
  IF (bits AND 32) > 0 THEN PN532_REVERSE=PN532_REVERSE+4
  IF (bits AND 64) > 0 THEN PN532_REVERSE=PN532_REVERSE+2
  IF (bits AND 128) > 0 THEN PN532_REVERSE=PN532_REVERSE+1
  'PN532_REVERSE is returned
END FUNCTION
  
FUNCTION PN532_GETFIRMWAREVERSION() AS INTEGER
  LOCAL I%
  PN532_PACKETBUFFER%(0)=PN532_FIRMWAREVERSION
  IF PN532_SENDCMDCHECKACK(1) = 0 THEN PN532_GETFIRMWAREVERSION%=0: EXIT FUNCTION
  PN532_READBUFFER(12)
  FOR I%= 0 to 5
    if PN532_PACKETBUFFER%(I%) <> PN532_RESPONSEFIRMWAREVERSION%(I%) THEN PN532_GETFIRMWAREVERSION% =0: EXIT FUNCTION
  NEXT I%
  PN532_GETFIRMWAREVERSION%=PN532_PACKETBUFFER%(6)*256
  PN532_GETFIRMWAREVERSION%=(PN532_GETFIRMWAREVERSION%+PN532_PACKETBUFFER%(7))*256
  PN532_GETFIRMWAREVERSION%=(PN532_GETFIRMWAREVERSION%+PN532_PACKETBUFFER%(8))*256
  PN532_GETFIRMWAREVERSION%=PN532_GETFIRMWAREVERSION%+PN532_PACKETBUFFER%(9)
END FUNCTION
  
FUNCTION PN532_SAMCONFIG()
  PN532_SAMCONFIG=1
  PN532_PACKETBUFFER%(0)=PN532_SAMCONFIGURATION
  PN532_PACKETBUFFER%(1)=1
  PN532_PACKETBUFFER%(2)=20   'timeout = 20 x 50ms =1s
  PN532_PACKETBUFFER%(3)=1    'use IRQ pin
  if PN532_SENDCMDCHECKACK(4) = 0 THEN PN532_SAMCONFIG=0: EXIT FUNCTION
  PN532_READBUFFER(8)   ''read into PN532_PACKETBUFFER%
  if PN532_PACKETBUFFER%(5)<>21 THEN PN532_SAMCONFIG=0: EXIT FUNCTION
END FUNCTION
  
FUNCTION PN532_READPASSIVETARGETID(CARDBAUD%) AS INTEGER
  '  PN532_READPASSIVETARGETID
  LOCAL CARDID%=0,SENSRES%=0,I%,BYTECOUNT%
  PN532_PACKETBUFFER%(0)=PN532_INLISTPASSIVETARGET
  PN532_PACKETBUFFER%(1)=1    '1 card at a time
  PN532_PACKETBUFFER%(2)=CARDBAUD%  'from call
  if PN532_SENDCMDCHECKACK(3) = 0 THEN PN532_READPASSIVETARGETID=0: EXIT FUNCTION 'no cards detected
  PN532_READBUFFER(20)   ''read into PN532_PACKETBUFFER%
  'PRINT "Found ";PN532_PACKETBUFFER%(7);" card(s)."
  if PN532_PACKETBUFFER%(7) <> 1 THEN PN532_READPASSIVETARGETID=0: EXIT FUNCTION '!1 card found
  SENSRES%=PN532_PACKETBUFFER%(9)*256+PN532_PACKETBUFFER%(10)
  'PRINT "Sens Response:";SENSRES%
  'PRINT "Sel Response:";PN532_PACKETBUFFER%(11)
  BYTECOUNT%=PN532_PACKETBUFFER%(12)
  FOR I%=0 to BYTECOUNT%-1
    CARDID%=CARDID%*256+PN532_PACKETBUFFER%(13+I%)
  NEXT I%
  PN532_READPASSIVETARGETID=CARDID%
END FUNCTION
  
FUNCTION PN532_AUTHENTICATEBLOCK(CARDNO%,CARDID%,BLOCK%,KEY%) AS INTEGER 'Cardnumber,ID,BLOCK (0-63),AUTHTYPE (using PN532_KEYS%())
  LOCAL I%,TEMP%
  PN532_PACKETBUFFER%(0)=PN532_INDATAEXCHANGE
  PN532_PACKETBUFFER%(1)=CARDNO%    '1 card at a time
  if KEY% = KEY_A THEN
    PN532_PACKETBUFFER%(2)=PN532_AUTH_WITH_KEYA
  ELSE
    PN532_PACKETBUFFER%(2)=PN532_AUTH_WITH_KEYB
  END IF
  PN532_PACKETBUFFER%(3)=BLOCK%
  PN532_PACKETBUFFER%(4)=PN532_KEYS%(0)
  PN532_PACKETBUFFER%(5)=PN532_KEYS%(1)
  PN532_PACKETBUFFER%(6)=PN532_KEYS%(2)
  PN532_PACKETBUFFER%(7)=PN532_KEYS%(3)
  PN532_PACKETBUFFER%(8)=PN532_KEYS%(4)
  PN532_PACKETBUFFER%(9)=PN532_KEYS%(5)
  PN532_PACKETBUFFER%(10)=(CARDID%\16777216) AND 255
  PN532_PACKETBUFFER%(11)=(CARDID%\65536) AND 255
  PN532_PACKETBUFFER%(12)=(CARDID%\256) AND 255
  PN532_PACKETBUFFER%(13)=(CARDID%) AND 255
  if PN532_SENDCMDCHECKACK(14) = 0 THEN PN532_AUTHENTICATEBLOCK=0: EXIT FUNCTION 'fail to send
  PN532_READBUFFER(8)   ''read into PN532_PACKETBUFFER%
  if (PN532_PACKETBUFFER%(5) = 65) AND (PN532_PACKETBUFFER%(6) = 0) THEN PN532_AUTHENTICATEBLOCK =1: EXIT FUNCTION 'Match
  PN532_AUTHENTICATEBLOCK=0 'no match, fail
END FUNCTION
  
FUNCTION PN532_READMEMORYBLOCK(CARDNO%,BLOCK%) AS INTEGER 'CARDNO is 1 or 2, BLOCK as AUTHED, uses PN532_BLOCKDATA for read
  LOCAL I%
  PN532_PACKETBUFFER%(0)=PN532_INDATAEXCHANGE
  PN532_PACKETBUFFER%(1)=CARDNO%    '1 card at a time
  PN532_PACKETBUFFER%(2)=PN532_MIFARE_READ
  PN532_PACKETBUFFER%(3)=BLOCK%
  if PN532_SENDCMDCHECKACK(4) = 0 THEN PN532_READMEMORYBLOCK=0: EXIT FUNCTION 'fail to send
  PN532_READBUFFER(24)   ''read into PN532_PACKETBUFFER%
  FOR I%=0 to 15
    PN532_BLOCKDATA%(I%)=PN532_PACKETBUFFER%(I%+7)'off by one error?
  NEXT I%
  if (PN532_PACKETBUFFER%(5) = 65) AND (PN532_PACKETBUFFER%(6) = 0) THEN PN532_READMEMORYBLOCK =1: EXIT FUNCTION 'Match
  PN532_READMEMORYBLOCK=0 'no match, fail
END FUNCTION
  
FUNCTION PN532_WRITEMEMORYBLOCK(CARDNO%,BLOCK%) AS INTEGER 'CARDNO is 1 or 2, BLOCK as AUTHED, uses PN532_BLOCKDATA for write
  LOCAL I%
  PN532_WRITEMEMORYBLOCK=0
  IF (BLOCK% AND 3) = 3 THEN PRINT "Trying to write to Sector Trailer. Remove this check to proceed.": EXIT FUNCTION
  IF BLOCK%=0 THEN PRINT "Trying to write Manufacturer Block.  Remove this check to proceed.": EXIT FUNCTION
  PN532_PACKETBUFFER%(0)=PN532_INDATAEXCHANGE
  PN532_PACKETBUFFER%(1)=CARDNO%    '1 card at a time
  PN532_PACKETBUFFER%(2)=PN532_MIFARE_WRITE
  PN532_PACKETBUFFER%(3)=BLOCK%
  for I%=0 to 15
    PN532_PACKETBUFFER%(4+I%)=PN532_BLOCKDATAWRITE%(I%)
  NEXT I%
  if PN532_SENDCMDCHECKACK(20) = 0 THEN EXIT FUNCTION 'fail to send
  PN532_READBUFFER(8)   ''read into PN532_PACKETBUFFER%
  if (PN532_PACKETBUFFER%(6) = 65) AND (PN532_PACKETBUFFER%(7) = 0) THEN PN532_WRITEMEMORYBLOCK =1: EXIT FUNCTION 'Match
END FUNCTION
  
FUNCTION PN532_CONFIGUREPEERASTARGET() AS INTEGER 'for P2P mode
  PN532_CONFIGUREPEERASTARGET=0' default to fail
  LOCAL I%
  FOR I%=0 to 37
    PN532_PACKETBUFFER%(I%)=PN532_CONFIGPEERBUFFER%(I%)
  NEXT I%
  if PN532_SENDCMDCHECKACK(38) = 0 THEN EXIT FUNCTION 'fail to send
  PN532_READBUFFER(24)   ''read into PN532_PACKETBUFFER%
  if PN532_PACKETBUFFER%(23) = 0 THEN PN532_CONFIGUREPEERASTARGET =1: EXIT FUNCTION 'Match
END FUNCTION
  
FUNCTION PN532_TARGETTXRX()'use PN532_BLOCKDATA for rx and PN532_BLOCKDATAWRITE for TX
  LOCAL I%
  PN532_TARGETTXRX=0' default to fail
  PN532_PACKETBUFFER%(0)=PN532_TGGETDATA
  if PN532_SENDCMDCHECKACK(1) = 0 THEN EXIT FUNCTION 'fail to send
  PN532_READBUFFER(24)   ''read into PN532_PACKETBUFFER% - data is received first as we are target
  FOR I%=0 to 15
    PN532_BLOCKDATA%(I%)=PN532_PACKETBUFFER%(I%+7)  '  data received into PN532_BLOCKDATA%()
  NEXT I%
  FOR I%=0 to 7
    PRINT PN532_PACKETBUFFER%(I%)
  NEXT I%
  'if PN532_PACKETBUFFER%(6) <> 0 THEN EXIT FUNCTION 'fail
  print "PACKET RX OK"
  PN532_PACKETBUFFER%(0)=PN532_TGSETDATA
  FOR I%=0 to 15
    PN532_PACKETBUFFER%(I%+1)=PN532_BLOCKDATAWRITE%(I%) 'data to be sent
  NEXT I%
  if PN532_SENDCMDCHECKACK(17) = 0 THEN EXIT FUNCTION 'fail to send
  print "ACK OK"
  PN532_READBUFFER(8)   ''read into PN532_PACKETBUFFER%
  FOR I%=0 to 7
    PRINT PN532_PACKETBUFFER%(I%)
  NEXT I%
  'if (PN532_PACKETBUFFER%(7) = 0) THEN PN532_TARGETTXRX =1: EXIT FUNCTION 'Match
  PN532_TARGETTXRX =1
END FUNCTION
  
  'from V5.04.08 Cfunctions
'usage: rd = SPIPort( rx, tx, clk, data_to_send, speed, mode, bits )
CFunction SPIPort(integer, integer, integer, integer) integer
  00000008
  40024800 00442021 40024800 0044102B 1440FFFD 00000000 03E00008 00000000
  27BDFFB0 AFBF004C AFBE0048 AFB70044 AFB60040 AFB5003C AFB40038 AFB30034
  AFB20030 AFB1002C AFB00028 00808821 00A09021 00C0A021 00E0A821 10800005
  8FB30068 10A00004 3C029D00 14C00008 3C109D00 3C029D00 8C420010 00002021
  24050002 0040F809 00003021 3C109D00 8E020010 8E240000 24050002 0040F809
  00003021 8E020024 8E240000 0040F809 00002821 AFA20018 8E020028 0040F809
  8E240000 AFA2001C 8E020024 8E440000 0040F809 24050006 AFA20020 8E020024
  8E440000 0040F809 24050005 AFA20024 8E020028 0040F809 8E440000 24170001
  0057B804 8FA20064 10400008 3C109D00 8C420000 50400006 8E020024 24030003
  5443000D 8E020024 3C109D00 8E020024 8E840000 0040F809 24050005 0040B021
  8E020024 8E840000 0040F809 24050006 1000000A 0040F021 8E840000 0040F809
  24050006 0040B021 8E020024 8E840000 0040F809 24050005 0040F021 3C029D00
  8C420028 0040F809 8E840000 24140001 0054A004 12600002 24110008 8E710000
  2631FFFF 32220020 24030001 02238804 02208021 0002800A 0002880B 2402FFFF
  2403FFFF AFA20010 12A00005 AFA30014 8EA20000 8EA30004 AFA20010 AFA30014
  8FA30060 10600002 0000A821 8C750000 02301025 00009021 10400039 00009821
  8FA40010 02241824 8FA60014 02061024 00621025 10400004 8FA30024 8FA20020
  10000002 AC570000 AC770000 AED40000 00000000 00000000 00000000 00000000
  00000000 00000000 52A00013 00121FC2 02A02021 0411FF6A 00000000 00121FC2
  00131040 00122840 8FA60018 8CC40000 8FA6001C 00C42006 30840001 00A49025
  00629825 AFD40000 0411FF5D 02A02021 1000000C 00101FC0 00131040 00122840
  8FA60018 8CC40000 8FA6001C 00C42006 30840001 00A49025 00629825 AFD40000
  00101FC0 00111042 00621025 00101842 00408821 00431025 1440FFC9 00608021
  00000000 00000000 00000000 00000000 8FA20064 10400006 00000000 8C420000
  10400003 24030002 14430003 02401021 AED40000 02401021 02601821 8FBF004C
  8FBE0048 8FB70044 8FB60040 8FB5003C 8FB40038 8FB30034 8FB20030 8FB1002C
  8FB00028 03E00008 27BD0050
End CFunction
  
  
  '''''''''''''''''''''''''''''''''MAIN CODE HERE'''''''''''''''''''''''''''''''''''''''''''''
  DIM VERSIONDATA%,CONFIGOK%,READOK%,I%,J%,WRITEDONE% AS INTEGER
  DIM TXSTRING$, RXSTRING$ AS STRING
  TXSTRING$="From Target"
  FOR I%=0 to 14
    PN532_BLOCKDATAWRITE%(I%)=asc(MID$(TXSTRING$,I%+1,1))
  NEXT I%
  PN532_BLOCKDATAWRITE%(15)=0    'null terminate in case we are talking to Arduino/C
  
  PN532_BEGIN
  VERSIONDATA%=PN532_GETFIRMWAREVERSION()
  if VERSIONDATA%=0 THEN PRINT "PN532 board not found":END
  PRINT "FOUND PN5";HEX$((VERSIONDATA%\16777216) and 255)
  PRINT "FIRMWARE VERSION:";HEX$((VERSIONDATA%\65536) and 255);".";HEX$((VERSIONDATA%\256) and 255)
  PRINT "SUPPORTS:"(VERSIONDATA%) and 255
  if PN532_SAMCONFIG() = 0 THEN PRINT "SAM Config Failed":END
  
MAINLOOP:
  CONFIGOK%=PN532_CONFIGUREPEERASTARGET()
  if CONFIGOK%<>0 THEN
    PRINT "Write to initiator:";CHR$(34);TXSTRING$;CHR$(34)
    READOK%=PN532_TARGETTXRX()
    if READOK%<>0 THEN
      RXSTRING$=""
      FOR I%=0 to 15
        RXSTRING$=RXSTRING$+chr$(PN532_BLOCKDATA(I%))
      NEXT I%
      PRINT "Write OK"
      PRINT "Received from initiator:";CHR$(34);RXSTRING$;CHR$(34)
    else
      PRINT "No initiator."
    END IF  
  ELSE
   PRINT "P2P Config failed"
  END IF
  PAUSE 1000
  GOTO MAINLOOP:

