'              THE COOBER PEDE OPAL MINER GAME (opal_miner_20m2.bas) 
 
'****************************** MAIN PROGRAM CODE *************************       

power_up:'------ initialise the microcontroller settings
b0 = 0: b1 = 0: b2 = 0: b3 = 0
let dirsB = %11111111: let pinsB = 00000000
let dirsC = %10001011: let pinsC = 00000000
pullup %0111000000000000
setfreq m16
'goto start_up

start_up:'------ beep and initialise the program settings
tune C.7,4,($27) 
read 1,b0
if b0 < 50 then: b0 = 140: write 1,b0: endif
if PinC.2 = 0 then gosub on_time
gosub array_drive
'goto light_on

light_on:'------- climb PB increments the up/down counter
high C.3
let b2 = 0
for b1 = 1 to b0
if pinC.2 = 0 then: inc b2: endif
if b2 > 10 then: inc b3: let b2 = 0: endif
if b3 > 200 then: goto short_tune: endif
gosub array_drive
pause 5
next b1
'goto light_off

light_off:'------ climb PB decrements the up/down counter
low C.3
let b2 = 0
for b1 = 1 to 250
if pinC.2 = 0 then: inc b2: endif
if b3 < 2 then let b3 = 4: endif
if b2 > 6 then: let b3 = b3 - 2: let b2 = 0: endif
if b3 > 200 then: goto short_tune: endif
pause 8
next b1
goto light_on

array_drive: '---- turn on one of the LEDs in the array
pause 2
if b3 > 198 then: pinsB = %00000000: high C.1: low C.0: endif ' (top Led)                   
if b3 > 176 and b3 < 199 then: pinsB = %00000000: low C.1: high C.0: endif
if b3 > 154 and b3 < 177 then: pinsB = %10000000: low C.1:  low C.0: endif
if b3 > 132 and b3 < 155 then: pinsB = %01000000: low C.1:  low C.0: endif
if b3 > 110 and b3 < 133 then: pinsB = %00100000: low C.1:  low C.0  endif
if b3 >  88 and b3 < 111 then: pinsB = %00010000: low C.1:  low C.0: endif
if b3 >  66 and b3 <  89 then: pinsB = %00001000: low C.1:  low C.0: endif
if b3 >  44 and b3 <  67 then: pinsB = %00000100: low C.1:  low C.0  endif
if b3 >  22 and b3 <  45 then: pinsB = %00000010: low C.1:  low C.0: endif
if b3 <  23 then: pinsB = %00000001:low C.1: low C.0 : endif ' (bot Led)
return

short_tune: '----- play the Muppets Theme at top of ladder 
pinsB = %00000000: pinsC = 00000010
tune C.7,5,($2C,$24,$24,$27,$25,$64,$25,$40,$60,$62,$24,$64,$64,$6C,$64,$27)
end


'**************************** SET DEFAULT ON TIME ***************************

on_time:'-------- table selects climb indicator on time 
pause 2
high B.0: low C.1: b0 = 250: gosub pb_test
high B.1: low B.0: b0 = 228: gosub pb_test
high B.2: low B.1: b0 = 206: gosub pb_test
high B.3: low B.2: b0 = 184: gosub pb_test
high B.4: low B.3: b0 = 162: gosub pb_test
high B.5: low B.4: b0 = 140: gosub pb_test
high B.6: low B.5: b0 = 118: gosub pb_test
high B.7: low B.6: b0 = 96:  gosub pb_test
high C.0: low B.7: b0 = 74:  gosub pb_test
high C.1: low C.0: b0 = 52:  gosub pb_test
goto on_time

pb_test:'-------- cycle untill the climb PB is releaswd 
for b1 = 0 to 200
if pinC.2 = 1 then goto save_no
pause 10
next b1
return

save_no:'-------- save the default on time in EEPROM
write 1,b0
pause 5000
goto light_on

'              NOTE turn the power switch OFF to end this game.
'           Turn the power switch OFF then ON to start a new game

'---------------------------------------------------------------------------------
' b0 = climb indicator on-time
' b1 = for-next loop variable
' b2 = climb button counter.
' b3 = main up-down counter.
'---------------------------------------------------------------------------------


'*************************** OPTIONAL SHORT TUNES ****************************

'            NOTE short tunes for use at the top of the ladder

'Muppets Theme
'tune C.7,5,($2C,$24,$24,$27,$25,$64,$25,$40,$60,$62,$24,$64,$64,$6C,$64,$27)
'Looney Tunes  
'tune C.7,5,($44,$42,$40,$42,$44,$43,$44,$40,$42,$42,$42,$C2,$42,$40,$6B,$40,$42)
'Peter Gunn  
'tune C.7,5,($66,$64,$67,$64,$69,$67,$64,$64,$66,$64,$67,$64,$69,$67,$A4,$21,$EC)
'Star Wars   
'tune C.7,5,($65,$65,$EA,$C5,$43,$40,$8A,$C5,$43,$42,$40,$8A,$C5,$42,$43,$80)
'Batman
'tune C.7,5,($6A,$6A,$69,$69,$6A,$6A,$6B,$6B,$6A,$6A,$69,$69,$6A,$6A,$2B,$6C,$2B)
'George Of The Jungle  
'tune C.7,5,($4C,$25,$25,$4C,$25,$29,$4C,$00,$4C,$25,$4C,$25,$4C,$27,$27,$4C,$29)
'Indiana Jones  
'tune C.7,5,($6C,$65,$67,$6C,$C0,$6C,$22,$6C,$64,$A5,$2C,$27,$6C,$69,$6B,$6C,$C5)
'Adams Family  
'tune C.7,5,($05,$49,$05,$40,$2B,$07,$45,$04,$47,$04,$64,$29,$05,$40,$05,$49,$05)