from PIL import Image
from PIL import ImageDraw
from PIL import ImageFont

import math
import urllib
import time
import re
from datetime import datetime
from datetime import timedelta
import tideParser

from lib_tft24T import TFT24T
import RPi.GPIO as GPIO
import spidev
# for displaying tides on display

#define colours here (r,g,b)
Cbackground = (0,0,0)
Ctext = (0,255,255)
Cday = (0,0,64)
Cnight = (0,0,24)
Ctrace = (255,255,255)
Chighlight = (0,0,48)
Clowlight = (0,48,0)

# GPIO assignments
DC = 24
RST = 23
LED = 18
PEN = 25

GPIO.setmode(GPIO.BCM)
GPIO.setwarnings(False)
TFT = TFT24T(spidev.SpiDev(), GPIO, landscape=False)        #landscape not working, coordinates are all kludged
TFT.initLCD(DC, RST, LED)
TFT.initTOUCH(PEN)
draw = TFT.draw()
font=ImageFont.truetype('FreeSans.ttf', 24)

def initScreen():
    TFT.clear(Cbackground)

def clearScreen():
    draw.rectangle((0, 0, 239, 319), outline=(0,0,0), fill=Cbackground)

def loadingScreen():
    draw.rectangle((216, 0, 239, 319), outline=(0,0,0), fill=Cbackground)
    draw.textrotated((216,0), "Loading", 270, font=font, fill=Ctext)
    return

def clearBuffer():
    draw.rectangle((0, 0, 239, 319), outline=(0,0,0), fill=Cbackground)
    
def drawFixed():
    draw.rectangle((216, 0, 24, 239), outline=(0,0,0), fill=Cday)
    draw.textrotated((192,245), "High:", 270, font=font, fill=Ctext)
    draw.textrotated((120,245), "Low:", 270, font=font, fill=Ctext)
    draw.textrotated(( 48,245), "Now:", 270, font=font, fill=Ctext)
    draw.rectangle((23, 0, 0, 319), outline=Clowlight, fill=Clowlight)            
    
def tideStatus(thigh,hhigh,tlow,hlow,s,hnow):       #time, height, rising/falling,current h
    draw.textrotated(( 24-5,240),s, 270, font=font, fill=Ctext)
    draw.textrotated((168,240), thigh, 270, font=font, fill=Ctext)
    draw.textrotated((144,240), hhigh, 270, font=font, fill=Ctext)
    draw.textrotated(( 96,240), tlow, 270, font=font, fill=Ctext)
    draw.textrotated(( 72,240), hlow, 270, font=font, fill=Ctext)
    draw.textrotated(( 0,240), "  {:04.2f}m".format(hnow), 270, font=font, fill=Ctext)
    
def line(x1,y1,x2,y2,c):        #line interface
    draw.line((x1,y1,x2,y2),fill=c)

def rectangle(x1,y1,x2,y2,c):   #rectangle
    draw.rectangle((x1, y1, x2, y2), outline=c, fill=c)
    
def text(x,y,t):           #minimal text x,y,text
    draw.textrotated((x,y), t, 270, font=font, fill=Ctext)
    
def textr(x,y,t):           #minimal rotated text x,y,text
    draw.textrotated((x,y), t, 0, font=font, fill=Ctext)

def textfull(x,y,t,c,r):           #minimal text x,y,text,colour,rotation
    draw.textrotated((x,y), t, r, font=font, fill=c)
    
def update():
    TFT.display()

def touchx():
    return TFT.penPosition()[0]

def touchy():
    return TFT.penPosition()[1]

def textwidth(t):
    return font.getsize(t)[0]
    
def textheight(t):
    return font.getsize(t)[1]
