from datetime import datetime
from datetime import timedelta
import time
import tideParser
import screen
import copy
import json

location ="NSW_TP007"
#location ="VIC_TP001"
maxtide = 2.2
mintide = -0.2
tidemult = 192/(maxtide-mintide)
tideoffset = 24-(tidemult*mintide)

#define colours here (r,g,b)
Cbackground = (0,0,0)
Ctext = (0,255,255)
Cday = (0,0,64)
Cnight = (0,0,24)
Ctrace = (255,255,255)
Chighlight = (0,0,48)
Clowlight = (0,48,0)
screen.initScreen()
screen.update()
datastatus=0         #0=no data,1=valid but old, 2=valid
savestatus=0         #current valid data has been saved
tresults=[]
tempresults=[]

runflag=1

while runflag:
    d=datetime.now()
    dh=datetime(year=d.year,month=d.month,day=d.day,hour=d.hour)   #round to whole hours
    if datastatus < 2:
        print "Loading..."
        screen.loadingScreen()
        screen.update()        
        del tempresults[:]        
        tempresults=tideParser.getTides(location,d-timedelta(days=2),4) #location id, date start, number of days
        print len(tempresults)
        if len(tempresults)>8:
            del tresults[:]
            tresults=copy.deepcopy(tempresults)
        print "Done"
        if len(tresults)>8:
            datastatus=2

    #print len(tresults),datastatus
    screen.clearBuffer()

    try:
        screen.text(216,0, tresults[0][0])     #title
    except IndexError:
        screen.text(216,0, "Error- data not available")     

    screen.drawFixed()      #non-changing parts
    
    i=0
    for t in tresults:
        if t[1]<datetime.now(): i=i+1 

    #draw graph with primitives
    lastt = tideParser.getIntermediate(tresults,dh+timedelta(hours=-25))
    if lastt < -10 :
        datastatus = 1         #data is valid but outdated
        lastt=0
    if lastt<mintide: lastt=mintide
    if lastt>maxtide: lastt=maxtide
    for h in range(-24,24):             ##iterate over last 1 day/next 1 day
        tnow = dh+timedelta(hours=h)
        thist = tideParser.getIntermediate(tresults,tnow)
        if thist < -10 :
            datastatus = 1         #data is valid but outdated
            thist=0        
        if tnow.hour <7 or tnow.hour >17:
            screen.rectangle(216, h*5+121, 24, h*5+125,Cnight)
        else:
            screen.rectangle(216, h*5+121, 24, h*5+125, Cday)        
        if thist<mintide: thist=mintide
        if thist>maxtide: thist=maxtide
        screen.line(tideoffset+lastt*tidemult,h*5+120,tideoffset+thist*tidemult,h*5+125,Ctrace)
        lastt=thist
        if tnow.day == dh.day:
            screen.rectangle(23, h*5+121, 0, h*5+125,Chighlight)
    next

    #draw now graticule
    screen.line(216,125,24,125,Ctrace)
    #draw horizontal lines
    for p in range (int(mintide),int(maxtide+1)):
        if p>= mintide and p<= maxtide:
            screen.line(tideoffset+p*tidemult,0,tideoffset+p*tidemult,239,Ctrace)
            screen.text(int(tideoffset+p*tidemult)-6,3,str(p))

    dlabel=datetime(year=d.year,month=d.month,day=d.day,hour=12)+timedelta(days=-1)   #mark out days on time axis
    dtext=datetime.strftime(dlabel, '%a %d')
    dpixel = int(((d-dlabel).total_seconds())/720+35)
    screen.text(1,125-dpixel, dtext)

    dlabel=datetime(year=d.year,month=d.month,day=d.day,hour=12)+timedelta(days=0)   #mark out days on time axis
    dtext=datetime.strftime(dlabel, '%a %d')
    dpixel = int(((d-dlabel).total_seconds())/720+35)
    screen.text(1,125-dpixel, dtext)

    dlabel=datetime(year=d.year,month=d.month,day=d.day,hour=12)+timedelta(days=1)   #mark out days on time axis
    dtext=datetime.strftime(dlabel, '%a %d')
    dpixel = int(((d-dlabel).total_seconds())/720+35)
    screen.text(1,125-dpixel, dtext)

    #erase overflow text
    screen.rectangle(23, 240, 0, 319, Cbackground)            

    thigh='    -'  #blank defaults
    hhigh='    -'
    tlow='    -'
    hlow='    -'
    s='    -'
    hnow=0

    if i>0:
        if len(tresults)>i+1:
            if tresults[i][0] == 'High' and tresults[i+1][0] == 'Low':
                s="  Rising"
                thigh=datetime.strftime(tresults[i][1],'  %H:%M')
                hhigh="  {}m".format(tresults[i][2])
                tlow=datetime.strftime(tresults[i+1][1],'  %H:%M')
                hlow="  {}m".format(tresults[i+1][2])
            if tresults[i][0] == 'Low' and tresults[i+1][0] == 'High':
                s="  Falling"
                thigh=datetime.strftime(tresults[i+1][1],'  %H:%M')
                hhigh="  {}m".format(tresults[i+1][2])
                tlow=datetime.strftime(tresults[i][1],'  %H:%M')
                hlow="  {}m".format(tresults[i][2])
        hnow = tideParser.getIntermediate(tresults,d)    
    screen.tideStatus(thigh,hhigh,tlow,hlow,s,hnow)

    screen.rectangle(239, 240, 216, 319, Cbackground)            #top right corner
    screen.text(222,260,datetime.strftime(d, '%H:%M'))

    screen.update()
    #wait for minute to roll over
    while datetime.now().minute == d.minute and runflag:
        time.sleep(0.2)
        if screen.touchx()>0 and screen.touchy()>0: runflag = 0 #finish
    print datetime.now().minute

print "Exiting Tides"
screen.clearBuffer()
screen.update()


