# custom handler just extracts data
import math
#import urllib
import urllib2
import time
import re
from HTMLParser import HTMLParser
from datetime import datetime
from datetime import timedelta

hflag=0
tides=[]   #list of tide events
tide=[]    #single tide event (type, time, height)

#url="http://www.bom.gov.au/australia/tides/print.php?aac=NSW_TP007&type=tide&date=18-4-2018&days=2"
url1="http://www.bom.gov.au/australia/tides/print.php?aac="  #followed by place (eg NSW_TP007)
url2="&type=tide&date=" # folowed by date
url3="&days="     #followed by number of days

class tideParser(HTMLParser):    
    def handle_starttag(self, tag, attrs):
        global hflag
        #print "Encountered a start tag:", tag,attrs
        a=dict(attrs)
        if tag == "td":
            if 'class' in a:
                #print a['class']
                if a['class'] == 'localtime high-tide' :
                    if 'data-time-local' in a:
                        #print 'High Tide:'
                        #print '   ',a['data-time-local']
                        #print datetime.strptime(a['data-time-local'][:19], '%Y-%m-%dT%H:%M:%S')
                        del tide[:]
                        tide.append("High")
                        tide.append(datetime.strptime(a['data-time-local'][:19], '%Y-%m-%dT%H:%M:%S'))
                if a['class'] == 'localtime low-tide' :
                    if 'data-time-local' in a:
                        #print 'Low Tide:'
                        #print '   ',a['data-time-local']
                        #print datetime.strptime(a['data-time-local'][:19], '%Y-%m-%dT%H:%M:%S')
                        del tide[:]
                        tide.append("Low")
                        tide.append(datetime.strptime(a['data-time-local'][:19], '%Y-%m-%dT%H:%M:%S'))
                if a['class'] == 'height high-tide' :
                    if len(tide)>1:
                        if tide[0] == 'High':
                            hflag = 1    #catch height from between tags
                        
                if a['class'] == 'height low-tide' :
                    if len(tide)>1:
                        if tide[0] == 'Low':
                            hflag = 1    #catch height from between tags

        if tag == "img":
            if 'class' in a:
                if a['class'] == 'moon-phase':
                    if 'title' in a:
                        #print a['title'],
                        hflag = 2    # catch date
        if tag == "h2":
            if 'class' in a:
                if a['class'] == 'tide':
                    hflag = 3     #catch title

    #def handle_endtag(self, tag):
        #global hflag
        #print "Encountered an end tag :", tag

    def handle_data(self, data):
        global hflag
        if hflag == 1:
            #print '      Height:',data
            #print float(re.search('\d+.\d+',data).group(0))
            tide.append(float(re.search('\d+.\d+',data).group(0)))
            tides.append(list(tide))                  #add to our list of tides
            #print tide
            del tide[:]                         #clear
            hflag=0
        if hflag == 2:
            #print 'Date:',data
            hflag=0
        if hflag == 3:
            del tide[:]
            tide.append(data)
            tide.append(datetime(2000,1,1))  #dummy time
            tide.append(0)
            tides.append(list(tide))        #add to our list of tides
            del tide[:]
            hflag=0

def getTides(tpname,datestart,daycount):
    d=(datestart).strftime('%d-%m-%Y')
    #print url1 + tpname + url2 + d + url3 + str(daycount)
    r = urllib2.build_opener()
    r.addheaders = [('User-Agent', 'Mozilla/5.0')]
    res = r.open(url1 + tpname + url2 + d + url3 + str(daycount))    
    response = res.read()
    #print response
    t=tideParser()
    t.feed(response)
    print "Getting tides"
    return tides

def getIntermediate(tides,ti):      #get tide at intermediate time ti
    i=0
    for t in tides:
        if t[1]< ti: i=i+1
    if i>0 and i<len(tides):
        tt=(tides[i][1]-tides[i-1][1]).seconds
        tn=(ti-tides[i-1][1]).seconds
        p= (math.cos(float(tn)*math.pi/float(tt))+1)/2          #is one for near first item, 0 for second
        print p*tides[i-1][2]+(1-p)*tides[i][2]
        return p*tides[i-1][2]+(1-p)*tides[i][2]
    return -100     #flag that there isn't data available for this time
