from datetime import datetime, timedelta
import time
import screen
import urllib, json

feednumber = 329619

#get the following from the channel page
fielda = 6
fieldb = 3
#spans for graph
amin=0
amax=40
bmin=0
bmax=100
divisions=5        #vertical divisions
hourspan=168       #total horizontal span (needs to be divisible by hourdivisions)
hourdivisions=24   #hours per division, lines shown on multiple of this
tformat='%d'       #use this format for day of month
#tformat='%H:00'    #use this format for hours
#tformat='%a %d'     #Mon 17 format
updateInterval=10    #in minutes

#graph boundaries
v0=24
v1=216
t0=48
t1=272

#define colours here (r,g,b)
Coloura = (255,0,0)     #data a trace and axis
Colourb = (0,255,0)     #data b trace and axis
Cbackground = (0,0,0)
Ctext = (0,255,255)
Cday = (0,0,64)
Cnight = (0,0,24)
Ctrace = (255,255,255)
Chighlight = (0,0,48)
Clowlight = (0,48,0)
Cgrid = (128,128,128)

#internal storage
fieldaname=""
fieldbname=""
title=""
desc=""

graphdata=[]            #only the data we need in nice formats (timedate/float/float)
datapoint=[]            #single line to add to above

dayspan=str(int(hourspan/24)+1)

url1 = "https://thingspeak.com/channels/"
url2 = "/feed.json?days="
url = url1+str(feednumber)+url2+dayspan

print url

screen.initScreen()
screen.rectangle(v0,t0,v1,t1,Chighlight)
screen.loadingScreen()
screen.update()

runflag =1
while runflag:
    now = time.time()
    del graphdata[:]
    try:
        response = urllib.urlopen(url)
        data = json.loads(response.read())
        title= str(data['channel']['name'])
        desc=str(data['channel']['description'])

        for field in data['channel']:
            if str(field)[0:5] == "field" and str(field)[5:] == str(fielda):
                fieldaname=data['channel'][field]
            if str(field)[0:5] == "field" and str(field)[5:] == str(fieldb):
                fieldbname=data['channel'][field]
        print title
        print desc
        print fieldaname
        print fieldbname
        for feed in data['feeds']:
            del datapoint[:]    #clear
            #parse UTC and convert to local current (ie ignore DST changes)
            datapoint.append(datetime.strptime(feed['created_at'][:19], '%Y-%m-%dT%H:%M:%S')+ (datetime.fromtimestamp(now) - datetime.utcfromtimestamp(now)))
            datapoint.append(float(feed['field'+str(fielda)]))
            datapoint.append(float(feed['field'+str(fieldb)]))
            if datapoint[0]>datetime.fromtimestamp(now)-timedelta(hours=hourspan) and datapoint[0]<datetime.fromtimestamp(now):
                graphdata.append(list(datapoint))  #only keep if they're in our time range
        graphdata.sort(key=lambda x: x[0]) #sort by time (in case not already)

        if len(graphdata)>0:
            print graphdata[0][0]
            print graphdata[len(graphdata)-1][0]
            print len(graphdata), "items found"
        else:
            print "List empty"

        #draw basic parts of screen
        screen.clearBuffer()
        screen.rectangle(v0,t0,v1,t1,Chighlight)        #plot area
        screen.text(220,(t0+t1-screen.textwidth(title))/2, title)
        screen.textfull((v0+v1-screen.textwidth(fieldaname))/2,-4, fieldaname,Coloura,0)
        screen.textfull((v0+v1-screen.textwidth(fieldbname))/2,296, fieldbname,Colourb,0)
        for i in range(0,divisions+1):
            vi=int(v0+(v1-v0)*(float(i)/divisions))
            a=str(int(amin+(amax-amin)*(float(i)/divisions)))
            b=str(int(bmin+(bmax-bmin)*(float(i)/divisions)))
            screen.line(vi,t0,vi,t1,Cgrid)          #horizontal grid lines
            screen.textfull(vi-(screen.textwidth(a))/2,20,a,Coloura,0)  #and vertical axis labels
            screen.textfull(vi-(screen.textwidth(b))/2,272,b,Colourb,0)
        
        tright=datetime.fromtimestamp(now)
        tleft=tright-timedelta(hours=hourspan)
        print tright
        print tleft
        for i in range(0,hourspan,hourdivisions):        
            tempt = datetime.fromtimestamp(now)-timedelta(hours=i)
            #round down to multiple of hourdivisions
            tgrid = datetime(tempt.year,tempt.month,tempt.day,int(tempt.hour/hourdivisions)*hourdivisions)
            #chart position of tgrid
            ti= t0+(t1-t0)*((tgrid-tleft)/(hourspan/24)).seconds/86400  #reduce to fraction [0-1] > convert to seconds => [0-86400]
            screen.line(v0,ti,v1,ti,Cgrid)
            screen.text(0,ti, datetime.strftime(tgrid,tformat))

            #plot data
            lastt=int(t1+((t0-t1)*((datetime.fromtimestamp(now)-graphdata[0][0])/(hourspan/24)).seconds)/86400)
            lasta=int(v0+(v1-v0)*(graphdata[0][1]-amin)/(amax-amin))
            lastb=int(v0+(v1-v0)*(graphdata[0][2]-bmin)/(bmax-bmin))
        for dp in graphdata:            
            thist=int(t1+((t0-t1)*((datetime.fromtimestamp(now)-dp[0])/(hourspan/24)).seconds)/86400)
            thisa=int(v0+(v1-v0)*(dp[1]-amin)/(amax-amin))
            thisb=int(v0+(v1-v0)*(dp[2]-bmin)/(bmax-bmin))
            #print thist,thisa,thisb
            screen.line(lasta,lastt,thisa,thist,Coloura)
            screen.line(lastb,lastt,thisb,thist,Colourb)
            lastt=thist
            lasta=thisa
            lastb=thisb
        screen.update()

    except (KeyError,IOError):
        print "URL Error or Load error"
        screen.rectangle(216,296,239,319,(255,0,0))     #red flag in corner
        screen.update()
        
    while datetime.fromtimestamp(now)+timedelta(minutes=updateInterval)-datetime.now()>timedelta(minutes=0):
        time.sleep(0.2)
        if screen.touchx()>0 and screen.touchy()>0:
            runflag = 0 #finish
            break

print "Exiting Thingspeak"
screen.clearBuffer()
screen.update()
