#todo get disruption message (when there's one active to test)

import urllib, json
import time
import re
import screen
from datetime import datetime

#set stop# here (find from http://tramtracker.com/pid.html )
stop = "3013"

#define colours here (r,g,b)
Cbackground = (0,0,0)
Ctext = (0,255,255)
Cday = (0,0,64)
Cnight = (0,0,24)
Ctrace = (255,255,255)
Chighlight = (0,0,48)
Clowlight = (0,48,0)
screen.initScreen()    
screen.loadingScreen()            
screen.update()

url1 = "http://tramtracker.com/Controllers/GetNextPredictionsForStop.ashx?stopNo="
url2 = "&routeNo=0&isLowFloor=false"
url3 = "http://tramtracker.com/Controllers/GetStopInformation.ashx?s="

stopinfourl=url3+stop
arrivalsurl=url1+stop+url2

stopname=""
stopname2=""
runflag=1

while runflag:
    currenttime=time.time()
    d=datetime.now()
    if stopname == "":
        try:
            #get stop name
            response = urllib.urlopen(stopinfourl)
            data = json.loads(response.read())
            stopname = data['ResponseObject']['StopName']
            if screen.textwidth(data['ResponseObject']['CityDirection'] + ": Stop "+ data['ResponseObject']['FlagStopNo']) >255:
                stopname2 = data['ResponseObject']['CityDirection'] #truncate if too long
            else:                
                stopname2 = data['ResponseObject']['CityDirection'] + ": Stop "+ data['ResponseObject']['FlagStopNo']
        except (TypeError,IOError):
            print "URL or data error"

    #get tt data
    try:
        response = urllib.urlopen(arrivalsurl)
        data = json.loads(response.read())

        arrivals=[]         #list of arrivals
        arrival=[]          #each arrival

        i=0

        querytime=float(re.search('\d{10}',str(data['timeResponded']),).group(0))
        timeoffset=currenttime-querytime

        for field in data['responseObject']:
            arrival.append(float(re.search('\d{10}',str(field['PredictedArrivalDateTime']),).group(0)))
            arrival.append(field['Destination'])
            arrival.append(field['RouteNo'])
            arrival.append(field['AirConditioned'])
            arrival.append(field['IsLowFloorTram'])
            arrival.append(field['VehicleNo'])
            arrivals.append(list(arrival))      #keep a copy only
            del arrival[:]                      #clear the old list
            i=i+1                               #keep count (not needed?)

        arrivals.sort(key=lambda x: x[0])       #sort by time

        print "Web Query Time:"+time.ctime(querytime)
            
        screen.clearBuffer()
        for i in range(0,4):        #row shading for clarity
            screen.rectangle(i*48+24,0,i*48+48,319,Chighlight)
        if stopname == "":
            screen.text(216,0,"Stop name unknown")
            print "Stop name unknown"
        else:
            screen.text(244-screen.textheight(stopname),5,stopname)
            screen.text(220-screen.textheight(stopname2),5,stopname2)
            print stopname
            print stopname2
        screen.text(197,260,datetime.strftime(d, '%H:%M')) #time

        displayline=0     #keep track of where we are printing on screen
        for a in arrivals:
            t=str(int((a[0]-querytime)/60))
            if t == '0': t="Now"
            print t,a[1],a[2]
            if displayline<8:
                screen.text(195-screen.textheight(a[2])-displayline*24,0,a[2])
                screen.text(195-screen.textheight(a[1])-displayline*24,50,a[1])
                screen.text(195-screen.textheight(t)-displayline*24,315-screen.textwidth(t),t)           
            displayline=displayline+1
            
        screen.update()
    except (TypeError,IOError):
        print "URL or data error"
        
    #wait for a minute since last request
    while currenttime+60 > time.time() and runflag:
        time.sleep(0.2)
        if screen.touchx()>0 and screen.touchy()>0: runflag = 0 #finish
    print datetime.now().minute

print "Exiting Trams"
screen.clearBuffer()
screen.update()
