'*********************************************************************************************
' Picaxe humidity sensor (Honeywell HIH4000-001)
' Each ADC step is 5V/256 = 0.0195 V
' Manufacturer data shows an offset of 0.8V which equates to an ADC value of 41 (0.8/0.0195)
' Relative humidity (RH) slope is ~ 0.0306 V/%RH or 1.57 ADC step/%RH
' RH = ADC value - offset/slope
' RH = ADC value - 41/(1.57) (for the Picaxe RH = ADC value - 41*100/157
' The program first checks to see what the required humidity is set to (main).
' The program then goes to the approprate subroutine (RH70, RH80 or RH90).
' The relevant subroutine then checks the actual humidity and turns the humifier on or off accordingly.

	b1 = 0
	
main:
	output C.0							'Set C.0 as output pin
	pause 30
	if pinC.4 = 1 then RH70
	if pinC.3 = 1 then RH80
	if pinC.2 = 1 then RH90
	goto main
	
RH70:
	readadc C.1, b1						'read ADC humidity value into variable b1
	if b1 => 152 then
	low C.0 else						'turn off relay and humdifier when humidity reaches 70%
	high C.0
	endif
	pause 10000							'wait 10 seconds
	goto main

RH80:
	readadc C.1, b1						'read ADC humidity value into variable b1
	if b1 => 167 then
	low C.0 else						'turn off relay and humdifier when humidty reaches 80%
	high C.0
	endif
	pause 10000							'wait 10 seconds
	goto main
	
RH90:
	readadc C.1, b1						'read ADC humidity value into variable b1
	if b1 => 183 then
	low C.0 else						'turn off relay and humdifier when humidity reaches 90%
	high C.0
	endif
	pause 10000							'wait 10 seconds
	goto main							'loop
	