
'=============================================================================
'/////////////////////////////////////////////////////////////////////////////
'=============================================================================

'                       R/C Servo Tester 2018 Ver 2
'                       Created by G Ramsay

'=============================================================================
'/////////////////////////////////////////////////////////////////////////////
'=============================================================================

'                   NOTE THIS PROGRAM REQUIRES PBP3

'=============================================================================
'/////////////////////////////////////////////////////////////////////////////
'=============================================================================

'The microcontroller is a PIC16F616 with an internal oscillator of 8MHz.
'The controller PCB is the Servo Tester 2018 PCB.
'The LCD is 2 lines x 16 characters.

'=============================================================================
'/////////////////////////////////////////////////////////////////////////////
'=============================================================================

'PORT DEFINITIONS
'================

' Define port A function

'PORTA.0    Analogue        Potentiometer input.
'PORTA.1    Output          Servo signal.
'PORTA.2    Unassigned
'PORTA.3                    Configured as MClr.
'PORTA.4    Unassigned
'PORTA.5    Unassigned
 
' Define port C function

'PORTC.0    Output          LCD data bit D4.
'PORTC.1    Output          LCD data bit D5.
'PORTC.2    Output          LCD data bit D6.
'PORTC.3    Output          LCD data bit D7.
'PORTC.4    Output          LCD signal EN.
'PORTC.5    Output          LCD signal RS.

'=============================================================================
'/////////////////////////////////////////////////////////////////////////////
'=============================================================================

'CONFIGURATION SETTINGS
'======================

'This configuration method is NOT supported by PBP versions before PBP3.
#CONFIG
    __config _INTRC_OSC_NOCLKOUT & _WDT_ON & _PWRTE_ON & _MCLRE_ON & _CP_OFF & _IOSCFS_8MHZ
#ENDCONFIG

'=============================================================================
'/////////////////////////////////////////////////////////////////////////////
'=============================================================================

'DEFINITIONS
'===========

 DEFINE OSC 8

 DEFINE LCD_DREG        PORTC       'Set LCD data port.
 DEFINE LCD_DBIT        0           'Set LCD lowest data bit.
 DEFINE LCD_RSREG       PORTC       'Set LCD register select port.
 DEFINE LCD_RSBIT       5           'Set LCD register select bit.
 DEFINE LCD_EREG        PORTC       'Set LCD enable port.
 DEFINE LCD_EBIT        4           'Set LCD enable bit.
 DEFINE LCD_BITS        4           'Set LCD buss size.
 DEFINE LCD_LINES       2           'Set LCD number of display lines.
 DEFINE LCD_COMMANDUS   1500        'Set LCD command delay time in usecs.
 DEFINE LCD_DATAUS      50          'Set LCD data delay time in usecs.

 DEFINE ADC_BITS 10                 '10 bit result.
 DEFINE ADC_CLOCK 3                 'ADCIN clock source - rc = 3
 DEFINE ADC_SAMPLEUS 50             'Pause after selecting channel before
                                    'ADC sample.

'=============================================================================
'/////////////////////////////////////////////////////////////////////////////
'=============================================================================

'General  Constants
'------------------

 POTIN          CON     0           'Potentiometer analogue port.

'Word Variables
'--------------

 CURRPOT        VAR     WORD        'The current potentiometer value.
 OFFTIME        VAR     WORD        'R/C signal off time in usecs.
 PULWID         VAR     WORD        'R/C signal pulse width in usecs.
 TEMPWORD1      VAR     WORD        'Temporary variable.

'Byte Variables
'--------------

 TEMPBYTE1      VAR     BYTE        'Temporary variable.

'Bit Variables
'-------------

 TEMPBIT1       VAR     BIT         'Temporary variable

'Port Aliases.
'-------------

 RCPULSE        VAR     PORTA.1     'R/C output port.

'Initialisation.
'---------------

 GOSUB INITIALIZE

'=============================================================================
'/////////////////////////////////////////////////////////////////////////////
'=============================================================================

 'Main loop.
 DO
    'Get the pot value.
    ADCIN POTIN, TEMPWORD1
    'Generally cannot get the left justify to work. Don't bother setting. Just
    'accept right justify and perform a left shift.
    TEMPWORD1 = TEMPWORD1 >> 6
    'Get the difference between the current potentiometer value and the new
    'measurement to decide on changing the pulse setting. Since the R/C pulse
    'resolution is set 20 usec over a range of 2000 usecs, only change the
    'setting if the difference is greater than 10.
    IF TEMPWORD1 > CURRPOT THEN
        TEMPBYTE1 = TEMPWORD1 - CURRPOT
    ELSE
        TEMPBYTE1 = CURRPOT - TEMPWORD1
    ENDIF
    IF TEMPBYTE1 > 10 THEN
        'Record the new pot value as the current value.
        CURRPOT = TEMPWORD1
        'Change the pot value to suit the 100 value range. NB. integer maths.
        TEMPWORD1 = TEMPWORD1 / 10
        'Convert to usec and limit the maximum.
        TEMPWORD1 = TEMPWORD1 * 20
        IF TEMPWORD1 > 2000 THEN TEMPWORD1 = 2000
        'Get the pulse value.
        PULWID = TEMPWORD1 + 500
        'And the off period.
        OFFTIME = 20000 - PULWID
        'Display the value.
        'Clear the LCD screen and print the first line.
        LCDOUT $FE, 1
        LCDOUT "Pulse width ="
        'Move the cursor to the beginning of the second line.
        LCDOUT $FE, $C0
        'Print the pulse width.
        LCDOUT DEC PULWID, " usec"
    ENDIF
    'Generate the R/C pulse.
    RCPULSE = 1
    PAUSEUS PULWID
    RCPULSE = 0
    'Wait for enough milliseconds to make the approx. 20msec refresh timing.
    PAUSEUS OFFTIME
 LOOP

'=============================================================================
'/////////////////////////////////////////////////////////////////////////////
'=============================================================================

 'This subroutine initializes the microcontroller.
 INITIALIZE:

    'Firstly, ensure that unwanted functional blocks are not enabled.
    T1CON = 0           'Disable the timer 1 module.
    T2CON = 0           'Disable the timer 2 module.
    CM1CON0 = 0         'Disable the comparator 1 module.
    CM2CON0 = 0         'Disable the comparator 2 module.
    INTCON = 0          'Disable interrupts.
    ANSEL = %00000001   'Enable analogue channel 0 only.

    TRISA = %11111101
    TRISC = %11000000

    CURRPOT = 1500      'This nominal value triggers the first display.
    RCPULSE = 0         'Set the R/C output to off.

    PAUSE 500           'Wait for the LCD to startup.
    LCDOUT $FE, 1       'Clear the LCD screen.
    LCDOUT "RC Servo Tester"
    PAUSE 2000
 RETURN

'=============================================================================
'/////////////////////////////////////////////////////////////////////////////
'=============================================================================
