

'                        REACTION TIMER WITH DELAYED START 
'                            (reaction_timer_20m2.bas)

'----------------------------------------------------------------------------------
' Start in standby mode with the 7 segment displays blank and the WAIT indicator on. 
'.Press the START button to cancel the WAIT indicator and begin a 2-6 second delay..
' Players must wait for the RUN indicator to light before pressing the STOP button. 
' You have 999ms to press the STOP button or the program halts and goes to standby.
' View the reaction time on the display,then press the CLEAR button to go to standby.
'----------------------------------------------------------------------------------


set_up:' -------------- initalise microprocessor - sound start-up beep -----------
b1 = 0: b2 = 0: b3 = 0
let dirsB = %11111111: let pinsB = %00000000
let dirsC = %10001111: let pinsC = %00001000
pullup %0111000000000000
tune B.7,4,($27)
setfreq m16
'goto start_loop:

start_loop:'------------ wait for a push button before starting counter -----------
pause 8
inc b4
if pinC.4 = 0 then goto start_delay
if b4 >= 12 then: let b4 = 4: endif
goto start_loop

start_delay:'----------- random delay (2-6 sec) before starting counter -----------
low C.3
tune B.7,4,($27)
for b5 = 0 to b4
pause 1000
if pinC.5 = 0 then goto set_up
next b5
gosub check_button
goto count_units

check_button:'--------- check "stop" button is off before the next move ----------
pause 8
if pinC.6 = 0 then goto check_button
return 

count_units:'--------- count "units" save in b1 - exit with "stop" button ---------
high C.7: low C.3
for b5 = 0 to 9
inc b1
if pinC.6 = 0 then goto display_driver
if pinC.5 = 0 then goto set_up
pause 3' (this pause sets the basic clock rate)
next b5
b1 = 0
'goto count_tens

count_tens:'----------- count "tens" save in b2 - exit with "stop" button ---------
inc b2
if pinC.6 = 0 then goto display_driver
if b2 <= 9 then goto count_units 
b2 = 0
'goto count_100s

count_100s:'----------- count "100s" save in b3 - exit with "stop" button ---------
inc b3 
if pinC.6 = 0 then goto display_driver
if b3 <= 9 then goto count_units
b3 = 0
goto set_up' (will re-start if count exceeds 999)

display_driver:'-------- check "stop" button is off before displaying count --------
gosub check_button
low C.7
tune B.7,4,($27)
'goto display_loop

display_loop:'---------- show the count untill the "clear" button is pressed --------
pause 2
on b1 gosub zero,one,two,three,four,five,six,seven,eight,nine
pulsout C.0,2000
on b2 gosub zero,one,two,three,four,five,six,seven,eight,nine
pulsout C.1,2000
on b3 gosub zero,one,two,three,four,five,six,seven,eight,nine
pulsout C.2,2000
if pinC.5 = 0 then goto set_up
goto display_loop

segment_data:'---------- the pinout required to display each 7 segment number ------

zero:  pinsB = %00111111: return
one:   pinsB = %00000110: return
two:   pinsB = %01011011: return
three: pinsB = %01001111: return
four:  pinsB = %01100110: return
five:  pinsB = %01101101: return
six:   pinsB = %01111100: return
seven: pinsB = %00000111: return
eight: pinsB = %01111111: return
nine:  pinsB = %01100111: return

  
'                               Definition of variables
'----------------------------------------------------------------------------------
'                  b1 = units count                b4 = start delay  
'                  b2 = tens count                 b5 = for/next loops . 
'                  b3 = 100s count             
'----------------------------------------------------------------------------------