//Tilt sensor library
//https://github.com/sparkfun/SparkFun_MMA8452Q_Arduino_Library
#include <Wire.h>
#include "SparkFun_MMA8452Q.h"
MMA8452Q accel;                   // create instance of the MMA8452 class

//display library
#include "XC3746.h"

//button
#define BUTTON A1

const char errMsg[]= {0,127,73,73,65,0,127,9,25,102,0,127,9,25,102,0}; //
const char splashMsg[]= {190,160,128,190,170,128,158,160,158,128,190,170,128,190,160,255}; //
const char blankMsg[]=  {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}; //

void(* resetFunc) (void) = 0; //declare reset function @ address 0

bool dispMode=false;  //false=> degrees, true => %grade

void setup() {
  XC3746_init();      //clear ram and set up
  XC3746_setDuty(2);  //turn on
  pinMode(BUTTON,INPUT_PULLUP);
  XC3746_sendArrayReverse(splashMsg);
  Wire.begin();
  delay(2000);
  if (accel.begin() == false) {             //if we can't communicate with the tilt sensor
    XC3746_sendArrayReverse(errMsg);        //display a message
    while(1){
      XC3746_setDuty(2);
      delay(300);
      if(digitalRead(BUTTON)==0){resetFunc();}    //and reboot if the button is pressed
      XC3746_setDuty(0);
      delay(300);
      if(digitalRead(BUTTON)==0){resetFunc();}
    }
  }
  XC3746_sendArrayReverse(blankMsg);      //clear display 
}

void loop() {
  long x,y,z;
  float a;  
  int n;
  long g=-1000; //flag value
  if (accel.available()){ 
    x=accel.getX();
    y=accel.getY();
    z=accel.getZ();
    //angle of level is in XY plane, we can check that Z is near zero too
    a=atan2(x,y)*(180/PI);  //in degrees, 0 horizontal
    n=a;
    if(abs(x)<abs(y)){
      g=(x*100)/y;
    }
    if(abs(z)<300){
      if(dispMode){     //% grade
        if(g>-100){
          XC3746_column=2;
          showPercent();
          XC3746_column=15;
          if(g<0){
            showDown();
            g=-g;
          }else{
            if(g==0){
              showNull();
            }else{
              showUp();
            }
          }
          XC3746_column=12;
          if(g<10){    //leading zero blanking
            XC3746_sendDigitReverse2(10); //is blank
          }else{
            XC3746_sendDigitReverse2((g/10)%10); //tens
          }
          XC3746_sendDigitReverse2(g%10); //units        
        }else{
          XC3746_sendArrayReverse(errMsg);        //display a message
        }
      }else{            //degrees
        if(abs(n)<100){
          XC3746_column=2;
          showDegree();
          XC3746_column=15;
          if(n<0){
            showDown();
            n=-n;
          }else{
            if(n==0){
              showNull();
            }else{
              showUp();
            }
          }
          XC3746_column=12;
          if(n<10){    //leading zero blanking
            XC3746_sendDigitReverse2(10); //is blank
          }else{
            XC3746_sendDigitReverse2((n/10)%10); //tens
          }
          XC3746_sendDigitReverse2(n%10); //units        
        }else{
          XC3746_sendArrayReverse(errMsg);        //display a message
        }
      }
    }else{        //ERROR
      XC3746_sendArrayReverse(errMsg);        //display a message
    }
    delay(300);
  }  
  if(digitalRead(A1)==0){
    XC3746_sendArrayReverse(blankMsg);      //clear display 
    dispMode=!dispMode;                     //switch mode
    while(digitalRead(A1)==0){}             //wait for release
    delay(10);
  }
}


void showPercent(void){
  XC3746_start();
  XC3746_data(XC3746_SETCOLUMN | ((XC3746_column+14)&0xF));  //15 is leftmost
  XC3746_data(194);
  XC3746_data(56);
  XC3746_data(134);
  XC3746_stop();
  XC3746_column=XC3746_column-3;
}

void showDegree(void){
  XC3746_start();
  XC3746_data(XC3746_SETCOLUMN | ((XC3746_column+14)&0xF));  //15 is leftmost
  XC3746_data(224);
  XC3746_data(160);
  XC3746_data(224);
  XC3746_stop();
  XC3746_column=XC3746_column-3;
}

void showUp(void){
  XC3746_start();
  XC3746_data(XC3746_SETCOLUMN | ((XC3746_column+14)&0xF));  //15 is leftmost
  XC3746_data(24);
  XC3746_data(96);
  XC3746_data(24);
  XC3746_stop();
  XC3746_column=XC3746_column-3;
}

void showDown(void){
  XC3746_start();
  XC3746_data(XC3746_SETCOLUMN | ((XC3746_column+14)&0xF));  //15 is leftmost
  XC3746_data(48);
  XC3746_data(12);
  XC3746_data(48);
  XC3746_stop();
  XC3746_column=XC3746_column-3;
}

void showNull(void){
  XC3746_start();
  XC3746_data(XC3746_SETCOLUMN | ((XC3746_column+14)&0xF));  //15 is leftmost
  XC3746_data(0);
  XC3746_data(0);
  XC3746_data(0);
  XC3746_stop();
  XC3746_column=XC3746_column-3;
}