typedef enum { trigger_on_high, trigger_on_low, trigger_on_rising_edge, trigger_on_falling_edge, trigger_on_change } input_sense_t;
typedef enum { delay_is_minimum, delay_is_maximum, delay_is_fixed } delay_type_t;
typedef enum { on_time_is_exact, on_time_is_minimum, on_time_is_maximum } on_time_type_t;
typedef enum { controls_nothing, controls_on_time, controls_delay_time, controls_off_time, controls_led_on_time } trimpot_controls_t;
//typedef enum { linear, exponential } trimpot_law_t;
//typedef enum { leds_off, leds_show_output_state, leds_show_input_state } leds_show_t;
typedef enum { waiting, pre_trigger, triggered, triggered_timeout, post_trigger } state_t;

typedef struct {
  trimpot_controls_t controls;
  unsigned char pad[3];
//  trimpot_law_t law;
  unsigned long min, max;
} trimpot_config_t;

typedef struct {
    union {
        struct {
            input_sense_t input_polarity;
            delay_type_t delay_type;
            on_time_type_t on_time_type;
            unsigned char on_time_resettable;
            unsigned long input_delay_ms;
            unsigned long relay_on_time_ms;
            unsigned long relay_off_time_ms;
            unsigned long led_on_time_ms;
            trimpot_config_t trimpots[2];
            unsigned char pullup_resistor_enabled;
        };
        unsigned long padding[16];
    };
//  leds_show_t leds_show;
} config_t;

typedef struct {
  unsigned char input_state, retrigger;
  state_t state;
  unsigned short trimpots[2];
  unsigned long timer, led_timer, retrigger_timer;
  unsigned long on_time, delay_time, off_time, led_time;
} status_t;

extern config_t active_config, saved_config;
extern status_t status;
