#include <TinyGPS++.h>                                  // Tiny GPS Plus Library
#include <SoftwareSerial.h>                             // Software Serial Library so we can use other Pins for communication with the GPS module
#include <SPI.h>
#include <Adafruit_GFX.h>
#include <Adafruit_SSD1306.h>


#include <EEPROM.h>
#include "writeAnything.h"
struct config_t{
    long ts;   //total time
    long ds;   //total dist
} int2IEeprom;



#define OLED_RESET 4
Adafruit_SSD1306 display(OLED_RESET);
#if (SSD1306_LCDHEIGHT != 32)
#error("Height incorrect, please fix Adafruit_SSD1306.h!");
#endif

#define AVG_NUM 10    // number of iterations of the adc routine to average the adc readings

char spinner[5] = "->";

// Error messages stored in flash.
//#define error(msg) Serial.println(F(msg))

static const int RXPin = 9; 
static const int TXPin = 8;       //12,13         // Ublox 6m GPS module to pins 12 and 13
static const uint32_t GPSBaud = 9600;                   // Ublox GPS default Baud Rate is 9600

const double Home_LAT = '24.088737';                      // Your Home Latitude
const double Home_LNG = '82.648176';                     // Your Home Longitude

TinyGPSPlus gps;                                        // Create an Instance of the TinyGPS++ object called gps

float dist;
//unsigned long dist,dist0,distI,ddist[10];
float dist0=0;

byte month, day, hour, minute, second, hundredths;
int year,t,d,m,h,m1,s,sh,x,y,ns;
String dataString="";
char datadate[16];
char ist[10];
char isd[10];
char ist1[10];

int i=0;
int st=0;
byte tracker=0;
byte tracker1=0;
byte tracker2=0;

float flat,flon,flat1,flon1,flat0,flon0,flatI,flonI;
long bfr0,bfr1,dbfr;

#define playpin 6   //Switch-P
#define viewpin 7  //Switch-Q

SoftwareSerial ss(RXPin, TXPin);                        // The serial connection to the GPS device



void setup(){  
pinMode(playpin,INPUT_PULLUP);   //5=input
pinMode(viewpin,INPUT_PULLUP);  //16=output  

//  Serial.begin(115200);
  ss.begin(GPSBaud); 

    display.begin(SSD1306_SWITCHCAPVCC, 0x3C);  // initialize with the I2C addr 0x3C (for the 128x32)
    display.display();
    delay(200);
    display.clearDisplay();
    display.setRotation(2); //2

display.clearDisplay();
display.setTextSize(1);                               // Set OLED text size to small
display.setCursor(0,0);
display.setTextColor( WHITE,BLACK); // white on black
display.println("GPS example");  
display.println(TinyGPSPlus::libraryVersion());
delay(1500);                                          // Pause 1.5 seconds  
display.print("Welcome");
display.display();
display.clearDisplay();
display.display();
}

void loop(){
getgps();

int val=digitalRead(playpin);  
int val1=digitalRead(viewpin);


display.drawRect(0,0,display.width(),display.height(), WHITE);

if(flat>0 and flon>0) {
 display.setTextSize(1);  
 display.setCursor(5,2);  //5,2
 display.print(flat,5);
 display.print(' ');
 display.print(flon,5);
 display.print(' ');
 printDigits(ns);
 display.setCursor(5,12);   //5,18
 display.print("T ");
 printDigits(h);
 display.print(':');
 printDigits(m1);
 display.print(':');
 printDigits(s);

 
 display.setCursor(70,10);
 display.setTextSize(2);
 display.setTextColor( WHITE,BLACK); // white on black
 if( gps.speed.kmph()>=1)
 //printDigits(gps.speed.kmph());
 display.println(gps.speed.kmph(),1);
 else display.println(" 0  ");

   unsigned long Distance_To_Home = (unsigned long)TinyGPSPlus::distanceBetween(gps.location.lat(),gps.location.lng(),Home_LAT, Home_LNG);
}



if(val==HIGH && x==1) {
flatI=flat;
flonI=flon;
dist= (unsigned long)TinyGPSPlus::distanceBetween(flat,flon,flat1,flon1); 
display.setTextSize(1);
display.setCursor(5,23); //5,21
display.print("l:");
printDigits(dist);
display.print("                 ");
}







if(val==LOW && x==1) {
flatI=flat;
flonI=flon;

x=0;
dist= (unsigned long)TinyGPSPlus::distanceBetween(flat,flon,flat1,flon1); 
//dist0=(unsigned long)TinyGPSPlus::distanceBetween(flat0,flon0,flat,flon);
dist0=dist0+dist;

if(st==0){
  dist=0.00;
  dist0=0.00;
  flat0=flat;
  flon0=flon;
  bfr0=(d*24+h)*3600+ m1*60+s;

}

flat1=flat;
flon1=flon;
bfr1=(d*24+h)*3600+ m1*60+s;

st=st+1;

display.setTextSize(1);
display.setCursor(5,23); //5,21
display.print("l/L:");

display.print(dist,0);
display.print('/');
display.print(dist0,0);

//display.setCursor(5,31);
display.print(" ");
printDigits(st);


//EEPROM_readAnything(1,int2IEeprom);
//long lts=int2IEeprom.ts;
display.print(" ");
dbfr=bfr1-bfr0;
display.print(dbfr);


int2IEeprom.ts=dbfr;
int2IEeprom.ds=dist0;

tracker=EEPROM_writeAnything(0,dbfr);
tracker1=EEPROM_writeAnything(156,dist0);
tracker2=EEPROM_writeAnything(200,ist);

}

//distI= (unsigned long)TinyGPSPlus::distanceBetween(flat,flon,flatI,flonI); 

if(val==HIGH && x==0) {
  x=1;
  }

if(val1==LOW) {
EEPROM_readAnything(0,dbfr);
EEPROM_readAnything(156,dist0);
EEPROM_readAnything(200,ist1);


display.clearDisplay();
display.setTextSize(1);  
display.drawRect(0,0,display.width(),display.height(), WHITE);

display.setCursor(5,2);   //5,18
display.print("T:");
display.print(dbfr);
display.print(" L:");
display.print(dist0);

display.setCursor(5,12);  //5,2
display.print(ist1);

//display.print("Kmph:");
display.setCursor(70,10);
display.setTextSize(2);
display.println(dist0*3.6/dbfr,1);
}

  
 // delay(200); 
smartDelay(500);                                      // Run Procedure smartDelay
display.display();

} //loop ends

//Functions
static void smartDelay(unsigned long ms)  {             // This custom version of delay() ensures that the gps object is being "fed".
  unsigned long start = millis();
  do {
    while (ss.available())
      gps.encode(ss.read());
  } while (millis() - start < ms);
}



   void getgps()   {
   if (ss.available() ) {
   hour=gps.time.hour()+5; 
   minute=gps.time.minute()+30;   // correct for your time zone
   day=gps.date.day();
   year=gps.date.year();
   month=gps.date.month();
   if(minute>59) {
     minute=minute-60;
     hour=hour+1;
     }
     if (hour>23) { 
     hour=hour-24;
     day=day+1;
     if(month==1 && day>31) month = month+1;
     if(month==2 && day>28) month = month+1;
     if(month==3 && day>31) month = month+1;
     if(month==4 && day>30) month = month+1;
     if(month==5 && day>31) month = month+1;
     if(month==6 && day>30) month = month+1;
     if(month==7 && day>31) month = month+1;
     if(month==8 && day>31) month = month+1;
     if(month==9 && day>30) month = month+1;
     if(month==10 && day>31) month = month+1;
     if(month==11 && day>30) month = month+1;
     if(month==12 && day>31) { month = month+1-12; year=year+1; }
     }

    d=day;
    m=month;
    y=year-2000;
    h=hour;
    m1=minute;
    s=gps.time.second();
  
    
    flat=gps.location.lat();
    flon=gps.location.lng();
    ns=gps.satellites.value();
  //day date block ends

sprintf(datadate, "%.2d/%.2d/%.2d %.2d:%.2d:%.2d %.2d", d,m,y,h,m1,s,gps.satellites.value());

sprintf(ist,"%.2d:%.2d:%.2d",h,m1,s);
sprintf(isd,"%.2d/%.2d/%.2d",d,m,y);

  }

}

void printDigits(int digits){
  if(digits < 10)
    display.print('0');
  display.print(digits);
}

float read_val(float parameter){
  float sum = 0;
  float sample ;
  for (int i=0; i<AVG_NUM; i++)   { 
    sample = parameter;  
    sum += sample;                  
 //   delayMicroseconds(100);  
    delay(100);     //100     
  }
  return(sum / AVG_NUM);
}

