
; Frequency Switch

	ERRORLEVEL -302
	ERRORLEVEL -306

	list P=16F88
	#include p16f88.inc

;Program Configuration Register 1

; code protection
		__CONFIG    _CONFIG1, _CP_ALL & _CCP1_RB0  & _DEBUG_OFF & _WRT_PROTECT_ALL & _CPD_OFF & _LVP_OFF & _BODEN_ON & _MCLR_OFF & _PWRTE_ON & _WDT_OFF & _HS_OSC
;Program Configuration Register 2
		__CONFIG    _CONFIG2, _IESO_OFF & _FCMEN_OFF

EEPROM0		equ	H'00'	; non-volatile storage for capture overflow
EEPROM1		equ	H'01'	; non-volatile storage for CCPR1H 	UPPER THRESHOLD
EEPROM2		equ	H'02'	; non-volatile storage for CCPR1L
 
EEPROM3		equ	H'03'	; non-volatile storage for capture overflow
EEPROM4		equ	H'04'	; non-volatile storage for CCPR1H 	LOWER THRESHOLD/ hysteresis
EEPROM5		equ	H'05'	; non-volatile storage for CCPR1L


; bank 0 RAM
OVER			equ	H'20'	; input overflow
INPUTms		equ	H'21'	; input value ms byte
INPUTls			equ	H'22'	; input value ls  byte
TMP_OVR		equ	H'23'	; working overflow
TMP_IN_ms		equ	H'24'	; working input value ms byte
TMP_IN_ls		equ	H'25'	; working input value ms byte
THRESH		equ	H'26'	; threshold reached flag
RESPONSE		equ	H'27' 	; response timer
TEMP			equ	H'28'	; temporary use		 
WORKING		equ	H'29'	; working value in normal running
WORKING1		equ	H'2A'	; working
NO_SIG			equ	H'2B'	; no signal 
INPUT_OVR		equ	H'2C'	; stored overrange
PORTB_STO		equ	H'2D'	; portb storage 
FREQ_CAP		equ	H'2E'	; capture or frequency mode flag
TEMP1			equ	H'2F'	; temporary
TEMP2			equ	H'30'	; temporary
TEMP3			equ	H'31'	; temporary
SWITCH_TMR	equ	H'32'	; switch timer	
SWITCH_TMR2	equ	H'33'	; switch timer
SWITCH_TMR3	equ	H'34'	; switch timer
T_DEL			equ	H'35'	; delay period
PROCESSED1	equ	H'36'	; processed value temporary
PROCESSED2	equ	H'37'	; processed value temporary
CHANGE		equ	H'38'	; frequency rate chage flag
LED_TMR		equ	H'39'	; frequency mode LED flasher for signal LEDs

; extra frequency mode
; each half of period for frequency output, F1,F2
COUNT_F1		equ	H'4E'	; working counters in interrupt	
COUNT_F2		equ	H'4F'
OVER_F1		equ	H'50'	; overflow1
OVER_F2		equ	H'51'
TIMERH_F1		equ	H'52'	; timer1 value ms byte
TIMERH_F2		equ	H'53'
TIMERL_F1		equ	H'54'	; timer 1 ls byte
TIMERL_F2		equ	H'55'			
SWITCH			equ	H'56'	; switch counter to toggle between F1/F2 
; interrupt frequency  mode use
I_OVER_F1		equ	H'57'	; overflow1
I_OVER_F2		equ	H'58'
I_TIMERH_F1	equ	H'59'	; timer1 value ms byte
I_TIMERH_F2	equ	H'5A'
I_TIMERL_F1	equ	H'5B'	; timer 1 ls byte
I_TIMERL_F2	equ	H'5C'	

; math routines
TEMPB2		equ	H'5D'
TEMPB1      		equ H'5E'
TEMPB0     		equ H'5F'
TEMPD       		equ H'60'   	 ; temporary storage
AARGB5		equ	H'61'
AARGB4		equ	H'62'
AARGB3		equ	H'63'
AARGB2      		equ H'64'
AARGB1     		equ H'65'
AARGB0      		equ H'66'	; most significant byte of argument A  
BARGB3		equ	H'67'
BARGB2		equ	H'68'  
BARGB1      		equ H'69'
BARGB0      		equ H'6A'	; most significant byte of argument B  
REMB1       		equ H'6B'
REMB0       		equ H'6C'   	; most significant byte of remainder
LOOPCOUNT   	equ H'6D'   	; loop counter
STO1	    		equ	H'6E'	; AARGB1 storage

; All Banks RAM

W_TMP			equ	H'70'	; storage of w before interrupt
STATUS_TMP	equ	H'71'	; status storage before interrupt
CONVERSION	equ	H'72'	; A/D delay before conversion	
STORE1			equ	H'73'	; delay counter
STORE2			equ	H'74'	; delay counter
STORE3			equ	H'75'	; delay counter
STORE4			equ	H'76'	; delay counter

; Initial values for EEPROM	
	ORG     H'2100'
	DE	H'0'					; overflow
	DE	H'C3',H'50'			; UPPER threshold period D50,000 (100Hz)

	DE	H'0'					; overflow
	DE	H'D9', H'03'			; LOWER threshold period D55,555 (90Hz)
	

; *************************************************************************************************

; start at memory 0

	org		0			; reset vector
	clrf		PORTB		; 
	clrf		PORTA		; outputs low
	goto	MAIN		; 

	org     4				; interrupt vector
; start interrupt by saving w and status registers  
INTERRUPT
	movwf	W_TMP		; w to w_tmp storage
	swapf	STATUS,w	; status to w
	movwf	STATUS_TMP	; status in status_tmp 

	bcf		STATUS,RP0	; select bank 0
	bcf		STATUS,RP1	; bank 0
; which mode?
	btfss	FREQ_CAP,0	; capture or frequency mode flag, if set use ferquency interrupt
	goto	TIMER1_OVERFLOW_CHECK
	goto	INTERRUPT_F

; check interrupt. Timer1 overflow PIR1,TMR1IF.or capture CCP1IF
TIMER1_OVERFLOW_CHECK
	btfss	PIR1,TMR1IF		; timer overflow
	goto	CAPTURE

OVERFLOW; timer1 overflow
	bcf		PIR1,TMR1IF		; clear timer overflow
; read portB
	movf	PORTB,w
	movwf	PORTB_STO

	incf		OVER,f			; increase overflow flag
	btfss	OVER,7			; if set set overrange flag
	goto	CAPTURE
	bsf		NO_SIG,1		; if overrange
;	goto	CAPTURE
; >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
	
CAPTURE
	btfss	PIR1,CCP1IF			; if set then capture
	goto	RECLAIM			; no capture
	bcf		PIR1,CCP1IF			; clear flag
	movlw	D'20'				; compensate for interrupt timing
	movwf	TMR1L
	clrf		TMR1H

; read portB
	movf	PORTB,w
	movwf	PORTB_STO

; If NO_SIG, bypass storing capture and clear error flag
	movf	NO_SIG,w
	btfss	STATUS,Z		; when zero read and store
	goto	BY_CAPTURE

READ_STORE
; read
	movf		CCPR1H,w
	movwf		INPUTms		; input value ms byte
	movf		CCPR1L,w
	movwf		INPUTls			; input value ls  byte
	movf		OVER,w
	movwf		INPUT_OVR

; if values are near zero, check overflow flag. if not cleared, increase OVER by 1
	movf		INPUTms,w		
	btfss		STATUS,Z		; if zero
	goto		BY_CAPTURE
	movf		INPUTls,w
	sublw		D'20'
	btfss		STATUS,C		; if >20
	goto		BY_CAPTURE

	btfss		PIR1,TMR1IF		; check if timer overflow 
	goto		BY_CAPTURE

; timer1 overflow
	bcf			PIR1,TMR1IF		; clear timer overflow
	incf			OVER,f			; increase overflow flag
	btfss		OVER,7			; if set set overrange flag
	goto		BY_CAPTURE
	bsf			NO_SIG,1		; if overrange
	movf		OVER,w
	movwf		INPUT_OVR		; reload input over value 

BY_CAPTURE
; clear values
	clrf			OVER
	movf		NO_SIG,w
	btfss		STATUS,Z		; reduce until zero
	decf		NO_SIG,f

; end of interrupt reclaim w and status
RECLAIM
	swapf	STATUS_TMP,w; status temp storage to w
	movwf	STATUS		; w to status register
	swapf	W_TMP,f		; swap upper and lower 4-bits in w_tmp
	swapf   	W_TMP,w		; swap bits and into w register
	retfie				; return from interrupt

;******************************************************************************************* 
MAIN
	bsf		STATUS,RP0	; select memory bank 1
; set inputs/outputs
	movlw	B'00000111'	; comparators off
	movwf	CMCON
	movlw	B'01100111'	; port B outputs/ inputs set 
	movwf	TRISB		; port B data direction register
	movlw	B'00101100'	; outputs (0) and inputs (1)
	movwf	TRISA		; port A data direction register
	movlw	B'00000111'	; settings (pullups enabled TMR0/256)
	movwf	OPTION_REG

; analog inputs, A/D

	movlw	B'00001100'	; AN2,3 analog inputs
	movwf	ANSEL
	movlw	B'01000000'	; left justified A/D result, Vdd to Vss A/D
	movwf	ADCON1
	bcf		STATUS,RP0	; select memory bank 0
	movlw	B'10001000'	; Fosc, channel  etc
	movwf	ADCON0
	bsf		ADCON0,ADON	; A/D on

	movlw	B'00000001'	; timer 1 fosc/4 /1
	movwf	T1CON
	movlw	H'FF'		; timer 2, /16 prescaler and /16 post scaler for 13ms count
	movwf	T2CON

; check for both upper and lower set switches pressed for frequency output
	call		DELAYms	; ensure pullups on S1 and S2 charge capacitance for correct high reading
	btfsc	PORTB,1	; check S1
	goto	RUN_AS_FREQ_SWITCH
	btfsc	PORTB,2	; check S2
	goto	RUN_AS_FREQ_SWITCH
; frequency output mode
	bsf		FREQ_CAP,0	; capture or frequency mode flag, if set use frequency interrupt
	clrf		SWITCH_TMR	; switch timer	
	goto	FREQUENCY_MODE

RUN_AS_FREQ_SWITCH; use as input frequency detect

; read portB
	movf	PORTB,w
	movwf	PORTB_STO

; Capture: 1 edge; Timer1 prescaler:  /1 
	movlw	B'00000101'
	movwf	CCP1CON		; 1 edge capture

; initial conditions
INITIAL
; initialise registers
	clrf		NO_SIG			; no signal flag
	bsf		NO_SIG,2		; start with a no signal value	
	clrf		OVER			; overflow from capture
	clrf		INPUTms		; input counter from capture
	clrf		INPUTls
	clrf		INPUT_OVR
	clrf		TMP_OVR
	clrf		TMP_IN_ms
	clrf		TMP_IN_ls
	clrf		THRESH		
	clrf		FREQ_CAP	; capture mode if flag is clear

; check high to low or low to high selection
	btfss	PORTB_STO,5		; if high then low to high so relay should be off with no signal
	goto	RELAY_ON
	bcf		PORTB,3		; relay off
	bcf		PORTA,4		; threshold LED off
	goto	ALLOW_I
RELAY_ON
	bsf		PORTB,3		; relay on with no signal
	bsf		PORTA,4		; threshold LED on
ALLOW_I
; allow interrupts
	bsf		STATUS,RP0	; select memory bank 1
	bsf		PIE1,TMR1IE		; timer1 overrange
	bsf		PIE1,CCP1IE	; capture/compare
	bcf		STATUS,RP0	; select memory bank 0
	bcf		PIR1,TMR1IF		; flags clear
	bcf		PIR1,CCP1IF
	bsf		INTCON,PEIE	; enable peripheral interrupts
	bsf		INTCON,GIE		; global interrupt enable

;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
RUN ; program loop starting point
; stop interrupt and get values

SIGNAL_VALUES
	bcf		INTCON,GIE	
	movf	INPUT_OVR,w	;overflow counter
	movwf	TMP_OVR		; 
	movf	INPUTms,w		; input value ms byte
	movwf	TMP_IN_ms		; working input value ms byte
	movf	INPUTls,w		; input value ls  byte
	movwf	TMP_IN_ls		; working input value ms byte
	bsf		INTCON,GIE		; allow interrrupt

; if INPUT_OVR,  INPUTms and INPUTls (in TMP working registers) are >5,000,000 or NO_SIG is not clear, then input frequency is <1Hz so no LED. Bypass frequency test
	movf	NO_SIG,w
	btfss	STATUS,Z
	goto	LEDS_OFF

; check for capture less than 5,000,000 (H4C4B40)
	movlw	H'4C'
	subwf	TMP_OVR,w
	movwf	WORKING
	movlw	H'4B'
	subwf	TMP_IN_ms,w	; working input value ms byte
	movwf	WORKING1
	btfss	STATUS,C
	decf	WORKING,f
	movlw	H'40'
	subwf	TMP_IN_ls,w		; working input ls value
	movlw	D'1'
	btfss	STATUS,C
	subwf	WORKING1,f
	btfss	STATUS,C
	decf	WORKING,f
	btfsc	WORKING,7		; if set then 5,000,000  is greater than capture 
	goto	FREQ_LEDS	; drive frequency LEDs
LEDS_OFF
	bcf		PORTA,0		; LED2 off
	bcf		PORTB,4		; LED3 off
	bcf		PORTA,1		; LED5 off
	bcf		PORTB,7		; LED4 off

; set all at maximum
	movlw	H'FF'
	movwf	TMP_OVR		; 
	movwf	TMP_IN_ms		; working input value ms byte
	movwf	TMP_IN_ls		; working input value ms byte

; no change in threshold and relay status

	goto	THRESHOLDS	; check switch press and thresholds

;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
; find frequency zone at less than 10Hz, 100Hz, 1kHz or 10kHz (count updated in interrupt)
FREQ_LEDS

; <10Hz >500,000 H 7 A1 20
; check for capture less than 500,000 H 7 A1 20
	movlw	H'7'
	subwf	TMP_OVR,w
	movwf	WORKING
	movlw	H'A1'
	subwf	TMP_IN_ms,w	; working input value ms byte
	movwf	WORKING1
	btfss	STATUS,C
	decf	WORKING,f
	movlw	H'20'
	subwf	TMP_IN_ls,w		; working input ls value
	movlw	D'1'
	btfss	STATUS,C
	subwf	WORKING1,f
	btfss	STATUS,C
	decf	WORKING,f
	btfss	WORKING,7		; if set then 500,000  is greater than capture 
	goto	LED_10Hz
; <100Hz > 50,000 H C3 50
; check for capture less than 50,000 H 0 C3 50
	movlw	H'0'
	subwf	TMP_OVR,w
	movwf	WORKING
	movlw	H'C3'
	subwf	TMP_IN_ms,w	; working input value ms byte
	movwf	WORKING1
	btfss	STATUS,C
	decf	WORKING,f
	movlw	H'50'
	subwf	TMP_IN_ls,w		; working input ls value
	movlw	D'1'
	btfss	STATUS,C
	subwf	WORKING1,f
	btfss	STATUS,C
	decf	WORKING,f
	btfss	WORKING,7		; if set then 50,000  is greater than capture 
	goto	LED_100Hz

; <1kHz > 5,000 H 13 88
; check for capture less than 5,000 H 0 13 88
	movlw	H'0'
	subwf	TMP_OVR,w
	movwf	WORKING
	movlw	H'13'
	subwf	TMP_IN_ms,w	; working input value ms byte
	movwf	WORKING1
	btfss	STATUS,C
	decf	WORKING,f
	movlw	H'88'
	subwf	TMP_IN_ls,w		; working input ls value
	movlw	D'1'
	btfss	STATUS,C
	subwf	WORKING1,f
	btfss	STATUS,C
	decf	WORKING,f
	btfss	WORKING,7		; if set then 5,000  is greater than capture 
	goto	LED_1kHz

; <10kHz> 500 H 1 F4
; check for capture less than 500 H 0 1 F4
	movlw	H'0'
	subwf	TMP_OVR,w
	movwf	WORKING
	movlw	H'01'
	subwf	TMP_IN_ms,w	; working input value ms byte
	movwf	WORKING1
	btfss	STATUS,C
	decf	WORKING,f
	movlw	H'F4'
	subwf	TMP_IN_ls,w		; working input ls value
	movlw	D'1'
	btfss	STATUS,C
	subwf	WORKING1,f
	btfss	STATUS,C
	decf	WORKING,f
	btfss	WORKING,7		; if set then 500  is greater than capture 
	goto	LED_10kHz
; <100kHz>50.
	goto	LED_100kHz
;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
LED_10Hz;  less than 10Hz
	bsf		PORTA,0		; LED2 on 10Hz
	bcf		PORTB,4		; LED3 off 100Hz
	bcf		PORTA,1		; LED5 off 10k
	bcf		PORTB,7		; LED4 off 1kHz	
	goto	THRESHOLDS
LED_100Hz;  less than 100Hz
	bcf		PORTA,0		; LED2 off 10Hz
	bsf		PORTB,4		; LED3 on 100Hz
	bcf		PORTA,1		; LED5 off 10k
	bcf		PORTB,7		; LED4 off 1kHz	
	goto	THRESHOLDS
LED_1kHz;  less than 1kHz
	bcf		PORTA,0		; LED2 off 10Hz
	bcf		PORTB,4		; LED3 off 100Hz
	bcf		PORTA,1		; LED5 off 10k
	bsf		PORTB,7		; LED4 on 1kHz	
	goto	THRESHOLDS
LED_10kHz;  less than 10kHz
	bcf		PORTA,0		; LED2 off 10Hz
	bcf		PORTB,4		; LED3 off 100Hz
	bsf		PORTA,1		; LED5 on 10k
	bcf		PORTB,7		; LED4 off 1kHz	
	goto	THRESHOLDS
LED_100kHz;  10kHz and over
	bsf		PORTA,0		; LED2 on 10Hz
	bsf		PORTB,4		; LED3 on 100Hz
	bsf		PORTA,1		; LED5 on 10k
	bsf		PORTB,7		; LED4 on 1kHz	
;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
THRESHOLDS

; if switch pressed, then store values in EEPROM 
SWITCH2
	btfss 	PORTB_STO,2		; if low
	goto	UPPER_THRESH	; upper threshold
SWITCH1
	btfsc	PORTB_STO,1	
	goto	COMPARE		; no switches

LOWER_THRESHOLD; if lower threshold switch is pressed, then store 

	call		STORE_LOWER
; if JP2 (thresholds or hysteresis) out or in, 
	btfss	PORTB,6
	goto	CALC_UPPER	; requires upper threshold hysteresis calculation
	call		CK_OPPOSITE_THRESH1; make sure lower threshold frequency is below upper.
	goto	COMPARE

STORE_LOWER	

	movlw	EEPROM3		; non-volatile storage for overrange  LOWER THRESHOLD/ hysteresis
	call		EEREAD		; sets EEADR
	movf	TMP_OVR,w		; working overrange
	call		EEWRITE		; store

	movlw	EEPROM4		; non-volatile storage for CCPR1H 	LOWER THRESHOLD/ hysteresis
	call		EEREAD		; sets EEADR
	movf	TMP_IN_ms,w	; working input value ms byte
	call		EEWRITE		; store

	movlw	EEPROM5		; non-volatile storage for CCPR1L 	LOWER THRESHOLD/ hysteresis
	call		EEREAD		; sets EEADR
	movf	TMP_IN_ls,w		; working input value ls byte
	call		EEWRITE		; store
	return
CK_OPPOSITE_THRESH1
; make sure lower threshold frequency is below upper.

; upper capture value 
	movlw	EEPROM0		; upper capture value overrange
	call		EEREAD
	movwf	BARGB0
	movlw	EEPROM1		; upper capture value ms byte
	call		EEREAD
	movwf	BARGB1
	movlw	EEPROM2		; upper capture value ls byte
	call		EEREAD
	movwf	BARGB2

	movf	BARGB0,w
	subwf	TMP_OVR,w
	movwf	WORKING
	movf	BARGB1,w
	subwf	TMP_IN_ms,w	; working input value ms byte
	movwf	WORKING1
	btfss	STATUS,C
	decf	WORKING,f
	movf	BARGB2,w
	subwf	TMP_IN_ls,w		; working input ls value
	movlw	D'1'
	btfss	STATUS,C
	subwf	WORKING1,f
	btfss	STATUS,C
	decf	WORKING,f
	btfss	WORKING,7		; if set then upper threshold  is greater than lower
	return

; if FF FF FF (no signal)  then bypass
	movlw	H'FF'
	xorwf	TMP_OVR,w
	btfss	STATUS,Z
	goto	STORE_UP_OK
	movlw	H'FF'
	xorwf	TMP_IN_ms,w
	btfss	STATUS,Z
	goto	STORE_UP_OK
	movlw	H'FF'
	xorwf	TMP_IN_ls,w
	btfsc	STATUS,Z
	return					; all FF so bypass
STORE_UP_OK
	call		STORE_UPPER	; store same values in upper as lower
 
	return

;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
; if JP1 is out, calculate hysteresis based on upper threshold then store
CALC_LOWER
	; if JP1 is in, calculate hysteresis based on upper threshold then store in lower threshold	

; get Hysteresis value at AN2 (0-5V = 0-50%)
; set for channel 2
	bcf		ADCON0,5
	bsf		ADCON0,4
	bcf		ADCON0,3
	call		ACQUIRE_AD
	movf	ADRESH,w
	movwf	AARGB2		; multiply by percentage value[
	clrf		AARGB0		; ms byte cleared
	clrf		AARGB1
; upper capture value 
	movlw	EEPROM0		; higher capture value overrange
	call		EEREAD
	movwf	BARGB0
	movlw	EEPROM1		; higher capture value ms byte
	call		EEREAD
	movwf	BARGB1
	movlw	EEPROM2		; higher capture value ls byte
	call		EEREAD
	movwf	BARGB2

; percentage calculation (count x A/D value /255) ; eg when A/D value is at maximum (ie 256) calculation will be 50%
; (note we calculate hysteresis using period counting. So for a frequency hysteresis, the period calculation is non-linear)
	call		FXM2424		; multiply percentage value by lower capture value 

; value in AARGB0,1,2,3,4,5 AARGB0,1 is zero AARGB2 is FF maximum 
; to divide by 256 use AARGB2 and AARGB3 and AARGB4  as the 24-bit value

; then add percentage AARGB2 and AARGB3 and AARGB4 to count BARGB0,BARGB1,BARGB2
; lower capture value 
	movlw	EEPROM0		; upper capture value overrange
	call		EEREAD
	movwf	BARGB0
	movlw	EEPROM1		; upper capture value ms byte
	call		EEREAD
	movwf	BARGB1
	movlw	EEPROM2		; upper capture value ls byte
	call		EEREAD
	movwf	BARGB2

; add  percentage value for lower frequency (24bit)

; BARGB0 BARGB1 BARGB2 + AARGB2 AARGB3 AARGB4 = BARGB0,1,2
	movf	AARGB4,w		; ls bytes
	addwf	BARGB2,f

	btfss	STATUS,C		; if over
	goto	ADD1
	incfsz	AARGB3,f		; increase next byte if over
	goto	ADD1
	incfsz	AARGB2,f		; continue increase next byte if over
	goto	ADD1
	goto	ADD_OVR
ADD1
	movf	AARGB3,w		; add next bytes
	addwf	BARGB1,f

	btfss	STATUS,C
	goto	ADD2
	incfsz	AARGB2,f		; increase next byte if over
	goto	ADD2
	goto	ADD_OVR
ADD2
	movf	AARGB2,w		; add ms bytes
	addwf	BARGB0,f

	btfss	STATUS,C
	goto	ST_LOW

; overrange so set at FF FF FF
ADD_OVR
	movlw	H'FF'
	movwf	BARGB0
	movwf	BARGB1
	movwf	BARGB2

; STORE in LOWER
ST_LOW
	movlw	EEPROM3		; non-volatile storage for overrange  LOWER THRESHOLD/ hysteresis
	call		EEREAD		; sets EEADR
	movf	BARGB0,w		; overrange
	call		EEWRITE		; store

	movlw	EEPROM4		; non-volatile storage for CCPR1H 	LOWER THRESHOLD/ hysteresis
	call		EEREAD		; sets EEADR
	movf	BARGB1,w		; working input value ms byte
	call		EEWRITE		; store

	movlw	EEPROM5		; non-volatile storage for CCPR1L 	LOWER THRESHOLD/ hysteresis
	call		EEREAD		; sets EEADR
	movf	BARGB2,w		; working input value ls byte
	call		EEWRITE		; store

	goto	COMPARE
;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>

UPPER_THRESH
; store threshold value
	call		STORE_UPPER
; if JP2 (thresholds or hysteresis) out or in,
	btfss	PORTB,6
	goto	CALC_LOWER		; calculate lower hysteresis and store

	call		CK_OPPOSITE_THRESH; check opposister threshold (upper for higher frequency than lower)
	goto	COMPARE

STORE_UPPER	

	movlw	EEPROM0	; non-volatile storage for overflow UPPER THRESHOLD/ hysteresis
	call		EEREAD		; sets EEADR
	movf	TMP_OVR,w		; working input1 setting
	call		EEWRITE		; store

	movlw	EEPROM1	; non-volatile storage for CCPR1H 	UPPER THRESHOLD/ hysteresis
	call		EEREAD		; sets EEADR
	movf	TMP_IN_ms,w	; working input value ms byte
	call		EEWRITE		; store

	movlw	EEPROM2	; non-volatile storage for CCPR1L 	UPPER THRESHOLD/ hysteresis
	call		EEREAD		; sets EEADR
	movf	TMP_IN_ls,w		; working input value ls byte
	call		EEWRITE		; store
	return

CK_OPPOSITE_THRESH
; make sure upper threshold frequency is above lower.
; Lower capture value 
	movlw	EEPROM3		; lower capture value overrange
	call		EEREAD
	movwf	BARGB0
	movlw	EEPROM4		; lower capture value ms byte
	call		EEREAD
	movwf	BARGB1
	movlw	EEPROM5		; lower capture value ls byte
	call		EEREAD
	movwf	BARGB2

	movf	BARGB0,w
	subwf	TMP_OVR,w
	movwf	WORKING
	movf	BARGB1,w
	subwf	TMP_IN_ms,w	; working input value ms byte
	movwf	WORKING1
	btfss	STATUS,C
	decf	WORKING,f
	movf	BARGB2,w
	subwf	TMP_IN_ls,w		; working input ls value
	movlw	D'1'
	btfss	STATUS,C
	subwf	WORKING1,f
	btfss	STATUS,C
	decf	WORKING,f
	btfsc	WORKING,7		; if set then lower threshold frequency is greater than upper (thresholds are oppossite for frequency ie higher threshold=lower frequency)
	return

; if FF FF FF (no signal)  then bypass
	movlw	H'FF'
	xorwf	TMP_OVR,w
	btfss	STATUS,Z
	goto	STOR_L_OK
	movlw	H'FF'
	xorwf	TMP_IN_ms,w
	btfss	STATUS,Z
	goto	STOR_L_OK
	movlw	H'FF'
	xorwf	TMP_IN_ls,w
	btfsc	STATUS,Z
	return		; all FF so bypass
STOR_L_OK
	call		STORE_LOWER	; store same values in lower as upper

	return

;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
CALC_UPPER
; if JP1 is in, calculate hysteresis based on lower threshold then store in upper threshold	
;; get Hysteresis value at AN2 (0-5V = 0-50%)
; set for channel 2
	bcf		ADCON0,5
	bsf		ADCON0,4
	bcf		ADCON0,3
	call		ACQUIRE_AD
	movf	ADRESH,w
	movwf	AARGB2		; multiply by percentage value[
	clrf		AARGB0		; ms byte cleared
	clrf		AARGB1
; lower capture value 
	movlw	EEPROM3		; lower capture value overrange
	call		EEREAD
	movwf	BARGB0
	movlw	EEPROM4		; lower capture value ms byte
	call		EEREAD
	movwf	BARGB1
	movlw	EEPROM5		; lower capture value ls byte
	call		EEREAD
	movwf	BARGB2

; if FF FF FF (no signal)  then bypass
	movlw	H'FF'
	xorwf	BARGB0,w
	btfss	STATUS,Z
	goto	CALC_OK
	movlw	H'FF'
	xorwf	BARGB1,w
	btfss	STATUS,Z
	goto	CALC_OK
	movlw	H'FF'
	xorwf	BARGB2,w
	btfsc	STATUS,Z
	goto	COMPARE		; all FF so bypass

CALC_OK
; percentage calculation (count x A/D value /255) ; eg when A/D value is at maximum (ie 256) calculation will be 50%
	call		FXM2424		; multiply percentage value by lower capture value 


; value in AARGB0,1,2,3,4,5 AARGB0,1 is zero AARGB2 is FF maximum 
; to divide by 256 use AARGB2 and AARGB3 and AARGB4  as the 24-bit value
; divide by 3 for a 50% change at maximum setting. (note we calculate hysteresis using period counting. So for a frequency hysteresis, the period calculation is non-linear)
	
; move along to most significant end for divide
	movf	AARGB2,w
	movwf	AARGB0
	movf	AARGB3,w
	movwf	AARGB1
	movf	AARGB4,w
	movwf	AARGB2

	clrf		BARGB0
	movlw	D'3'
	movwf	BARGB1
	call		FXD2416				

; then subtract percentage AARGB0 and AARGB1 and AARGB2 from count BARGB0,BARGB1,BARGB2
; upper capture value 
	movlw	EEPROM3		; lower capture value overrange
	call		EEREAD
	movwf	BARGB0
	movlw	EEPROM4		; lower capture value ms byte
	call		EEREAD
	movwf	BARGB1
	movlw	EEPROM5		; lower capture value ls byte
	call		EEREAD
	movwf	BARGB2

; BARGB0 BARGB1 BARGB2 - AARGB0 AARGB1 AARGB2 = BARGB0,1,2

	movf	AARGB2,w		; start with low byte subtraction
	subwf	BARGB2,f
	btfsc	STATUS,C    		; if carry is clear then decrease next byte
	goto	SUB1
	movlw	D'1'
	subwf	AARGB1,f
	btfsc	STATUS,C
	goto	SUB1
	movlw	D'1'
	subwf	AARGB0,f
	btfss	STATUS,C
	goto	REWRITE_LOW
SUB1
	movf	AARGB1,w		; mid byte subtraction
	subwf	BARGB1,f
	btfsc	STATUS,C    		; if carry is clear then decrease next byte
	goto	SUB0
	movlw	D'1'
	subwf	AARGB0,f
	btfss	STATUS,C
	goto	REWRITE_LOW	
SUB0
	movf	AARGB0,w		; high byte subtraction
	subwf	BARGB0,f
	btfsc	STATUS,C    		; if carry is clear then decrease next byte
	goto	ST_UP

; end rewrite subtraction
REWRITE_LOW
; small so set at H00 00 10
	movlw	H'10'
	movwf	BARGB2
	clrf		BARGB1
	clrf		BARGB0

; STORE in UPPER
ST_UP

	movlw	EEPROM0		; non-volatile storage for capture over UPPER
	call		EEREAD		; sets EEADR
	movf	BARGB0,w
	call		EEWRITE		; store

	movlw	EEPROM1		; non-volatile storage for CCPR1H 	UPPER THRESHOLD/ hysteresis
	call		EEREAD		; sets EEADR
	movf	BARGB1,w		;  ms byte
	call		EEWRITE		; store

	movlw	EEPROM2		; non-volatile storage for CCPR1L 	UPPER THRESHOLD/ hysteresis
	call		EEREAD		; sets EEADR
	movf	BARGB2,w		; working input value ls byte
	call		EEWRITE		; store

;	goto	COMPARE

;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
; compare captured with thresholds  
COMPARE
	movf	NO_SIG,w			; if no signal, bypass 
	btfss	STATUS,Z
	goto	LEDS_OFF

; wait for switches to open
WAIT1
	btfss	PORTB_STO,1		; S1
	goto	LED_ON
	btfsc	PORTB_STO,2		; S2
	goto	COMPARISON
LED_ON
	bsf		PORTA,4
	call		DELAYms
	bcf		PORTA,4
	call		DELAYms
	goto	WAIT1

COMPARISON	

CK_HIGH_THRESH
; do comparisons of captured with thresholds

	btfss	THRESH,0		; check if on and RELAY on
	goto	COMP1

; get low to high or high to low triggering threshold
	btfss	PORTB_STO,5
	goto	RLY1
; relay off
	btfsc	PORTB,3		; is relay off
	goto	CK_LOW_THRESH	; check low Threshold
	goto	COMP1
RLY1
	btfss	PORTB,3		; is relay on
	goto	CK_LOW_THRESH	; check low Threshold
	
COMP1
; check if values are lower (ie higher frequency) than Upper Threshold

	call		UPPER_COMPARISON ; do comparison
	btfsc	WORKING,7		; if set then threshold  is greater than capture and threshold frequency is lower than input 
	goto	REACHED_UPPER
; threshold not reached
; check low to high or high to low
; get low to high or high to low triggering threshold
	btfss	PORTB_STO,5
	goto	OFF4_1
; indicator off
	bcf		PORTA,4		; indicator off
	goto	CLEAR_TH
OFF4_1
	bsf		PORTA,4		; indicator on
CLEAR_TH
; clear THRESH if RESPONSE is not 0 
	movf	RESPONSE,w
	btfsc	STATUS,Z
	goto	RUN
; not 0
	bcf		THRESH,0
	goto	RUN			; main program loop

REACHED_UPPER
; check THRESH,0			; threshold reached
; if set then continue counting down timer
; if delay has started bypass loading RESPONSE. Reset timer if  thresholds are not met during response delay.
	btfsc	THRESH,0		; if set
	goto	COUNT_D
	bsf		THRESH,0

; get low to high or high to low triggering threshold
	btfsc	PORTB_STO,5
	goto	ON4_1
; indicator off
	bcf		PORTA,4		; indicator off
	goto	GET_RESP1
ON4_1
	bsf		PORTA,4		; indicator on
GET_RESP1

 ; get response (0-5V = 0-500ms)
	call		SET_RESPONSE ; get response value

COUNT_D	
	movf	RESPONSE,w
	btfsc	STATUS,Z		; if zero stop decrement
	goto	THRESH_UP
; wait for timer 0 overflow
	btfss	INTCON,TMR0IF	; if set then overflow
	goto	RUN
	bcf		INTCON,TMR0IF
	movlw	H'D9'			; FF-D38 for 1.94ms per count
	movwf	TMR0
	decfsz	RESPONSE,f
	goto	RUN

THRESH_UP
; get low to high or high to low triggering threshold
	btfsc	PORTB_STO,5
	goto	ON3_1
; relay off
	bcf		PORTB,3		; relay off
	goto	RUN
ON3_1
	bsf		PORTB,3		; relay on
	goto	RUN

;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
CK_LOW_THRESH	; check low Threshold

; do comparisons of captured with thresholds

	btfss	THRESH,0		; check if on
	goto	CK_HIGH_THRESH	;  check high Threshold

COMP2

; if FF FF FF (no signal)  then bypass
	movlw	H'FF'
	xorwf	BARGB0,w
	btfss	STATUS,Z
	goto	CHECK_OK
	movlw	H'FF'
	xorwf	BARGB1,w
	btfss	STATUS,Z
	goto	CHECK_OK
	movlw	H'FF'
	xorwf	BARGB2,w
	btfsc	STATUS,Z
	goto	RUN		; all FF so bypass

CHECK_OK
; check if values are greater than (ie lower frequency) than Lower Threshold
	call		LOWER_COMPARISON
	btfss	WORKING,7		; if set then threshold  is greater than capture and threshold frequency is lower than input
	goto	REACHED_LOWER
; threshold not reached

; get low to high or high to low triggering threshold
	btfsc	PORTB_STO,5
	goto	ON4_2
; indicator off
	bcf		PORTA,4		; indicator off
	goto	CLEAR_TH1
ON4_2
	bsf		PORTA,4		; indicator on

CLEAR_TH1
; clear THRESH if RESPONSE is not 0 and PORTB_STO,5 is low (for H-L threshold)
	movf	RESPONSE,w
	btfsc	STATUS,Z
	goto	RUN
; not 0
	bcf		THRESH,1
	goto	RUN			; main program loop

REACHED_LOWER
; check THRESH,0			; threshold reached
; if set than continue counting down timer
; if delay has started bypass loading RESPONSE. Reset timer if  thresholds are not met during response delay.
	btfsc	THRESH,1		; if set
	goto	COUNT_D1
	bsf		THRESH,1

; get low to high or high to low triggering threshold
	btfss	PORTB_STO,5
	goto	OFF4_11
; indicator off
	bcf		PORTA,4		; indicator off
	goto	SET_RESP1
OFF4_11
	bsf		PORTA,4		; indicator on

SET_RESP1
; get response (0-5V = 0-500ms) value
	call		SET_RESPONSE

COUNT_D1	
	movf	RESPONSE,w
	btfsc	STATUS,Z		; if zero stop decrement
	goto	THRESH_DN
; wait for timer 0 overflow
	btfss	INTCON,TMR0IF	; if set then overflow
	goto	RUN
	bcf		INTCON,TMR0IF
	movlw	H'D9'			; FF-D38 for 1.94ms per count
	movwf	TMR0
	decfsz	RESPONSE,f
	goto	RUN

THRESH_DN

; get low to high or high to low triggering threshold
	btfss	PORTB_STO,5
	goto	ON3_11
; relay off
	bcf		PORTB,3		; relay off
	clrf		THRESH
	goto	RUN
ON3_11
	bsf		PORTB,3		; relay on
	clrf		THRESH
	goto	RUN


; xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx


; Subroutines

; subroutine to wait for conversion

ACQUIRE_AD
; wait for >20us
	movlw	D'50'
	movwf	CONVERSION
LOOP_CONV
	decfsz	CONVERSION,f	; decrease 
	goto	LOOP_CONV	
	bsf		ADCON0,2		; GO/DONE bit start conversion
WAIT_CONV
	btfsc	ADCON0,2		; conversion complete when cleared ~11 cycles
	goto	WAIT_CONV
	return

SET_RESPONSE ; get response value
; set for channel 3
	bcf		ADCON0,5
	bsf		ADCON0,4
	bsf		ADCON0,3
	call		ACQUIRE_AD
	movf	ADRESH,w
	movwf	RESPONSE		; delay for response
	return

; delay loop

DELAYms
	movlw	D'33'
DELAY1
	movwf	STORE3
LOOP7
	movlw	D'23'		; delay value
DELAYX
	movwf	STORE1		; STORE1 is number of loops value
LOOP8	
	movlw	H'B0'
DELDSP
	movwf	STORE2		; STORE2 is internal loop value	
LOOP9
	decfsz	STORE2,f
	goto	LOOP9
	decfsz	STORE1,f
	goto	LOOP8		; decrease till STORE1 is zero
	decfsz	STORE3,f
	goto	LOOP7
	return

EEREAD
	bcf		STATUS,RP0	; select bank 0
	bsf 		STATUS,RP1	; select memory bank 2
	movwf 	EEADR			; indirect special function register
	bsf 		STATUS,RP0	; select memory bank 3
	bcf		EECON1,EEPGD; data memory
	bsf		EECON1,RD		; read EEPROM
	bcf 		STATUS,RP0	; select memory bank 2
	movf	EEDATA,w		; EEPROM value in w
	bcf		STATUS,RP1	; select bank 0
	return

; subroutine to write to EEPROM
EWRITE
EEWRITE	
	bcf 		STATUS,RP0	; bank 0
	bsf		STATUS,RP1	; select bank 2
	movwf	EEDATA		; data register
	bsf 		STATUS,RP0	; select memory bank 3
WR3	
	btfsc	EECON1,WR	; check if write complete 
	goto 	WR3			; not written yet
	bcf		INTCON,GIE		; disable interrupts
	bcf		EECON1,EEPGD; data memory
	bsf		EECON1,WREN	; enable write
	movlw	H'55'			; place 55H in w for write sequence
	movwf 	EECON2 		; write 55H to EECON2
	movlw 	H'AA'			; AAH to w
	movwf	EECON2		; write AA to EECON2
	bsf		EECON1,WR	; set WR bit and begin write sequence
	bcf		EECON1,WREN	; clear WREN bit
	bsf 		INTCON,GIE		; enable interrupts
WRITE
	btfsc	EECON1,WR	; skip if write complete 
	goto 	WRITE			; not written yet
	bcf		EECON1,EEIF	; clear write interrupt flag
	bcf		STATUS,RP1	; 
	bcf 		STATUS,RP0	; select memory bank 0
	return					; value written 

; **********************************************************************
; maths routines

;***********************************************************************
UPPER_COMPARISON
;  comparison here for < Upper threshold
; get upper threshold capture value 
	movlw	EEPROM0		; upper capture value overrange
	call		EEREAD
	movwf	BARGB0
	movlw	EEPROM1		; upper capture value ms byte
	call		EEREAD
	movwf	BARGB1
	movlw	EEPROM2		; upper capture value ls byte
	call		EEREAD
	movwf	BARGB2
;compare
	movf	BARGB0,w
	subwf	TMP_OVR,w
	movwf	WORKING
	movf	BARGB1,w
	subwf	TMP_IN_ms,w	; working input value ms byte
	movwf	WORKING1
	btfss	STATUS,C
	decf	WORKING,f
	movf	BARGB2,w
	subwf	TMP_IN_ls,w		; working input ls value
	movlw	D'1'
	btfss	STATUS,C
	subwf	WORKING1,f
	btfss	STATUS,C
	decf	WORKING,f
	return

LOWER_COMPARISON
;  comparison here for < Upper threshold
; get lower threshold capture value 
	movlw	EEPROM3		; lower capture value overrange
	call		EEREAD
	movwf	BARGB0
	movlw	EEPROM4		; lower capture value ms byte
	call		EEREAD
	movwf	BARGB1
	movlw	EEPROM5		; lower capture value ls byte
	call		EEREAD
	movwf	BARGB2
;compare
	movf	BARGB0,w
	subwf	TMP_OVR,w
	movwf	WORKING
	movf	BARGB1,w
	subwf	TMP_IN_ms,w	; working input value ms byte
	movwf	WORKING1
	btfss	STATUS,C
	decf	WORKING,f
	movf	BARGB2,w
	subwf	TMP_IN_ls,w		; working input ls value
	movlw	D'1'
	btfss	STATUS,C
	subwf	WORKING1,f
	btfss	STATUS,C
	decf	WORKING,f
	return

; Math routines

; 24/16 Bit Unsigned Fixed Point Divide 

;       Input:  24 bit unsigned fixed point dividend in AARGB0, AARGB1,AARGB2
;               16 bit unsigned fixed point divisor in BARGB0, BARGB1

;       Use:    CALL    FXD2416U

;       Output: 24 bit unsigned fixed point quotient in AARGB0, AARGB1,AARGB2
;               16 bit unsigned fixed point remainder in REMB0, REMB1

;       Result: AARG, REM  <--  AARG / BARG


FXD2416   
	       CLRF            REMB0
                CLRF            REMB1
                CLRF            TEMPD
                RLF             AARGB0,W
                RLF             REMB1, F
                MOVF            BARGB1,W
                SUBWF           REMB1, F
                MOVF            BARGB0,W
                BTFSS           STATUS,C
                INCFSZ          BARGB0,W
                SUBWF           REMB0, F
                CLRW
                BTFSS           STATUS,C
                MOVLW           H'1'
                SUBWF           TEMPD, F
                RLF             AARGB0, F
                MOVLW           H'7'
                MOVWF           LOOPCOUNT
LOOPU2416A 
		RLF             AARGB0,W
                RLF             REMB1, F
                RLF             REMB0, F
                RLF             TEMPD, F
                MOVF            BARGB1,W
                BTFSS           AARGB0,0
                GOTO            UADD46LA
                SUBWF           REMB1, F
                MOVF            BARGB0,W
                BTFSS           STATUS,C
                INCFSZ          BARGB0,W
                SUBWF           REMB0, F
                CLRW
                BTFSS           STATUS,C
                MOVLW           H'1'
                SUBWF           TEMPD, F
                GOTO            UOK46LA
UADD46LA 
                ADDWF           REMB1, F
                MOVF            BARGB0,W
                BTFSC           STATUS,C
                INCFSZ          BARGB0,W
                ADDWF           REMB0, F
                CLRW
                BTFSC           STATUS,C
                MOVLW           H'1'
                ADDWF           TEMPD, F
UOK46LA 
		RLF             AARGB0, F
                DECFSZ          LOOPCOUNT, F
                GOTO            LOOPU2416A
                RLF             AARGB1,W
                RLF             REMB1, F
                RLF             REMB0, F
                RLF             TEMPD, F
                MOVF            BARGB1,W
                BTFSS           AARGB0,0
                GOTO            UADD46L8
                SUBWF           REMB1, F
                MOVF            BARGB0,W
                BTFSS           STATUS,C
                INCFSZ          BARGB0,W
                SUBWF           REMB0, F
                CLRW
                BTFSS           STATUS,C
                MOVLW           1
                SUBWF           TEMPD, F
                GOTO            UOK46L8
UADD46L8 
               ADDWF           REMB1, F
                MOVF            BARGB0,W
                BTFSC           STATUS,C
                INCFSZ          BARGB0,W
                ADDWF           REMB0, F
                CLRW
                BTFSC           STATUS,C
                MOVLW           H'1'
                ADDWF           TEMPD, F
UOK46L8  
		RLF             AARGB1, F
                MOVLW           H'7'
                MOVWF           LOOPCOUNT
LOOPU2416B 
		RLF             AARGB1,W
                RLF             REMB1, F
                RLF             REMB0, F
                RLF             TEMPD, F
                MOVF            BARGB1,W
                BTFSS           AARGB1,0
                GOTO            UADD46LB
                SUBWF           REMB1, F
                MOVF            BARGB0,W
                BTFSS           STATUS,C
                INCFSZ          BARGB0,W
                SUBWF           REMB0, F
                CLRW
                BTFSS           STATUS,C
                MOVLW           H'1'
                SUBWF           TEMPD, F
                GOTO            UOK46LB
UADD46LB  
	        ADDWF           REMB1, F
                MOVF            BARGB0,W
                BTFSC           STATUS,C
                INCFSZ          BARGB0,W
                ADDWF           REMB0, F
                CLRW
                BTFSC           STATUS,C
                MOVLW           H'1'
                ADDWF           TEMPD, F
UOK46LB
	        RLF             AARGB1, F
                DECFSZ          LOOPCOUNT, F
                GOTO            LOOPU2416B
                RLF             AARGB2,W
                RLF             REMB1, F
                RLF             REMB0, F
                RLF             TEMPD, F
                MOVF            BARGB1,W
                BTFSS           AARGB1,0
                GOTO            UADD46L16
                SUBWF           REMB1, F
                MOVF            BARGB0,W
                BTFSS           STATUS,C
                INCFSZ          BARGB0,W
                SUBWF           REMB0, F
                CLRW
                BTFSS           STATUS,C
                MOVLW           H'1'
                SUBWF           TEMPD, F
                GOTO            UOK46L16
UADD46L16 
	        ADDWF           REMB1, F
                MOVF            BARGB0,W
                BTFSC           STATUS,C
                INCFSZ          BARGB0,W
                ADDWF           REMB0, F
                CLRW
                BTFSC           STATUS,C
                MOVLW           H'1'
                ADDWF           TEMPD, F
UOK46L16 
	        RLF             AARGB2, F
                MOVLW           H'7'
                MOVWF           LOOPCOUNT
LOOPU2416C  
		RLF             AARGB2,W
                RLF             REMB1, F
                RLF             REMB0, F
                RLF             TEMPD, F
                MOVF            BARGB1,W
                BTFSS           AARGB2,0
                GOTO            UADD46LC
                SUBWF           REMB1, F
                MOVF            BARGB0,W
                BTFSS           STATUS,C
                INCFSZ          BARGB0,W
                SUBWF           REMB0, F
                CLRW
                BTFSS           STATUS,C
                MOVLW           H'1'
                SUBWF           TEMPD, F
                GOTO            UOK46LC
UADD46LC  
	        ADDWF           REMB1, F
                MOVF            BARGB0,W
                BTFSC           STATUS,C
                INCFSZ          BARGB0,W
                ADDWF           REMB0, F
                CLRW
                BTFSC           STATUS,C
                MOVLW           H'1'
                ADDWF           TEMPD, F
UOK46LC 
		RLF             AARGB2, F
                DECFSZ          LOOPCOUNT, F
                GOTO            LOOPU2416C
                BTFSC           AARGB2,0
                GOTO            UOK46L
                MOVF            BARGB1,W
	        ADDWF           REMB1, F
                MOVF            BARGB0,W
                BTFSC           STATUS,C
                INCFSZ          BARGB0,W
                ADDWF           REMB0, F
UOK46L	
		RETURN
	
; 24x24 Bit Unsigned Fixed Point Multiply 24x24 -> 48
; Input: 24 bit unsigned fixed point multiplicand in AARGB0
; 24 bit unsigned fixed point multiplier in BARGB0
; Use: CALL FXM2424
; Output: 48 bit unsigned fixed point product in AARGB0
; Result: AARG <-- AARG x BARG
; Max Timing: 9+501+2 = 512 clks
; Min Timing: 9+150 = 159 clks

FXM2424
	CLRF 	AARGB3 ; clear partial product
	CLRF 	AARGB4
	CLRF 	AARGB5
	MOVF 	AARGB0,W
	MOVWF 	TEMPB0
	MOVF 	AARGB1,W
	MOVWF 	TEMPB1
	MOVF 	AARGB2,W
	MOVWF 	TEMPB2

	MOVLW 	H'08'
	MOVWF 	LOOPCOUNT
LOOPUM2424A
	RRF 	BARGB2,F
	BTFSC 	STATUS,C
	GOTO 	ALUM2424NAP
	DECFSZ 	LOOPCOUNT,F
	GOTO	LOOPUM2424A
	MOVWF 	LOOPCOUNT
LOOPUM2424B
	RRF 	BARGB1,F
	BTFSC 	STATUS,C
	GOTO	BLUM2424NAP
	DECFSZ	LOOPCOUNT,F
	GOTO	LOOPUM2424B
	MOVWF	LOOPCOUNT
LOOPUM2424C
	RRF		BARGB0,F
	BTFSC 	STATUS,C
	GOTO 	CLUM2424NAP
	DECFSZ 	LOOPCOUNT,F
	GOTO 	LOOPUM2424C
	CLRF 	AARGB0
	CLRF 	AARGB1
	CLRF 	AARGB2
	RETLW 	H'00'
CLUM2424NAP
	BCF 	STATUS,C
	GOTO 	CLUM2424NA
BLUM2424NAP
	BCF 	STATUS,C
	GOTO 	BLUM2424NA
ALUM2424NAP
	BCF 	STATUS,C
	GOTO 	ALUM2424NA
ALOOPUM2424
	RRF 	BARGB2,F
	BTFSS 	STATUS,C
	GOTO 	ALUM2424NA
	MOVF 	TEMPB2,W
	ADDWF 	AARGB2,F
	MOVF 	TEMPB1,W
	BTFSC 	STATUS,C
	INCFSZ 	TEMPB1,W
	ADDWF 	AARGB1,F
	MOVF 	TEMPB0,W
	BTFSC 	STATUS,C
	INCFSZ 	TEMPB0,W
	ADDWF	AARGB0,F
ALUM2424NA
	RRF 	AARGB0,F
	RRF 	AARGB1,F
	RRF 	AARGB2,F
	RRF 	AARGB3,F
	DECFSZ 	LOOPCOUNT,F
	GOTO 	ALOOPUM2424
	MOVLW 	H'08'
	MOVWF 	LOOPCOUNT
BLOOPUM2424
	RRF 	BARGB1,F
	BTFSS 	STATUS,C
	GOTO 	BLUM2424NA
	MOVF 	TEMPB2,W
	ADDWF 	AARGB2,F
	MOVF 	TEMPB1,W
	BTFSC 	STATUS,C
	INCFSZ 	TEMPB1,W
	ADDWF 	AARGB1,F
	MOVF 	TEMPB0,W
	BTFSC 	STATUS,C
	INCFSZ 	TEMPB0,W
	ADDWF 	AARGB0,F
BLUM2424NA
	RRF 	AARGB0,F
	RRF 	AARGB1,F
	RRF 	AARGB2,F
	RRF 	AARGB3,F
	RRF 	AARGB4,F
	DECFSZ 	LOOPCOUNT,F
	GOTO 	BLOOPUM2424
	MOVLW 	H'08'
	MOVWF 	LOOPCOUNT
CLOOPUM2424
	RRF 	BARGB0,F
	BTFSS 	STATUS,C
	GOTO 	CLUM2424NA
	MOVF 	TEMPB2,W
	ADDWF 	AARGB2,F
	MOVF 	TEMPB1,W
	BTFSC 	STATUS,C
	INCFSZ 	TEMPB1,W
	ADDWF 	AARGB1,F
	MOVF 	TEMPB0,W
	BTFSC 	STATUS,C
	INCFSZ 	TEMPB0,W
	ADDWF 	AARGB0,F
CLUM2424NA
	RRF 	AARGB0,F
	RRF 	AARGB1,F
	RRF 	AARGB2,F
	RRF 	AARGB3,F
	RRF 	AARGB4,F
	RRF 	AARGB5,F
	DECFSZ 	LOOPCOUNT,F
	GOTO 	CLOOPUM2424
	return

;*******************************************************************************************************************

INTERRUPT_F
			
	btfss	PIR1,TMR1IF		; flags clear or set
	goto	TEST_T2
	bcf		PIR1,TMR1IF

	btfss	SWITCH,0	; switch counter to toggle between F1/F2 
	goto	F2

; when timer 1 overflows, increase COUNT_F1
; if overflows, then toggle PORTB,0 and SWITCH,0
	incfsz	COUNT_F1,f
	goto	TEST_T2
	bcf		PORTB,0
	bcf		SWITCH,0
	clrf		COUNT_F2
; reload for F2 values
	bcf		T1CON,0		; stop timer
	movf	I_TIMERL_F2,w
	movwf	TMR1L
NO_F2_OVR
	movf	I_TIMERH_F2,w
	movwf	TMR1H
	movf	I_OVER_F2,w
	movwf	COUNT_F2
	bsf		T1CON,0	; start timer
	goto	TEST_T2

F2
; when timer 1 overflows, increase COUNT_F2
; if overflows, then toggle PORTB,0 and SWITCH,0
	incfsz	COUNT_F2,f
	goto	TEST_T2
	bsf		PORTB,0
	bsf		SWITCH,0
	clrf		COUNT_F1
; reload for F1 values
	bcf		T1CON,0		; stop timer
	movf	I_TIMERL_F1,w
	movwf	TMR1L
NO_F1_OVR
	movf	I_TIMERH_F1,w
	movwf	TMR1H
	movf	I_OVER_F1,w
	movwf	COUNT_F1
	bsf		T1CON,0	; start timer

TEST_T2; timer 2
	btfss	PIR1,TMR2IF
	goto	RECLAIM_F
	bcf		PIR1,TMR2IF

; FREQUENCY LEDS flasher
	incf		LED_TMR,f
; switch rate timers
	movf	SWITCH_TMR,w
	btfsc	STATUS,Z		; no decrement if 0, ie stop at 0
	goto	DEC_2			; only decrease 2nd timer when first is reduced to 0
	decf	SWITCH_TMR,f
	goto	RECLAIM_F
DEC_2
	movf	SWITCH_TMR2,w
	btfsc	STATUS,Z		; no decrement if 0, ie stop at 0
	goto	DEC_3			; only decrease 3rd timer when second is reduced to 0
	decf	SWITCH_TMR2,f
	goto	RECLAIM_F
DEC_3
	movf	SWITCH_TMR3,w
	btfss	STATUS,Z		; no decrement if 0, ie stop at 0
	decf	SWITCH_TMR3,f

; end of interrupt reclaim w and status
RECLAIM_F
	movf	PORTB,w
	movwf	PORTB_STO

;	bcf		PIR1,TMR1IF
	swapf	STATUS_TMP,w; status temp storage to w
	movwf	STATUS		; w to status register
	swapf	W_TMP,f		; swap upper and lower 4-bits in w_tmp
	swapf   	W_TMP,w		; swap bits and into w register
	retfie				; return from interrupt

;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>

FREQUENCY_MODE ; outputs frequency
	bsf		STATUS,RP0	; select memory bank 1
; set inputs/outputs
	movlw	B'01100110'	; port B outputs/ inputs set 
	movwf	TRISB		; port B data direction register
	bcf		STATUS,RP0	; select memory bank 0
	clrf		LED_TMR

;allow interrupts
	bsf		STATUS,RP0	; select memory bank 1
	bsf		PIE1,TMR1IE		; timer1 overrange
	bsf		PIE1,TMR2IE		; timer 2
	bcf		STATUS,RP0	; select memory bank 0
	bcf		PIR1,TMR1IF		; flags clear
	bcf		PIR1,TMR2IF		; clear flag
	bsf		INTCON,PEIE	; enable peripheral interrupts
;	bsf		INTCON,GIE		; global interrupt enable

; for frequency, use two period counters (totalling required value) so output can drive as a square wave

; start at upper threshold

; upper capture value 
	movlw	EEPROM0		; upper capture value overrange
	call		EEREAD
	movwf	OVER
	movlw	EEPROM1		; upper capture value ms byte
	call		EEREAD
	movwf	INPUTms
	movlw	EEPROM2		; upper capture value ls byte
	call		EEREAD
	movwf	INPUTls

; Check if >50,000,000
; check for capture less than 5,000,000 (H4C4B40)
	movlw	H'4C'
	subwf	OVER,w
	movwf	WORKING
	movlw	H'4B'
	subwf	INPUTms,w	; working input value ms byte
	movwf	WORKING1
	btfss	STATUS,C
	decf	WORKING,f
	movlw	H'40'
	subwf	INPUTls,w		; working input ls value
	movlw	D'1'
	btfss	STATUS,C
	subwf	WORKING1,f
	btfss	STATUS,C
	decf	WORKING,f
	btfsc	WORKING,7		; if set then 5,000,000  is greater than capture 
	goto	FREQUENCY_LOOP	; 
 ; load with 100Hz
	clrf		OVER
	movlw	H'C3'
	movwf	INPUTms
	movlw	H'50'
	movwf	INPUTls

FREQUENCY_LOOP
; check if frequency adjust or set Threshold
; uses JP1 (RB5)
	btfss	PORTB_STO,5
	goto	SET_THRESH_F	; set thresholds based on pressed switch	

; up/down adjust	
; check switches
	btfss	PORTB_STO,1
	goto	DOWN
	btfss	PORTB_STO,2
	goto	UP
; if no switch, load timers that set the period between switch pressed and next frequency update speed
	movlw	D'153'			; 2s (153 x 13ms) 
	movwf	SWITCH_TMR	; decreased at 13ms rate
	movwf	SWITCH_TMR2
	movwf	SWITCH_TMR3
	goto	USE

DOWN
; if UP switch also pressed wait till open
	btfsc	PORTB_STO,2
	goto	CONT_DOWN
	call		DELAYms
	goto	DOWN	

CONT_DOWN

; increase period for lower frequency stop at 1Hz (5,000,000) H4C4B40	
; OVER main counter for period overflow
; INPUTms output value ms byte
; INPUTls output value ls  byte
C_D

; below 10Hz step in greater steps
	movf	OVER,w
	sublw	D'3'			; if > 3	
	btfss	STATUS,C
	goto	EXTRA_DOWN
	incfsz	INPUTls,f
	goto	CK_LESS_1Hz	
	incfsz	INPUTms,f
	goto	CK_LESS_1Hz	
	incfsz	OVER,f
	goto	CK_LESS_1Hz		
	goto	SET1Hz			; set at 1Hz if overrange

CK_LESS_1Hz	
	
; check for period less than 5,000,000 (H4C4B40)
	movlw	H'4C'
	subwf	OVER,w
	movwf	WORKING
	movlw	H'4B'
	subwf	INPUTms,w		; working input value ms byte
	movwf	WORKING1
	btfss	STATUS,C
	decf	WORKING,f
	movlw	H'40'
	subwf	INPUTls,w		; working input ls value
	movlw	D'1'
	btfss	STATUS,C
	subwf	WORKING1,f
	btfss	STATUS,C
	decf	WORKING,f
	btfsc	WORKING,7		; if set then 5,000,000  is greater than capture 
	goto	USE			; use up value
; otherwise set at 1Hz
SET1Hz
	movlw	H'4C'
	movwf	OVER
	movlw	H'4B'
	movwf	INPUTms
	movlw	H'40'
	movwf	INPUTls
	goto	USE

EXTRA_DOWN
	movlw	D'8'
	addwf	INPUTls,f
	btfss	STATUS,C	; increase next byte if carry
	goto	CK_LESS_1Hz	
	incfsz	INPUTms,f
	goto	CK_LESS_1Hz	
	incfsz	OVER,f
	goto	CK_LESS_1Hz		
	goto	SET1Hz			; set at 1Hz if overrange

UP
; if DOWN switch also pressed wait till open
	btfsc	PORTB_STO,1
	goto	CONT_UP
	call		DELAYms
	goto	UP
CONT_UP

; decrease period for higher frequency, stop at 10kHz (500)	H1F4
; OVER main counter for period overflow
; INPUTms output value ms byte
; INPUTls output value ls  byte
; decrease ls byte then higher bytes if carry clear

; below 10Hz step in greater steps
	movf	OVER,w
	sublw	D'3'			; if > 3	
	btfss	STATUS,C
	goto	EXTRA_UP

	movlw	D'1'
	subwf	INPUTls,f
	btfsc	STATUS,C			; if carry clear reduce next byte
	goto	CK_MORE_10kHz
	movlw	D'1'
	subwf	INPUTms,f
	btfsc	STATUS,C			; if carry clear reduce next byte
	goto	CK_MORE_10kHz
	movlw	D'1'
	subwf	OVER,f
;	btfss	STATUS,C			; if carry clear; overrange
;	goto	SET10kHz			; set at 10kHz if overrange

CK_MORE_10kHz

; check for period less than 500 (H1F4)
	movlw	H'00'
	subwf	OVER,w
	movwf	WORKING
	movlw	H'01'
	subwf	INPUTms,w		; working input value ms byte
	movwf	WORKING1
	btfss	STATUS,C
	decf	WORKING,f
	movlw	H'F4'
	subwf	INPUTls,w		; working input ls value
	movlw	D'1'
	btfss	STATUS,C
	subwf	WORKING1,f
	btfss	STATUS,C
	decf	WORKING,f
	btfss	WORKING,7		; if set then 500  is greater than capture 
	goto	USE			; use up value
; otherwise set at 10kHz
SET10kHz
	movlw	H'00'
	movwf	OVER
	movlw	H'01'
	movwf	INPUTms
	movlw	H'F4'
	movwf	INPUTls
	goto	USE

EXTRA_UP
	movlw	D'8'
	subwf	INPUTls,f
	btfsc	STATUS,C			; if carry clear reduce next byte
	goto	CK_MORE_10kHz
	movlw	D'1'
	subwf	INPUTms,f
	btfsc	STATUS,C			; if carry clear reduce next byte
	goto	CK_MORE_10kHz
	movlw	D'1'
	subwf	OVER,f
	btfss	STATUS,C			; if carry clear; overrange
	goto	SET10kHz			; set at 10kHz if overrange
	goto	CK_MORE_10kHz

;............................................................................................................................................
USE
	
; find frequency zone at less than 10Hz, 100Hz, 1kHz or 10kHz (count updated in interrupt)
; check timer and light LEDs 
	btfss	LED_TMR,5
	goto	LEDS_F			; LEDs on
; LEDS_OFF
	bcf		PORTA,0		; LED2 on 10Hz
	bcf		PORTB,4		; LED3 off 100Hz
	bcf		PORTA,1		; LED5 off 10k
	bcf		PORTB,7		; LED4 off 1kHz	
	goto	COMPARE_F
LEDS_F	
; <10Hz >500,000 H 7 A1 20
; check for capture less than 500,000 H 7 A1 20
	movlw	H'7'
	subwf	OVER,w
	movwf	WORKING
	movlw	H'A1'
	subwf	INPUTms,w	; working input value ms byte
	movwf	WORKING1
	btfss	STATUS,C
	decf	WORKING,f
	movlw	H'20'
	subwf	INPUTls,w		; working input ls value
	movlw	D'1'
	btfss	STATUS,C
	subwf	WORKING1,f
	btfss	STATUS,C
	decf	WORKING,f
	btfss	WORKING,7		; if set then 500,000  is greater than capture 
	goto	LED_10Hz_F
; <100Hz > 50,000 H C3 50
; check for capture less than 50,000 H 0 C3 50
	movlw	H'0'
	subwf	OVER,w
	movwf	WORKING
	movlw	H'C3'
	subwf	INPUTms,w	; working input value ms byte
	movwf	WORKING1
	btfss	STATUS,C
	decf	WORKING,f
	movlw	H'50'
	subwf	INPUTls,w		; working input ls value
	movlw	D'1'
	btfss	STATUS,C
	subwf	WORKING1,f
	btfss	STATUS,C
	decf	WORKING,f
	btfss	WORKING,7		; if set then 50,000  is greater than capture 
	goto	LED_100Hz_F

; <1kHz > 5,000 H 13 88
; check for capture less than 5,000 H 0 13 88
	movlw	H'0'
	subwf	OVER,w
	movwf	WORKING
	movlw	H'13'
	subwf	INPUTms,w	; working input value ms byte
	movwf	WORKING1
	btfss	STATUS,C
	decf	WORKING,f
	movlw	H'88'
	subwf	INPUTls,w		; working input ls value
	movlw	D'1'
	btfss	STATUS,C
	subwf	WORKING1,f
	btfss	STATUS,C
	decf	WORKING,f
	btfss	WORKING,7		; if set then 5,000  is greater than capture 
	goto	LED_1kHz_F

; <10kHz> 500 H 1 F4
; check for capture less than 500 H 0 1 F4
	movlw	H'0'
	subwf	OVER,w
	movwf	WORKING
	movlw	H'01'
	subwf	INPUTms,w	; working input value ms byte
	movwf	WORKING1
	btfss	STATUS,C
	decf	WORKING,f
	movlw	H'F4'
	subwf	INPUTls,w		; working input ls value
	movlw	D'1'
	btfss	STATUS,C
	subwf	WORKING1,f
	btfss	STATUS,C
	decf	WORKING,f
	btfss	WORKING,7		; if set then 500  is greater than capture 
	goto	LED_10kHz_F
; <100kHz>50.
	goto	LED_100kHz_F
;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
LED_10Hz_F;  less than 10Hz
	bsf		PORTA,0		; LED2 on 10Hz
	bcf		PORTB,4		; LED3 off 100Hz
	bcf		PORTA,1		; LED5 off 10k
	bcf		PORTB,7		; LED4 off 1kHz	
	goto	COMPARE_F
LED_100Hz_F;  less than 100Hz
	bcf		PORTA,0		; LED2 off 10Hz
	bsf		PORTB,4		; LED3 on 100Hz
	bcf		PORTA,1		; LED5 off 10k
	bcf		PORTB,7		; LED4 off 1kHz	
	goto	COMPARE_F
LED_1kHz_F;  less than 1kHz
	bcf		PORTA,0		; LED2 off 10Hz
	bcf		PORTB,4		; LED3 off 100Hz
	bcf		PORTA,1		; LED5 off 10k
	bsf		PORTB,7		; LED4 on 1kHz	
	goto	COMPARE_F
LED_10kHz_F;  less than 10kHz
	bcf		PORTA,0		; LED2 off 10Hz
	bcf		PORTB,4		; LED3 off 100Hz
	bsf		PORTA,1		; LED5 on 10k
	bcf		PORTB,7		; LED4 off 1kHz	
	goto	COMPARE_F
LED_100kHz_F;  10kHz and over
	bsf		PORTA,0		; LED2 on 10Hz
	bsf		PORTB,4		; LED3 on 100Hz
	bsf		PORTA,1		; LED5 on 10k
	bsf		PORTB,7		; LED4 on 1kHz	
;...................................................................................................................

COMPARE_F

; do comparisons of OVER,INPUTms and INPUTls with thresholds
CK_HIGH_THRESH_F
	btfss	THRESH,0		; check if on and RELAY on
	goto	COMP1_F

; relay off
	btfsc	PORTB,3		; is relay off
	goto	CK_LOW_THRESH_F	; check low Threshold
	
COMP1_F
; check if values are lower (ie higher frequency) than Upper Threshold

	call		UPPER_COMPARISON_F ; do comparison
	btfsc	WORKING,7		; if set then threshold  is greater than capture and threshold frequency is lower than input 
	goto	REACHED_UPPER_F
; threshold not reached
; indicator off
	bcf		PORTA,4		; indicator off
; clear THRESH if RESPONSE is not 0 
	movf	RESPONSE,w
	btfsc	STATUS,Z
	goto	PERIODS
; not 0
	bcf		THRESH,0
	goto	PERIODS			; continue

REACHED_UPPER_F
; check THRESH,0			; threshold reached
; if set then continue counting down timer
; if delay has started bypass loading RESPONSE. Reset timer if  thresholds are not met during response delay.
	btfsc	THRESH,0		; if set
	goto	COUNT_D_F
	bsf		THRESH,0
	bsf		PORTA,4		; indicator on
 ; get response (0-5V = 0-500ms)
	call		SET_RESPONSE ; get response value

COUNT_D_F	
	movf	RESPONSE,w
	btfsc	STATUS,Z		; if zero stop decrement
	goto	THRESH_UP_F
; wait for timer 0 overflow
	btfss	INTCON,TMR0IF	; if set then overflow
	goto	PERIODS
	bcf		INTCON,TMR0IF
	movlw	H'D9'			; FF-D38 for 1.94ms per count
	movwf	TMR0
	decfsz	RESPONSE,f
	goto	PERIODS

THRESH_UP_F
	bsf		PORTB,3		; relay on
	goto	PERIODS

;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
CK_LOW_THRESH_F	; check low Threshold

; do comparisons of captured with thresholds

	btfss	THRESH,0		; check if on
	goto	CK_HIGH_THRESH_F	;  check high Threshold

;COMP2_F

; if FF FF FF (no signal)  then bypass
	movlw	H'FF'
	xorwf	BARGB0,w
	btfss	STATUS,Z
	goto	CHECK_OK_F
	movlw	H'FF'
	xorwf	BARGB1,w
	btfss	STATUS,Z
	goto	CHECK_OK_F
	movlw	H'FF'
	xorwf	BARGB2,w
	btfsc	STATUS,Z
	goto	PERIODS		; all FF so bypass

CHECK_OK_F
; check if values are greater than (ie lower frequency) than Lower Threshold
	call		LOWER_COMPARISON_F
	btfss	WORKING,7		; if set then threshold  is greater than capture and threshold frequency is lower than input
	goto	REACHED_LOWER_F
; threshold not reached
	bsf		PORTA,4		; indicator on

; clear THRESH if RESPONSE is not 0 and PORTB_STO,5 is low (for H-L threshold)
	movf	RESPONSE,w
	btfsc	STATUS,Z
	goto	PERIODS
; not 0
	bcf		THRESH,1
	goto	PERIODS			; continue
REACHED_LOWER_F
; check THRESH,0			; threshold reached
; if set than continue counting down timer
; if delay has started bypass loading RESPONSE. Reset timer if  thresholds are not met during response delay.
	btfsc	THRESH,1		; if set
	goto	COUNT_D1_F
	bsf		THRESH,1

; indicator off
	bcf		PORTA,4		; indicator off
; get response (0-5V = 0-500ms) value
	call		SET_RESPONSE

COUNT_D1_F	
	movf	RESPONSE,w
	btfsc	STATUS,Z		; if zero stop decrement
	goto	THRESH_DN_F
; wait for timer 0 overflow
	btfss	INTCON,TMR0IF	; if set then overflow
	goto	PERIODS
	bcf		INTCON,TMR0IF
	movlw	H'D9'			; FF-D38 for 1.94ms per count
	movwf	TMR0
	decfsz	RESPONSE,f
	goto	PERIODS

THRESH_DN_F

; relay off
	bcf		PORTB,3		; relay off
	clrf		THRESH
;	goto	PERIODS

;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
; setup period count for a 50% count change in output level to generate the frequency based on period
; divide by 2 for frequency output place in OVER_F1,TIMERH_F1, TIMERL_F1
PERIODS;
	bcf		STATUS,C	; carry off
	rrf		OVER,w		; main counter for period overflow
	movwf	OVER_F1	; one half of period
	movwf	OVER_F2

	rrf		INPUTms,w	; output value ms byte
	movwf	TIMERH_F1
	movwf	TIMERH_F2

	rrf		INPUTls,w	; output value ls  byte
	movwf	TIMERL_F1
	movwf	TIMERL_F2

; check if INPUTls,0 is set
	btfss	INPUTls,0	; if set, add 1 to F2 timers since divide by 2 is not exactly half but one ls bit left
	goto	CPR
	incfsz	TIMERL_F2,f
	goto	CPR
	incfsz	TIMERH_F2,f
	goto	CPR
	incf		OVER_F2,f
CPR
;compare with temp
	movf	TEMP1,w
	xorwf	INPUTls,w
	btfss	STATUS,Z
	goto	USE1		; different
	
	movf	TEMP2,w
	xorwf	INPUTms,w
	btfss	STATUS,Z
	goto	USE1		; different

	movf	TEMP3,w
	xorwf	OVER,w
	btfsc	STATUS,Z
	goto	FREQUENCY_LOOP	; all the same

USE1; store values for checking 
	movf	INPUTls,w
	movwf	TEMP1
	movf	INPUTms,w
	movwf	TEMP2
	movf	OVER,w
	movwf	TEMP3

; subtract F1 and F2 values from FF FF FF for interrupt timer1 use where output changes when entire counting up is reached. 
; for calculation ease, use complementary values 
; stop interrupt while placing in I_ values

; add compensation for interrupt delays

	movlw	D'33'
	subwf	TIMERL_F1,f
	btfsc	STATUS,C		; if carry add to next byte
	goto	CHNG2
	movlw	D'1'
	subwf	TIMERH_F1,f
	btfsc	STATUS,C
	goto	CHNG2
	decf	OVER_F1,f
CHNG2
	movlw	D'33'
	subwf	TIMERL_F2,f
	btfsc	STATUS,C		; if carry add to next byte
	goto	CHNG
	movlw	D'1'
	subwf	TIMERH_F2,f
	btfsc	STATUS,C
	goto	CHNG
	decf	OVER_F2,f
CHNG
; transfer to interrupt working values
TRANSF
	bcf		INTCON,GIE
	comf	OVER_F1,w
	movwf	I_OVER_F1
	comf	TIMERH_F1,w
	movwf	I_TIMERH_F1
	comf	TIMERL_F1,w
	movwf	I_TIMERL_F1

	comf	OVER_F2,w
	movwf	I_OVER_F2
	comf	TIMERH_F2,w
	movwf	I_TIMERH_F2
	comf	TIMERL_F2,w
	movwf	I_TIMERL_F2
	
BY_TRANSF
	bsf		INTCON,GIE
; DELAY
; if OVER is <7 the use delay to slow down change in frequency

	movf	OVER,w
	sublw	D'8'			; if < 7	
	btfss	STATUS,C
	goto 	FREQUENCY_LOOP

; if frequency is >1k use different timing values INPUTms <D19, OVER is 0
	movf	OVER,w		; OVER =zero?
	btfss	STATUS,Z
	goto	T2
	movf	INPUTms,w
	sublw	D'19'
	btfss	STATUS,C
	goto	T2
; >1k so use slower	
	bsf		CHANGE,0		; set so processed value altered as well
	movlw	D'255'
	movf	SWITCH_TMR,f
	btfsc	STATUS,Z
	movlw	D'100'
	movf	SWITCH_TMR2,f
	btfsc	STATUS,Z
	movlw	D'50'
	movf	SWITCH_TMR3,f
	btfsc	STATUS,Z
	movlw	D'10'
	movwf	T_DEL
	goto	SWI
T2
	clrf		CHANGE
	movlw	D'50'
	movf	SWITCH_TMR,f
	btfsc	STATUS,Z
	movlw	D'25'
	movf	SWITCH_TMR2,f
	btfsc	STATUS,Z
	movlw	D'10'
	movf	SWITCH_TMR3,f
	btfsc	STATUS,Z
	movlw	D'1'
	movwf	T_DEL
SWI
; check switches if both open bypass delay
	btfss	PORTB_STO,1
	goto	DELA
	btfsc	PORTB_STO,2
	goto	FREQUENCY_LOOP

DELA

;	shift OVER and INPUTms
	movf	OVER,w
	movwf	PROCESSED1
	movf	INPUTms,w
	movwf	PROCESSED2
	bcf		STATUS,C
	rrf		PROCESSED1,f
	rrf		PROCESSED2,f
	bcf		STATUS,C
	rrf		PROCESSED1,f
	rrf		PROCESSED2,f
	bcf		STATUS,C
	rrf		PROCESSED1,f
	rrf		PROCESSED2,f
	bcf		STATUS,C
	rrf		PROCESSED1,f
	rrf		PROCESSED2,f
	btfsc	CHANGE,0			; change rate flag
	goto	BY_CHNG
	bsf		PROCESSED2,7
;	bsf		PROCESSED2,6
	bsf		PROCESSED2,5
BY_CHNG
	comf	PROCESSED2,w	; delay set by value
	btfsc	STATUS,Z		; if zero, use 1
	movlw	D'1'
	movwf	STORE1		; STORE1 is number of loops value

LOOP11	
	movf	T_DEL,w		; delay period
	movwf	STORE2		; STORE2 is internal loop value	
LOOP22
	decfsz	STORE2,f
	goto	LOOP22
	decfsz	STORE1,f
	goto	LOOP11
	goto	FREQUENCY_LOOP

;_________________________________________________________

SET_THRESH_F

; if switch pressed, then store values in EEPROM 
	btfss 	PORTB_STO,2		; if low
	goto	UPPER_THRESH_F	; upper threshold

	btfsc	PORTB_STO,1	
	goto	USE				; no switches

LOWER_THRESHOLD_F; if lower threshold switch is pressed, then store 

; wait for switches to open

	btfss	PORTB_STO,1		; S1
	goto	LED_ON_F
	btfsc	PORTB_STO,2		; S2
	goto	L_THRESH_F
LED_ON_F
	bsf		PORTA,4
	call		DELAYms
	bcf		PORTA,4
	call		DELAYms
	goto	LOWER_THRESHOLD_F

L_THRESH_F	
	call		STORE_LOWER_F
; if JP2 (thresholds or hysteresis) out or in, 
	btfss	PORTB,6
	goto	CALC_UPPER_F	; requires upper threshold hysteresis calculation
	call		CK_OPPOSITE_THRESH1_F; make sure lower threshold frequency is below upper.
	goto	USE

STORE_LOWER_F

	movlw	EEPROM3		; non-volatile storage for overrange  LOWER THRESHOLD/ hysteresis
	call		EEREAD		; sets EEADR
	movf	OVER,w			; working overrange
	call		EEWRITE		; store

	movlw	EEPROM4		; non-volatile storage for CCPR1H 	LOWER THRESHOLD/ hysteresis
	call		EEREAD		; sets EEADR
	movf	INPUTms,w		; working input value ms byte
	call		EEWRITE		; store

	movlw	EEPROM5		; non-volatile storage for CCPR1L 	LOWER THRESHOLD/ hysteresis
	call		EEREAD		; sets EEADR
	movf	INPUTls,w		; working input value ls byte
	call		EEWRITE		; store
	return
CK_OPPOSITE_THRESH1_F
; make sure lower threshold frequency is below upper.

; upper capture value 
	movlw	EEPROM0		; upper capture value overrange
	call		EEREAD
	movwf	BARGB0
	movlw	EEPROM1		; upper capture value ms byte
	call		EEREAD
	movwf	BARGB1
	movlw	EEPROM2		; upper capture value ls byte
	call		EEREAD
	movwf	BARGB2

	movf	BARGB0,w
	subwf	OVER,w
	movwf	WORKING
	movf	BARGB1,w
	subwf	INPUTms,w	; working input value ms byte
	movwf	WORKING1
	btfss	STATUS,C
	decf	WORKING,f
	movf	BARGB2,w
	subwf	INPUTls,w		; working input ls value
	movlw	D'1'
	btfss	STATUS,C
	subwf	WORKING1,f
	btfss	STATUS,C
	decf	WORKING,f
	btfss	WORKING,7		; if set then upper threshold  is greater than lower
	return

	call		STORE_UPPER_F	; store same values in upper as lower
 
	return

;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
; if JP1 is out, calculate hysteresis based on upper threshold then store
CALC_LOWER_F
	; if JP1 is in, calculate hysteresis based on upper threshold then store in lower threshold	

; get Hysteresis value at AN2 (0-5V = 0-50%)
; set for channel 2
	bcf		ADCON0,5
	bsf		ADCON0,4
	bcf		ADCON0,3
	call		ACQUIRE_AD
	movf	ADRESH,w
	movwf	AARGB2		; multiply by percentage value[
	clrf		AARGB0		; ms byte cleared
	clrf		AARGB1
; upper capture value 
	movlw	EEPROM0		; higher capture value overrange
	call		EEREAD
	movwf	BARGB0
	movlw	EEPROM1		; higher capture value ms byte
	call		EEREAD
	movwf	BARGB1
	movlw	EEPROM2		; higher capture value ls byte
	call		EEREAD
	movwf	BARGB2

; percentage calculation (count x A/D value /255) ; eg when A/D value is at maximum (ie 256) calculation will be 50%
; (note we calculate hysteresis using period counting. So for a frequency hysteresis, the period calculation is non-linear)
	call		FXM2424		; multiply percentage value by lower capture value 

; value in AARGB0,1,2,3,4,5 AARGB0,1 is zero AARGB2 is FF maximum 
; to divide by 256 use AARGB2 and AARGB3 and AARGB4  as the 24-bit value

; then add percentage AARGB2 and AARGB3 and AARGB4 to count BARGB0,BARGB1,BARGB2
; lower capture value 
	movlw	EEPROM0		; upper capture value overrange
	call		EEREAD
	movwf	BARGB0
	movlw	EEPROM1		; upper capture value ms byte
	call		EEREAD
	movwf	BARGB1
	movlw	EEPROM2		; upper capture value ls byte
	call		EEREAD
	movwf	BARGB2

; add  percentage value for lower frequency (24bit)

; BARGB0 BARGB1 BARGB2 + AARGB2 AARGB3 AARGB4 = BARGB0,1,2
	movf	AARGB4,w		; ls bytes
	addwf	BARGB2,f

	btfss	STATUS,C		; if over
	goto	ADD1_F
	incfsz	AARGB3,f		; increase next byte if over
	goto	ADD1_F
	incfsz	AARGB2,f		; continue increase next byte if over
	goto	ADD1_F
	goto	ADD_OVR_F
ADD1_F
	movf	AARGB3,w		; add next bytes
	addwf	BARGB1,f

	btfss	STATUS,C
	goto	ADD2_F
	incfsz	AARGB2,f		; increase next byte if over
	goto	ADD2_F
	goto	ADD_OVR_F
ADD2_F
	movf	AARGB2,w		; add ms bytes
	addwf	BARGB0,f

	btfss	STATUS,C
	goto	ST_LOW_F

; overrange so set at FF FF FF
ADD_OVR_F
	movlw	H'FF'
	movwf	BARGB0
	movwf	BARGB1
	movwf	BARGB2

; STORE in LOWER
ST_LOW_F
	movlw	EEPROM3		; non-volatile storage for overrange  LOWER THRESHOLD/ hysteresis
	call		EEREAD		; sets EEADR
	movf	BARGB0,w		; overrange
	call		EEWRITE		; store

	movlw	EEPROM4		; non-volatile storage for CCPR1H 	LOWER THRESHOLD/ hysteresis
	call		EEREAD		; sets EEADR
	movf	BARGB1,w		; working input value ms byte
	call		EEWRITE		; store

	movlw	EEPROM5		; non-volatile storage for CCPR1L 	LOWER THRESHOLD/ hysteresis
	call		EEREAD		; sets EEADR
	movf	BARGB2,w		; working input value ls byte
	call		EEWRITE		; store

	goto	USE
;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>

UPPER_THRESH_F
; store threshold value
	call		STORE_UPPER_F

; wait for switches to open
U1_THRESHOLD_F
	btfss	PORTB_STO,1		; S1
	goto	LED_ON_U_F
	btfsc	PORTB_STO,2		; S2
	goto	U_THRESH_F
LED_ON_U_F
	bsf		PORTA,4
	call		DELAYms
	bcf		PORTA,4
	call		DELAYms
	goto	U1_THRESHOLD_F

U_THRESH_F	

; if JP2 (thresholds or hysteresis) out or in,
	btfss	PORTB,6
	goto	CALC_LOWER_F		; calculate lower hysteresis and store

	call		CK_OPPOSITE_THRESH_F; check opposister threshold (upper for higher frequency than lower)
	goto	USE

STORE_UPPER_F	

	movlw	EEPROM0		; non-volatile storage for overflow UPPER THRESHOLD/ hysteresis
	call		EEREAD		; sets EEADR
	movf	OVER,w			; working input1 setting
	call		EEWRITE		; store

	movlw	EEPROM1		; non-volatile storage for CCPR1H 	UPPER THRESHOLD/ hysteresis
	call		EEREAD		; sets EEADR
	movf	INPUTms,w		; working input value ms byte
	call		EEWRITE		; store

	movlw	EEPROM2		; non-volatile storage for CCPR1L 	UPPER THRESHOLD/ hysteresis
	call		EEREAD		; sets EEADR
	movf	INPUTls,w		; working input value ls byte
	call		EEWRITE		; store
	return

CK_OPPOSITE_THRESH_F
; make sure upper threshold frequency is above lower.
; Lower capture value 
	movlw	EEPROM3		; lower capture value overrange
	call		EEREAD
	movwf	BARGB0
	movlw	EEPROM4		; lower capture value ms byte
	call		EEREAD
	movwf	BARGB1
	movlw	EEPROM5		; lower capture value ls byte
	call		EEREAD
	movwf	BARGB2

	movf	BARGB0,w
	subwf	OVER,w
	movwf	WORKING
	movf	BARGB1,w
	subwf	INPUTms,w		; working input value ms byte
	movwf	WORKING1
	btfss	STATUS,C
	decf	WORKING,f
	movf	BARGB2,w
	subwf	INPUTls,w		; working input ls value
	movlw	D'1'
	btfss	STATUS,C
	subwf	WORKING1,f
	btfss	STATUS,C
	decf	WORKING,f
	btfsc	WORKING,7		; if set then lower threshold frequency is greater than upper (thresholds are oppossite for frequency ie higher threshold=lower frequency)
	return

	call		STORE_LOWER_F	; store same values in lower as upper

	return

;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
CALC_UPPER_F
; if JP1 is in, calculate hysteresis based on lower threshold then store in upper threshold	
;; get Hysteresis value at AN2 (0-5V = 0-50%)
; set for channel 2
	bcf		ADCON0,5
	bsf		ADCON0,4
	bcf		ADCON0,3
	call		ACQUIRE_AD
	movf	ADRESH,w
	movwf	AARGB2		; multiply by percentage value[
	clrf		AARGB0		; ms byte cleared
	clrf		AARGB1
; lower capture value 
	movlw	EEPROM3		; lower capture value overrange
	call		EEREAD
	movwf	BARGB0
	movlw	EEPROM4		; lower capture value ms byte
	call		EEREAD
	movwf	BARGB1
	movlw	EEPROM5		; lower capture value ls byte
	call		EEREAD
	movwf	BARGB2

; percentage calculation (count x A/D value /255) ; eg when A/D value is at maximum (ie 256) calculation will be 50%
	call		FXM2424		; multiply percentage value by lower capture value 


; value in AARGB0,1,2,3,4,5 AARGB0,1 is zero AARGB2 is FF maximum 
; to divide by 256 use AARGB2 and AARGB3 and AARGB4  as the 24-bit value
; divide by 3 for a 50% change at maximum setting. (note we calculate hysteresis using period counting. So for a frequency hysteresis, the period calculation is non-linear)
	
; move along to most significant end for divide
	movf	AARGB2,w
	movwf	AARGB0
	movf	AARGB3,w
	movwf	AARGB1
	movf	AARGB4,w
	movwf	AARGB2

	clrf		BARGB0
	movlw	D'3'
	movwf	BARGB1
	call		FXD2416				

; then subtract percentage AARGB0 and AARGB1 and AARGB2 from count BARGB0,BARGB1,BARGB2
; upper capture value 
	movlw	EEPROM3		; lower capture value overrange
	call		EEREAD
	movwf	BARGB0
	movlw	EEPROM4		; lower capture value ms byte
	call		EEREAD
	movwf	BARGB1
	movlw	EEPROM5		; lower capture value ls byte
	call		EEREAD
	movwf	BARGB2

; BARGB0 BARGB1 BARGB2 - AARGB0 AARGB1 AARGB2 = BARGB0,1,2

; BARGB0 BARGB1 BARGB2 - AARGB0 AARGB1 AARGB2 = BARGB0,1,2

	movf	AARGB2,w		; start with low byte subtraction
	subwf	BARGB2,f
	btfsc	STATUS,C    		; if carry is clear then decrease next byte
	goto	SUB1_F
	movlw	D'1'
	subwf	AARGB1,f
	btfsc	STATUS,C
	goto	SUB1_F
	movlw	D'1'
	subwf	AARGB0,f
	btfss	STATUS,C
	goto	REWRITE_LOW_F
SUB1_F
	movf	AARGB1,w		; mid byte subtraction
	subwf	BARGB1,f
	btfsc	STATUS,C    		; if carry is clear then decrease next byte
	goto	SUB0_F
	movlw	D'1'
	subwf	AARGB0,f
	btfss	STATUS,C
	goto	REWRITE_LOW_F	
SUB0_F
	movf	AARGB0,w		; high byte subtraction
	subwf	BARGB0,f
	btfsc	STATUS,C    		; if carry is clear then decrease next byte
	goto	ST_UP_F

; end rewrite subtraction
REWRITE_LOW_F
; small so set at H00 00 10
	movlw	H'10'
	movwf	BARGB2
	clrf		BARGB1
	clrf		BARGB0

; STORE in UPPER
ST_UP_F

	movlw	EEPROM0		; non-volatile storage for capture over UPPER
	call		EEREAD		; sets EEADR
	movf	BARGB0,w
	call		EEWRITE		; store

	movlw	EEPROM1		; non-volatile storage for CCPR1H 	UPPER THRESHOLD/ hysteresis
	call		EEREAD		; sets EEADR
	movf	BARGB1,w		;  ms byte
	call		EEWRITE		; store

	movlw	EEPROM2		; non-volatile storage for CCPR1L 	UPPER THRESHOLD/ hysteresis
	call		EEREAD		; sets EEADR
	movf	BARGB2,w		; working input value ls byte
	call		EEWRITE		; store


	goto	FREQUENCY_LOOP

;___________________________________________________

UPPER_COMPARISON_F
;  comparison here for < Upper threshold
; get upper threshold capture value 
	movlw	EEPROM0		; upper capture value overrange
	call		EEREAD
	movwf	BARGB0
	movlw	EEPROM1		; upper capture value ms byte
	call		EEREAD
	movwf	BARGB1
	movlw	EEPROM2		; upper capture value ls byte
	call		EEREAD
	movwf	BARGB2
;compare
	movf	BARGB0,w
	subwf	OVER,w
	movwf	WORKING
	movf	BARGB1,w
	subwf	INPUTms,w	; working input value ms byte
	movwf	WORKING1
	btfss	STATUS,C
	decf	WORKING,f
	movf	BARGB2,w
	subwf	INPUTls,w		; working input ls value
	movlw	D'1'
	btfss	STATUS,C
	subwf	WORKING1,f
	btfss	STATUS,C
	decf	WORKING,f
	return

LOWER_COMPARISON_F
;  comparison here for < Upper threshold
; get lower threshold capture value 
	movlw	EEPROM3		; lower capture value overrange
	call		EEREAD
	movwf	BARGB0
	movlw	EEPROM4		; lower capture value ms byte
	call		EEREAD
	movwf	BARGB1
	movlw	EEPROM5		; lower capture value ls byte
	call		EEREAD
	movwf	BARGB2
;compare
	movf	BARGB0,w
	subwf	OVER,w
	movwf	WORKING
	movf	BARGB1,w
	subwf	INPUTms,w	; working input value ms byte
	movwf	WORKING1
	btfss	STATUS,C
	decf	WORKING,f
	movf	BARGB2,w
	subwf	INPUTls,w		; working input ls value
	movlw	D'1'
	btfss	STATUS,C
	subwf	WORKING1,f
	btfss	STATUS,C
	decf	WORKING,f
	return

	end
