
//The XC3804 sets up an AP with these credentials:
#define STASSID "Duinotech WiFi Relay"
#define STAPSK NULL
//at this server/port
const char* host = "relay.net";
const uint16_t port = 80; //well known http port

const char* ssid = STASSID;
const char* password = STAPSK;
const char greenURL[]="http://relay.net/open";
const char redURL[]="http://relay.net/close";
#define CONNECT_TIMEOUT 30000

#include <ESP8266WiFi.h>
#include <ESP8266HTTPClient.h>
WiFiClient client;
HTTPClient http;

#define RED_LIGHT D7
#define RED_BUTTON D1
#define GREEN_LIGHT D6
#define GREEN_BUTTON D5
//onboard LED is active low
#define STATUS_LED D4
#define LED_OFF (0)
#define LED_DIM (1)
#define LED_ON (255)
#define STATUS_UNKNOWN 0
#define STATUS_RED 1
#define STATUS_GREEN 2

int status=STATUS_UNKNOWN;  //until one of the buttons gets pressed

void setup() {
  Serial.begin(115200);
  analogWriteRange(255);
  analogWrite(RED_LIGHT,LED_DIM);
  analogWrite(GREEN_LIGHT,LED_DIM);
  pinMode(RED_BUTTON,INPUT_PULLUP);
  pinMode(GREEN_BUTTON,INPUT_PULLUP);
  pinMode(STATUS_LED,OUTPUT);
  digitalWrite(STATUS_LED,HIGH);  //OFF
  WiFi.begin(STASSID, STAPSK);
  while (WiFi.status()!=WL_CONNECTED){
    delay(400);
    digitalWrite(STATUS_LED,LOW);
    delay(100);
    digitalWrite(STATUS_LED,HIGH);  //flicker while connecting
    Serial.print(".");
    if(millis()>CONNECT_TIMEOUT){
      Serial.println("\r\nCould not connect, rebooting");
      delay(100);
      ESP.restart();
    }
  }
  digitalWrite(STATUS_LED,LOW); //solid on once we're connected
  Serial.println("");
  Serial.print("Connected! IP address: ");
  Serial.println(WiFi.localIP());
}

void loop() {
  int state=0;
  int httpcode=0;
  if(WiFi.status()==WL_CONNECTED){
    digitalWrite(STATUS_LED,LOW);
  }else{
    digitalWrite(STATUS_LED,HIGH);  //status LED off if disconnected
  }
  if(digitalRead(RED_BUTTON)==0){   //initiate command
    analogWrite(RED_LIGHT,LED_OFF); //LEDs off until we get feedback
    analogWrite(GREEN_LIGHT,LED_OFF);
    status=STATUS_UNKNOWN;
    state=http.begin(client,redURL);
    Serial.printf("Requesting %s\r\n",redURL);
    if(state){
      httpcode=http.GET();
      Serial.printf("HTTP code %d received.\r\n",httpcode);
      if(httpcode==HTTP_CODE_OK){
        Serial.println("Command done.");
        status=STATUS_RED;      //status set
        analogWrite(RED_LIGHT,LED_ON); //LED on
        delay(200); //debouncing
      }
    }else{
      Serial.println("Cannot connect to server.");
    }
  }
  if(digitalRead(GREEN_BUTTON)==0){   //initiate command
    analogWrite(RED_LIGHT,LED_OFF); //LEDs off until we get feedback
    analogWrite(GREEN_LIGHT,LED_OFF);
    status=STATUS_UNKNOWN;
    state=http.begin(client,greenURL);
    Serial.printf("Requesting %s\r\n",greenURL);
    if(state){
      httpcode=http.GET();
      Serial.printf("HTTP code %d received.\r\n",httpcode);
      if(httpcode==HTTP_CODE_OK){
        Serial.println("Command done.");
        status=STATUS_GREEN;      //status set
        analogWrite(GREEN_LIGHT,LED_ON); //LED on
        delay(200); //debouncing
      }
    }else{
      Serial.println("Cannot connect to server.");
    }
  }
  switch(status){
    case STATUS_UNKNOWN:
      analogWrite(RED_LIGHT,LED_DIM);
      analogWrite(GREEN_LIGHT,LED_DIM);
      break;
    case STATUS_RED:
      analogWrite(RED_LIGHT,LED_ON);
      analogWrite(GREEN_LIGHT,LED_DIM);
      break;
    case STATUS_GREEN:
      analogWrite(RED_LIGHT,LED_DIM);
      analogWrite(GREEN_LIGHT,LED_ON);
      break;
  }
  delay(50);
}
