/*
  SerialPassthrough sketch for the Arduino Mega/2560

  Arduino UNO modules only have a single hardware UART capable of
  performing serial data communication at 115,200 baud, using digital I/O
  pins 0 (Rx) and 1 (Tx). This port is normally connected to the board's
  USB-serial interface, used for uploading sketches to the UNO and also
  for communicating with the PC via the IDE's Serial Monitor. Any other
  serial ports which may be needed by a sketch to communicate with
  peripherals must be 'software serial' ports created using functions in
  the 'SoftwareSerial' library built into the Arduino IDE.
  
  This is fine for many applications, but a limitation of the SoftwareSerial
  library functions is that they can only operate at rates up to 38,400 baud.
  As a result it is not possible to achieve "serial passthrough" functionality
  with a UNO at speeds greater than 38,400 baud. Which poses a problem if you
  want to interact with devices/shields that come preprogrammed to communicate
  via a serial interface at a speed of 115,200 baud. An example of such a
  device is current versions of the ESP-01 Wi-Fi module (using the ESP8266 SOC),
  which come pre-programmed for operation at a speed of 115,200 baud.
  
  As a result, it is easier to interact with these modules using an Arduino
  Mega/2560 or clone, rather than a UNO. That's because the ATMega CPUs have
  a total of four hardware UARTs, three more than the UNO.
 
  This sketch allows you to achieve serial passthrough behaviour at 115,200
  baud by taking advantage of the additional hardware UARTs in a Mega CPU.
  Any text you type in the IDE Serial monitor will be written out to the
  Serial1 port on Digital I/O pins 19 and 18, and vice-versa. However you can
  easily change the sketch to use the Serial2 port (I/O pins 17 & 16) or the
  Serial3 port (I/O pins 15 & 14) instead of Serial1, simply by changing the
  'Serial1' in lines 42, 49, 51 and 53 below. You can also change the data rate
  from 115,200 baud by changing the rate in brackets in lines 41 and 42.
  
  Adapted 20 November 2017 by Jim Rowe from a sketch by Erik Nyquist created
  on 23 May 2016.
*/

void setup()
{
  Serial.begin(115200);
  Serial1.begin(115200);
}

void loop()
{
  if (Serial.available())
  {                                 // If anything comes in Serial (USB),
    Serial1.write(Serial.read());   // read it and send it out Serial1 (pins 19 & 18)
  }
  if (Serial1.available())
  {                                 // If anything comes in Serial1 (pins 19 & 18)
    Serial.write(Serial1.read());   // read it and send it out Serial (USB)
  }
}
