#include <NTPClient.h>
#include <Time.h>
#include <TimeLib.h>
#include <Preferences.h>  //For reading and writing into the ROM memory
Preferences preferences;
unsigned int counter;
//#include <ESP8266WiFi.h>   //for ESP8266
#include <WiFi.h> //    //For ESP32
#include <WiFiUdp.h>
#include <Adafruit_GFX.h>
#include <Adafruit_SSD1306.h>

#define OLED_RESET 4
Adafruit_SSD1306 display(OLED_RESET);

#if (SSD1306_LCDHEIGHT != 32)
#error("Height incorrect, please fix Adafruit_SSD1306.h!");
#endif

const char *ssid     = "bera";
const char *password = "**********";

const char *ssid1     = "beramobile";
const char *password1 = "**********";


WiFiUDP ntpUDP;
NTPClient timeClient(ntpUDP);
int i=0;
void setup(){
  Serial.begin(115200);
  display.begin(SSD1306_SWITCHCAPVCC, 0x3C);
//  WiFi.begin(ssid, password);
  preferences.begin("my-app", false);
  
counter = preferences.getUInt("counter", 1);
Serial.printf("Current counter value: %u\n", counter);


display.setTextSize(1);
display.setTextColor(WHITE);
display.setCursor(0,0);
display.print("Connecting...");
display.println(counter);
display.display();


if(counter==1)   WiFi.begin(ssid, password);
if(counter==2)   WiFi.begin(ssid1, password1);

  while ( WiFi.status() != WL_CONNECTED ) {
    delay ( 500 );
    i=i+1;
    Serial.print ( i );
    if(i>40){ 
if(counter==1)   preferences.putUInt("counter", 2);
if(counter==2)   preferences.putUInt("counter", 1);
preferences.end();    
esp_restart();     //Restart ESP it does not get connected for long

//ESP.deepSleep(1*1000000,WAKE_RF_DEFAULT);  //ESP8266 wakes up after 1 seceond sleep;

    
    }
     }
  timeClient.begin();
  display.clearDisplay();
  
}

String dow[7]  = {"Sun","Mon","Tue","Wed","Thu","Fri","Sat"};  // Sunday is dayOfWeek 0
String moy[12] = {"Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"}; // January is month 0

void printDigits(int digits){
  if(digits < 10)
    display.print('0');
  display.print(digits);
}

void loop() {
  timeClient.update();
String st1=timeClient.getFormattedTime();
//Serial.print("Time string value:");
//Serial.println(st1);

setTime(timeClient.getEpochTime()+5.5*3600);  //Add 5 hrs 30 minutes to IST
time_t t = now(); //Set the time;


/*
Serial.println(timeClient.getFormattedTime());
Serial.println(st1);
Serial.println(timeClient.getEpochTime()+5.5*3600);
Serial.println(weekday(t));
Serial.print(hour(t));
Serial.print(":");
Serial.print(minute(t));
Serial.print(":");
Serial.println(second(t));
Serial.print(day(t));
Serial.print(month(t));
Serial.println(year(t));
*/

display.clearDisplay();
display.setTextSize(3);
display.setTextColor(WHITE);
display.setCursor(0,0);

printDigits(hour(t));
display.print(":");
printDigits(minute(t));
display.setTextSize(2);
display.setTextColor(WHITE);
display.setCursor(95,0);
printDigits(second(t));

display.setTextSize(2);
display.setTextColor(WHITE);
display.setCursor(90,18);
display.println(dow[weekday(t)-1]);

display.setTextSize(1);
display.setTextColor(WHITE);
display.setCursor(5,25);
display.print(day(t));
display.print(" ");
display.print(moy[month(t)-1]);
display.print(" ");
display.print(year(t));
display.display();
delay(1000);
}


