
#include <OneWire.h>
#include <DallasTemperature.h>
#include <RealTimeClockDS1307.h>
#include <Wire.h>
#include <Adafruit_MLX90614.h>

#define ONE_WIRE_BUS 7
OneWire oneWire(ONE_WIRE_BUS);
DallasTemperature sensors(&oneWire);

#include <Adafruit_GFX.h>
#include <Adafruit_SSD1306.h>
#define OLED_RESET 4
Adafruit_SSD1306 display(OLED_RESET);

Adafruit_MLX90614 mymlx = Adafruit_MLX90614();

#include <Wire.h>     // for I2C
#include <SPI.h> 
#include <SdFat.h>


const uint8_t chipSelect = SS;
const uint32_t SAMPLE_INTERVAL_MS = 200;
#define FILE_BASE_NAME "Data"
SdFat sd;
SdFile file;
uint32_t logTime;

String dataString = "";
char tm[10],dt[10];

int i=0;
int j=0;

float rps;
float temp,rpm,arpm;
volatile byte pulses;
unsigned long timeold;

float s;

//this subprogram will run when interrupt is triggered
void counter(){
  pulses++; //every time this subprogram runs, the number of pulses is increased by 1 
  s=s+6.18; //and the variable s is increased by 20.42cm, which is the circumference of my wheel, s stands for path
}
// Error messages stored in flash.
#define error(msg) sd.errorHalt(F(msg))
int switchpin=A0;
int switchval=0;
String fl="";
int flt;

#define AVG_NUM 5


void setup() {
  Serial.begin(9600);

  RTC.readClock();
 
    pinMode(switchpin, INPUT);
    digitalWrite(switchpin,1);
    
    attachInterrupt(0,counter,RISING);  //attaching the interrupt and declaring the variables, one of the interrupt pins on Nano is D2, and has to be declared as 0 here
    pulses=0;
    rps=0;
    rpm=0;
    timeold=0;
    s=0;  
display.begin(SSD1306_SWITCHCAPVCC, 0x3C);  // initialize with the I2C addr 0x3D (for the 128x64)
display.display();

const uint8_t BASE_NAME_SIZE = sizeof(FILE_BASE_NAME) - 1;
char fileName[13] = FILE_BASE_NAME "00.csv";

 if (!sd.begin(chipSelect, SPI_HALF_SPEED)) sd.initErrorHalt();
  
 // Find an unused file name.
  if (BASE_NAME_SIZE > 6) error("FILE_BASE_NAME too long");
  
  while (sd.exists(fileName)) {
    if (fileName[BASE_NAME_SIZE + 1] != '9') {
      fileName[BASE_NAME_SIZE + 1]++;
    } else if (fileName[BASE_NAME_SIZE] != '9') {
      fileName[BASE_NAME_SIZE + 1] = '0';
      fileName[BASE_NAME_SIZE]++;
    } else {
      error("Can't create file name");
    }
  }
  if (!file.open(fileName, O_CREAT | O_WRITE | O_EXCL)) {
    error("file.open");
  }

 sprintf(dt, "%02d/%02d/%02d",
 RTC.getDay(),RTC.getMonth(),RTC.getYear()); 

  mymlx.begin();

  writeHeader();
  
  Serial.println(dt);
  Serial.println("SD Card initialized.");
  Serial.print(F("Logging to: "));
  Serial.println(fileName);
  Serial.println(F("Press Switch to stop"));
//  fl=String(fileName);
//  fl=fl.substring(4,6);
}

int read_rpm(){
int sum = 0;
int sample ;
//digitalWrite(pwr,0);
  for (int i=0; i<AVG_NUM; i++)   { 
if (pulses>=1) { //this part of the code calculates the rpm and rps in a way that every time the magnet passes by the sensor, the time between the pulses is measured and rpm and rps is calculated
    detachInterrupt(0);
    rpm = 60000.0/(millis()-timeold)*pulses;
    rps=rpm/60.0;
    timeold = millis();
    pulses=0;
    attachInterrupt(0,counter,RISING);  //RISING
}
    sample = rpm;
    sum += sample;      
  }
  return(sum / AVG_NUM);
} 




void loop() {
RTC.readClock();
sensors.begin();
sensors.requestTemperatures(); // Send the command to get temperatures
temp=sensors.getTempCByIndex(0); 


sprintf(tm, "%02d:%02d:%02d",
RTC.getHours(),RTC.getMinutes(),RTC.getSeconds());
sprintf(dt, "%02d/%02d/%02d",
RTC.getDay(),RTC.getMonth(),RTC.getYear()); 

display.clearDisplay();
display.setTextSize(1);
display.setTextColor(1);
display.setCursor(0,0);

  
 if (pulses>=1) { //this part of the code calculates the rpm and rps in a way that every time the magnet passes by the sensor, the time between the pulses is measured and rpm and rps is calculated
 arpm = read_rpm();
    
logData();
// Force data to SD,update the directory entry to avoid data loss.
  if (!file.sync() || file.getWriteError()) {
    error("write error");
  }    

  switchval=digitalRead(switchpin);
  if(switchval==0)  {
    Serial.println(switchval);
    file.close();
    Serial.println(F("Done"));
display.clearDisplay();    
display.setTextSize(2);
//display.setCursor(0,0); 
display.println(tm);
display.println("Data end");

display.display();    
    while(1) {}
  }


Serial.print(dt);
Serial.print("::");
Serial.print(tm);
Serial.print(",");
Serial.print(temp);
Serial.print(",");
Serial.println(arpm,0);

display.print(tm);
display.print("  Temp:");
display.println(temp,2);
display.setTextSize(3);
display.setCursor(0,10); 
display.print(arpm,0);
display.setTextSize(1);
display.println(dt);
display.display();    

delay(100);
  }
  
else {
display.print(tm);
display.print("  Temp:");
display.println(temp,2);
display.setTextSize(3);
display.setCursor(0,10); 
display.print("NIL");
display.setTextSize(1);
display.println(dt);
display.display();    

}





}

void writeHeader() {
    file.print(F("Date of Creation:"));
    file.println(dt);
    file.print(F("Time   "));
    file.print(F("Temperature "));
    file.print(F("RPM "));
    file.println();
}


// Log a data record.
void logData() {
file.print(tm);
file.print("  ");
file.print(temp,2);
file.print(" ");
file.print(mymlx.readAmbientTempC());
file.print(" ");
file.print(mymlx.readObjectTempC());
file.print(" ");
file.println(arpm,0);
 }





