/*  sketch_to_check_nRF24L01_modules.ino
    with an Arduino Uno or equivalent
    Based on 'Getting Started' example by TMRh20.
    Written by Jim Rowe (Silicon Chip)
    Last updated 18/04/2017 at 10:15 am

    Note that the sketch makes use of TMRh20's excellent
    RF24 library to communicate with the nRF24L01 chip,
    and for use with an Arduino Uno the library expects
    the chip's CE and CSN pins to be connected to pins IO7
    and IO8 respectively. These pins may well need to be
    changed for other Arduinos.
*/

#include <SPI.h>
#include <nRF24L01.h>
#include <printf.h>
#include <RF24.h>
#include <RF24_config.h>

bool radioNumber = 0;   // set this radio as number 1 or 0
RF24 radio(7,8);  // set up nRF24L01 on SPI bus plus pins 7 & 8
                  // (CE to pin IO7, CSN to pin IO8)

byte addresses[][6] = {"1Node","2Node"};
bool role = 0;  // used to control whether this node is sending
                // or receiving (0 = receiving, 1 = sending)
                
void setup()
{
  Serial.begin(115200); // open serial line to PC (Serial Monitor)
  Serial.println(F("RF24 Getting Started example"));
  Serial.println(F("*** PRESS 'T' to begin transmitting to the other node"));

  radio.begin();

  radio.setPALevel(RF24_PA_LOW);  // set this module's power level to LOW

  // now open a writing and reading pipe on each radio, with opposite addresses
  if(radioNumber)
  {
    radio.openWritingPipe(addresses[1]);
    radio.openReadingPipe(1,addresses[0]);
  }
  else
  {
    radio.openWritingPipe(addresses[0]);
    radio.openReadingPipe(1,addresses[1]);
  }
  radio.startListening();   // start the radio listening for data
}

void loop()
{
  if(role == 1)   // if we are in sending mode
  {
    radio.stopListening();  // stop listening so we can talk
    Serial.println(F("Now sending"));  // tell user we're sending
    unsigned long start_time = micros();  // take the time and send it
    if(!radio.write( &start_time, sizeof(unsigned long)))
    {
      Serial.println(F("failed"));
    }
    radio.startListening();   //now continue listening
    unsigned long startedWaitingAt = micros();  // set up a timeout period
    boolean timeout = false;  // set up a variable to indicate if a response

    while (!radio.available() ) // while nothing is received
    {
      if(micros() - startedWaitingAt > 200000)  // if waited longer than 200ms
      {
        timeout = true; // indicate timeout and exit while loop
        break;
      }
    }
    if( timeout)    // if there was a timeout
    {
      Serial.println(F("Failed, response timed out."));
    }
    else            // but if there was no timeout
    {
      unsigned long got_time;
      radio.read( &got_time, sizeof(unsigned long));  // grab response and process it
      unsigned long end_time = micros();
      // show the results
      Serial.print(F("Sent "));
      Serial.print(start_time);
      Serial.print(F(", Got response "));
      Serial.print(got_time);
      Serial.print(F(", Round-trip delay "));
      Serial.print(end_time - start_time);
      Serial.println(F(" microseconds"));
    }
    // try again one second later
    delay(1000);
  }
  
 if(role == 0)    // if we are in listening mode
  {
    unsigned long got_time;   // variable for the received time stamp
    if(radio.available())     // while there is data ready
    {
      while (radio.available())
      {
        radio.read( &got_time, sizeof(unsigned long));  // get the payload
      }
      radio.stopListening();  // then stop listening so we can talk
      radio.write( &got_time, sizeof(unsigned long));   // send the final one back(?)
      radio.startListening(); // then resume listening for the next packet
      Serial.print(F("sent response "));
      Serial.println(got_time);
    }
  }
  if(Serial.available())
  {
    char c = toupper(Serial.read());  // get char from serial monitor, change to upper case
    if( c == 'T' && role == 0)
    {
      Serial.println(F("*** CHANGING TO TRANSMIT ROLE -- PRESS 'R' TO SWITCH BACK"));
      role = 1;   // and change to send role
    }
    else if (c == 'R' && role == 1)
    {
        Serial.println(F("*** CHANGING TO RECEIVE ROLE -- PRESS 'T' TO SWITCH BACK"));
        role = 0;   // change to receive role
        radio.startListening();
    }
  }
}   // end of main loop

