'                    CHESS CLOCK  (chess_clock_20m2.bas)

'********************** SET-UP AND SAVE MOVE TIME ********************

power_up:' -------- initialize the microprocessor, sound a startup beep 
setfreq m16
let dirsB = %11111111: let pinsB = %00000000
let dirsC = %00110011: let pinsC = %00000000
pullup %1100110000000000
if pinC.6 = 0 then gosub move_time
read 2,b0: if b0 = 0 then: write 2,2: endif
sound C.5,(60,20)
goto re_start

move_time:' ------- holding reset button at power_up sets the move time   
for b0 = 0 to 100
on b1 gosub zero1'(units display)
on b2 gosub zero2,one2,two2,three2,four2,five2,six2,seven2,eight2,nine2'(tens display) 
next b0
if pinC.6 = 1 then:write 1,b1: write 2,b2: return: endif  
inc b2
if b2=> 10 then: b2 = 0:endif
pulsout C.5,1000' (clock tick)
goto move_time 


'*********************** MAIN CHESS CLOCK PROGRAM **********************

re_start:'----------- load saved move time and clear the seconds counter 
b5 =0: b6 = 0: b7 = 0: low C.4
read 1,b1: read 2,b2
let w5 = 0: time = 0
'goto show_count

show_count:'--------- show the current count on the seven segment displays
on b1 gosub zero1,one1,two1,three1,four1,five1,six1,seven1,eight1,nine1' (units)
on b2 gosub zero2,one2,two2,three2,four2,five2,six2,seven2,eight2,nine2' (tens)
'goto next_move

next_move:' --------- program selects the next move based on these options
if pinC.6 = 0 then: goto pb_check: endif' (reset) 
if pinC.2 = 0 or pinC.3 = 0 then goto start_stop
if b6 = 20 and b7 = 0 then goto re_start
if b7 = 20 then goto show_count
if b7 = 10 then:goto alarm_tone:endif
if b6 = 10 then goto time_check
goto show_count

pb_check:' --------- check reset button is released then beep and restart
pause 10
if pinC.6 = 0 then pb_check
sound C.5,(60,20): pinC.4=0: goto re_start' (reset)

alarm_tone:' ------- alarm tone is played when player's clock reaches zero
for b0 = 0 to 20
on b1 gosub zero1'(units)
on b2 gosub zero2'(tens) 
next b0
inc b5
if b5 > 3 then: b7 = 20: b5 = 0: sound C.5,(20,90,60,90,20,90,60,90):endif
goto show_count

start_stop:' ------- player buttons alternately start and stop the clocks
if pinC.2 = 0 then: b6 = 10: w5 = 0: time = 0: high C.4: endif' (start)
if pinC.3 = 0 then: b6 = 20: w5 = 0: time = 0: low C.4: endif' (stop)
goto show_count

time_check:' ------- check if the time on the seconds counter has changed
if b7 = 10 then goto show_count  
let w6 = time
if w6 > w5 then: goto clock_down: endif
goto show_count

clock_down:'-------- decrement the clock each second including clock ticks
let w5 = time
dec b1
if pinC.7 = 0 and b1 < 4 and b2 = 0 then: sound C.5,(60,20)' (clock beep)
else: pulsout C.5,1000: endif' (clock tick)
if b1 < 9 then goto check_zero' (units)  
b1 = 9
dec b2 
if b2 < 9 then goto check_zero' (tens)
b2 = 9
goto show_count

check_zero:'-------- if player's clock is at zero,change b7 from 0 to 10
if b1 = 0 and b2 = 0 then: b7 = 10: endif 
goto show_count


'************************* SEVEN SEGMENT TABLES **********************

'-------------- units_table ----------------
blank1:
let pinsB = %00000000: pulsout C.0,2000:return
zero1:
let pinsB = %00111111: pulsout C.0,2000:return   
one1:
let pinsB = %00000110: pulsout C.0,2000:return
two1:
let pinsB = %01011011: pulsout C.0,2000:return
three1:
let pinsB = %01001111: pulsout C.0,2000:return
four1:
let pinsB = %01100110: pulsout C.0,2000:return
five1:
let pinsB = %01101101: pulsout C.0,2000:return
six1:
let pinsB = %01111100: pulsout C.0,2000:return
seven1:
let pinsB = %00000111: pulsout C.0,2000:return
eight1:
let pinsB = %01111111  pulsout C.0,2000:return
nine1:
let pinsB = %01100111: pulsout C.0,2000:return


'-------------- tens_table -----------------
blank2:
let pinsB = %00000000: pulsout C.1,2000:return
zero2:
let pinsB = %00111111: pulsout C.1,2000:return   
one2:
let pinsB = %00000110: pulsout C.1,2000:return
two2:
let pinsB = %01011011: pulsout C.1,2000:return
three2:
let pinsB = %01001111: pulsout C.1,2000:return
four2:
let pinsB = %01100110: pulsout C.1,2000:return
five2:
let pinsB = %01101101: pulsout C.1,2000:return
six2:
let pinsB = %01111100: pulsout C.1,2000:return
seven2:
let pinsB = %00000111: pulsout C.1,2000:return
eight2:
let pinsB = %01111111  pulsout C.1,2000:return
nine2:
let pinsB = %01100111: pulsout C.1,2000:return


'************************** LIST OF VARIABLES *************************

'    w5 = time old
'    w6 = time new 
'    b0 = temp variable   
'    b1 = unit count(seconds)
'    b2 = tens count(seconds)
'    b5 = alarm control 
'    b6 = count control (0 wait),(10 start),(20 stop)
'    b7 = time control (0 run),(10 halt),(20 show)  `
