  CONST PIN_ANALOG_VH = 2
  CONST PIN_ANALOG_VPLUSH = 23
  CONST PIN_ANALOG_VL = 26
  CONST PIN_ANALOG_VMINUSL = 24
  CONST PIN_ANALOG_IPLUS = 6
  CONST PIN_ANALOG_IMINUS = 7
  CONST PIN_DOUT_SWPLUS = 9
  CONST PIN_DOUT_SWMINUS = 10
  CONST PIN_DOUT_BLPWM = 18
  CONST LCD_DUTY_SCALE = 0.75

  SETPIN PIN_ANALOG_VH, AIN
  SETPIN PIN_ANALOG_VPLUSH, AIN
  SETPIN PIN_ANALOG_VL, AIN
  SETPIN PIN_ANALOG_VMINUSL, AIN
  SETPIN PIN_ANALOG_IPLUS, AIN
  SETPIN PIN_ANALOG_IMINUS, AIN
  SETPIN PIN_DOUT_SWPLUS, DOUT
  PIN(PIN_DOUT_SWPLUS) = 1
  SETPIN PIN_DOUT_SWMINUS, DOUT
  PIN(PIN_DOUT_SWMINUS) = 0
  SETPIN PIN_DOUT_BLPWM, DOUT
  
  DIM VH, VPLUSH, VL, VMINUSL, IPLUS, IMINUS
  
  DIM INTEGER lcd_timeout_values(12)
  DIM INTEGER f1w, f1h, f8w, f8h, touch_delay, fuse_trip_linked = 0, keypad_visible = 0
  DIM STRING fuse_trip_speed LENGTH 6 = " Fast ", new_current_value LENGTH 6, start_up_mode LENGTH 4 = "Off"
  DIM INTEGER touch_timer, touch_x, touch_y, calibration_mode = -1, lcd_backlight = 50, lcd_timeout_index = 3, last_bl_sec, last_output_state
  DIM trip_current = 10.0
  DIM reading_scale(3), reading_offset(3)
  reading_scale(0) = 1
  reading_scale(1) = 1
  reading_scale(2) = 1
  reading_scale(3) = 1
  reading_offset(2) = -0.12
  reading_offset(3) = -0.12
  lcd_timeout_values(0) = 5
  lcd_timeout_values(1) = 10
  lcd_timeout_values(2) = 15
  lcd_timeout_values(3) = 30
  lcd_timeout_values(4) = 45
  lcd_timeout_values(5) = 60
  lcd_timeout_values(6) = 90
  lcd_timeout_values(7) = 120
  lcd_timeout_values(8) = 180
  lcd_timeout_values(9) = 300
  lcd_timeout_values(10) = 600
  lcd_timeout_values(11) = 900
  lcd_timeout_values(12) = 1800
  
  DIM INTEGER bargraph(3)
  DIM INTEGER freq, duty, pinsa, pinsb
  DIM INTEGER ADCResults(6), ADCCount, ADCInputs = &H1A31
  DIM INTEGER FuseParams(14)
  VAR RESTORE
  freq = 12000
  duty = lcd_backlight * LCD_DUTY_SCALE
  pinsa = 0
  pinsb = 512
  FuseParams(0) = 28125000000 \ (trip_current*800) \ (trip_current*800)
  IF fuse_trip_speed = " Fast " THEN
    FuseParams(1) = 15
    FuseParams(2) = 40
  ELSE IF fuse_trip_speed = " Slow " THEN
    FuseParams(1) = 1430
    FuseParams(2) = 3800
  ELSE
    FuseParams(1) = 143
    FuseParams(2) = 380
  ENDIF
  FuseParams(3) = fuse_trip_linked  
  FuseParams(11) = reading_scale(2) * 50000
  FuseParams(12) = reading_offset(2) * 1024000
  FuseParams(13) = reading_scale(3) * 50000
  FuseParams(14) = reading_offset(3) * 1024000
  
  DIM INTEGER porta_state, ignore, last_max_duty = 100
  ADCCount = SoftPWM(freq, duty, pinsa, pinsb, ADCInputs, ADCResults(), FuseParams())
  IF start_up_mode = "On" OR (start_up_mode = "Last" and (last_output_state = 1 OR last_output_state = 3)) THEN PIN(PIN_DOUT_SWPLUS) = 0 ' Q1 on
  IF start_up_mode = "On" OR (start_up_mode = "Last" and (last_output_state = 2 OR last_output_state = 3)) THEN PIN(PIN_DOUT_SWMINUS) = 1' Q3 on
  
SUB limit_maximum_bl_duty
  LOCAL INTEGER max_duty = (2500 / (VH - 5) - 63) / 2.79
  IF max_duty < last_max_duty THEN
    last_max_duty = last_max_duty
  ELSE IF max_duty > last_max_duty and last_max_duty < 100 THEN
    last_max_duty = last_max_duty + 1
  END IF
  IF duty > last_max_duty * LCD_DUTY_SCALE THEN duty = last_max_duty * LCD_DUTY_SCALE
END SUB
  
SUB update_bargraphs
  IF bargraph(0) > bargraph(2) THEN
    BOX bargraph(2) + f1w*3 + 1, 1, bargraph(0) - bargraph(2), 5, 1, RGB(RED), RGB(RED)
  ELSE IF bargraph(0) < bargraph(2) THEN
    BOX bargraph(0) + f1w*3 + 1, 1, bargraph(2) - bargraph(0), 5, 1, RGB(BLACK), RGB(BLACK)
  ENDIF
  bargraph(2) = bargraph(0)
  IF bargraph(1) > bargraph(3) THEN
    BOX bargraph(3) + f1w*3 + 1, MM.VRES-6, bargraph(1) - bargraph(3), 5, 1, RGB(RED), RGB(RED)
  ELSE IF bargraph(1) < bargraph(3) THEN
    BOX bargraph(1) + f1w*3 + 1, MM.VRES-6, bargraph(3) - bargraph(1), 5, 1, RGB(BLACK), RGB(BLACK)
  ENDIF
  bargraph(3) = bargraph(1)
END SUB
  
FUNCTION TIMESTR$(seconds%)
  IF seconds% <= 60 THEN
    TIMESTR$ = STR$(seconds%) + "s"
  ELSE IF seconds% MOD 60 > 0 THEN
    TIMESTR$ = STR$(seconds% \ 60) + "m" + STR$(seconds% MOD 60, 2, 0, "0") + "s"
  ELSE
    TIMESTR$ = STR$(seconds% \ 60) + "m"
  ENDIF
END FUNCTION
  
SUB update_main_screen
  LOCAL iplusa, iminusa, vlow
  WATCHDOG 500
  ignore = ReadOutputState(porta_state)
  iplusa = IPLUS * reading_scale(2) + reading_offset(2)
  IF iplusa < 0 OR (porta_state AND 4) = 4 THEN iplusa = 0
  iminusa = IMINUS * reading_scale(3) + reading_offset(3)
  IF iminusa < 0 OR (porta_state AND 8) = 0 THEN iminusa = 0
  vlow = VL * -1 * reading_scale(1) + reading_offset(1)
  IF vlow < 0 THEN vlow = 0
  TEXT 0, 8, "+" + VOLTAGE3$(VH * reading_scale(0) + reading_offset(0)), LT, 8, 1, RGB(WHITE), RGB(BLACK)
  TEXT 0, MM.VRES-8, "-" + VOLTAGE3$(vlow), LB, 8, 1, RGB(WHITE), RGB(BLACK)
  WATCHDOG 500
  TEXT MM.HRES, 8, " " + CURRENT3$(iplusa), RT, 8, 1, RGB(WHITE), RGB(BLACK)
  TEXT MM.HRES, MM.VRES-8, "-" + CURRENT3$(iminusa), RB, 8, 1, RGB(WHITE), RGB(BLACK)
  TEXT MM.HRES*3/4 - 6, MM.VRES/2 + f8h/2, fuse_trip_speed, CM, 8, 1, RGB(WHITE), RGB(BLACK)
  IF fuse_trip_linked THEN
    LINE MM.HRES-8, MM.VRES/2 - f1h / 2, MM.HRES-8, MM.VRES/2 + f1h / 2, 1, RGB(WHITE)
    BOX MM.HRES-7-f1w/2, MM.VRES/2 - f1h / 2, f1w/2-1, f1h, 1, RGB(BLACK), RGB(BLACK)
    BOX MM.HRES-7, MM.VRES/2 - f1h / 2, f1w/2-1, f1h, 1, RGB(BLACK), RGB(BLACK)
  ELSE
    TEXT MM.HRES-7, MM.VRES/2, "X", CM, 1, 1, RGB(WHITE)
  ENDIF
  IF keypad_visible = 0 THEN
    TEXT f8w * 3.6, f8h + 8, STR$(25 + FuseParams(4) / 1000000, 3, 1) + "`", CT, 1, 2, RGB(RED), RGB(BLACK)
    TEXT f8w * 3.6, MM.VRES-(f8h + 8), STR$(25 + FuseParams(5) / 1000000, 3, 1) + "`", CB, 1, 2, RGB(RED), RGB(BLACK)
  ENDIF
  
  IF (porta_state AND 4) = 0 THEN
    TEXT MM.HRES - f8w * 2.5, f8h + 8, " CONDUCTING ", CT, 1, 1, RGB(GREEN), RGB(BLACK)
  ELSE IF FuseParams(9) = 1 THEN
    TEXT MM.HRES - f8w * 2.5, f8h + 8, "TRIPPED (OC)", CT, 1, 1, RGB(RED), RGB(BLACK)
  ELSE IF FuseParams(9) = 2 THEN
    TEXT MM.HRES - f8w * 2.5, f8h + 8, "TRIPPED (OT)", CT, 1, 1, RGB(RED), RGB(BLACK)
  ELSE IF FuseParams(9) = 3 THEN
    TEXT MM.HRES - f8w * 2.5, f8h + 8, "TRIPPED (LI)", CT, 1, 1, RGB(RED), RGB(BLACK)
  ELSE IF FuseParams(9) = 4 THEN
    TEXT MM.HRES - f8w * 2.5, f8h + 8, "TRIPPED (UV)", CT, 1, 1, RGB(RED), RGB(BLACK)
  ELSE
    TEXT MM.HRES - f8w * 2.5, f8h + 8, "     OFF    ", CT, 1, 1, RGB(YELLOW), RGB(BLACK)
  ENDIF
  IF (porta_state AND 8) = 8 THEN
    TEXT MM.HRES - f8w * 2.5, MM.VRES-(f8h + 8), " CONDUCTING ", CB, 1, 1, RGB(GREEN), RGB(BLACK)
  ELSE IF FuseParams(10) = 1 THEN
    TEXT MM.HRES - f8w * 2.5, MM.VRES-(f8h + 8), "TRIPPED (OC)", CB, 1, 1, RGB(RED), RGB(BLACK)
  ELSE IF FuseParams(10) = 2 THEN
    TEXT MM.HRES - f8w * 2.5, MM.VRES-(f8h + 8), "TRIPPED (OT)", CB, 1, 1, RGB(RED), RGB(BLACK)
  ELSE IF FuseParams(10) = 3 THEN
    TEXT MM.HRES - f8w * 2.5, MM.VRES-(f8h + 8), "TRIPPED (LI)", CB, 1, 1, RGB(RED), RGB(BLACK)
  ELSE IF FuseParams(10) = 4 THEN
    TEXT MM.HRES - f8w * 2.5, MM.VRES-(f8h + 8), "TRIPPED (UV)", CB, 1, 1, RGB(RED), RGB(BLACK)
  ELSE
    TEXT MM.HRES - f8w * 2.5, MM.VRES-(f8h + 8), "     OFF    ", CB, 1, 1, RGB(YELLOW), RGB(BLACK)
  ENDIF
  WATCHDOG 500
END SUB
  
SUB hide_keypad
  FONT 1
  TEXT 0, MM.VRES/2 - f1h*3/2, "LCD B/L: " + STR$(lcd_backlight) + "%", LM, 1, 1,  RGB(WHITE)
  TEXT 0, MM.VRES/2 - f1h/2, "Timeout: " + TIMESTR$(lcd_timeout_values(lcd_timeout_index)), LM, 1, 1,  RGB(WHITE)
  TEXT 0, MM.VRES/2 + f1h/2, "Drawing: " + STR$(63 + 2.79 * lcd_backlight, 0, 0) + "mA", LM, 1, 1,  RGB(WHITE)
  IF start_up_mode = "Off" THEN
    TEXT 0, MM.VRES/2 + f1h*3/2, "Startup: outputs off", LM, 1, 1,  RGB(WHITE)
  ELSE IF start_up_mode = "On" THEN
    TEXT 0, MM.VRES/2 + f1h*3/2, "Startup: outputs on", LM, 1, 1,  RGB(WHITE)
  ELSE
    TEXT 0, MM.VRES/2 + f1h*3/2, "Startup: last state", LM, 1, 1,  RGB(WHITE)
  ENDIF
END SUB
  
SUB draw_keypad
  LOCAL INTEGER x, y, xpos, ypos
  LOCAL STRING key$ LENGTH 16 = "789b456m123mX0.A"
  xpos = 16
  ypos = 0
  BOX xpos, ypos + MM.VRES / 2 - 2 * 32, 32 * 4, 32 * 4, 1, RGB(BLACK), RGB(BLACK)
  WATCHDOG 500
  FOR y = 0 to 3
    FOR x = 0 to 3
      IF x = 3 and y > 0 and y < 3 THEN
        IF y = 1 THEN BOX xpos + x * 32, ypos + MM.VRES / 2 + (y - 2) * 32, 30, 30 + 32, 1, RGB(WHITE), RGB(BLUE)
        '      ELSE IF x < 2 and y = 3 THEN
        '        IF x = 0 THEN BOX xpos + x * 32, ypos + MM.VRES / 2 + (y - 2) * 32, 30 + 32, 30, 1, RGB(WHITE), RGB(BLUE)
      ELSE
        BOX xpos + x * 32, ypos + MM.VRES / 2 + (y - 2) * 32, 30, 30, 1, RGB(WHITE), RGB(BLUE)
      ENDIF
      IF x = 3 and y < 3 THEN
        IF y = 0 THEN
          LINE xpos + x * 32 + 4, ypos + MM.VRES / 2 + (y - 2) * 32 + 16 - 1, xpos + x * 32 + 30 - 4, ypos + MM.VRES / 2 + (y - 2) * 32 + 16 - 1, 2, RGB(WHITE)
          LINE xpos + x * 32 + 4 + 6, ypos + MM.VRES / 2 + (y - 2) * 32 + 16 - 1 - 6, xpos + x * 32 + 4, ypos + MM.VRES / 2 + (y - 2) * 32 + 16 - 1, 1, RGB(WHITE)
          LINE xpos + x * 32 + 4 + 6, ypos + MM.VRES / 2 + (y - 2) * 32 + 16 - 1 - 5, xpos + x * 32 + 4, ypos + MM.VRES / 2 + (y - 2) * 32 + 16, 1, RGB(WHITE)
          LINE xpos + x * 32 + 4 + 6, ypos + MM.VRES / 2 + (y - 2) * 32 + 16 - 1 + 6, xpos + x * 32 + 4, ypos + MM.VRES / 2 + (y - 2) * 32 + 16 - 1, 1, RGB(WHITE)
          LINE xpos + x * 32 + 4 + 6, ypos + MM.VRES / 2 + (y - 2) * 32 + 16 - 1 + 7, xpos + x * 32 + 4, ypos + MM.VRES / 2 + (y - 2) * 32 + 16, 1, RGB(WHITE)
        ELSE IF y = 1 THEN
          TEXT xpos + x * 32 + 16, ypos + MM.VRES / 2 + (y - 2) * 32 + 31, "m", CB, 1, 2, RGB(WHITE), RGB(BLUE)
          TEXT xpos + x * 32 + 15, ypos + MM.VRES / 2 + (y - 2) * 32 + 28, "A", CT, 1, 2, RGB(WHITE), RGB(BLUE)
        ENDIF
        '      ELSE IF x < 2 AND y = 3 THEN
        '        IF x = 0 THEN TEXT xpos + x * 32 + 32, ypos + MM.VRES / 2 + (y - 2) * 32 + 16 - 1, MID$(key$, y * 4 + x + 1, 1), CM, 1, 2, RGB(WHITE), RGB(BLUE)
      ELSE IF x = 2 and y = 3 THEN
        TEXT xpos + x * 32 + 16, ypos + MM.VRES / 2 + (y - 2) * 32 + 16 - 1, MID$(key$, y * 4 + x + 1, 1), CM, 1, 2, RGB(WHITE), RGB(BLUE)
      ELSE
        TEXT xpos + x * 32 + 16 - 1, ypos + MM.VRES / 2 + (y - 2) * 32 + 16 - 1, MID$(key$, y * 4 + x + 1, 1), CM, 1, 2, RGB(WHITE), RGB(BLUE)
      ENDIF
    NEXT x
  NEXT y
END SUB
  
SUB handle_keypad_press
  LOCAL INTEGER xpos = 16, ypos = MM.VRES / 2 - 2 * 32
  LOCAL INTEGER x, y
  LOCAL STRING key$ LENGTH 16 = "789b456m123mX0.A"
  x = (TOUCH(X) - xpos) \ 32
  y = (TOUCH(Y) - ypos) \ 32
  IF x >= 0 and x < 4 and y >= 0 and y < 4 THEN
    touch_delay = 5
    LOCAL STRING new_char LENGTH 1 = MID$(key$, 1 + y * 4 + x, 1)
    IF new_char = "b" THEN
      IF LEN(new_current_value) > 0 THEN
        new_current_value = LEFT$(new_current_value, LEN(new_current_value)-1)
        TEXT MM.HRES*3/4 - 6 + f8w*2.5, MM.VRES/2 - f8h/2, " " + new_current_value, RM, 8, 1, RGB(232,232,232), RGB(BLACK)
        LINE MM.HRES*3/4 - 6 + f8w*3/2, MM.VRES/2 - 3, MM.HRES*3/4 - 7 + f8w*5/2, MM.VRES/2 - 3, 2, RGB(WHITE)
      ENDIF
    ELSE IF new_char = "m" THEN
      IF VAL(new_current_value) >= 100 AND VAL(new_current_value) <= 25000 THEN
        trip_current = VAL(new_current_value) / 1000.0
        IF trip_current < 0.1 THEN trip_current = 0.1 ELSE IF trip_current > 25.0 THEN trip_current = 25.0
        VAR SAVE trip_current
        TEXT MM.HRES*3/4 - 6, MM.VRES/2 - f8h/2, CURRENT3$(trip_current), CM, 8, 1, RGB(WHITE), RGB(BLACK)
        
        BOX 0, f8h + 7, MM.HRES/2, MM.VRES-f8h*2-14, 1, RGB(BLACK), RGB(BLACK)
        hide_keypad
        keypad_visible = 0
      ENDIF
    ELSE IF new_char = "A" THEN
      IF VAL(new_current_value) >= 0.1 AND VAL(new_current_value) <= 25.0 THEN
        trip_current = VAL(new_current_value)
        IF trip_current < 0.1 THEN trip_current = 0.1 ELSE IF trip_current > 25.0 THEN trip_current = 25.0
        VAR SAVE trip_current
        TEXT MM.HRES*3/4 - 6, MM.VRES/2 - f8h/2, CURRENT3$(trip_current), CM, 8, 1, RGB(WHITE), RGB(BLACK)
        
        BOX 0, f8h + 7, MM.HRES/2, MM.VRES-f8h*2-14, 1, RGB(BLACK), RGB(BLACK)
        hide_keypad
        keypad_visible = 0
      ENDIF
    ELSE IF new_char = "X" THEN
      TEXT MM.HRES*3/4 - 6, MM.VRES/2 - f8h/2, CURRENT3$(trip_current), CM, 8, 1, RGB(WHITE), RGB(BLACK)
      LINE MM.HRES*3/4 - 6 + f8w*3/2, MM.VRES/2 - 3, MM.HRES*3/4 - 6 + f8w*5/2, MM.VRES/2 - 3, 2, RGB(BLACK)
      
      BOX 0, f8h + 7, MM.HRES/2, MM.VRES-f8h*2-14, 1, RGB(BLACK), RGB(BLACK)
      hide_keypad
      keypad_visible = 0
    ELSE IF LEN(new_current_value) < 5 THEN
      new_current_value = new_current_value + new_char
      IF VAL(new_current_value) > 0 THEN
        TEXT MM.HRES*3/4 - 6 + f8w*2.5, MM.VRES/2 - f8h/2, new_current_value, RM, 8, 1, RGB(232,232,232), RGB(BLACK)
      ELSE
        TEXT MM.HRES*3/4 - 6 + f8w*2.5, MM.VRES/2 - f8h/2, new_current_value, RM, 8, 1, RGB(232,0,0), RGB(BLACK)
      ENDIF
      LINE MM.HRES*3/4 - 6 + f8w*3/2, MM.VRES/2 - 3, MM.HRES*3/4 - 7 + f8w*5/2, MM.VRES/2 - 3, 2, RGB(WHITE)
    ENDIF
  ENDIF
END SUB
  
SUB draw_calibration_mode
  WATCHDOG 500
  CLS RGB(Black)
  FONT 1
  IF calibration_mode = 0 THEN
    TEXT MM.HRES/2, 0, "Raw VH reading", CT, 1, 2, RGB(YELLOW)
  ELSE IF calibration_mode = 1 THEN
    TEXT MM.HRES/2, 0, "Raw VL reading", CT, 1, 2, RGB(YELLOW)
  ELSE IF calibration_mode = 2 THEN
    TEXT MM.HRES/2, 0, "Raw IH reading", CT, 1, 2, RGB(YELLOW)
  ELSE
    TEXT MM.HRES/2, 0, "Raw IL reading", CT, 1, 2, RGB(YELLOW)
  ENDIF
  TEXT MM.HRES/2, f1h*5, "Adjusted reading", CT, 1, 2, RGB(YELLOW)
  BOX MM.HRES*1/16, MM.VRES*14/16, MM.HRES*6/16, MM.VRES/8, 1, RGB(WHITE), RGB(BLUE)
  BOX MM.HRES*9/16, MM.VRES*14/16, MM.HRES*6/16, MM.VRES/8, 1, RGB(WHITE), RGB(BLUE)
  TEXT MM.HRES*8/32, MM.VRES*15/16, "Cancel", CM, 1, 2, RGB(WHITE), RGB(BLUE)
  TEXT MM.HRES*24/32, MM.VRES*15/16, "Save", CM, 1, 2, RGB(WHITE), RGB(BLUE)
  BOX f1w/2, MM.VRES*5/8 - f1h-1, f1h*2, f1h*2+2, 1, RGB(WHITE), RGB(BLUE)
  BOX MM.HRES-f1w/2-f1h*2, MM.VRES*5/8 - f1h-1, f1h*2, f1h*2+2, 1, RGB(WHITE), RGB(BLUE)
  BOX f1w/2, MM.VRES*6/8 - f1h-1, f1h*2, f1h*2+2, 1, RGB(WHITE), RGB(BLUE)
  BOX MM.HRES-f1w/2-f1h*2, MM.VRES*6/8 - f1h-1, f1h*2, f1h*2+2, 1, RGB(WHITE), RGB(BLUE)
  TEXT f1w/2 + f1h, MM.VRES*5/8, "-", CM, 1, 2, RGB(WHITE), RGB(BLUE)
  TEXT MM.HRES - f1w/2 - f1h+1, MM.VRES*5/8, "+", CM, 1, 2, RGB(WHITE), RGB(BLUE)
  TEXT f1w/2 + f1h, MM.VRES*6/8, "-", CM, 1, 2, RGB(WHITE), RGB(BLUE)
  TEXT MM.HRES - f1w/2 - f1h+1, MM.VRES*6/8, "+", CM, 1, 2, RGB(WHITE), RGB(BLUE)
  WATCHDOG 500
END SUB
  
FUNCTION VOLTAGE3$(voltage)
  IF voltage < 9.95 and voltage > -9.95 THEN
    VOLTAGE3$ = STR$(voltage, 1, 2) + "V"
  ELSE
    VOLTAGE3$ = STR$(voltage, 2, 1) + "V"
  ENDIF
END FUNCTION
  
FUNCTION CURRENT3$(current)
  IF current < 9.95 THEN
    CURRENT3$ = STR$(current, 1, 2) + "A"
  ELSE
    CURRENT3$ = STR$(current, 2, 1) + "A"
  ENDIF
END FUNCTION
  
FUNCTION CURRENT4$(current)
  IF current < 9.995 THEN
    CURRENT4$ = STR$(current, 1, 3) + "A"
  ELSE
    CURRENT4$ = STR$(current, 2, 2) + "A"
  ENDIF
END FUNCTION
  
SUB update_calibration_mode
  WATCHDOG 500
  IF calibration_mode = 0 THEN
    TEXT MM.HRES/2, MM.VRES*1/8, STR$(VH, 2, 2) + "V", CT, 1, 2, RGB(WHITE)
    TEXT MM.HRES/2, MM.VRES*3/8, STR$(VH * reading_scale(0) + reading_offset(0), 2, 2) + "V", CT, 1, 2, RGB(WHITE)
  ELSE IF calibration_mode = 1 THEN
    TEXT MM.HRES/2, MM.VRES*1/8, STR$(VL, 2, 2) + "V", CT, 1, 2, RGB(WHITE)
    TEXT MM.HRES/2, MM.VRES*3/8, STR$(VL * reading_scale(1) + reading_offset(1), 2, 2) + "V", CT, 1, 2, RGB(WHITE)
  ELSE IF calibration_mode = 2 THEN
    TEXT MM.HRES/2, MM.VRES*1/8, STR$(IPLUS, 2, 2) + "A", CT, 1, 2, RGB(WHITE)
    TEXT MM.HRES/2, MM.VRES*3/8, STR$(IPLUS * reading_scale(2) + reading_offset(2), 2, 2) + "A", CT, 1, 2, RGB(WHITE)
  ELSE IF calibration_mode = 3 THEN
    TEXT MM.HRES/2, MM.VRES*1/8, STR$(IMINUS, 2, 2) + "A", CT, 1, 2, RGB(WHITE)
    TEXT MM.HRES/2, MM.VRES*3/8, STR$(IMINUS * reading_scale(3) + reading_offset(3), 2, 2) + "A", CT, 1, 2, RGB(WHITE)
  ENDIF
  TEXT MM.HRES/2, MM.VRES*5/8, " Scale :  " + STR$(reading_scale(calibration_mode), 1, 3) + " ", CM, 1, 2, RGB(WHITE)
  TEXT MM.HRES/2, MM.VRES*6/8, " Offset: " + STR$(reading_offset(calibration_mode), 1, 3) + " ", CM, 1, 2, RGB(WHITE)
  WATCHDOG 500
END SUB
  
SUB draw_main_screen
  WATCHDOG 500
  CLS RGB(Black)
  FONT 8
  TEXT 0, -3, "in+", LT, 1, 1, RGB(YELLOW)
  TEXT MM.HRES-f1w*4, -3, "out+", LT, 1, 1, RGB(YELLOW)
  BOX f1w*3, 0, MM.HRES-f1w*7-1, 7, 1, RGB(WHITE)
  TEXT 0, MM.VRES-f1h+2, "in-", LT, 1, 1, RGB(220,220,255)
  LINE 2, MM.VRES-1, 5, MM.VRES-1, 1, RGB(220,220,255)
  LINE 9, MM.VRES-1, 9, MM.VRES-2, 1, RGB(220,220,255)
  LINE 14, MM.VRES-1, 14, MM.VRES-2, 1, RGB(220,220,255)
  TEXT MM.HRES-f1w*4, MM.VRES-f1h+2, "out-", LT, 1, 1, RGB(220,220,255)
  LINE MM.HRES-f1w*4+3, MM.VRES-1, MM.HRES-f1w*4+5, MM.VRES-1, 1, RGB(220,220,255)
  LINE MM.HRES-f1w*3+2, MM.VRES-1, MM.HRES-f1w*3+4, MM.VRES-1, 1, RGB(220,220,255)
  LINE MM.HRES-f1w*3+6, MM.VRES-1, MM.HRES-f1w*3+6, MM.VRES-1, 1, RGB(220,220,255)
  LINE MM.HRES-f1w*2+3, MM.VRES-1, MM.HRES-f1w*2+5, MM.VRES-1, 1, RGB(220,220,255)
  BOX f1w*3, MM.VRES-7, MM.HRES-f1w*7-1, 7, 1, RGB(WHITE)
  '    BOX f1w*3+1, MM.VRES-6, MM.HRES*1/4, 5, 1, RGB(RED), RGB(RED)
  TEXT MM.HRES*3/4 - 6, MM.VRES/2 - f8h/2, CURRENT3$(trip_current), CM, 8, 1, RGB(WHITE), RGB(BLACK)
  LINE MM.HRES-8, f8h + 6, MM.HRES-8, MM.VRES - (MM.FONTHEIGHT + 6), 1, RGB(WHITE)
  WATCHDOG 500
  
  hide_keypad
  
  bargraph(2) = 0
  bargraph(3) = 0
  WATCHDOG 500
END SUB
  
FUNCTION HHMM$(seconds%)
  HHMM$ = STR$(seconds% \ 60, 2) + ":" + STR$(seconds% MOD 60, 2, 0, "0")
END FUNCTION
  
SUB draw_settings_screen
  LOCAL INTEGER xval, barw, old_lcd_backlight = lcd_backlight, old_lcd_timeout_index = lcd_timeout_index
  LOCAL STRING old_start_up_mode LENGTH 4 = start_up_mode
  
  WATCHDOG 500
  CLS RGB(Black)
  FONT 1
  TEXT MM.HRES/2, 0, "eFuse Settings", CT, 1, 2, RGB(WHITE)
  TEXT MM.HRES/2, MM.FONTHEIGHT*3, "LCD Backlight " + STR$(lcd_backlight, 3) + "%", CT, 1, 2, RGB(WHITE)
  BOX 0, MM.FONTHEIGHT*5, MM.HRES, MM.FONTHEIGHT*2, 1, RGB(WHITE)
  BOX 1, MM.FONTHEIGHT*5+1, (MM.HRES-2) * lcd_backlight / 100, MM.FONTHEIGHT*2-2, 1, RGB(220,220,220), RGB(220,220,220)
  TEXT MM.HRES/2, MM.FONTHEIGHT*7, "LCD Timeout  " + HHMM$(lcd_timeout_values(lcd_timeout_index)), CT, 1, 2, RGB(WHITE)
  BOX 0, MM.FONTHEIGHT*9, MM.HRES, MM.FONTHEIGHT*2, 1, RGB(WHITE)
  BOX 1, MM.FONTHEIGHT*9+1, (MM.HRES-2) * lcd_timeout_index / 12, MM.FONTHEIGHT*2-2, 1, RGB(240,240,240), RGB(240,240,240)
  TEXT MM.HRES/2, MM.FONTHEIGHT*11, "Start-up state", CT, 1, 2, RGB(WHITE)
  IF start_up_mode = "Off" THEN
    BOX MM.HRES*0.5/27, MM.FONTHEIGHT*13, MM.HRES*8/27, MM.FONTHEIGHT*2.5, 1, RGB(WHITE), RGB(YELLOW)
    TEXT MM.HRES*4.5/27, MM.FONTHEIGHT*14.25, "Off", CM, 1, 2, RGB(BLACK), RGB(YELLOW)
  ELSE
    BOX MM.HRES*0.5/27, MM.FONTHEIGHT*13, MM.HRES*8/27, MM.FONTHEIGHT*2.5, 1, RGB(WHITE), RGB(BLUE)
    TEXT MM.HRES*4.5/27, MM.FONTHEIGHT*14.25, "Off", CM, 1, 2, RGB(WHITE), RGB(BLUE)
  ENDIF
  IF start_up_mode = "On" THEN
    BOX MM.HRES*9.5/27, MM.FONTHEIGHT*13, MM.HRES*8/27, MM.FONTHEIGHT*2.5, 1, RGB(WHITE), RGB(YELLOW)
    TEXT MM.HRES*13.5/27, MM.FONTHEIGHT*14.25, "On", CM, 1, 2, RGB(BLACK), RGB(YELLOW)
  ELSE
    BOX MM.HRES*9.5/27, MM.FONTHEIGHT*13, MM.HRES*8/27, MM.FONTHEIGHT*2.5, 1, RGB(WHITE), RGB(BLUE)
    TEXT MM.HRES*13.5/27, MM.FONTHEIGHT*14.25, "On", CM, 1, 2, RGB(WHITE), RGB(BLUE)
  ENDIF
  IF start_up_mode = "Last" THEN
    BOX MM.HRES*18.5/27, MM.FONTHEIGHT*13, MM.HRES*8/27, MM.FONTHEIGHT*2.5, 1, RGB(WHITE), RGB(YELLOW)
    TEXT MM.HRES*22.5/27, MM.FONTHEIGHT*14.25, "Last", CM, 1, 2, RGB(BLACK), RGB(YELLOW)
  ELSE
    BOX MM.HRES*18.5/27, MM.FONTHEIGHT*13, MM.HRES*8/27, MM.FONTHEIGHT*2.5, 1, RGB(WHITE), RGB(BLUE)
    TEXT MM.HRES*22.5/27, MM.FONTHEIGHT*14.25, "Last", CM, 1, 2, RGB(WHITE), RGB(BLUE)
  ENDIF
  
  BOX MM.HRES*1/16, MM.VRES*14/16, MM.HRES*6/16, MM.VRES/8, 1, RGB(WHITE), RGB(BLUE)
  BOX MM.HRES*9/16, MM.VRES*14/16, MM.HRES*6/16, MM.VRES/8, 1, RGB(WHITE), RGB(BLUE)
  TEXT MM.HRES*8/32, MM.VRES*15/16, "Cancel", CM, 1, 2, RGB(WHITE), RGB(BLUE)
  TEXT MM.HRES*24/32, MM.VRES*15/16, "Save", CM, 1, 2, RGB(WHITE), RGB(BLUE)
  
  WHILE 1
    WATCHDOG 500
    IF TOUCH(Y) >= MM.FONTHEIGHT*5 AND TOUCH(Y) <= MM.FONTHEIGHT*7 THEN
      xval = TOUCH(X)
      IF xval > 0 THEN
        TEXT MM.HRES/2, MM.FONTHEIGHT*3, "LCD Backlight " + STR$(lcd_backlight, 3) + "%", CT, 1, 2, RGB(WHITE)
        barw = (MM.HRES-2) * lcd_backlight / 100
        BOX 1, MM.FONTHEIGHT*5+1, barw - 1, MM.FONTHEIGHT*2-2, 1, RGB(220,220,220), RGB(220,220,220)
        BOX 2 + barw, MM.FONTHEIGHT*5+1, MM.HRES - 3 - barw, MM.FONTHEIGHT*2-2, 1, RGB(BLACK), RGB(BLACK)
        lcd_backlight = xval * 100 / MM.HRES
        duty = lcd_backlight * LCD_DUTY_SCALE
      ENDIF
    ELSE IF TOUCH(Y) >= MM.FONTHEIGHT*9 AND TOUCH(Y) <= MM.FONTHEIGHT*11 THEN
      xval = TOUCH(X)
      IF xval > 0 THEN
        lcd_timeout_index = xval * 12 / MM.HRES
        TEXT MM.HRES/2, MM.FONTHEIGHT*7, "LCD Timeout  " + HHMM$(lcd_timeout_values(lcd_timeout_index)), CT, 1, 2, RGB(WHITE)
        barw = (MM.HRES-2) * lcd_timeout_index / 12
        BOX 1, MM.FONTHEIGHT*9+1, barw - 1, MM.FONTHEIGHT*2-2, 1, RGB(220,220,220), RGB(220,220,220)
        BOX 2 + barw, MM.FONTHEIGHT*9+1, MM.HRES - 3 - barw, MM.FONTHEIGHT*2-2, 1, RGB(BLACK), RGB(BLACK)
      ENDIF
    ELSE IF TOUCH(Y) >= MM.FONTHEIGHT*13 AND TOUCH(Y) <= MM.FONTHEIGHT*15.5 THEN
      xval = TOUCH(X)
      IF xval > 0 THEN
        IF xval < MM.HRES \ 3 THEN
          start_up_mode = "Off"
          BOX MM.HRES*0.5/27, MM.FONTHEIGHT*13, MM.HRES*8/27, MM.FONTHEIGHT*2.5, 1, RGB(WHITE), RGB(YELLOW)
          TEXT MM.HRES*4.5/27, MM.FONTHEIGHT*14.25, "Off", CM, 1, 2, RGB(BLACK), RGB(YELLOW)
        ELSE
          BOX MM.HRES*0.5/27, MM.FONTHEIGHT*13, MM.HRES*8/27, MM.FONTHEIGHT*2.5, 1, RGB(WHITE), RGB(BLUE)
          TEXT MM.HRES*4.5/27, MM.FONTHEIGHT*14.25, "Off", CM, 1, 2, RGB(WHITE), RGB(BLUE)
        ENDIF
        IF xval >= MM.HRES \ 3 AND xval < MM.HRES * 2 \ 3 THEN
          start_up_mode = "On"
          BOX MM.HRES*9.5/27, MM.FONTHEIGHT*13, MM.HRES*8/27, MM.FONTHEIGHT*2.5, 1, RGB(WHITE), RGB(YELLOW)
          TEXT MM.HRES*13.5/27, MM.FONTHEIGHT*14.25, "On", CM, 1, 2, RGB(BLACK), RGB(YELLOW)
        ELSE
          BOX MM.HRES*9.5/27, MM.FONTHEIGHT*13, MM.HRES*8/27, MM.FONTHEIGHT*2.5, 1, RGB(WHITE), RGB(BLUE)
          TEXT MM.HRES*13.5/27, MM.FONTHEIGHT*14.25, "On", CM, 1, 2, RGB(WHITE), RGB(BLUE)
        ENDIF
        IF xval >= MM.HRES * 2 \ 3 THEN
          start_up_mode = "Last"
          BOX MM.HRES*18.5/27, MM.FONTHEIGHT*13, MM.HRES*8/27, MM.FONTHEIGHT*2.5, 1, RGB(WHITE), RGB(YELLOW)
          TEXT MM.HRES*22.5/27, MM.FONTHEIGHT*14.25, "Last", CM, 1, 2, RGB(BLACK), RGB(YELLOW)
        ELSE
          BOX MM.HRES*18.5/27, MM.FONTHEIGHT*13, MM.HRES*8/27, MM.FONTHEIGHT*2.5, 1, RGB(WHITE), RGB(BLUE)
          TEXT MM.HRES*22.5/27, MM.FONTHEIGHT*14.25, "Last", CM, 1, 2, RGB(WHITE), RGB(BLUE)
        ENDIF
      ENDIF
    ELSE IF TOUCH(Y) >= MM.VRES*14/16 THEN
      IF TOUCH(X) > MM.HRES/2 THEN
        VAR SAVE lcd_backlight, lcd_timeout_index, start_up_mode, last_output_state
      ELSE
        lcd_backlight = old_lcd_backlight
        lcd_timeout_index = old_lcd_timeout_index
        start_up_mode = old_start_up_mode
        duty = lcd_backlight * LCD_DUTY_SCALE
        limit_maximum_bl_duty
        ADCCount = SoftPWM(freq, duty, pinsa, pinsb, ADCInputs, ADCResults(), FuseParams())
      ENDIF
      touch_delay = 10
      TIMER = 0
      RETURN
    ENDIF
    
    limit_maximum_bl_duty
    ADCCount = SoftPWM(freq, duty, pinsa, pinsb, ADCInputs, ADCResults(), FuseParams())
    WATCHDOG 500
    PAUSE 50
  WEND
END SUB
  
SUB draw_error_screen reason$
  LOCAL INTEGER OK
  
  CLS RGB(Black)
  WATCHDOG 500
  FONT 1
  BOX f1w*2, f1h, MM.HRES-f1w*4, f1h*8.5, 1, RGB(WHITE), RGB(RED)
  TEXT MM.HRES/2, f1h*1.5, "Operation Halted", CT, 1, 2, RGB(WHITE), RGB(RED)
  TEXT MM.HRES/2, f1h*4.5, "The unit has shut down because the", CT, 1, 1, RGB(WHITE), RGB(RED)
  IF reason$ = "VH" THEN
    TEXT MM.HRES/2, f1h*5.5, "VH rail voltage is too low", CT, 1, 1, RGB(WHITE), RGB(RED)
    TEXT MM.HRES/2, f1h*6.5, "for the unit to function. Operation", CT, 1, 1, RGB(WHITE), RGB(RED)
  ELSE IF reason$ = "V+H"
    TEXT MM.HRES/2, f1h*5.5, "V+H rail voltage is too low", CT, 1, 1, RGB(WHITE), RGB(RED)
    TEXT MM.HRES/2, f1h*6.5, "compared to the V+ rail. Operation", CT, 1, 1, RGB(WHITE), RGB(RED)
  ELSE IF reason$ = "V-L"
    TEXT MM.HRES/2, f1h*5.5, "V-L rail voltage is too low", CT, 1, 1, RGB(WHITE), RGB(RED)
    TEXT MM.HRES/2, f1h*6.5, "compared to the V- rail. Operation", CT, 1, 1, RGB(WHITE), RGB(RED)
  ENDIF
  TEXT MM.HRES/2, f1h*7.5, "will resume once it recovers.", CT, 1, 1, RGB(WHITE), RGB(RED)
  OK = 0
  WHILE OK = 0
    WATCHDOG 500
    ADCCount = SoftPWM(freq, duty, pinsa, pinsb, ADCInputs, ADCResults(), FuseParams())
    
    IF ADCCount > 0 THEN
      IPLUS = ADCResults(0) * 50 / 1023.0 / ADCCount
      IMINUS = ADCResults(1) * 50 / 1023.0 / ADCCount
      VH = ADCResults(2) * 33.0 / 1023.0 / ADCCount
      VPLUSH = ADCResults(3) * 46.2 / 1023.0 / ADCCount
      VL = ADCResults(4) * 33 / 1023.0 / ADCCount - 29.7
      VMINUSL = ADCResults(5) * 46.2 / 1023.0 / ADCCount - 42.9
    ENDIF

    OK = 1
    IF VH < 11 THEN
      TEXT 0, MM.VRES-f1h*8, "V+ :+" + STR$(VH, 2, 2) + "V", LT, 1, 2, RGB(RED)
      OK = 0
    ELSE
      TEXT 0, MM.VRES-f1h*8, "V+ :+" + STR$(VH, 2, 2) + "V", LT, 1, 2, RGB(WHITE)
    ENDIF
    IF VPLUSH - VH < 8 THEN
      TEXT 0, MM.VRES-f1h*6, "V+H:+" + STR$(VPLUSH, 2, 2) + "V  +" + STR$(VPLUSH - VH, 2, 2) + "V", LT, 1, 2, RGB(RED)
      OK = 0
    ELSE
      TEXT 0, MM.VRES-f1h*6, "V+H:+" + STR$(VPLUSH, 2, 2) + "V  +" + STR$(VPLUSH - VH, 2, 2) + "V", LT, 1, 2, RGB(WHITE)
    ENDIF
    TEXT 0, MM.VRES-f1h*4, "V- :" + STR$(VL, 3, 2) + "V", LT, 1, 2, RGB(WHITE)
    IF VL <= -12 AND VMINUSL - VL > -4.5 THEN
      TEXT 0, MM.VRES-f1h*2, "V-H:" + STR$(VMINUSL, 3, 2) + "V  " + STR$(VMINUSL - VL, 3, 2) + "V", LT, 1, 2, RGB(RED)
      OK = 0
    ELSE
      TEXT 0, MM.VRES-f1h*2, "V-L:" + STR$(VMINUSL, 3, 2) + "V  " + STR$(VMINUSL - VL, 3, 2) + "V", LT, 1, 2, RGB(WHITE)
    ENDIF
  WEND
  WATCHDOG 500
  PAUSE 250
  WATCHDOG 500
END SUB
  
  FONT 1
  f1w = MM.FONTWIDTH
  f1h = MM.FONTHEIGHT
  FONT 8
  f8w = MM.FONTWIDTH
  f8h = MM.FONTHEIGHT

  IF VH < 11 THEN
    draw_error_screen "VH"
  ELSE IF VPLUSH - VH < 8 THEN
    draw_error_screen "V-H"
  ELSE IF VL < -12 AND VMINUSL - VL > -4.5 THEN
    draw_error_screen "V-L"
  ENDIF
  draw_main_screen
  
  DIM TEMPSTR$ LENGTH 8
  TIMER = 0
  
  DIM INTEGER update_counter
  WHILE 1
    FuseParams(0) = 28125000000 \ (trip_current*800) \ (trip_current*800)
    IF fuse_trip_speed = " Fast " THEN
      FuseParams(1) = 15
      FuseParams(2) = 40
    ELSE IF fuse_trip_speed = " Slow " THEN
      FuseParams(1) = 1430
      FuseParams(2) = 3800
    ELSE
      FuseParams(1) = 143
      FuseParams(2) = 380
    ENDIF
    FuseParams(3) = fuse_trip_linked
    FuseParams(11) = reading_scale(2) * 50000
    FuseParams(12) = reading_offset(2) * 1024000
    FuseParams(13) = reading_scale(3) * 50000
    FuseParams(14) = reading_offset(3) * 1024000
    limit_maximum_bl_duty
    ADCCount = SoftPWM(freq, duty, pinsa, pinsb, ADCInputs, ADCResults(), FuseParams())
    
    IF ADCCount > 0 THEN
      IPLUS = ADCResults(0) * 50 / 1023.0 / ADCCount
      IMINUS = ADCResults(1) * 50 / 1023.0 / ADCCount
      VH = ADCResults(2) * 33.0 / 1023.0 / ADCCount
      VPLUSH = ADCResults(3) * 46.2 / 1023.0 / ADCCount
      VL = ADCResults(4) * 33 / 1023.0 / ADCCount - 29.7
      VMINUSL = ADCResults(5) * 46.2 / 1023.0 / ADCCount - 42.9
    ENDIF
    IF TOUCH(X) <> -1 THEN
      TIMER = 0
      IF duty = 0 THEN touch_delay = 10
      duty = lcd_backlight * LCD_DUTY_SCALE
      limit_maximum_bl_duty
    ELSE
      IF TIMER >= lcd_timeout_values(lcd_timeout_index) * 1000 THEN
        duty = 0
      ELSE
        IF TIMER \ 1000 <> last_bl_sec THEN
          last_bl_sec = TIMER \ 1000
          TEMPSTR$ = TIMESTR$(lcd_timeout_values(lcd_timeout_index) - last_bl_sec)
          IF keypad_visible = 0 and calibration_mode = -1 THEN TEXT f1w * 9, MM.VRES/2 - f1h/2, TIMESTR$(lcd_timeout_values(lcd_timeout_index)) + "(" + TEMPSTR$ + ")" + SPACE$(5 - LEN(TEMPSTR$)), LM, 1, 1,  RGB(WHITE)
        ENDIF
      ENDIF
    ENDIF
    
    IF calibration_mode > -1 THEN
      update_calibration_mode
    ELSE
      bargraph(0) = FuseParams(6) * (MM.HRES-f1w*7-3) / 75000000
      IF bargraph(0) > MM.HRES-f1w*7-3 THEN bargraph(0) = MM.HRES-f1w*7-3
      bargraph(1) = FuseParams(7) * (MM.HRES-f1w*7-3) / 75000000
      IF bargraph(1) > MM.HRES-f1w*7-3 THEN bargraph(1) = MM.HRES-f1w*7-3
      update_bargraphs
      WATCHDOG 500
      
      update_counter = update_counter + 1
      IF update_counter MOD 4 = 0 THEN update_main_screen
    ENDIF
    
    IF touch(x) = -1 or touch(x) < touch_x - 10 OR touch(x) > touch_x + 10 OR touch(y) < touch_y - 10 OR touch(y) > touch_y + 10 THEN
      touch_timer = 0
      touch_x = TOUCH(X)
      touch_y = TOUCH(Y)
    ELSE
      touch_timer = touch_timer + 1
    ENDIF
    
    IF touch_delay > 0 THEN
      touch_delay = touch_delay - 1
    ELSE IF duty > 0 THEN
      IF calibration_mode > -1 THEN
        IF TOUCH(y) > MM.VRES*4/8 THEN
          IF TOUCH(y) > MM.VRES*11/16 THEN
            IF TOUCH(y) > MM.VRES*14/16 THEN
              IF TOUCH(X) < MM.HRES/2 THEN
                reading_scale(calibration_mode) = 1
                reading_offset(calibration_mode) = 0
                VAR RESTORE
              ELSE
                VAR SAVE reading_scale(), reading_offset()
              ENDIF
              calibration_mode = -1
              draw_main_screen
            ELSE IF TOUCH(x) < MM.HRES/2 THEN
              reading_offset(calibration_mode) = reading_offset(calibration_mode) - 0.001
            ELSE
              reading_offset(calibration_mode) = reading_offset(calibration_mode) + 0.001
            ENDIF
          ELSE
            IF TOUCH(x) < MM.HRES/2 THEN
              reading_scale(calibration_mode) = reading_scale(calibration_mode) - 0.001
            ELSE
              reading_scale(calibration_mode) = reading_scale(calibration_mode) + 0.001
            ENDIF
          ENDIF
        ENDIF
      ELSE IF calibration_mode = -1 and touch_timer > 15 and touch(x) < MM.HRES/2 and touch(y) < MM.VRES/4 THEN
        calibration_mode = 0
        draw_calibration_mode
        touch_delay = 10
      ELSE IF calibration_mode = -1 and touch_timer > 15 and touch(x) < MM.HRES/2 and touch(y) > MM.VRES*3/4 THEN
        calibration_mode = 1
        draw_calibration_mode
        touch_delay = 10
      ELSE IF calibration_mode = -1 and touch_timer > 15 and touch(x) > MM.HRES/2 and touch(y) < MM.VRES/4 THEN
        calibration_mode = 2
        draw_calibration_mode
        touch_delay = 10
      ELSE IF calibration_mode = -1 and touch_timer > 15 and touch(x) > MM.HRES/2 and touch(y) > MM.VRES*3/4 THEN
        calibration_mode = 3
        draw_calibration_mode
        touch_delay = 10
      ELSE IF TOUCH(X) < MM.HRES/2 and TOUCH(Y) > f8h + 8 and TOUCH(Y) < MM.VRES - (f8h + 8) THEN
        IF keypad_visible THEN
          handle_keypad_press
        ELSE IF TOUCH(Y) > MM.VRES/3 AND TOUCH(Y) < MM.VRES*2/3 THEN
          draw_settings_screen
          draw_main_screen
        ENDIF
        touch_delay = 10
      ELSE IF TOUCH(X) > MM.HRES-16 AND TOUCH(Y) > f8h + 8 and TOUCH(Y) < MM.VRES - (f8h + 8) THEN
        fuse_trip_linked = 1 - fuse_trip_linked
        VAR SAVE fuse_trip_linked
        touch_delay = 10
      ELSE IF TOUCH(Y) > MM.VRES/2 - f8h AND TOUCH(y) < MM.VRES/2 THEN
        BOX 0, f8h + 10, MM.HRES/2, MM.VRES-f8h*2-20, 1, RGB(BLACK), RGB(BLACK)
        TEXT MM.HRES*3/4 - 6, MM.VRES/2 - f8h/2, "     ", CM, 8, 1, RGB(220,220,220), RGB(BLACK)
        LINE MM.HRES*3/4 - 6 + f8w*3/2, MM.VRES/2 - 3, MM.HRES*3/4 - 7 + f8w*5/2, MM.VRES/2 - 3, 2, RGB(WHITE)
        draw_keypad
        new_current_value = ""
        keypad_visible = 1
        touch_delay = 10
      ELSE IF TOUCH(Y) > MM.VRES/2 AND TOUCH(y) < MM.VRES/2 + f8h THEN
        IF TOUCH(x) > MM.HRES/2 THEN
          IF fuse_trip_speed = " Fast " THEN
            fuse_trip_speed = "Medium"
          ELSE IF fuse_trip_speed = "Medium" THEN
            fuse_trip_speed = " Slow "
          ELSE
            fuse_trip_speed = " Fast "
          ENDIF
          touch_delay = 10
        ENDIF
      ELSE IF TOUCH(Y) < f8h + 8 AND TOUCH(X) > MM.HRES/3 THEN
        touch_delay = 10
        ignore = ReadOutputState(porta_state)
        IF (porta_state AND 4) = 0 THEN ' Q1 is on
          PIN(9) = 1
          FuseParams(9) = 0
          IF last_output_state > 1 THEN last_output_state = 2 ELSE last_output_state = 0
          IF fuse_trip_linked AND (porta_state AND 8) = 8 THEN
            PIN(10) = 0
            last_output_state = 0
          ENDIF
          IF start_up_mode = "Last" THEN VAR SAVE last_output_state
        ELSE
          IF FuseParams(9) > 0 THEN
            IF fuse_trip_linked AND FuseParams(9) = 3 AND (porta_state AND 8) = 0 AND FuseParams(10) > 0 THEN FuseParams(10) = 0
            FuseParams(9) = 0
            IF last_output_state > 1 THEN last_output_state = 2 ELSE last_output_state = 0
            IF fuse_trip_linked AND (porta_state AND 8) = 0 AND FuseParams(10) = 3 THEN FuseParams(10) = 0
            IF start_up_mode = "Last" THEN VAR SAVE last_output_state
          ELSE
            PIN(9) = 0
            IF last_output_state > 1 THEN last_output_state = 3 ELSE last_output_state = 1
            IF fuse_trip_linked AND (porta_state AND 8) = 0 AND FuseParams(10) = 0 AND VL <= -10 THEN
              PIN(10) = 1
              last_output_state = 3
            ENDIF
            IF start_up_mode = "Last" THEN VAR SAVE last_output_state
          ENDIF
        ENDIF
      ELSE IF TOUCH(Y) > MM.VRES - (f8h + 8) AND TOUCH(X) > MM.HRES/3 THEN
        touch_delay = 10
        ignore = ReadOutputState(porta_state)
        IF (porta_state AND 8) = 8 THEN ' Q3 is on
          PIN(10) = 0
          FuseParams(10) = 0
          IF last_output_state = 1 or last_output_state = 3 THEN last_output_state = 1 ELSE last_output_state = 0
          IF fuse_trip_linked AND (porta_state AND 4) = 0 THEN
            PIN(9) = 1
            last_output_state = 0
          ENDIF
          IF start_up_mode = "Last" THEN VAR SAVE last_output_state
        ELSE
          IF FuseParams(10) > 0 THEN
            IF fuse_trip_linked AND FuseParams(10) = 3 AND (porta_state AND 4) = 4 AND FuseParams(9) > 0 THEN FuseParams(9) = 0
            FuseParams(10) = 0
`            IF last_output_state = 1 or last_output_state = 3 THEN last_output_state = 1 ELSE last_output_state = 0
            IF fuse_trip_linked AND (porta_state AND 4) = 4 AND FuseParams(9) = 3 THEN FuseParams(9) = 0
            IF start_up_mode = "Last" THEN VAR SAVE last_output_state
          ELSE IF VL <= -10 THEN
            PIN(10) = 1
            IF last_output_state = 1 or last_output_state = 3 THEN last_output_state = 3 ELSE last_output_state = 2
            IF fuse_trip_linked AND (porta_state AND 4) = 4 AND FuseParams(9) = 0 THEN
              PIN(9) = 0
              last_output_state = 3
            ENDIF
            IF start_up_mode = "Last" THEN VAR SAVE last_output_state
          ENDIF
        ENDIF
      ENDIF
    ENDIF
    WATCHDOG 500
  WEND
  
CFunction SoftPWM
    000002F5
    'lim0
    28820000 0002200B 03E00008 00801021 
    'Min
    0085102A 00A2200A 03E00008 00801021 
    'UpdateTemperatures
    27BDFFF0 AFB2000C AFB10008 AFB00004 3C02BF88 8C426030 30420004 5440000E 
    00006021 3C029D00 8C42008C 8C43006C 8C44005C 0064602A 008C180A 8C450044 
    8C420048 70651802 00626021 29820000 0002600B 000C6282 3C02BF88 8C426030 
    30420008 5040000E 00005821 3C029D00 8C42008C 8C430070 8C440060 0064582A 
    008B180A 8C45004C 8C420050 70651802 00625821 29620000 0002580B 000B5A82 
    3C029D00 8C43008C 8C64006C AC64005C 8C43008C 8C640070 AC640060 8C42008C 
    718C5002 716B4802 8C430078 00032080 00032900 00A42023 00047200 008E2021 
    00831823 00037100 01C31823 00037282 8C440074 00042940 00041B00 00A31821 
    00641821 000318C0 00031A82 01C37023 8C450024 240800C8 0148001B 010001F4 
    0000C812 25C3E2B4 24070003 0067001B 00E001F4 00002012 2418206C 03042023 
    3C030002 246622E0 00A6001A 00C001F4 00008012 261003E8 70902002 246386A0 
    0083001B 006001F4 00007812 732F7802 24040032 01E4001B 008001F4 00007812 
    8C4D0080 000D8080 000D8900 02308023 00108A00 02118021 020D6823 000D8100 
    020D6823 000D6A82 3410A794 020D6823 8C51007C 00119140 00118300 02508021 
    02118021 001080C0 00108282 01B06821 25AD8BFC 0128001B 010001F4 00004012 
    25B0E2B4 0207001B 00E001F4 00003812 0307C023 8C500028 0206001A 00C001F4 
    00003012 24C603E8 7306C002 0303001B 006001F4 00003012 71063002 00C4001B 
    008001F4 8C430018 0143502B 11400008 00003012 8C4A0014 732AC802 24040005 
    0324001B 008001F4 10000002 00005012 240AFFFF 0123482B 51200007 2408FFFF 
    8C430014 71034002 24040005 0104001B 008001F4 00004012 8C43002C 00A31823 
    240404B0 0064001A 008001F4 00001812 00A32823 AC450024 3C029D00 8C45008C 
    24030096 01E3001B 006001F4 00007812 8CA70024 00EF7821 ACAF0024 8C45008C 
    8CA70028 8CA9002C 00E94823 0124001A 008001F4 00002012 00E43823 ACA70028 
    8C45008C 00C3001B 006001F4 00001812 8CA60028 00C31821 ACA30028 8C44008C 
    8C83002C 3405A410 0065001A 00A001F4 00002812 00651823 AC83002C 8C42008C 
    8C440024 8C43002C 0064282A 50A0000A 3C029D00 00832023 3405FFFF 00852821 
    28860000 0086280A 00052C03 00A31821 AC43002C 3C029D00 8C42008C 8C440028 
    8C43002C 0064282A 50A0000A 3C029D00 00832023 3405FFFF 00852821 28860000 
    0086280A 00052C03 00A31821 AC43002C 3C029D00 8C42008C 8C430020 24040ED8 
    14640020 2404017C 8C440030 24030ED8 0083001A 006001F4 00002812 00852023 
    AC440030 3C049D00 8C85008C 24020596 0142001B 004001F4 00005012 8CA60030 
    00CA5021 ACAA0030 8C86008C 8CC50034 00A3001A 006001F4 00001812 00A32823 
    ACC50034 8C83008C 0102001B 004001F4 00004012 8C620034 00481021 1000003E 
    AC620034 1464001F 8C440030 2403017C 0083001A 006001F4 00002812 00852023 
    AC440030 3C049D00 8C85008C 2402008F 0142001B 004001F4 00005012 8CA60030 
    00CA5021 ACAA0030 8C86008C 8CC50034 00A3001A 006001F4 00001812 00A32823 
    ACC50034 8C83008C 0102001B 004001F4 00004012 8C620034 00481021 1000001E 
    AC620034 24030028 0083001A 006001F4 00002812 00852023 AC440030 3C049D00 
    8C85008C 2402000F 0142001B 004001F4 00005012 8CA60030 00CA5021 ACAA0030 
    8C86008C 8CC50034 00A3001A 006001F4 00001812 00A32823 ACC50034 8C83008C 
    0102001B 004001F4 00004012 8C620034 00484021 AC680034 3C02BF88 8C426030 
    30420004 14400063 3C02BF88 340284D0 0182602B 11800004 3C029D00 8C42008C 
    10000005 AC400054 8C42008C 8C430054 24630001 AC430054 3C029D00 8C42008C 
    8C440024 3C03080B 3463EFC1 0083182A 54600018 8C440030 24030004 3C02BF88 
    AC436038 3C029D00 8C43008C 24040002 AC64003C 8C42008C 8C420038 10400045 
    3C02BF88 8C426030 30420008 10400041 3C02BF88 24030008 3C02BF88 AC436034 
    3C029D00 8C42008C 24030003 10000038 AC430040 3C030478 246368C1 0083182A 
    10600006 24030004 8C420054 28420003 54400018 2DCE1964 24030004 3C02BF88 
    AC436038 3C029D00 8C43008C 24040001 AC64003C 8C42008C 8C420038 10400025 
    3C02BF88 8C426030 30420008 10400021 3C02BF88 24030008 3C02BF88 AC436034 
    3C029D00 8C42008C 24030003 10000018 AC430040 11C00017 3C02BF88 24030004 
    3C02BF88 AC436038 3C029D00 8C44008C AC83003C 8C42008C 8C420038 1040000D 
    3C02BF88 8C426030 30420008 10400009 3C02BF88 24030008 3C02BF88 AC436034 
    3C029D00 8C42008C 24030003 AC430040 3C02BF88 8C426030 30420008 10400060 
    340284D0 0162582B 11600004 3C029D00 8C42008C 10000005 AC400058 8C42008C 
    8C430058 24630001 AC430058 3C029D00 8C42008C 8C440028 3C03080B 3463EFC1 
    0083182A 54600018 8C440034 24030008 3C02BF88 AC436034 3C029D00 8C43008C 
    24040002 AC640040 8C42008C 8C420038 10400043 3C02BF88 8C426030 30420004 
    14400040 8FB2000C 24030004 3C02BF88 AC436038 3C029D00 8C42008C 24030003 
    10000037 AC43003C 3C030478 246368C1 0083182A 10600006 24030008 8C420058 
    28420003 54400018 2DAD05DC 24030008 3C02BF88 AC436034 3C029D00 8C43008C 
    24040001 AC640040 8C42008C 8C420038 10400023 3C02BF88 8C426030 30420004 
    14400020 8FB2000C 24030004 3C02BF88 AC436038 3C029D00 8C42008C 24030003 
    10000017 AC43003C 11A00015 24030008 3C02BF88 AC436034 3C029D00 8C43008C 
    24040004 AC640040 8C42008C 8C420038 1040000B 3C02BF88 8C426030 30420004 
    14400007 24030004 3C02BF88 AC436038 3C029D00 8C42008C 24030003 AC43003C 
    8FB2000C 8FB10008 8FB00004 03E00008 27BD0010 
    'T1Int
    27BDFFE8 AFBF0014 3C029D00 8C42008C 8C430008 14600018 3C03BF88 8C430000 
    18600015 3C03BF88 8C646030 8C42000C 00821025 AC626030 3C03BF88 8C656130 
    3C029D00 8C42008C 8C440010 00A42025 AC646130 8C440000 3C03BF80 AC640620 
    24030001 AC430008 3C02BF80 AC400610 100000B1 8FBF0014 8C646030 8C42000C 
    00021027 00441024 AC626030 3C03BF88 8C656130 3C029D00 8C42008C 8C440010 
    00042027 00852024 AC646130 8C440004 3C03BF80 AC640620 AC400008 3C02BF81 
    8C429000 30420001 1040009A 3C029D00 8C42008C 8C430064 30640001 50800009 
    3C029D00 3C04BF81 8C849070 00031843 2463001B 00031880 00621021 AC440000 
    3C029D00 8C43008C 8C620064 24420001 AC620064 2403000C 1443004F 3C029D00 
    8C43008C AC600064 8C43008C 8C640074 2484FE8C 00042143 8C65006C 00A42023 
    AC64006C 8C43008C 8C62006C 04410003 28420400 10000005 AC60006C 54400004 
    3C039D00 240203FF AC62006C 3C039D00 8C62008C 8C44007C 2405028B 00A42023 
    00042143 8C450070 00A42023 AC440070 8C63008C 8C620070 04410003 28420400 
    10000005 AC600070 14400004 3C029D00 240203FF AC620070 3C029D00 8C43008C 
    8C650084 8C64006C 00A42021 AC640084 8C43008C 8C650088 8C640070 00A42021 
    AC640088 8C43008C 8C65008C 8C640074 00A42021 AC64008C 8C43008C 8C650090 
    8C640078 00A42021 AC640090 8C43008C 8C650094 8C64007C 00A42021 AC640094 
    8C43008C 8C650098 8C640080 00A42021 AC640098 8C42008C 8C430068 24630001 
    AC430068 0411FD59 00000000 3C02BF80 AC400610 3C029D00 8C42008C 8C420064 
    00021043 24030002 1043001B 28430003 10600008 24030004 1040000F 3C030004 
    24030001 54430024 3C02BF81 1000000E 3C030005 10430018 28430004 14600012 
    3C03000C 24030005 1443001B 3C02BF81 10000016 3C03000B 3C02BF81 AC439040 
    10000015 3C02BF81 3C02BF81 AC439040 10000011 3C02BF81 3C02BF81 AC409040 
    1000000D 3C02BF81 3C02BF81 AC439040 10000009 3C02BF81 3C030009 3C02BF81 
    AC439040 10000004 3C02BF81 3C02BF81 AC439040 3C02BF81 8C439000 7C030004 
    AC439000 8C439000 24040001 7C830844 AC439000 8FBF0014 03E00008 27BD0018 
    'getFPC
    27BDFFF8 AFBF0004 00852023 03E42021 ACC40000 8FBF0004 03E00008 27BD0008 
    'main
    27BDFFC0 AFBF003C AFB70038 AFB60034 AFB50030 AFB4002C AFB30028 AFB20024 
    AFB10020 AFB0001C 00808821 00A08021 8FB20054 8C830000 8C840004 00641825 
    1060016A 8FA20058 24040010 3C03BF88 AC641064 3C03BF88 AC601068 3C039D00 
    8C64008C 8CC50000 AC85000C 8C64008C 8CE50000 AC850010 8C64008C 8C450000 
    AC850014 8C64008C 8C860014 240500C8 00C5001B 00A001F4 00002812 24A60001 
    2405FFFF 00A6001B 00C001F4 00003012 AC860018 8C64008C 8C450008 AC85001C 
    8C64008C 8C450010 AC850020 8C64008C 8C450018 AC850038 8C64008C 8C450058 
    AC850044 8C64008C 8C450060 AC850048 8C64008C 8C450068 AC85004C 8C64008C 
    8C450070 AC850050 8C64008C 8C840024 AC440020 000427C3 AC440024 8C64008C 
    8C840028 AC440028 000427C3 AC44002C 8C64008C 8C840030 AC440030 000427C3 
    AC440034 8C64008C 8C840034 AC440038 000427C3 AC44003C 8C63008C 8C63002C 
    AC430040 00031FC3 AC430044 8C430048 8C45004C 00651825 5460000A 8C430050 
    3C039D00 8C65008C 8CA5003C AC450048 00052FC3 AC45004C 8C63008C AC60003C 
    8C430050 8C450054 00651825 14600009 00002021 3C039D00 8C65008C 8CA50040 
    AC450050 00052FC3 AC450054 8C62008C AC400040 3C059D00 24A50DBC 27A60010 
    0411FF7F 00000000 3C139D00 8E76007C 8E750064 8E630000 8E620080 8C640000 
    0040F809 00002821 0040A021 8E620080 8E240000 0040F809 8E250004 02802021 
    02A0F809 00402821 02C0F809 00402021 00408821 3C020001 0222102A 1440001A 
    34178000 3C020007 3442FFF9 0222102A 14400011 26220007 3C02003F 3442FFC1 
    0222102A 14400007 2622003F 262200FF 2A230000 0043880B 00118A03 1000000A 
    34178030 2A230000 0043880B 00118983 10000005 34178020 2A230000 0043880B 
    001188C3 34178010 3C139D00 8E76007C 8E750064 001117C3 8E040000 8E030004 
    00710018 70820000 00001012 00910019 00002810 00452821 8E620080 0040F809 
    00002012 0040A021 8E620080 24040064 0040F809 00002821 02802021 02A0F809 
    00402821 02C0F809 00402021 02228823 3C03BF80 8C630600 16E30008 3C039D00 
    8C63008C 8C640000 14820004 00000000 8C630004 5071005B 3C02BF88 8FA50010 
    3C039D00 8C6300AC 3C049D00 24840874 00852021 AC640000 8E030004 5C600006 
    3C03BF88 14600011 3C03BF88 8E030000 1060000E 3C03BF88 8C666030 3C049D00 
    8C84008C 8C85000C 00C52825 AC656030 3C03BF88 8C656130 8C840010 00A42025 
    AC646130 1000000F 3C039D00 8C666030 3C049D00 8C84008C 8C85000C 00052827 
    00A62824 AC656030 3C03BF88 8C656130 8C840010 00042027 00852024 AC646130 
    3C039D00 8C66008C 8E050004 000527C3 8E070000 00873823 0087382B 00852023 
    00872023 000427C2 ACC40008 8C64008C AC820000 8C62008C AC510004 8E020004 
    5C400006 3C029D00 1440000A 3C029D00 8E020000 10400007 3C029D00 8C42008C 
    8C430000 3C02BF80 AC430620 10000006 3C02BF80 8C42008C 8C430004 3C02BF80 
    AC430620 3C02BF80 AC570600 2403001C 3C02BF88 AC4310A4 24030004 3C02BF88 
    AC4310A8 24020010 3C03BF88 AC621034 3C03BF88 AC621064 3C03BF88 AC621068 
    3C02BF88 8C431060 7C032104 AC431060 3C029D00 8C43008C 8C630084 AE430000 
    00031FC3 AE430004 8C43008C 8C630088 AE430008 00031FC3 AE43000C 8C43008C 
    8C63008C AE430010 00031FC3 AE430014 8C43008C 8C630090 AE430018 00031FC3 
    AE43001C 8C43008C 8C630094 AE430020 00031FC3 AE430024 8C43008C 8C630098 
    AE430028 00031FC3 AE43002C 8C43008C AC600084 8C43008C AC600088 8C43008C 
    AC60008C 8C43008C AC600090 8C43008C AC600094 8C43008C AC600098 8C42008C 
    8C430068 AC400068 3C02BF81 8C429000 30428000 14400015 3C02BF81 240404E0 
    AC449000 3C02BF81 AC409010 34048F02 3C02BF81 AC449020 3C040004 3C02BF81 
    AC449040 3C02BF81 AC409050 3C02BF81 8C449000 24050001 7CA47BC4 AC449000 
    8C449000 7CA40844 AC449000 3C02BF88 8C441060 24050001 7CA42104 AC441060 
    00602021 1000000C 00032FC3 24030010 3C02BF88 AC431064 3C02BF88 AC401068 
    3C02BF80 AC400600 3C02BF80 AC400620 00002021 00002821 00801021 00A01821 
    8FBF003C 8FB70038 8FB60034 8FB50030 8FB4002C 8FB30028 8FB20024 8FB10020 
    8FB0001C 03E00008 27BD0040 
End CFunction

CFunction ReadOutputState
  00000000
  'main
  10800004 3C02BF88 8C426030 AC820000 AC800004 50A00006 00001021 3C02BF88
  8C426130 ACA20000 ACA00004 00001021 03E00008 00001821
End CFunction
