#define Version 100     //Version 1.00
#define _SUPPRESS_PLIB_WARNING                                      // required for XC1.33  Later compiler versions will need PLIB to be installed
#include <plib.h>                                                   // the pre Harmony peripheral libraries
#include "../cfunctions.h"
#define magic 0
#define t1pin 1
#define t5pin 2
#define t1port 3
#define t5port 4
#define t1count 5
#define t5count 6
//
void T1Int(void){
    *(volatile unsigned int *)CFuncRam[t1port]=CFuncRam[t1pin];
    if(!(CFuncRam[t1count]--)){
        mT1IntEnable(0);
        T1CON=0;
        CFuncT1=0;
        CFuncRam[t1pin]=0;
        CFuncRam[t1port]=0;
    }
}
void T5Int(void){
    *(volatile unsigned int *)CFuncRam[t5port]=CFuncRam[t5pin];
    if(!(CFuncRam[t5count]--)){
        mT5IntEnable(0);
        T5CON=0;
        CFuncT5=0;
        CFuncRam[t5pin]=0;
        CFuncRam[t5port]=0;
    }
}
void main(long long *MyAddress, long long *pin, float *frequency, float *duration, long *channel){
    int T5IntVectorOffset,T1IntVectorOffset,ps,clockspeed,divide=1;
    float counts,tickspersecond,tickrate;
    counts=FMul(*frequency,*duration);
    counts=FMul(counts,LoadFloat(0x40000000)); //number of interrupts for the pulse train
    clockspeed=CurrentCpuSpeed; 

    CFuncRam[magic]=0xA5A5A5A5;
    if(clockspeed>80000000){ //start by assuming divide by 1
        clockspeed/=4;
    } else {
        clockspeed/=2;        
    }
    tickspersecond=IntToFloat(clockspeed);
    tickrate=FDiv(tickspersecond,*frequency);
    while(FCmp(tickrate,IntToFloat(0xFFFF))==1){
        tickrate=FDiv(tickrate,LoadFloat(0x41000000));
        divide*=8;
    }
    if(*channel==1){
        mT1IntEnable(0);          
        ExtCfg(*pin,EXT_DIG_OUT,0);
        CFuncRam[t1port]=(int)(volatile unsigned int *)GetPortAddr(*pin,LATINV);
        CFuncRam[t1pin]=1<<GetPinBit(*pin);
        PinSetBit(*pin, LATCLR);
        if ((unsigned int)&T1Int < (unsigned int)&main){
            T1IntVectorOffset=*MyAddress - ((unsigned int)&main - (unsigned int)&T1Int);
        }else{
            T1IntVectorOffset=*MyAddress + ((unsigned int)&T1Int - (unsigned int)&main);
        }
        CFuncT1=T1IntVectorOffset;
        CFuncRam[t1count]=FloatToInt(counts); //used to hold count of cycles
        ps=0;
        if(divide==8)ps=0x10;
        if(divide==64)ps=0x20;
        PR1 = FloatToInt(tickrate);
        T1CON = 0x8000 | ps;         										// T5 on, prescaler as input
        mT1SetIntPriority(1);  											// high priority
        mT1ClearIntFlag();      										// clear interrupt flag
        mT1IntEnable(1);
    } else {
        mT5IntEnable(0);  
        ExtCfg(*pin,EXT_DIG_OUT,0);
        CFuncRam[t5port]=(int)(volatile unsigned int *)GetPortAddr(*pin,LATINV);
        CFuncRam[t5pin]=1<<GetPinBit(*pin);
        PinSetBit(*pin, LATCLR);
        if ((unsigned int)&T5Int < (unsigned int)&main){
            T5IntVectorOffset=*MyAddress - ((unsigned int)&main - (unsigned int)&T5Int);
        }else{
            T5IntVectorOffset=*MyAddress + ((unsigned int)&T5Int - (unsigned int)&main);
        }
        CFuncT5=T5IntVectorOffset;
        CFuncRam[t5count]=FloatToInt(counts); //used to hold count of cycles
        ps=0;
        if(divide==8)ps=0x30;
        if(divide==64)ps=0x60;
        PR5 = FloatToInt(tickrate);
        T5CON = 0x8000 | ps;         										// T5 on, prescaler as input
        mT5SetIntPriority(1);  											// high priority
        mT5ClearIntFlag();      										// clear interrupt flag
        mT5IntEnable(1);  
   }
}
