#include <SoftwareSerial.h>
#include <string.h>
#include "LowPower.h"  //8 sec timer to use

#include <stdio.h>
uint8_t hh, mm, ss, cnt=0; //containers for current time


#include <OneWire.h>
#include <DallasTemperature.h>

// Data wire is plugged into port 8 on the Arduino
#define ONE_WIRE_BUS 8
// Setup a oneWire instance to communicate with any OneWire devices (not just Maxim/Dallas temperature ICs)
OneWire oneWire(ONE_WIRE_BUS);
// Pass our oneWire reference to Dallas Temperature. 
DallasTemperature sensors(&oneWire);



#define AVG_NUM 10    // 10 of iterations of the adc routine to average the adc readings
#define MAX_DISTANCE 2200   //mm


#define GPSBAUD 9600

SoftwareSerial myLoRa(5,6); // RX, TX on board

int pwr=9;
int aux=2;
int p0=3;
int p1=4;
int sw=7;
int gpss=12;

String dataString="";
uint8_t data2[9];
uint8_t data1[56];
uint8_t data3[9];
uint8_t data4[8];
uint8_t data5[8];
uint8_t data6[8];

float temp;
//float dist,dist0;
//int year,a,t,d,m,h,m1,s,sh,x,y;
//int st;
unsigned long age;
int i=0,j,k;
float level;


#include <Wire.h>
#include <VL53L0X.h>
VL53L0X sensor;

#define LONG_RANGE

//#define HIGH_SPEED
#define HIGH_ACCURACY



void setup(){

hh = conv2d(__TIME__);
mm = conv2d(__TIME__ + 3);
ss = conv2d(__TIME__ + 6);

  
Serial.begin(9600);   
myLoRa.begin(GPSBAUD);    

pinMode(aux,OUTPUT);
pinMode(p0,OUTPUT);
pinMode(p1,OUTPUT);
pinMode(sw,OUTPUT);
pinMode(gpss,OUTPUT);
pinMode(pwr,OUTPUT);

//digitalWrite(pwr,1);
digitalWrite(aux,0);
digitalWrite(p0,1);
digitalWrite(p1,1);
digitalWrite(sw,0);
digitalWrite(gpss,0);

  Wire.begin();

  sensor.init();
  sensor.setTimeout(500);

#if defined LONG_RANGE
  // lower the return signal rate limit (default is 0.25 MCPS)
  sensor.setSignalRateLimit(0.1);
  // increase laser pulse periods (defaults are 14 and 10 PCLKs)
  sensor.setVcselPulsePeriod(VL53L0X::VcselPeriodPreRange, 18);
  sensor.setVcselPulsePeriod(VL53L0X::VcselPeriodFinalRange, 14);
#endif

#if defined HIGH_SPEED
  // reduce timing budget to 20 ms (default is about 33 ms)
  sensor.setMeasurementTimingBudget(2000);
#elif defined HIGH_ACCURACY
  // increase timing budget to 200 ms
  sensor.setMeasurementTimingBudget(200000);
#endif

 }

void loop(){
// ltime();
cnt=cnt+1;
     myLoRa_recd();
     
//digitalWrite(pwr,0);
     myLoRa_send();
//digitalWrite(pwr,1);
     
if (cnt==60) cnt=0;
LowPower.powerDown(SLEEP_8S, ADC_OFF, BOD_OFF); 
LowPower.powerDown(SLEEP_8S, ADC_OFF, BOD_OFF);  
}



void myLoRa_send() {
//if(sensor.readRangeSingleMillimeters()<=MAX_DISTANCE) 
//level=sensor.readRangeSingleMillimeters();

level=read_laser();  

dtostrf(level, 5, 1, (char*)data6); //level

sensors.begin();
sensors.requestTemperatures(); // Send the command to get temperatures
temp=sensors.getTempCByIndex(0); 
dtostrf(temp, 5, 2, (char*)data5); //temperature
 

myLoRa.listen();
digitalWrite(aux,1);  
digitalWrite(p0,0); 
digitalWrite(p1,0);
//ltime();
sprintf((char*)data1, "%02d:%5s,%5s,%5s",cnt,(char*)data6,(char*)data5,"Loc-1");

Serial.println((char*)data1);

myLoRa.println((char*)data1);

digitalWrite(aux,0);  //0
digitalWrite(p0,1);  //1
digitalWrite(p1,1);  //1


//delay(6000);  //give some delay if you want to send more data

myLoRa.end();
}


void myLoRa_recd() {
  
  
 myLoRa.listen();
digitalWrite(aux,1);  
digitalWrite(p0,0); 
digitalWrite(p1,0);
//Serial.println("Ready");
//myLoRa.println("Ready");
if(myLoRa.available() >0 ){
  char cb=myLoRa.read();
  if(cb=='B') digitalWrite(sw,1);
  if(cb=='C') digitalWrite(sw,0);
 
  Serial.print( cb );
//  delay(500);
  myLoRa.write(cb  );
//  Serial.println("Message");
}

if(Serial.available() ){
  myLoRa.write(Serial.read());
}
myLoRa.end();
}



uint8_t conv2d(const char* p){
    uint8_t v = 0;
    if ('0' <= *p && *p <= '9') v = *p - '0';
    return 10 * v + *++p - '0';
}

void ltime() {
        if (++ss > 59) {
            ss = 0;
            mm++;
            if (mm > 59) {
                mm = 0;
                hh++;
                if (hh > 23) hh = 0;
            }
        }
        char buf[20];
        sprintf(buf, "%02d:%02d:%02d", hh, mm, ss);
        Serial.println(buf);
        delay(1000);
  
}

int read_laser(){
int sum = 0;
int sample ;
//digitalWrite(pwr,0);
  for (int i=0; i<AVG_NUM; i++)   { 
    if(sensor.readRangeSingleMillimeters()<2200)
    sample = sensor.readRangeSingleMillimeters();// Send ping, get ping time in microseconds (uS).
//    delay(105);   //100 give some time to chill Arduino
 //   sonar.timer_stop();
    sum += sample;      
  }
//  digitalWrite(pwr,1);
  return(sum / AVG_NUM);
} 

