' Started....31/3/17
' Microcontroller used:  Microchip Technology PIC12F675
'                        microchip.com
' PicBasic Pro Code: micro-Engineering Labs, Inc.
'                    melabs.com 

'--------Program Desciption--------

' If a 2 pulse /second positive edge is applied to GP2 as an interrupt,then 
'the circuit will count the number of 1 sec pulses and record the result in Hours
' Minutes,and Seconds in memory. When the hours reach 3(am) an ouput pulse on GP0
'turns off the modem. After 1 min the modem is turned back on.The time is set by 
'switching the unit on at 11 am
'The led flashes on GP1 every half second to let you know the circuit is operating
' 

  #CONFIG
  __CONFIG    _CPD_OFF & _CP_OFF & _BODEN_OFF & _MCLRE_ON & _PWRTE_ON & _WDT_OFF & _INTRC_OSC_NOCLKOUT
  #ENDCONFIG
'
' 
 DEFINE OSC 4  'oscillator 4MHz
define OSCCAL_1K 1  'use the stored oscillator cal value to calibrate the oscillator                                                                                                                       
 
 
 CMCON = %0000111    ' comparitor off
 VRCON.7 = 0 ' voltage ref off
INTCON.4 = 1  'interupt on GP2 enabled
OPTION_REG.6 = 1 'interrupt on rising edge of GP2
 ANSEL = %000000 'all ports digital

TRISIO = %001100 'all ports outputs except interrupt input GP2 and reset MCRL GP3 


     
       
'------------Variables-------------
   Second var byte
   Minute var byte  
   Hour var byte  
   Tick var byte
   
   
'----------Initialization----------
    
    
   On interrupt  goto myint  ' define interrupt handler

                            
    
   Tick = 0
   Second = 0
   Minute = 0
   Hour = 12
   GPIO.0 = 0 'modem on
   
'-------------Main Code------------
   Main:
    if Hour = 3 and minute = 0 and Second = 0 then GPIO.0 = 1  'switch modem off
    if Hour = 3 and Minute = 1 and  Second = 0 then GPIO.0 = 0 ' switch modem on
    if GPIO.2 = 1 then  ' flash led
    GPIO.1 = 1
    endif
    If GPIO.2 = 0 then
    GPIO.1 = 0
    endif
    
   goto main
   Disable ' turn interrupts off
   
   myint:
   Tick = Tick + 1
   If Tick = 2 then
   Tick = 0
   Second = Second + 1   ' advance seconds count by 1
   Endif
   IF Second = 60 THEN ' reset the seconds when a minute is reached
   Second = 0
   Minute = Minute + 1  ' advance minute by 1
   endif
   IF Minute = 60 THEN  'reset minute when hour is reached
   Minute = 0
   Hour = Hour + 1   ' advance hour by 1
   endif
   IF Hour = 24 THEN   ' reset hour when  hour is reached
   Hour = 0
   
   endif
   
   INTCON.1 = 0 'clear interrupt flag bit
   RESUME  ' return to main
   enable  ' enable interrupt

  
   end

	


