#ifndef ReceiveOnlyAltSoftSerial_h
#define ReceiveOnlyAltSoftSerial_h

#include <inttypes.h>

#if ARDUINO >= 100
#include "Arduino.h"
#else
#include "WProgram.h"
#include "pins_arduino.h"
#endif

#if defined(__arm__) && defined(CORE_TEENSY)
#define ALTSS_BASE_FREQ F_BUS
#else
#define ALTSS_BASE_FREQ F_CPU
#endif

class ReceiveOnlyAltSoftSerial : public Stream
{
public:
	ReceiveOnlyAltSoftSerial() { }
	~ReceiveOnlyAltSoftSerial() { end(); }
	static void begin(uint32_t baud) { init((ALTSS_BASE_FREQ + baud / 2) / baud); }
	static void end();
	int peek();
	int read();
	int available();
#if ARDUINO >= 100
	size_t write(uint8_t byte) { return 0; }
	void flush() { }
#else
	void write(uint8_t byte) { }
	void flush() { }
#endif
	static void flushInput();
	bool listen() { return false; }
	bool isListening() { return true; }
	bool overflow() { bool r = timing_error; timing_error = false; return r; }
	static int library_version() { return 1; }
	static void enable_timer0(bool enable) { }
	static bool timing_error;
private:
	static void init(uint32_t cycles_per_bit);
};

#endif

