#ifndef IO_H
#define	IO_H

//DTR was RC3 in revA PCB
//RX     RC5
//TX     RC4
//DTR    RA5
//RX_LED RC0
//TX_LED RC1

//active high:
#define RX_LED LATCbits.LATC0
#define TX_LED LATCbits.LATC1
#define DTR_PIN LATAbits.LATA5

//# of timer ISR ticks (45Hz)
#define LED_FLICKER_TIME (2)

#include <xc.h> // include processor files - each processor file is guarded.  
#include <stdint.h> //exact width types

#define UART_BUFFER_SIZE 256
#define BAUD_DIVIDEND_H (12000000UL)
#define BAUD_DIVIDEND_L (3000000UL)
#define LIMIT_16BIT (64000)

//for buffered operation
extern volatile char uart_rx_buffer[UART_BUFFER_SIZE];
extern volatile char uart_tx_buffer[UART_BUFFER_SIZE];
extern volatile unsigned char uart_rx_buffer_head,uart_rx_buffer_tail;
extern volatile unsigned char uart_tx_buffer_head,uart_tx_buffer_tail;
extern volatile unsigned char txFlicker;
extern volatile unsigned char rxFlicker;

void ioInit(void);  //basic IO
void uartSetBR(uint32_t r); //
void uartInit(void);        //set up hardware UART
char uartReceive(void);     //pull a character from hardware RX ring buffer
void uartReceiveN(char n, char* b); //receive n bytes into b; no check done, use uartAvailable prior
char uartSend(char b);      //add a character to hardware TX ring buffer
void uartSendN(char n, const char* b);    //add n bytes from b to tx buffer, use uartTXBufferSpace before!
char uartAvailable(void);   //bytes available in RX ring buffer
char uartTXavailable();     //bytes buffered! not bytes free
char uartTXBufferSpace(void);       //room in tx to add to buffer
void rxInject(char c);      //inject a byte of debugging message in data to host
inline void uartISR(void);         //handle RX and TX interrupts
void tmr2Init(void);
inline void tmr2ISR(void);

#endif	/* IO_H */

