//SSD1306/SH1106 OLED implementation using portbits, should work with PIC16 and PIC24
#include "oled.h"

char col,page; //column variable
char textFlip;

//buffer for number display
char dbuf[11]="";

void I2Cinit(void){    
    //power on and delay   
    //ansbits.OLEDPWR=0;    //uncomment if analog capable
    trisbits.OLEDPWR=0; //output
    latbits.OLEDPWR=1;  //on
    __delay_ms(10);
    //io pins
    //ansbits.I2C_SDA=0;    //uncomment if analog capable
    //ansbits.I2C_SCL=0;    //uncomment if analog capable
    trisbits.I2C_SCL=1;//input= pulled up by bus
    trisbits.I2C_SDA=1;//input= pulled up by bus
    latbits.I2C_SCL=0;
    latbits.I2C_SDA=0;
    I2Cstop();      //idle state
}

void I2Cdeinit(void){
    I2Cstart();      //low pin levels to avoid leakage
    latbits.OLEDPWR=0;  //off
}

//write only:
void I2Cbit(unsigned char n){      //send one bit
    if(n){
        SDAHI
    }else{
        SDALO
    }
    //__delay_us(1); //as and where needed
    SCLHI
    //__delay_us(1); //as and where needed
    __delay32(1);   //seems to be enough
    SCLLO
}

#ifdef OLED_DEBUG

void I2Cbyte(unsigned char n){  //send byte, unrolled inline version is slightly faster
    if(n&128){SDAHI}else{SDALO}__delay_us(DEBUG_DELAY);
    SCLHI;__delay_us(DEBUG_DELAY);SCLLO;__delay_us(DEBUG_DELAY);
    if(n&64){SDAHI}else{SDALO}__delay_us(DEBUG_DELAY);
    SCLHI;__delay_us(DEBUG_DELAY);SCLLO;__delay_us(DEBUG_DELAY);
    if(n&32){SDAHI}else{SDALO}__delay_us(DEBUG_DELAY);
    SCLHI;__delay_us(DEBUG_DELAY);SCLLO;__delay_us(DEBUG_DELAY);
    if(n&16){SDAHI}else{SDALO}__delay_us(DEBUG_DELAY);
    SCLHI;__delay_us(DEBUG_DELAY);SCLLO;__delay_us(DEBUG_DELAY);
    if(n&8){SDAHI}else{SDALO}__delay_us(DEBUG_DELAY);
    SCLHI;__delay_us(DEBUG_DELAY);SCLLO;__delay_us(DEBUG_DELAY);
    if(n&4){SDAHI}else{SDALO}__delay_us(DEBUG_DELAY);
    SCLHI;__delay_us(DEBUG_DELAY);SCLLO;__delay_us(DEBUG_DELAY);
    if(n&2){SDAHI}else{SDALO}__delay_us(DEBUG_DELAY);
    SCLHI;__delay_us(DEBUG_DELAY);SCLLO;__delay_us(DEBUG_DELAY);
    if(n&1){SDAHI}else{SDALO}__delay_us(DEBUG_DELAY);
    SCLHI;__delay_us(DEBUG_DELAY);SCLLO;__delay_us(DEBUG_DELAY);
    SDAHI;      __delay_us(DEBUG_DELAY);                    //ack
    SCLHI;__delay_us(DEBUG_DELAY);SCLLO;__delay_us(DEBUG_DELAY);
}

void I2Cstart(void){                 //send start condition
    //SDAHI                            //allow repeated start
    SDALO
    __delay_us(DEBUG_DELAY);
    SCLLO
    __delay_us(DEBUG_DELAY);
}

void I2Cstop(void){                  //send stop condition
    SDALO
    __delay_us(DEBUG_DELAY);
    SCLHI
    __delay_us(DEBUG_DELAY);
    SDAHI
    __delay_us(DEBUG_DELAY);
}

#else

void I2Cbyte(unsigned char n){  //send byte, unrolled inline version is slightly faster
    if(n&128){SDAHI}else{SDALO}
    SCLHI;Nop();SCLLO
    if(n&64){SDAHI}else{SDALO}
    SCLHI;Nop();SCLLO
    if(n&32){SDAHI}else{SDALO}
    SCLHI;Nop();SCLLO
    if(n&16){SDAHI}else{SDALO}
    SCLHI;Nop();SCLLO
    if(n&8){SDAHI}else{SDALO}
    SCLHI;Nop();SCLLO
    if(n&4){SDAHI}else{SDALO}
    SCLHI;Nop();SCLLO
    if(n&2){SDAHI}else{SDALO}
    SCLHI;Nop();SCLLO
    if(n&1){SDAHI}else{SDALO}
    SCLHI;Nop();SCLLO
    SDAHI;                          //ack
    SCLHI;Nop();SCLLO
}

void I2Cstart(void){                 //send start condition
    //SDAHI                            //allow repeated start
    SDALO
    SCLLO
}

void I2Cstop(void){                  //send stop condition
    SDALO
    SCLHI
    SDAHI
}

#endif

void OLEDsendCommand(unsigned char c){
    I2Cstart();
    I2Cbyte(OLED_ADDRESS); //write
    I2Cbyte(0x80); //write
    I2Cbyte(c); //write
    I2Cstop();
}

void OLEDsendData(unsigned char c){     //not used only does a single byte
    I2Cstart();
    I2Cbyte(OLED_ADDRESS); //write
    I2Cbyte(0x40); //write
    I2Cbyte(c); //write
    I2Cstop();
}

void OLEDinit(void){
    __delay_ms(100);
    OLEDsendCommand(0x20);  //set addressing mode
    OLEDsendCommand(0x02);  //set page addressing mode (SH1106 only supports page mode)
    OLEDsendCommand(0x8D);  //Charge pump setting
    OLEDsendCommand(0x14);  //Enable Charge pump
    //OLEDsendCommand(0xA1);  //column reverse
    OLEDsendCommand(0xA0);  //column normal
    //OLEDsendCommand(0xC8);  //row reverse
    OLEDsendCommand(0xC0);  //row normal
    OLEDsendCommand(0x40);  //display start 0
    OLEDsendCommand(0xD3);  //display offset
    OLEDsendCommand(0x00);  //is zero
    OLEDsendCommand(0xAF);  //display on
    OLEDbrightness(0xFF);   //max for now
    OLEDclear();
}

void OLEDbrightness(unsigned char b){
    OLEDsendCommand(0x81);   //set contrast
    OLEDsendCommand(b);      //to b
}

void OLEDclear(void){
    unsigned char i,j;
    for(i=0;i<8;i++){
        OLEDsetpage(i);
        OLEDsetcolumn(0);
        I2Cstart();
        I2Cbyte(OLED_ADDRESS); //write
        I2Cbyte(0x40); //write data
        for(j=0;j<128;j++){
            I2Cbyte(0x00);
        }
        I2Cstop();
    }
}

void OLEDsetpage(unsigned char p){
    //p=7-p;      //flipped
    OLEDsendCommand(0xB0 + (p&7));      //set page address    
}

void OLEDsetcolumn(unsigned char c){
    c=c+OLED_X_OFFSET;
    OLEDsendCommand(0x00 + (c & 0x0F));  //set column lower address
    OLEDsendCommand(0x10 + ((c>>4)&0x0F));   //set column higher address    
}

void OLEDflip(char c){      //to suit flip orientation according
    if(c==TEXT_LH){
        OLEDsendCommand(0xA1);  //column reverse
        OLEDsendCommand(0xC8);  //row reverse
    }else{
        OLEDsendCommand(0xA0);  //column normal
        OLEDsendCommand(0xC0);  //row normal
    }          
}

void OLEDchar(const char c,const char* f){
    unsigned int w,h,c0,i,j,p;
    char colAdj=col+OLED_X_OFFSET;
    w=f[0];
    h=f[1]/8;
    c0=f[2];
    p=(c-c0)*w*h+4;   //4 is data offset
    for(j=0;j<h;j++){
        I2Cstart();
        I2Cbyte(OLED_ADDRESS); //write
        I2Cbyte(0x80); //write command
        I2Cbyte(0xB0|(page+j));      //set page address    
        I2Cbyte(0x80); //write command
        I2Cbyte(0x00 + (colAdj & 0x0F));  //set column lower address
        I2Cbyte(0x80); //write command
        I2Cbyte(0x10 + ((colAdj>>4)&0x0F));   //set column higher address    
        I2Cbyte(0x40); //write data
        for(i=0;i<w;i++){
            I2Cbyte(f[p+i*h+j]);
        }
        I2Cstop();                        
    }
    col=col+w;
}

void OLEDchararray(const char* c, const char* f){
    while(*c){
        OLEDchar(*c++,f);
    }
}

void OLEDscanlong(unsigned long n){ //converts an unsigned long into decimal
    unsigned long r=1000000000;
    int p;
    for(p=0;p<10;p++){dbuf[p]='0';}   //clear
    dbuf[10]=0;
    p=0;
    while(n){
        while(n>=r){
            n=n-r;
            dbuf[p]++;            
        }
        r=r/10;
        p++;
    }
}

void OLEDlzb(char n){   //leading zero blank up to n
    char i=0;
    while(i<=n){
        if(dbuf[i]=='0'){
            dbuf[i]=' ';
            i=i+1;
        }else{
            return;
        }        
    }    
}