#include "defaults.h"

union flashpadded cur={.d=DATA_DEFAULTS};
//auto psv means we can access them like normal variables
IMG_DEFA sav={.d=DATA_DEFAULTS};
IMG_DEFB backup={.d=DATA_DEFAULTS};

//this is a check that fails to compile if struct is wrong size
//an error on this line probably means that the struct is larger than _FLASH_PAGE
char a[(sizeof(union flashpadded)==(_FLASH_PAGE*2))?0:-1];

char checkCurOK(void){  //check if values are valid
    if(cur.d.rLow<0){return 0;}
    if(cur.d.r1<0){return 0;}
    if(cur.d.r2<0){return 0;}
    if(cur.d.r3<0){return 0;}
    if(cur.d.vBandgap<0){return 0;}
    if(cur.d.vSatLow<0){return 0;}
    if(cur.d.vSatHi<0){return 0;}
    if(cur.d.oledBright<0){return 0;}
    if(cur.d.dispTimeOut<0){return 0;}
    if(cur.d.rProbe<0){return 0;}
    if(cur.d.cFactor<0){return 0;}
    if(cur.d.vBandgap<BANDGAP_MIN){cur.d.vBandgap=BANDGAP_MIN;} //sanity check
    if(cur.d.vBandgap>BANDGAP_MAX){cur.d.vBandgap=BANDGAP_MAX;} //sanity check
    return 1;   //passes all tests
}

void loadCalValues(void){
    flashLoad((unsigned int*)&sav,(unsigned int*)&cur);
    while(checkCurOK()==0){
        OLEDclear();
        col=4;
        page=1;
        OLEDchararray("Load Error",arial);
        col=16;
        page=4;
        OLEDchararray("Defaults",arial);
        __delay_ms(1000);
        OLEDclear();
        __delay_ms(100);
        flashLoad((unsigned int*)&backup,(unsigned int*)&cur);   //load from backups and retry        
    }
    OLEDflip(cur.d.hand);   //update
    OLEDbrightness(cur.d.oledBright);    
}