//SSD1306/SH1106 OLED implementation using portbits, should work with PIC16 and PIC24

#ifndef OLED_H
#define OLED_H
#include <xc.h>
#include "portbits.h"
#include <libpic30.h>        //delay macros

//fonts
#include "font.h"

#define OLEDPWR b4
#define I2C_SDA b5
#define I2C_SCL a4

//invoke slower I2C for debugging
//#define OLED_DEBUG
#define DEBUG_DELAY 10

//offset adjust
//#define X_OFFSET_ENABLED
#ifdef X_OFFSET_ENABLED
//adjust these to suit application
#include "defaults.h"
#define OLED_X_OFFSET cur.d.oledOffset
#else
//if off, used fixed offset
#define OLED_X_OFFSET (0)
#endif

#define SDAHI {trisbits.I2C_SDA=1;}
#define SDALO {trisbits.I2C_SDA=0;}

#define SCLHI {trisbits.I2C_SCL=1;}
#define SCLLO {trisbits.I2C_SCL=0;}

#define OLED_ADDRESS 0x78   //8bit write address, read address is +1
//#define OLED_ADDRESS 0x7A   //8bit write address, read address is +1

//for flippable text display
//TEXT_LH is same as original
#define TEXT_RH 1
#define TEXT_LH 2

//special font characters
#define C_ERROR (27)
#define C_DIODER (28)
#define C_DIODEF (29)
#define C_OHM (30)
#define C_MICRO (31)

extern char col,page; //column variable
extern char textFlip;
extern char dbuf[11];

void I2Cinit(void);
void I2Cdeinit(void);
void I2Cbit(unsigned char n);
void I2Cbyte(unsigned char n);
void I2Cstart(void);
void I2Cstop(void);
void OLEDsendCommand(unsigned char c);
void OLEDsendData(unsigned char c);
void OLEDbrightness(unsigned char b);
void OLEDclear(void);
void OLEDinit(void);
void OLEDsetpage(unsigned char p);
void OLEDsetcolumn(unsigned char c);
void OLEDflip(char c);      //to suit flip orientation according to textFlip
void OLEDchar(const char c,const char* f);//single character, col/page handled internally
void OLEDchararray(const char* c, const char* f);    //char array version of above
void OLEDscanlong(unsigned long n);
void OLEDlzb(char n);   //leading zero blank up to n

#endif  //OLED_H

